/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.CajaDto;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.MovimientoCreditoDto;
import electricpos.model.NotificacionType;
import electricpos.model.ReceptorDto;
import electricpos.service.MovimientoCreditoService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class AbonoCreditoViewController
implements Initializable {
    @FXML
    private TextField txtMontoEfectivo;
    @FXML
    private TextField txtMontoTarjeta;
    @FXML
    private TextField txtMontoTransferencia;
    @FXML
    private Label lblTotal;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    private BigDecimal total = BigDecimal.ZERO;
    private ReceptorDto cliente = new ReceptorDto();
    private EmisorDto emisor = new EmisorDto();

    public void initialize(URL url, ResourceBundle rb) {
        this.txtMontoEfectivo.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,13}([\\.]\\d{0,5})?")) {
                    AbonoCreditoViewController.this.txtMontoEfectivo.setText(oldValue);
                }
                AbonoCreditoViewController.this.calcularTotal();
            }
        });
        this.txtMontoTarjeta.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,13}([\\.]\\d{0,5})?")) {
                    AbonoCreditoViewController.this.txtMontoTarjeta.setText(oldValue);
                }
                AbonoCreditoViewController.this.calcularTotal();
            }
        });
        this.txtMontoTransferencia.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,13}([\\.]\\d{0,5})?")) {
                    AbonoCreditoViewController.this.txtMontoTransferencia.setText(oldValue);
                }
                AbonoCreditoViewController.this.calcularTotal();
            }
        });
    }

    private void calcularTotal() {
        Double efectivo = this.txtMontoEfectivo.getText().isEmpty() || this.txtMontoEfectivo.getText() == null ? 0.0 : Double.valueOf(this.txtMontoEfectivo.getText());
        Double tarjeta = this.txtMontoTarjeta.getText().isEmpty() || this.txtMontoTarjeta.getText() == null ? 0.0 : Double.valueOf(this.txtMontoTarjeta.getText());
        Double transferencia = this.txtMontoTransferencia.getText().isEmpty() || this.txtMontoTransferencia.getText() == null ? 0.0 : Double.valueOf(this.txtMontoTransferencia.getText());
        Double aux = efectivo + tarjeta + transferencia;
        this.total = new BigDecimal(aux);
        this.lblTotal.setText("Total abono:  " + FuncionesGenerales.getDecimalFormated(this.total));
    }

    @FXML
    private void onBtnGuardar() {
        Double efectivo = this.txtMontoEfectivo.getText().isEmpty() || this.txtMontoEfectivo.getText() == null ? 0.0 : Double.valueOf(this.txtMontoEfectivo.getText());
        Double tarjeta = this.txtMontoTarjeta.getText().isEmpty() || this.txtMontoTarjeta.getText() == null ? 0.0 : Double.valueOf(this.txtMontoTarjeta.getText());
        Double transferencia = this.txtMontoTransferencia.getText().isEmpty() || this.txtMontoTransferencia.getText() == null ? 0.0 : Double.valueOf(this.txtMontoTransferencia.getText());
        MovimientoCreditoDto mov = new MovimientoCreditoDto();
        mov.setEmisor(this.emisor);
        mov.setCliente(this.cliente);
        CajaDto cajaActual = this.funcionesGenerales.getUltimaCaja();
        if (cajaActual != null && cajaActual.getEstado().equalsIgnoreCase("A")) {
            mov.setIdCaja(cajaActual.getId());
        } else {
            mov.setIdCaja(null);
            if (GlobalApp.empresa.getReqCaja().equalsIgnoreCase("S")) {
                NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "No existe ninguna caja abierta para registrtar el movimiento.");
                return;
            }
        }
        mov.setCantidadProducto(BigDecimal.ZERO);
        mov.setPrecio(BigDecimal.ZERO);
        mov.setAbono(this.total);
        mov.setTipo("A");
        mov.setEstado("A");
        mov.setMontoEfectivo(new BigDecimal(efectivo));
        mov.setMontoTransferencia(new BigDecimal(transferencia));
        mov.setMontoTarjeta(new BigDecimal(tarjeta));
        MovimientoCreditoService service = (MovimientoCreditoService)AppContext.getInstance().get("MovimientoCreditoService");
        Respuesta respuesta = service.save(mov);
        if (respuesta.getEstado().booleanValue()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Abono aplicado correctamente.");
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error al aplicar el abono, intente mas tarde.");
        }
        this.closeModal();
    }

    @FXML
    private void onBtnCancelar() {
        this.closeModal();
    }

    public void setCliente(ReceptorDto cliente) {
        this.cliente = cliente;
    }

    public void setEmisor(EmisorDto emisor) {
        this.emisor = emisor;
    }

    private void closeModal() {
        Stage stage = (Stage)this.lblTotal.getScene().getWindow();
        stage.hide();
    }
}

