/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.ActividadesViewController;
import electricpos.controller.PreferenciasSucursalViewController;
import electricpos.customcontrol.ActividadCCController;
import electricpos.model.ActividadEmisor;
import electricpos.model.ActividadEmisorDto;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.service.EmisorService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class ActividadesEmisorViewController
implements Initializable {
    @FXML
    private VBox vboxActividades;
    private EmisorDto emisorDto;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void onBtnCerrar() {
        Stage stage = (Stage)this.vboxActividades.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnGuardar() {
        int principal = 0;
        ArrayList<ActividadEmisorDto> actividadesEconomicas = new ArrayList<ActividadEmisorDto>();
        for (Node node : GlobalApp.vBoxActividades.getChildren()) {
            ActividadCCController controller = (ActividadCCController)node;
            if (controller.getActividadEmisorDto().getPrincipal().equalsIgnoreCase("S")) {
                ++principal;
            }
            actividadesEconomicas.add(controller.getActividadEmisorDto());
        }
        if (principal == 1) {
            this.emisorDto.setActividadesEconomicas(actividadesEconomicas);
            EmisorService service = (EmisorService)AppContext.getInstance().get("EmisorService");
            Respuesta respuesta = service.saveEmisorActividades(this.emisorDto);
            if (respuesta.getEstado().booleanValue()) {
                EmisorDto resp = (EmisorDto)respuesta.getResultado("Emisor");
                this.funcionesGenerales.MostrarModalInfo("Actividades guardadas correctamente.");
            } else {
                this.funcionesGenerales.MostrarModalInfo("Error al guardar actividades del emisor: " + respuesta.getMensaje());
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de existir una sola actividad econ\u00f3mica marcada como principal.");
        }
    }

    @FXML
    private void onBtnSincronizar() {
        try {
            String url = "https://api.hacienda.go.cr/fe/ae?identificacion=" + this.emisorDto.getNumeroIdentificacion();
            Request request = new Request(url, true);
            request.get();
            if (!request.isError().booleanValue()) {
                ActividadEmisor ae = (ActividadEmisor)request.readEntity(ActividadEmisor.class);
                if (!ae.getActividades().isEmpty()) {
                    this.vboxActividades.getChildren().clear();
                    for (ActividadEmisorDto ac : ae.getActividades()) {
                        ActividadCCController controller = new ActividadCCController(ac, this.vboxActividades);
                        this.vboxActividades.getChildren().add((Object)controller);
                    }
                    GlobalApp.vBoxActividades = this.vboxActividades;
                } else {
                    this.funcionesGenerales.MostrarModalInfo("No se encontraron actividades para el emisor.");
                }
            } else {
                this.funcionesGenerales.MostrarModalInfo("No se encontraron actividades para el emisor.");
            }
        }
        catch (Exception ex) {
            this.funcionesGenerales.MostrarModalInfo("Error desconocido al consultar informaci\u00f3n de actividades en hacienda. " + ex.getLocalizedMessage());
        }
    }

    @FXML
    private void onBtnNuevo() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ActividadesView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(PreferenciasSucursalViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ActividadesViewController controller = (ActividadesViewController)fxmlLoader.getController();
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
        if (controller.isSelected.booleanValue()) {
            int repetidos = 0;
            for (Node node : GlobalApp.vBoxActividades.getChildren()) {
                ActividadCCController aec = (ActividadCCController)node;
                if (!aec.getActividadEmisorDto().getCodigo().equalsIgnoreCase(controller.getActividadSeleccionada().getCodigo())) continue;
                ++repetidos;
            }
            if (repetidos == 0) {
                ActividadEmisorDto actividadEmisorDto = new ActividadEmisorDto();
                actividadEmisorDto.setCodigo(controller.getActividadSeleccionada().getCodigo());
                actividadEmisorDto.setDescripcion(controller.getActividadSeleccionada().getActividad());
                actividadEmisorDto.setTipo("P");
                actividadEmisorDto.setEstado("A");
                actividadEmisorDto.setPrincipal("N");
                ActividadCCController con = new ActividadCCController(actividadEmisorDto, this.vboxActividades);
                this.vboxActividades.getChildren().add((Object)con);
            } else {
                this.funcionesGenerales.MostrarModalInfo("La actividad econ\u00f3mica ya fue agregada anteriormente.");
            }
        }
    }

    public void setEmisorDto(EmisorDto emisorDto) {
        this.emisorDto = emisorDto;
        if (emisorDto.getActividadesEconomicas() != null && !emisorDto.getActividadesEconomicas().isEmpty()) {
            for (ActividadEmisorDto ac : emisorDto.getActividadesEconomicas()) {
                ActividadCCController controller = new ActividadCCController(ac, this.vboxActividades);
                this.vboxActividades.getChildren().add((Object)controller);
            }
            GlobalApp.vBoxActividades = this.vboxActividades;
        }
    }
}

