/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.ActividadDto;
import electricpos.model.ActividadTv;
import electricpos.service.ActividadService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public class ActividadesViewController
implements Initializable {
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    ObservableList<ActividadTv> actividadTv;
    ObservableList<ActividadDto> actividadesDtos;
    public ActividadDto actividadSeleccionada = new ActividadDto();
    public Boolean isSelected = false;
    @FXML
    private TableView<ActividadTv> tv_actividades;
    @FXML
    private TableColumn<ActividadTv, String> tbcCodigo;
    @FXML
    private TableColumn<ActividadTv, String> tbcActividad;
    @FXML
    private Label txtDescripcionActividad;
    @FXML
    private TextField txtDescripcion;
    @FXML
    private TextField txtCodigo;

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.tv_actividades.setOnMouseClicked(event -> {
            if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
                int index = this.tv_actividades.getSelectionModel().getSelectedIndex();
                ActividadTv actividadTv = (ActividadTv)this.tv_actividades.getItems().get(index);
                this.txtDescripcionActividad.setText(actividadTv.getActividadDto().getDescripcion());
            }
        });
        this.tv_actividades.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.isPrimaryButtonDown() && event.getClickCount() == 2) {
                    ActividadesViewController.this.actividadSeleccionada = ((ActividadTv)ActividadesViewController.this.tv_actividades.getSelectionModel().getSelectedItem()).getActividadDto();
                    ActividadesViewController.this.isSelected = true;
                    Stage stage = (Stage)ActividadesViewController.this.tv_actividades.getScene().getWindow();
                    stage.hide();
                }
            }
        });
    }

    @FXML
    private void onBtnBuscar(ActionEvent event) {
        this.getActividades(this.txtCodigo.getText(), this.txtDescripcion.getText());
    }

    @FXML
    private void onBtnCerrar(ActionEvent event) {
        this.isSelected = false;
        Stage stage = (Stage)this.tv_actividades.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnSeleccionar(ActionEvent event) {
        this.actividadSeleccionada = ((ActividadTv)this.tv_actividades.getSelectionModel().getSelectedItem()).getActividadDto();
        this.isSelected = true;
        Stage stage = (Stage)this.tv_actividades.getScene().getWindow();
        stage.hide();
    }

    @FXML
    public void onEnterTxtCodigo(ActionEvent ae) {
        this.getActividades(this.txtCodigo.getText(), this.txtDescripcion.getText());
    }

    @FXML
    public void onEnterTxtDescripcion(ActionEvent ae) {
        this.getActividades(this.txtCodigo.getText(), this.txtDescripcion.getText());
    }

    private void crearRelacionTv() {
        this.tbcCodigo.setCellValueFactory(cd -> ((ActividadTv)cd.getValue()).codigo);
        this.tbcActividad.setCellValueFactory(cd -> ((ActividadTv)cd.getValue()).actividad);
    }

    private void getActividades(String codigo, String descripcion) {
        this.txtDescripcionActividad.setText("Seleccione una actividad...");
        ActividadService actividadService = (ActividadService)AppContext.getInstance().get("ActividadService");
        Respuesta respuesta = null;
        respuesta = !codigo.isEmpty() && codigo != null ? actividadService.getByCodigo(codigo) : (!descripcion.isEmpty() && descripcion != null ? actividadService.getByDescripcion(descripcion) : actividadService.getAll());
        if (respuesta.getEstado().booleanValue()) {
            this.actividadesDtos = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_actividades.getItems().clear();
            this.tv_actividades.setItems(this.converterTv(this.actividadesDtos));
        }
    }

    private ObservableList<ActividadTv> converterTv(ObservableList<ActividadDto> actividades) {
        ObservableList actividadTvs = FXCollections.observableArrayList();
        for (ActividadDto actividadDto : actividades) {
            ActividadTv actividadTv = new ActividadTv(actividadDto);
            actividadTvs.add((Object)actividadTv);
        }
        return actividadTvs;
    }

    public ActividadDto getActividadSeleccionada() {
        return this.actividadSeleccionada;
    }

    public void setActividadSeleccionada(ActividadDto actividadSeleccionada) {
        this.actividadSeleccionada = actividadSeleccionada;
    }
}

