/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.service.EmisorService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;

public class AjustesInventarioViewController
implements Initializable {
    @FXML
    ComboBox<NotificarType> cbxNotifica;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    TextField txtCantidadNotificar;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<NotificarType> notificarTypeLista;
    EmisorDto emisorSeleccionado;
    NotificarType notificaSeleccionado;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarTiposNotificacion();
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            this.emisorSeleccionado = emi = (EmisorDto)this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarValores(this.emisorSeleccionado);
    }

    @FXML
    private void onCbxNotificarChanged(ActionEvent event) {
        this.notificaSeleccionado = (NotificarType)this.cbxNotifica.getSelectionModel().getSelectedItem();
        this.validarEstadoNotificacion();
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
        this.emisorSeleccionado = (EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem();
        this.cargarValores(this.emisorSeleccionado);
    }

    @FXML
    private void OnBtnGuardar(ActionEvent event) {
        this.guardarEmisor();
    }

    private void guardarEmisor() {
        this.emisorSeleccionado.setInvNotificaStock(((NotificarType)this.cbxNotifica.getSelectionModel().getSelectedItem()).getValor());
        String invMinStockValue = this.txtCantidadNotificar.getText();
        if (invMinStockValue == null) {
            this.emisorSeleccionado.setInvMinStock(new BigDecimal(BigInteger.ZERO));
        } else {
            this.emisorSeleccionado.setInvMinStock(new BigDecimal(invMinStockValue));
        }
        EmisorService service = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = service.saveEmisor(this.emisorSeleccionado);
        if (respuesta.getEstado().booleanValue()) {
            EmisorDto resp = (EmisorDto)respuesta.getResultado("Emisor");
            this.funcionesGenerales.MostrarModalInfo("Ajustes del inventario guardado correctamente.");
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al guardar los ajustes");
        }
    }

    private void cargarValores(EmisorDto emisorDto) {
        NotificarType notificarType = new NotificarType();
        this.notificaSeleccionado = notificarType = this.cbxNotifica.getItems().stream().filter(c -> c.getValor().equalsIgnoreCase(this.emisorSeleccionado.getInvNotificaStock())).findAny().orElse((NotificarType)this.notificarTypeLista.get(1));
        this.cbxNotifica.getSelectionModel().select((Object)notificarType);
        if (this.emisorSeleccionado.getInvMinStock() != null) {
            this.txtCantidadNotificar.setText(this.emisorSeleccionado.getInvMinStock().toEngineeringString());
        } else {
            this.txtCantidadNotificar.setText("0");
        }
        this.validarEstadoNotificacion();
    }

    private void validarEstadoNotificacion() {
        this.txtCantidadNotificar.setDisable(!this.notificaSeleccionado.getValor().equalsIgnoreCase("S"));
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void cargarTiposNotificacion() {
        ArrayList<NotificarType> lista = new ArrayList<NotificarType>();
        NotificarType tps1 = new NotificarType("S", "Si notificar");
        NotificarType tps2 = new NotificarType("N", "No notificar");
        lista.add(tps1);
        lista.add(tps2);
        this.notificarTypeLista = FXCollections.observableArrayList(lista);
        this.cbxNotifica.setItems(this.notificarTypeLista);
        this.cbxNotifica.getSelectionModel().selectFirst();
    }

    class NotificarType {
        private String valor;
        private String descripcion;

        public NotificarType(String valor, String descripcion) {
            this.valor = valor;
            this.descripcion = descripcion;
        }

        public String toString() {
            return this.descripcion;
        }

        public NotificarType() {
        }

        public String getValor() {
            return this.valor;
        }

        public void setValor(String valor) {
            this.valor = valor;
        }

        public String getDescripcion() {
            return this.descripcion;
        }

        public void setDescripcion(String descripcion) {
            this.descripcion = descripcion;
        }
    }
}

