/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.model.ClienteTv;
import electricpos.model.GlobalApp;
import electricpos.model.ReceptorDto;
import electricpos.model.TipoExoneracionDto;
import electricpos.service.ReceptorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class BusquedaClienteViewController
implements Initializable {
    @FXML
    private TextField busquedaClienteViewController;
    @FXML
    private JFXButton btnCancelar;
    @FXML
    private JFXButton btnGuardar;
    @FXML
    private TextField txtNombre;
    ObservableList<ClienteTv> clientesTv;
    ObservableList<ReceptorDto> clientes;
    @FXML
    private TableView<ClienteTv> tv_clientes;
    @FXML
    private TableColumn<ClienteTv, String> tbcIdentificacion;
    @FXML
    private TableColumn<ClienteTv, String> tbcNombre;
    ObservableList<TipoExoneracionDto> tipoExoneracionLista;
    ReceptorDto receptorSeleccionado = new ReceptorDto();
    public boolean selecciono = false;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    Integer idEmisor = null;

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        ReceptorService receptorService = (ReceptorService)AppContext.getInstance().get("ReceptorService");
        Respuesta respuesta = receptorService.getReceptorEmisorYNombre(GlobalApp.idEmisor, "");
        if (respuesta.getEstado().booleanValue()) {
            this.clientes = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_clientes.setItems(this.converterTv(this.clientes));
        }
    }

    @FXML
    private void onBtnCancelar() {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
        this.selecciono = false;
        this.receptorSeleccionado = null;
    }

    @FXML
    private void onBtnGuardar(ActionEvent event) {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        if (!this.tv_clientes.getSelectionModel().isEmpty() && this.tv_clientes.getSelectionModel().getSelectedItem() != null) {
            this.receptorSeleccionado = ((ClienteTv)this.tv_clientes.getSelectionModel().getSelectedItem()).getReceptor();
            this.selecciono = true;
            stage.hide();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleciionar un cliente.");
        }
    }

    @FXML
    private void onBtnBuscar(ActionEvent event) {
        this.getReceptores();
    }

    private void getReceptores() {
        ReceptorService receptorService = (ReceptorService)AppContext.getInstance().get("ReceptorService");
        Respuesta respuesta = receptorService.getReceptorEmisorYNombre(this.idEmisor, this.txtNombre.getText());
        if (respuesta.getEstado().booleanValue()) {
            this.clientes = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_clientes.setItems(this.converterTv(this.clientes));
        }
    }

    private void crearRelacionTv() {
        this.tbcIdentificacion.setCellValueFactory(cd -> ((ClienteTv)cd.getValue()).identificacion);
        this.tbcNombre.setCellValueFactory(cd -> ((ClienteTv)cd.getValue()).nombre);
    }

    public ReceptorDto getReceptorSeleccionado() {
        return this.receptorSeleccionado;
    }

    public void setReceptorSeleccionado(ReceptorDto receptorSeleccionado) {
        this.receptorSeleccionado = receptorSeleccionado;
    }

    public boolean isModifico() {
        return this.selecciono;
    }

    public void setModifico(boolean selecciono) {
        this.selecciono = selecciono;
    }

    private ObservableList<ClienteTv> converterTv(ObservableList<ReceptorDto> clientes) {
        ObservableList clienteTv = FXCollections.observableArrayList();
        for (ReceptorDto receptorDto : clientes) {
            ClienteTv emiTv = new ClienteTv(receptorDto);
            clienteTv.add((Object)emiTv);
        }
        return clienteTv;
    }

    public Integer getIdEmisor() {
        return this.idEmisor;
    }

    public void setIdEmisor(Integer idEmisor) {
        this.idEmisor = idEmisor;
    }
}

