/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.model.ProductoServicioDto;
import electricpos.model.ProductoServicioLte;
import electricpos.model.ProductoServicioTv;
import electricpos.service.ProductoServicioService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class BusquedaProductoServicioViewController
implements Initializable {
    @FXML
    private JFXButton btnCancelar;
    @FXML
    private TextField txtNombre;
    ObservableList<ProductoServicioLte> productosServiciosTv;
    ProductoServicioDto productosServicioSeleccionado;
    Integer idEmisor = null;
    @FXML
    private TableView<ProductoServicioLte> tv_productoServicio;
    @FXML
    private TableColumn<ProductoServicioLte, String> tbcCodigo;
    @FXML
    private TableColumn<ProductoServicioLte, String> tbcDetalle;
    @FXML
    private TableColumn<ProductoServicioLte, Number> tbcPrecioImp;
    @FXML
    private TableColumn<ProductoServicioLte, Number> tbcStock;
    private Integer idSucursal;
    private String invCompartido;
    public boolean selecciono = false;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.tv_productoServicio.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    ProductoServicioLte data = (ProductoServicioLte)row.getItem();
                    Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
                    this.productosServicioSeleccionado = this.getPsById(data.getId());
                    this.selecciono = true;
                    stage.hide();
                }
            });
            return row;
        });
        this.crearRelacionTv();
    }

    @FXML
    private void onBtnCancelar(ActionEvent event) {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
        this.selecciono = false;
        this.productosServicioSeleccionado = null;
    }

    @FXML
    private void onBtnGuardar() {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        if (!this.tv_productoServicio.getSelectionModel().isEmpty() && this.tv_productoServicio.getSelectionModel().getSelectedItem() != null) {
            this.productosServicioSeleccionado = this.getPsById(((ProductoServicioLte)this.tv_productoServicio.getSelectionModel().getSelectedItem()).getId());
            this.selecciono = true;
            stage.hide();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar un producto/servicio.");
        }
    }

    private void seleccionarProductoServicio() {
    }

    @FXML
    private void onBtnBuscar() {
        this.getProductosServicios(this.idEmisor, this.idSucursal, this.invCompartido);
    }

    private void crearRelacionTv() {
        this.tbcCodigo.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).codigo);
        this.tbcDetalle.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).descripcion);
        this.tbcPrecioImp.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).precioConImp);
        this.tbcStock.setCellValueFactory(cd -> ((ProductoServicioLte)cd.getValue()).existencia);
    }

    private ProductoServicioDto getPsById(int id) {
        ProductoServicioService service = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
        Respuesta respuesta = service.getProductoServicioId(id);
        ProductoServicioDto psDto = null;
        if (respuesta.getEstado().booleanValue()) {
            psDto = (ProductoServicioDto)respuesta.getResultado("ProductoServicio");
        } else {
            psDto = null;
            this.funcionesGenerales.MostrarModalInfo("No se pudo obtener los datos del producto/servicio.");
        }
        return psDto;
    }

    private void getProductosServicios(Integer idEmisor, Integer idSucursal, String invCompartido) {
        ProductoServicioService productoServicioService = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
        Respuesta respuesta = null;
        if (invCompartido.equalsIgnoreCase("S")) {
            respuesta = productoServicioService.getProductoServicioNombre(idEmisor, this.txtNombre.getText(), "A", true);
        } else if (invCompartido.equalsIgnoreCase("N")) {
            respuesta = productoServicioService.getProductoServicioSucursal(idEmisor, this.txtNombre.getText(), idSucursal, "A", true);
        }
        if (respuesta.getEstado().booleanValue()) {
            this.productosServiciosTv = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_productoServicio.getItems().clear();
            this.tv_productoServicio.setItems(this.productosServiciosTv);
        }
    }

    public boolean isModifico() {
        return this.selecciono;
    }

    public void setModifico(boolean selecciono) {
        this.selecciono = selecciono;
    }

    private ObservableList<ProductoServicioTv> converterTv(ObservableList<ProductoServicioDto> productosServicios) {
        ObservableList productosServiciosTv = FXCollections.observableArrayList();
        for (ProductoServicioDto psDto : productosServicios) {
            ProductoServicioTv psTv = new ProductoServicioTv(psDto);
            productosServiciosTv.add((Object)psTv);
        }
        return productosServiciosTv;
    }

    public ProductoServicioDto getProductosServicioSeleccionado() {
        return this.productosServicioSeleccionado;
    }

    public void setProductosServicioSeleccionado(ProductoServicioDto productosServicioSeleccionado) {
        this.productosServicioSeleccionado = productosServicioSeleccionado;
    }

    public Integer getIdEmisor() {
        return this.idEmisor;
    }

    public void setIdEmisor(Integer idEmisor) {
        this.idEmisor = idEmisor;
    }

    public boolean isSelecciono() {
        return this.selecciono;
    }

    public void setSelecciono(boolean selecciono) {
        this.selecciono = selecciono;
    }

    public void setIdSucursal(Integer idSucursal) {
        this.idSucursal = idSucursal;
    }

    public void setInvCompartido(String invCompartido) {
        this.invCompartido = invCompartido;
    }
}

