/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.model.CabysTv;
import electricpos.service.CabysService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class CabysViewController
implements Initializable {
    @FXML
    private TextField txtCodigo;
    @FXML
    private TextField txtDescripcion;
    @FXML
    private ComboBox<String> cbxImpuesto;
    @FXML
    private TableView<CabysTv> tv_cabys;
    @FXML
    private TableColumn<CabysTv, String> tbcCodigo;
    @FXML
    private TableColumn<CabysTv, String> tbcDesc;
    @FXML
    private TableColumn<CabysTv, String> tbcImp;
    @FXML
    private Label lblEstado;
    @FXML
    private JFXButton btnReintentar;
    ObservableList<CabysTv> cabysTv;
    public CabysTv cabysSeleccionado;
    public boolean selecciono = false;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    private static final int MAX_REINTENTOS = 3;
    private static final int TIEMPO_ESPERA_MS = 1500;
    private String ultimoCodigo = "";
    private String ultimaDescripcion = "";
    private String ultimoImpuesto = "";
    private boolean buscando = false;

    public void initialize(URL url, ResourceBundle rb) {
        this.tv_cabys.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.cabysSeleccionado = (CabysTv)row.getItem();
                    this.selecciono = true;
                    Stage stage = (Stage)this.txtCodigo.getScene().getWindow();
                    stage.hide();
                }
            });
            return row;
        });
        this.cargarImpuestos();
        this.crearRelacionTv();
    }

    @FXML
    private void onBtnCerrar() {
        this.selecciono = false;
        this.cabysSeleccionado = null;
        Stage stage = (Stage)this.txtCodigo.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnSeleccionar() {
        Stage stage = (Stage)this.txtCodigo.getScene().getWindow();
        if (!this.tv_cabys.getSelectionModel().isEmpty() && this.tv_cabys.getSelectionModel().getSelectedItem() != null) {
            this.cabysSeleccionado = (CabysTv)this.tv_cabys.getSelectionModel().getSelectedItem();
            this.selecciono = true;
            stage.hide();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar un c\u00f3digo Cabys.");
        }
    }

    @FXML
    private void onEnterTxtCodigo() {
        this.getCabys(this.txtCodigo.getText(), this.txtDescripcion.getText(), (String)this.cbxImpuesto.getSelectionModel().getSelectedItem());
    }

    @FXML
    private void onEnterTxtDescripcion() {
        this.getCabys(this.txtCodigo.getText(), this.txtDescripcion.getText(), (String)this.cbxImpuesto.getSelectionModel().getSelectedItem());
    }

    @FXML
    private void onBtnBuscar() {
        this.getCabys(this.txtCodigo.getText(), this.txtDescripcion.getText(), (String)this.cbxImpuesto.getSelectionModel().getSelectedItem());
    }

    @FXML
    private void onBtnReintentar() {
        if (!this.ultimoCodigo.isEmpty() || !this.ultimaDescripcion.isEmpty()) {
            this.getCabys(this.ultimoCodigo, this.ultimaDescripcion, this.ultimoImpuesto);
        } else {
            this.actualizarEstado("No hay b\u00fasqueda previa para reintentar.", false);
        }
    }

    public void setDescripcion(String des) {
        this.txtDescripcion.setText(des);
    }

    private void getCabys(final String codigo, final String descripcion, String impuesto) {
        if (this.buscando) {
            return;
        }
        if ((codigo == null || codigo.trim().isEmpty()) && (descripcion == null || descripcion.trim().isEmpty())) {
            this.actualizarEstado("Debes ingresar al menos un c\u00f3digo o descripci\u00f3n para buscar.", false);
            return;
        }
        this.ultimoCodigo = codigo != null ? codigo : "";
        this.ultimaDescripcion = descripcion != null ? descripcion : "";
        this.ultimoImpuesto = impuesto != null ? impuesto : "";
        Task<Respuesta> busquedaTask = new Task<Respuesta>(){

            protected Respuesta call() throws Exception {
                return CabysViewController.this.buscarConReintentos(codigo, descripcion);
            }
        };
        busquedaTask.setOnSucceeded(arg_0 -> this.lambda$getCabys$2((Task)busquedaTask, arg_0));
        busquedaTask.setOnFailed(event -> {
            this.buscando = false;
            this.actualizarEstado("Error inesperado. Intenta de nuevo.", true);
            this.mostrarBotonReintentar(true);
        });
        this.buscando = true;
        this.actualizarEstado("Buscando c\u00f3digos CABYS...", false);
        new Thread((Runnable)busquedaTask).start();
    }

    private Respuesta buscarConReintentos(String codigo, String descripcion) {
        CabysService service = (CabysService)AppContext.getInstance().get("CabysService");
        Respuesta respuesta = null;
        for (int intento = 0; intento < 3; ++intento) {
            try {
                int intentoActual = intento;
                Platform.runLater(() -> {
                    if (intentoActual > 1) {
                        this.actualizarEstado("Reintentando b\u00fasqueda... (Intento " + intentoActual + " de " + 3 + ")", false);
                    }
                });
                respuesta = service.getCabysQuery(codigo, descripcion);
                if (respuesta == null || !respuesta.getEstado().booleanValue()) continue;
                return respuesta;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                System.err.println("Error en intento " + intento + ": " + e.getMessage());
                if (intento >= 3) continue;
                try {
                    Thread.sleep(1500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        return respuesta != null ? respuesta : new Respuesta(false, "No se pudo conectar con el servicio despu\u00e9s de 3 intentos.", "");
    }

    private void procesarRespuesta(Respuesta respuesta) {
        if (respuesta == null) {
            this.actualizarEstado("Error: No se recibi\u00f3 respuesta. Intenta de nuevo.", true);
            this.mostrarBotonReintentar(true);
            return;
        }
        if (respuesta.getEstado().booleanValue()) {
            List resultados = (List)respuesta.getResultado(ESTADO.OK.VALUE());
            if (resultados != null && !resultados.isEmpty()) {
                this.cabysTv = FXCollections.observableArrayList((Collection)resultados);
                this.tv_cabys.getItems().clear();
                this.tv_cabys.setItems(this.cabysTv);
                this.actualizarEstado("Se encontraron " + resultados.size() + " c\u00f3digo(s) CABYS.", false);
                this.mostrarBotonReintentar(false);
            } else {
                this.tv_cabys.getItems().clear();
                this.actualizarEstado("No se encontraron resultados. Intenta con otros criterios.", false);
                this.mostrarBotonReintentar(false);
            }
        } else {
            this.tv_cabys.getItems().clear();
            String mensajeError = respuesta.getMensaje() != null && !respuesta.getMensaje().isEmpty() ? respuesta.getMensaje() : "Servicio no disponible";
            this.actualizarEstado("Error: " + mensajeError + ". Intenta de nuevo.", true);
            this.mostrarBotonReintentar(true);
        }
    }

    private void actualizarEstado(String mensaje, boolean esError) {
        if (this.lblEstado != null) {
            Platform.runLater(() -> {
                this.lblEstado.setText(mensaje);
                this.lblEstado.setStyle(esError ? "-fx-text-fill: #D32F2F; -fx-font-weight: bold;" : "-fx-text-fill: #616161;");
                this.lblEstado.setVisible(true);
            });
        }
    }

    private void mostrarBotonReintentar(boolean mostrar) {
        if (this.btnReintentar != null) {
            Platform.runLater(() -> this.btnReintentar.setVisible(mostrar));
        }
    }

    private void cargarImpuestos() {
        ArrayList<String> lista = new ArrayList<String>();
        lista.add("Todos");
        lista.add("13%");
        lista.add("4%");
        lista.add("2%");
        lista.add("1%");
        lista.add("Exento");
        ObservableList impuestoLista = FXCollections.observableArrayList(lista);
        this.cbxImpuesto.setItems(impuestoLista);
        this.cbxImpuesto.getSelectionModel().selectFirst();
    }

    private void crearRelacionTv() {
        this.tbcCodigo.setCellValueFactory(cd -> ((CabysTv)cd.getValue()).codigo);
        this.tbcDesc.setCellValueFactory(cd -> ((CabysTv)cd.getValue()).descripcion);
        this.tbcImp.setCellValueFactory(cd -> ((CabysTv)cd.getValue()).impuesto);
    }

    private /* synthetic */ void lambda$getCabys$2(Task busquedaTask, WorkerStateEvent event) {
        this.buscando = false;
        Respuesta respuesta = (Respuesta)busquedaTask.getValue();
        this.procesarRespuesta(respuesta);
    }
}

