/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.CerrarCajaViewController;
import electricpos.controller.PrincipalController;
import electricpos.model.CajaDto;
import electricpos.model.CajaTv;
import electricpos.model.CierreCajaDto;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.CajasService;
import electricpos.service.EmisorService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class CajasViewController
implements Initializable {
    @FXML
    private ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    private DatePicker dpFechaIni;
    @FXML
    private DatePicker dpFechaFin;
    @FXML
    private TableView<CajaTv> tv_cajas;
    @FXML
    private TableColumn<CajaTv, String> tbcEstado;
    @FXML
    private TableColumn<CajaTv, String> tbcFechaApertura;
    @FXML
    private TableColumn<CajaTv, String> tbcFechaCierre;
    @FXML
    private TableColumn<CajaTv, Number> tbcMontoCierre;
    @FXML
    private TableColumn<CajaTv, Number> tbcApertura;
    @FXML
    private TableColumn<CajaTv, String> tbcObs;
    ObservableList<SucursalEmisorDto> sucursalLista;
    ObservableList<EmisorDto> emisoresLista;
    SucursalEmisorDto sucursalPrincipal = new SucursalEmisorDto();
    ObservableList<CajaDto> cajas;

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            this.sucursalPrincipal = suc = (SucursalEmisorDto)this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaIni.setValue((Object)localDate.minusDays(7L));
        this.dpFechaFin.setValue((Object)localDate);
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.sucursalPrincipal = (SucursalEmisorDto)this.sucursalLista.get(0);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    private void getCajas(Integer idSucursal, String ini, String fin) {
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.getCajasSucursalEmisor(idSucursal, ini, fin);
        if (respuesta.getEstado().booleanValue()) {
            this.cajas = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_cajas.getItems().clear();
            this.tv_cajas.setItems(this.converterTv(this.cajas));
        } else {
            this.tv_cajas.getItems().clear();
        }
    }

    private void crearRelacionTv() {
        this.tbcEstado.setCellValueFactory(cd -> ((CajaTv)cd.getValue()).estado);
        this.tbcObs.setCellValueFactory(cd -> ((CajaTv)cd.getValue()).observaciones);
        this.tbcFechaApertura.setCellValueFactory(cd -> ((CajaTv)cd.getValue()).fechaApertura);
        this.tbcFechaCierre.setCellValueFactory(cd -> ((CajaTv)cd.getValue()).fechaCierre);
        this.tbcMontoCierre.setCellValueFactory(cd -> ((CajaTv)cd.getValue()).montoCierre);
        this.tbcApertura.setCellValueFactory(cd -> ((CajaTv)cd.getValue()).montoApertura);
    }

    private ObservableList<CajaTv> converterTv(ObservableList<CajaDto> cajas) {
        ObservableList cajasTv = FXCollections.observableArrayList();
        for (CajaDto cajaDto : cajas) {
            CajaTv cajTv = new CajaTv(cajaDto);
            cajasTv.add((Object)cajTv);
        }
        return cajasTv;
    }

    @FXML
    private void onBtnVerCaja() {
        if (this.tv_cajas.getSelectionModel().getSelectedItem() != null) {
            if (((CajaTv)this.tv_cajas.getSelectionModel().getSelectedItem()).getCaja().getIdCierre() != null) {
                CierreCajaDto cierreCajaDto = null;
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CerrarCajaView.fxml"));
                Parent root1 = null;
                try {
                    root1 = (Parent)fxmlLoader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                }
                CerrarCajaViewController controller = (CerrarCajaViewController)fxmlLoader.getController();
                CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
                Respuesta respuesta = service.getCierreById(((CajaTv)this.tv_cajas.getSelectionModel().getSelectedItem()).getCaja().getIdCierre());
                if (respuesta.getEstado().booleanValue()) {
                    cierreCajaDto = (CierreCajaDto)respuesta.getResultado(ESTADO.OK.VALUE());
                }
                controller.setCierreCajaDto(cierreCajaDto, ((CajaTv)this.tv_cajas.getSelectionModel().getSelectedItem()).getCaja());
                FuncionesGenerales.showView(root1);
            } else {
                NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "La caja no tiene un cierre asociado.");
            }
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe seleccionar una caja para continuar.");
        }
    }

    @FXML
    private void onCbxEmisorChanged() {
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            this.sucursalPrincipal = suc = (SucursalEmisorDto)this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
            this.getCajas(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString());
        }
    }

    @FXML
    private void onCbxSucursalChanged() {
        this.getCajas(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString());
    }

    @FXML
    private void onBtnBuscar() {
        this.getCajas(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString());
    }
}

