/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.model.CierreCajaDto;
import electricpos.model.GlobalApp;
import electricpos.model.MesDto;
import electricpos.model.NotificacionType;
import electricpos.service.CajasService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;

public class CerrarCajaMesViewController
implements Initializable {
    @FXML
    private Label lblFechaIni;
    @FXML
    private Label lblFechaFin;
    @FXML
    private Label lblUsuario;
    @FXML
    private Label lblTitulo;
    @FXML
    private Label lblMontoVentasEfectivo;
    @FXML
    private Label lblMontoVentasTarjeta;
    @FXML
    private Label lblCanOtrosIngresos;
    @FXML
    private Label lblMontoOtrosIngresos;
    @FXML
    private Label lblCanGastos;
    @FXML
    private Label lblMontoGastos;
    @FXML
    private Label lblTotalVentas;
    @FXML
    private TextArea txaObservaciones;
    @FXML
    private Label lblCantRetiros;
    @FXML
    private Label lblMontoRetiros;
    @FXML
    private Label lblMontoVentasBanco;
    @FXML
    private Label lblTotalIngresos;
    @FXML
    private Label lblTotalEgresos;
    @FXML
    private Label lblDiferencia;
    @FXML
    private ComboBox<MesDto> cbxMes;
    @FXML
    private ComboBox<String> cbxAno;
    @FXML
    JFXButton btnGuardar;
    @FXML
    JFXButton btnGenerar;
    @FXML
    JFXButton bntReporte;
    private String fechaInicial;
    private String fechaFinal;
    LocalDateTime fechaSeleccionada;
    LocalDateTime fechaFin;
    private LocalDateTime fechaActual;
    private CierreCajaDto cierreCajaDto = new CierreCajaDto();
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    DecimalFormat formatterSimpleMonedaSuma = new DecimalFormat("+ #,##0.00 CRC");
    DecimalFormat formatterSimpleMonedaResta = new DecimalFormat("- #,##0.00 CRC");
    DecimalFormat formatterSimpleMoneda = new DecimalFormat("#,##0.00 CRC");
    DecimalFormat formatterSimple = new DecimalFormat("#,##0.00");
    DecimalFormat formatterEntero = new DecimalFormat("#,##0");

    public void initialize(URL url, ResourceBundle rb) {
        this.limpiarReporteCaja();
        this.bntReporte.setVisible(false);
        this.fechaActual = LocalDateTime.now();
        this.lblUsuario.setText(GlobalApp.usuarioLogueado.getNombreUsuario());
        this.fillMonths();
        this.calcularFechasCierre();
    }

    @FXML
    private void onBtnGuardar() {
        if (this.funcionesGenerales.getConfirmacionMensajeView("\u00bfEsta seguro de cerrar y guardar la caja?")) {
            this.guardarCaja();
        }
    }

    @FXML
    private void onBtnCancelar() {
        Stage stage = (Stage)this.cbxMes.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onCbxMesChanged() {
        this.limpiarReporteCaja();
        this.calcularFechasCierre();
    }

    @FXML
    private void onBtnGenerar() {
        this.generarCierreMes();
    }

    public void setCierreCajaDto(CierreCajaDto cierreCajaDto) {
        this.cierreCajaDto = cierreCajaDto;
        this.llenarReporteCaja(cierreCajaDto);
        this.lblFechaIni.setText(FuncionesGenerales.getDateSimpleFormated(cierreCajaDto.getFecha()));
        this.lblFechaFin.setText(FuncionesGenerales.getDateSimpleFormated(cierreCajaDto.getFechaFin()));
        this.txaObservaciones.setText(cierreCajaDto.getObservaciones());
        this.lblUsuario.setText(cierreCajaDto.getUsuario());
        int mes = cierreCajaDto.getFecha().getMonthValue();
        MesDto selected = new MesDto();
        selected = this.cbxMes.getItems().stream().filter(c -> c.getNumero() == mes).findAny().orElse(null);
        this.cbxMes.getSelectionModel().select((Object)selected);
        ArrayList<String> yearList = new ArrayList<String>();
        yearList.add(String.valueOf(cierreCajaDto.getFecha().getYear()));
        ObservableList years = FXCollections.observableArrayList(yearList);
        this.cbxAno.setItems(years);
        this.cbxAno.getSelectionModel().selectFirst();
        this.txaObservaciones.setDisable(true);
        this.cbxMes.setDisable(true);
        this.cbxAno.setDisable(true);
        this.btnGuardar.setDisable(true);
        this.btnGenerar.setVisible(false);
        this.bntReporte.setVisible(true);
    }

    private void generarCierreMes() {
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.getReporteCierreMes(GlobalApp.idSucursal, this.fechaInicial, this.fechaFinal);
        if (respuesta.getEstado().booleanValue()) {
            this.cierreCajaDto = (CierreCajaDto)respuesta.getResultado(ESTADO.OK.VALUE());
            this.llenarReporteCaja(this.cierreCajaDto);
        } else {
            this.limpiarReporteCaja();
        }
    }

    private void guardarCaja() {
        this.cierreCajaDto.setObservaciones(this.txaObservaciones.getText());
        this.cierreCajaDto.setMontoApertura(BigDecimal.ZERO);
        this.cierreCajaDto.setUsuario(GlobalApp.usuarioLogueado.getNombreUsuario());
        this.cierreCajaDto.setFecha(this.fechaSeleccionada);
        this.cierreCajaDto.setFechaFin(this.fechaFin);
        this.cierreCajaDto.setTipo("M");
        this.cierreCajaDto.setIdSucursal(GlobalApp.idSucursal);
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.saveCierre(this.cierreCajaDto);
        if (respuesta.getEstado().booleanValue()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Cierre del mes [" + ((MesDto)this.cbxMes.getSelectionModel().getSelectedItem()).getDescripcion() + "] generado correctamente.");
            this.cierreCajaDto = (CierreCajaDto)respuesta.getResultado(ESTADO.OK.VALUE());
            if (this.cierreCajaDto != null) {
                this.generarReporte(this.cierreCajaDto.getId());
            }
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error al guardar el cierre del mes, intentente m\u00e1s tarde.");
        }
        Stage stage = (Stage)this.cbxMes.getScene().getWindow();
        stage.hide();
    }

    private void fillMonths() {
        ArrayList<MesDto> lista = new ArrayList<MesDto>();
        lista.add(new MesDto(1, "Enero"));
        lista.add(new MesDto(2, "Febrero"));
        lista.add(new MesDto(3, "Marzo"));
        lista.add(new MesDto(4, "Abril"));
        lista.add(new MesDto(5, "Mayo"));
        lista.add(new MesDto(6, "Junio"));
        lista.add(new MesDto(7, "Julio"));
        lista.add(new MesDto(8, "Agosto"));
        lista.add(new MesDto(9, "Septiembre"));
        lista.add(new MesDto(10, "Octubre"));
        lista.add(new MesDto(11, "Noviembre"));
        lista.add(new MesDto(12, "Diciembre"));
        ObservableList meses = FXCollections.observableArrayList(lista);
        ArrayList<String> yearList = new ArrayList<String>();
        yearList.add(String.valueOf(this.fechaActual.getYear()));
        ObservableList years = FXCollections.observableArrayList(yearList);
        int mes = this.fechaActual.getMonthValue();
        MesDto selected = new MesDto();
        this.cbxMes.setItems(meses);
        selected = this.cbxMes.getItems().stream().filter(c -> c.getNumero() == mes).findAny().orElse(null);
        this.cbxMes.getSelectionModel().select((Object)selected);
        this.cbxAno.setItems(years);
        this.cbxAno.getSelectionModel().selectFirst();
    }

    private void calcularFechasCierre() {
        this.fechaSeleccionada = LocalDateTime.of(this.fechaActual.getYear(), ((MesDto)this.cbxMes.getSelectionModel().getSelectedItem()).getNumero(), 1, 0, 0);
        this.fechaFin = this.fechaSeleccionada.with(TemporalAdjusters.lastDayOfMonth());
        this.lblFechaIni.setText(FuncionesGenerales.getDateSimpleFormated(this.fechaSeleccionada));
        this.lblFechaFin.setText(FuncionesGenerales.getDateSimpleFormated(this.fechaFin));
        this.fechaInicial = FuncionesGenerales.getDateApiFormated(this.fechaSeleccionada);
        this.fechaFinal = FuncionesGenerales.getDateApiFormated(this.fechaFin);
        String obs = "Cierre " + ((MesDto)this.cbxMes.getSelectionModel().getSelectedItem()).getDescripcion() + " del " + this.fechaSeleccionada.getYear();
        this.txaObservaciones.setText(obs);
        this.lblTitulo.setText("Resumen del mes " + ((MesDto)this.cbxMes.getSelectionModel().getSelectedItem()).getDescripcion() + " del " + this.fechaSeleccionada.getYear());
    }

    private void llenarReporteCaja(CierreCajaDto reporte) {
        this.lblMontoVentasEfectivo.setText(this.formatterSimpleMonedaSuma.format(reporte.getVentasEfectivo()));
        this.lblMontoVentasBanco.setText(this.formatterSimpleMonedaSuma.format(reporte.getVentasBanco()));
        this.lblMontoVentasTarjeta.setText(this.formatterSimpleMonedaSuma.format(reporte.getVentasTarjeta()));
        this.lblTotalVentas.setText(this.formatterSimpleMoneda.format(reporte.getTotalVentas()));
        this.lblCanOtrosIngresos.setText(this.formatterEntero.format(reporte.getCanOtrosIngresos()));
        this.lblCanGastos.setText(this.formatterEntero.format(reporte.getCanGastos()));
        this.lblCantRetiros.setText(this.formatterEntero.format(reporte.getCanRetiros()));
        this.lblMontoOtrosIngresos.setText(this.formatterSimpleMonedaSuma.format(reporte.getOtrosIngresos()));
        this.lblMontoGastos.setText(this.formatterSimpleMonedaResta.format(reporte.getGastos()));
        this.lblMontoRetiros.setText(this.formatterSimpleMonedaResta.format(reporte.getRetiros()));
        BigDecimal totalIngresos = reporte.getTotalVentas().add(reporte.getOtrosIngresos());
        BigDecimal totalEgresos = reporte.getGastos().add(reporte.getRetiros());
        this.lblTotalIngresos.setText(this.formatterSimpleMonedaSuma.format(totalIngresos));
        this.lblTotalEgresos.setText(this.formatterSimpleMonedaResta.format(totalEgresos));
        BigDecimal diferencia = totalIngresos.subtract(totalEgresos);
        this.cierreCajaDto.setDiferencia(diferencia);
        if (diferencia.doubleValue() > 0.0) {
            this.lblDiferencia.setText(this.formatterSimpleMonedaSuma.format(diferencia));
        }
        if (diferencia.doubleValue() < 0.0) {
            this.lblDiferencia.setText(this.formatterSimpleMoneda.format(diferencia));
        }
        if (diferencia.doubleValue() == 0.0) {
            this.lblDiferencia.setText(this.formatterSimpleMoneda.format(diferencia));
        }
    }

    private void limpiarReporteCaja() {
        this.lblMontoVentasEfectivo.setText(this.formatterSimpleMonedaSuma.format(0L));
        this.lblMontoVentasBanco.setText(this.formatterSimpleMonedaSuma.format(0L));
        this.lblMontoVentasTarjeta.setText(this.formatterSimpleMonedaSuma.format(0L));
        this.lblTotalVentas.setText(this.formatterSimpleMoneda.format(0L));
        this.lblCanOtrosIngresos.setText(this.formatterEntero.format(0L));
        this.lblCanGastos.setText(this.formatterEntero.format(0L));
        this.lblCantRetiros.setText(this.formatterEntero.format(0L));
        this.lblMontoOtrosIngresos.setText(this.formatterSimpleMonedaSuma.format(0L));
        this.lblMontoGastos.setText(this.formatterSimpleMonedaResta.format(0L));
        this.lblMontoRetiros.setText(this.formatterSimpleMonedaResta.format(0L));
    }

    private void generarReporte(Integer idCierre) {
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.getReporteCierreMes(idCierre, GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
            try {
                File file = File.createTempFile("CierreMes", ".pdf");
                FileOutputStream output = new FileOutputStream(file);
                JasperExportManager.exportReportToPdfStream((JasperPrint)reporte, (OutputStream)output);
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(file);
                        NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Reporte de cierre de mes generado correctamente.");
                    }
                    catch (IOException ex) {
                        NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al intentar abrir el reporte generado.");
                    }
                }
            }
            catch (Exception ex) {
                NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error generando el reporte de cierre de mes.");
            }
        }
    }

    @FXML
    private void onBtnReporte() {
        this.generarReporte(this.cierreCajaDto.getId());
    }
}

