/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.CierreFisicoViewController;
import electricpos.controller.PrincipalController;
import electricpos.model.CajaDto;
import electricpos.model.CierreCajaDto;
import electricpos.model.CierreFisicoDto;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.service.CajasService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;

public class CerrarCajaViewController
implements Initializable {
    @FXML
    private Label lblFechaApertura;
    @FXML
    private Label lblFechaCierre;
    @FXML
    private Label lblUsuarioApertura;
    @FXML
    private Label lblUsuarioCierre;
    @FXML
    private Label lblMontoVentasEfectivo;
    @FXML
    private Label lblMontoVentasBanco;
    @FXML
    private Label lblMontoVentasTarjeta;
    @FXML
    private Label lblMontoOtrosIngresos;
    @FXML
    private Label lblCanOtrosIngresos;
    @FXML
    private Label lblMontoGastos;
    @FXML
    private Label lblCanGastos;
    @FXML
    private Label lblTotalFisico;
    @FXML
    private Label lblTotalFisico2;
    @FXML
    private Label lblTotalVentasDia;
    @FXML
    private Label lblTotalSistema;
    @FXML
    private Label lblDiferencia;
    @FXML
    private Label lblMontoApertura;
    @FXML
    private Label lblMontoRetiros;
    @FXML
    private Label lblCantRetiros;
    @FXML
    private TextArea txaObservaciones;
    @FXML
    private JFXButton btnReporte;
    @FXML
    private JFXButton btnCerrarCaja;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    DecimalFormat formatterSimpleMonedaSuma = new DecimalFormat("+ #,##0.00 CRC");
    DecimalFormat formatterSimpleMonedaResta = new DecimalFormat("- #,##0.00 CRC");
    DecimalFormat formatterSimpleMoneda = new DecimalFormat("#,##0.00 CRC");
    DecimalFormat formatterSimple = new DecimalFormat("#,##0.00");
    DecimalFormat formatterEntero = new DecimalFormat("#,##0");
    private CajaDto cajaActual;
    CierreCajaDto cierreCajaDto = new CierreCajaDto();
    CierreFisicoDto cierreFisicoDto = new CierreFisicoDto();
    double totalFisico = 0.0;
    double totalVentasDia = 0.0;

    public void initialize(URL url, ResourceBundle rb) {
    }

    public void setCierreCajaDto(CierreCajaDto cierreCajaDto, CajaDto caja) {
        this.cierreCajaDto = cierreCajaDto;
        if (cierreCajaDto == null) {
            this.cargarCajaActual();
            this.cargarReporteCaja();
            this.calcularDiferencia();
            this.btnReporte.setVisible(false);
            this.btnCerrarCaja.setDisable(false);
        } else {
            this.btnReporte.setVisible(true);
            this.btnCerrarCaja.setDisable(true);
            this.lblFechaApertura.setText(FuncionesGenerales.getDateFormatedSort(caja.getFechaApertura()));
            this.lblFechaCierre.setText(FuncionesGenerales.getDateFormatedSort(caja.getFechaCierre()));
            this.lblUsuarioApertura.setText(caja.getUsuarioApertura());
            this.lblUsuarioCierre.setText(caja.getUsuarioCierre());
            this.lblMontoApertura.setText(this.formatterSimpleMoneda.format(caja.getMontoApertura()));
            this.lblTotalSistema.setText(this.formatterSimpleMoneda.format(cierreCajaDto.getTotalSistema()));
            this.lblTotalFisico.setText(this.formatterSimpleMoneda.format(cierreCajaDto.getTotalFisico()));
            this.lblTotalFisico2.setText(this.formatterSimpleMoneda.format(cierreCajaDto.getTotalFisico()));
            if (cierreCajaDto.getDiferencia().doubleValue() > 0.0) {
                this.lblDiferencia.setText(this.formatterSimpleMonedaSuma.format(cierreCajaDto.getDiferencia()));
            }
            if (cierreCajaDto.getDiferencia().doubleValue() < 0.0) {
                this.lblDiferencia.setText(this.formatterSimpleMoneda.format(cierreCajaDto.getDiferencia()));
            }
            if (cierreCajaDto.getDiferencia().doubleValue() == 0.0) {
                this.lblDiferencia.setText(this.formatterSimpleMoneda.format(cierreCajaDto.getDiferencia()));
            }
            this.txaObservaciones.setText(cierreCajaDto.getObservaciones());
            this.llenarReporteCaja(cierreCajaDto);
        }
    }

    @FXML
    private void onBtnGuardar() {
        if (this.funcionesGenerales.getConfirmacionMensajeView("\u00bfEsta seguro de cerrar y guardar la caja?")) {
            this.guardarCaja();
        }
    }

    @FXML
    private void onBtnCancelar() {
        Stage stage = (Stage)this.lblTotalFisico.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnConteo() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CierreFisicoView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
        CierreFisicoViewController controller = (CierreFisicoViewController)fxmlLoader.getController();
        controller.setCierreFisicoDto(this.cierreFisicoDto);
        FuncionesGenerales.showView(root1);
        if (controller.guardado) {
            this.cierreFisicoDto = controller.cierreFisicoDto;
            this.totalFisico = controller.totalFisico;
            this.lblTotalFisico.setText(this.formatterSimpleMoneda.format(this.totalFisico));
            this.lblTotalFisico2.setText(this.formatterSimpleMoneda.format(this.totalFisico));
            this.calcularDiferencia();
        }
    }

    private void cargarCajaActual() {
        this.cajaActual = this.funcionesGenerales.getUltimaCaja();
        try {
            if (this.cajaActual != null) {
                this.lblFechaApertura.setText(FuncionesGenerales.getDateFormatedSort(this.cajaActual.getFechaApertura()));
                this.lblFechaCierre.setText(FuncionesGenerales.getDateFormatedSort(LocalDateTime.now()));
                this.lblUsuarioApertura.setText(this.cajaActual.getUsuarioApertura());
                this.lblUsuarioCierre.setText(GlobalApp.usuarioLogueado.getNombre() + " " + GlobalApp.usuarioLogueado.getPrimerApellido());
                this.lblMontoApertura.setText(this.formatterSimpleMoneda.format(this.cajaActual.getMontoApertura()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cargarReporteCaja() {
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.getReporteCierre(this.cajaActual.getId());
        if (respuesta.getEstado().booleanValue()) {
            this.cierreCajaDto = (CierreCajaDto)respuesta.getResultado(ESTADO.OK.VALUE());
            this.llenarReporteCaja(this.cierreCajaDto);
        }
    }

    private void llenarReporteCaja(CierreCajaDto reporte) {
        this.lblMontoVentasEfectivo.setText(this.formatterSimpleMonedaSuma.format(reporte.getVentasEfectivo()));
        this.lblMontoVentasBanco.setText(this.formatterSimpleMoneda.format(reporte.getVentasBanco()));
        this.lblMontoVentasTarjeta.setText(this.formatterSimpleMoneda.format(reporte.getVentasTarjeta()));
        this.lblTotalVentasDia.setText(this.formatterSimpleMoneda.format(reporte.getTotalVentas()));
        this.lblCanOtrosIngresos.setText(this.formatterEntero.format(reporte.getCanOtrosIngresos()));
        this.lblCanGastos.setText(this.formatterEntero.format(reporte.getCanGastos()));
        this.lblCantRetiros.setText(this.formatterEntero.format(reporte.getCanRetiros()));
        this.lblMontoOtrosIngresos.setText(this.formatterSimpleMonedaSuma.format(reporte.getOtrosIngresos()));
        this.lblMontoGastos.setText(this.formatterSimpleMoneda.format(reporte.getGastos()));
        this.lblMontoRetiros.setText(this.formatterSimpleMonedaResta.format(reporte.getRetiros()));
    }

    private void calcularDiferencia() {
        BigDecimal totalSistema = this.cierreCajaDto.getTotalVentas().add(this.cajaActual.getMontoApertura()).add(this.cierreCajaDto.getOtrosIngresos());
        totalSistema = totalSistema.subtract(this.cierreCajaDto.getRetiros());
        this.lblTotalSistema.setText(this.formatterSimpleMoneda.format(totalSistema));
        BigDecimal totalCajaFisico = new BigDecimal(this.totalFisico);
        BigDecimal diferencia = totalCajaFisico.subtract(totalSistema);
        this.cierreCajaDto.setTotalSistema(totalSistema);
        this.cierreCajaDto.setTotalFisico(totalCajaFisico);
        this.cierreCajaDto.setDiferencia(diferencia);
        if (diferencia.doubleValue() > 0.0) {
            this.lblDiferencia.setText(this.formatterSimpleMonedaSuma.format(diferencia));
        }
        if (diferencia.doubleValue() < 0.0) {
            this.lblDiferencia.setText(this.formatterSimpleMoneda.format(diferencia));
        }
        if (diferencia.doubleValue() == 0.0) {
            this.lblDiferencia.setText(this.formatterSimpleMoneda.format(diferencia));
        }
    }

    private void guardarCaja() {
        this.cajaActual = this.funcionesGenerales.getUltimaCaja();
        this.cierreCajaDto.setIdCaja(this.cajaActual.getId());
        this.cierreCajaDto.setObservaciones(this.txaObservaciones.getText());
        this.cierreCajaDto.setMontoApertura(this.cajaActual.getMontoApertura());
        this.cierreCajaDto.setUsuario(GlobalApp.usuarioLogueado.getNombre() + " " + GlobalApp.usuarioLogueado.getPrimerApellido());
        this.cierreCajaDto.setFecha(this.cajaActual.getFechaApertura());
        this.cierreCajaDto.setFechaFin(LocalDateTime.now());
        this.cierreCajaDto.setTipo("C");
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.saveCierre(this.cierreCajaDto);
        if (respuesta.getEstado().booleanValue()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Caja cerrada correctamente.");
            this.cierreCajaDto = (CierreCajaDto)respuesta.getResultado(ESTADO.OK.VALUE());
            if (this.cierreCajaDto != null) {
                this.generarReporte(this.cierreCajaDto.getId());
            }
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error al cerrar la caja, intentente m\u00e1s tarde.");
        }
        Stage stage = (Stage)this.lblTotalFisico.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnReporte() {
        this.generarReporte(this.cierreCajaDto.getId());
    }

    private void generarReporte(Integer idCierre) {
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.getReporteCierreDia(idCierre, GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
            try {
                File file = File.createTempFile("CierreCaja", ".pdf");
                FileOutputStream output = new FileOutputStream(file);
                JasperExportManager.exportReportToPdfStream((JasperPrint)reporte, (OutputStream)output);
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(file);
                        NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Reporte de cierre de caja generado correctamente.");
                    }
                    catch (IOException ex) {
                        NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al intentar abrir el reporte generado.");
                    }
                }
            }
            catch (Exception ex) {
                NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error generando el reporte de cierre de caja.");
            }
        }
    }
}

