/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.CierreFisicoDto;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class CierreFisicoViewController
implements Initializable {
    @FXML
    private TextField txtCan50m;
    @FXML
    private TextField txtCan20m;
    @FXML
    private TextField txtCan10m;
    @FXML
    private TextField txtTot50m;
    @FXML
    private TextField txtTot20m;
    @FXML
    private TextField txtTot10m;
    @FXML
    private TextField txtCan500;
    @FXML
    private TextField txtCan100;
    @FXML
    private TextField txtCan50;
    @FXML
    private TextField txtTot500;
    @FXML
    private TextField txtTot100;
    @FXML
    private TextField txtTot50;
    @FXML
    private TextField txtCan5m;
    @FXML
    private TextField txtCan2m;
    @FXML
    private TextField txtCan1m;
    @FXML
    private TextField txtTot5m;
    @FXML
    private TextField txtTot2m;
    @FXML
    private TextField txtTot1m;
    @FXML
    private TextField txtCan25;
    @FXML
    private TextField txtCan10;
    @FXML
    private TextField txtCan5;
    @FXML
    private TextField txtTot25;
    @FXML
    private TextField txtTot10;
    @FXML
    private TextField txtTot5;
    @FXML
    private Label lblTotal;
    public double totalFisico = 0.0;
    public boolean guardado = false;
    public CierreFisicoDto cierreFisicoDto = new CierreFisicoDto();

    public void initialize(URL url, ResourceBundle rb) {
        this.addEventos();
    }

    @FXML
    private void onBtnGuardar() {
        this.guardarCierreFisico();
    }

    @FXML
    private void onBtnCancelar() {
        this.guardado = false;
        this.closeView();
    }

    private void closeView() {
        Stage stage = (Stage)this.lblTotal.getScene().getWindow();
        stage.hide();
    }

    private Double calcularMonto(double total, String cantidad) {
        return cantidad.isEmpty() || cantidad == null ? 0.0 : total * Double.valueOf(cantidad);
    }

    private void addEventos() {
        this.txtCan50m.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot50m.setText(CierreFisicoViewController.this.calcularMonto(50000.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan20m.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot20m.setText(CierreFisicoViewController.this.calcularMonto(20000.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan10m.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot10m.setText(CierreFisicoViewController.this.calcularMonto(10000.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan5m.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot5m.setText(CierreFisicoViewController.this.calcularMonto(5000.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan2m.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot2m.setText(CierreFisicoViewController.this.calcularMonto(2000.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan1m.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot1m.setText(CierreFisicoViewController.this.calcularMonto(1000.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan500.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot500.setText(CierreFisicoViewController.this.calcularMonto(500.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan100.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot100.setText(CierreFisicoViewController.this.calcularMonto(100.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan50.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot50.setText(CierreFisicoViewController.this.calcularMonto(50.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan25.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot25.setText(CierreFisicoViewController.this.calcularMonto(25.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan10.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot10.setText(CierreFisicoViewController.this.calcularMonto(10.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
        this.txtCan5.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CierreFisicoViewController.this.txtTot5.setText(CierreFisicoViewController.this.calcularMonto(5.0, newValue).toString());
                CierreFisicoViewController.this.calcularTotal();
            }
        });
    }

    private void calcularTotal() {
        double total = Double.valueOf(this.txtTot50m.getText()) + Double.valueOf(this.txtTot20m.getText()) + Double.valueOf(this.txtTot10m.getText()) + Double.valueOf(this.txtTot5m.getText()) + Double.valueOf(this.txtTot1m.getText()) + Double.valueOf(this.txtTot500.getText()) + Double.valueOf(this.txtTot100.getText()) + Double.valueOf(this.txtTot50.getText()) + Double.valueOf(this.txtTot25.getText()) + Double.valueOf(this.txtTot10.getText()) + Double.valueOf(this.txtTot5.getText());
        this.lblTotal.setText(String.valueOf(total));
        this.totalFisico = total;
    }

    public void setCierreFisicoDto(CierreFisicoDto cierreFisicoDto) {
        this.cierreFisicoDto = cierreFisicoDto;
        this.txtCan50m.setText(cierreFisicoDto.getCan50m().toString());
        this.txtCan20m.setText(cierreFisicoDto.getCan20m().toString());
        this.txtCan10m.setText(cierreFisicoDto.getCan10m().toString());
        this.txtCan5m.setText(cierreFisicoDto.getCan5m().toString());
        this.txtCan2m.setText(cierreFisicoDto.getCan2m().toString());
        this.txtCan1m.setText(cierreFisicoDto.getCan1m().toString());
        this.txtCan500.setText(cierreFisicoDto.getCan500().toString());
        this.txtCan100.setText(cierreFisicoDto.getCan100().toString());
        this.txtCan50.setText(cierreFisicoDto.getCan50().toString());
        this.txtCan25.setText(cierreFisicoDto.getCan25().toString());
        this.txtCan10.setText(cierreFisicoDto.getCan10().toString());
        this.txtCan5.setText(cierreFisicoDto.getCan5().toString());
        this.calcularTotal();
    }

    private void guardarCierreFisico() {
        this.cierreFisicoDto.setCan50m(Integer.valueOf(this.txtCan50m.getText()));
        this.cierreFisicoDto.setCan20m(Integer.valueOf(this.txtCan20m.getText()));
        this.cierreFisicoDto.setCan10m(Integer.valueOf(this.txtCan10m.getText()));
        this.cierreFisicoDto.setCan5m(Integer.valueOf(this.txtCan5m.getText()));
        this.cierreFisicoDto.setCan2m(Integer.valueOf(this.txtCan2m.getText()));
        this.cierreFisicoDto.setCan1m(Integer.valueOf(this.txtCan1m.getText()));
        this.cierreFisicoDto.setCan500(Integer.valueOf(this.txtCan500.getText()));
        this.cierreFisicoDto.setCan100(Integer.valueOf(this.txtCan100.getText()));
        this.cierreFisicoDto.setCan50(Integer.valueOf(this.txtCan50.getText()));
        this.cierreFisicoDto.setCan25(Integer.valueOf(this.txtCan25.getText()));
        this.cierreFisicoDto.setCan10(Integer.valueOf(this.txtCan10.getText()));
        this.cierreFisicoDto.setCan5(Integer.valueOf(this.txtCan5.getText()));
        this.guardado = true;
        this.closeView();
    }
}

