/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.CerrarCajaMesViewController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.model.CierreCajaDto;
import electricpos.model.CierreCajaTv;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.CajasService;
import electricpos.service.EmisorService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class CierresMesViewController
implements Initializable {
    @FXML
    private ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    private TableView<CierreCajaTv> tv_cierres;
    @FXML
    private TableColumn<CierreCajaTv, String> tbcObs;
    @FXML
    private TableColumn<CierreCajaTv, String> tbcFechaApertura;
    @FXML
    private TableColumn<CierreCajaTv, String> tbcFechaCierre;
    @FXML
    private TableColumn<CierreCajaTv, String> tbcUsuario;
    @FXML
    private TableColumn<CierreCajaTv, Number> tbcMonto;
    ObservableList<SucursalEmisorDto> sucursalLista;
    ObservableList<EmisorDto> emisoresLista;
    SucursalEmisorDto sucursalPrincipal = new SucursalEmisorDto();
    ObservableList<CierreCajaDto> cierres;
    CierreCajaDto cierreCajaSeleccionada = new CierreCajaDto();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            this.sucursalPrincipal = suc = (SucursalEmisorDto)this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
            this.getCierres(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        }
    }

    @FXML
    private void onBtnVerCierre() {
        if (this.tv_cierres.getSelectionModel().getSelectedItem() != null) {
            this.cierreCajaSeleccionada = ((CierreCajaTv)this.tv_cierres.getSelectionModel().getSelectedItem()).getCierreCajaDto();
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CerrarCajaMesView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            CerrarCajaMesViewController controller = (CerrarCajaMesViewController)fxmlLoader.getController();
            controller.setCierreCajaDto(this.cierreCajaSeleccionada);
            FuncionesGenerales.showView(root1);
            this.getCierres(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe seleccionar un cierre de mes a ver.");
        }
    }

    @FXML
    private void onCbxEmisorChanged() {
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            this.sucursalPrincipal = suc = (SucursalEmisorDto)this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
            this.getCierres(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        }
    }

    @FXML
    private void onCbxSucursalChanged() {
        this.getCierres(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
    }

    @FXML
    private void onBtnBuscar() {
        this.getCierres(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
    }

    private void getCierres(Integer idSucursal) {
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.getCierresMes(idSucursal);
        if (respuesta.getEstado().booleanValue()) {
            this.cierres = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_cierres.getItems().clear();
            this.tv_cierres.setItems(this.converterTv(this.cierres));
        } else {
            this.tv_cierres.getItems().clear();
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.sucursalPrincipal = (SucursalEmisorDto)this.sucursalLista.get(0);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    private void crearRelacionTv() {
        this.tbcUsuario.setCellValueFactory(cd -> ((CierreCajaTv)cd.getValue()).usuario);
        this.tbcObs.setCellValueFactory(cd -> ((CierreCajaTv)cd.getValue()).observaciones);
        this.tbcFechaApertura.setCellValueFactory(cd -> ((CierreCajaTv)cd.getValue()).fechaApertura);
        this.tbcFechaCierre.setCellValueFactory(cd -> ((CierreCajaTv)cd.getValue()).fechaCierre);
        this.tbcMonto.setCellValueFactory(cd -> ((CierreCajaTv)cd.getValue()).totalVentas);
    }

    private ObservableList<CierreCajaTv> converterTv(ObservableList<CierreCajaDto> cajas) {
        ObservableList cajasTv = FXCollections.observableArrayList();
        for (CierreCajaDto cajaDto : cajas) {
            CierreCajaTv cajTv = new CierreCajaTv(cajaDto);
            cajasTv.add((Object)cajTv);
        }
        return cajasTv;
    }
}

