/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.BusquedaClienteViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.model.Customer;
import electricpos.model.CustomerActivity;
import electricpos.model.EmisorDto;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.model.IdentificacionDto;
import electricpos.model.NotificacionType;
import electricpos.model.ReceptorDto;
import electricpos.service.CustomerService;
import electricpos.service.ReceptorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import electricpos.util.VALIDACION;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class ClienteViewController
implements Initializable {
    @FXML
    private JFXButton btnCancelar;
    @FXML
    private JFXButton btnValidar;
    @FXML
    private JFXButton btnGuardar;
    @FXML
    private TextField txtIdentificacion;
    @FXML
    private TextField txtNombre;
    @FXML
    private TextField txtCorreo;
    @FXML
    ComboBox<CustomerActivity> cbxActividades;
    @FXML
    private TextField txtActividad;
    @FXML
    private Text txtCorreoRequerido;
    @FXML
    private Label lblEstadoValidacion;
    @FXML
    private JFXButton btnReintentarValidacion;
    @FXML
    private Label lblNoActividades;
    ObservableList<IdentificacionDto> tipoIdentificacionesLista;
    public ReceptorDto receptorDto = new ReceptorDto();
    public Integer idReceptor;
    public boolean desdeFacturacion = true;
    public Integer idEmisor = null;
    private Customer selectedCustomer = null;
    private String tipoIdentificacion = null;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    private static final int MAX_REINTENTOS = 3;
    private static final int TIEMPO_ESPERA_MS = 1500;
    private String ultimaIdentificacionBuscada = "";
    private boolean validando = false;
    private static final long CUSTOMER_TIMEOUT_SECONDS = 3L;

    public void initialize(URL url, ResourceBundle rb) {
        FuncionesGenerales.setValidationTextField(this.txtIdentificacion, VALIDACION.IDENTIFICACION);
        this.btnValidar.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.txtActividad.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !newValue.isEmpty()) {
                if (!newValue.matches("\\d*")) {
                    this.txtActividad.setText(oldValue);
                }
                if (newValue.length() > 6) {
                    this.txtActividad.setText(newValue.substring(0, 6));
                }
            }
        });
    }

    @FXML
    private void OnBtnCancelar() {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void OnBtnGuardar() {
        this.guardarReceptor();
    }

    @FXML
    private void onBtnBuscarIdentificacion() {
        if (!this.txtIdentificacion.getText().isEmpty()) {
            this.buscarConReintentos(this.txtIdentificacion.getText());
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "Debe de ingresar un n\u00famero de identificaci\u00f3n.");
        }
    }

    @FXML
    private void onBtnReintentarValidacion() {
        if (!this.ultimaIdentificacionBuscada.isEmpty()) {
            this.buscarConReintentos(this.ultimaIdentificacionBuscada);
        } else {
            this.actualizarEstadoValidacion("No hay b\u00fasqueda previa para reintentar.", false);
        }
    }

    @FXML
    private void onBtnFiltrar() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/BusquedaClienteView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex2) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex2);
        }
        BusquedaClienteViewController busquedaClienteViewController = (BusquedaClienteViewController)fxmlLoader.getController();
        busquedaClienteViewController.setIdEmisor(this.idEmisor);
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
        if (busquedaClienteViewController.selecciono) {
            ReceptorDto receptorSeleccionado = busquedaClienteViewController.getReceptorSeleccionado();
            this.idReceptor = receptorSeleccionado.getId();
            if (receptorSeleccionado.getTipoIdentificacion() != null) {
                ((CompletableFuture)FuncionesGenerales.fetchCustomerAsync(receptorSeleccionado.getNumeroIdentificacion()).thenAccept(customerOpt -> customerOpt.ifPresent(customer -> {
                    this.txtNombre.setText(customer.getNombre());
                    this.txtIdentificacion.setText(customer.getTipoIdentificacion());
                }))).exceptionally(ex -> null);
                CustomerService customerService = (CustomerService)AppContext.getInstance().get("CustomerService");
                CompletableFuture<Respuesta> futureCustomer = CompletableFuture.supplyAsync(() -> customerService.getCustomer(receptorSeleccionado.getNumeroIdentificacion()));
                CompletableFuture.allOf(futureCustomer).thenRun(() -> {
                    try {
                        Respuesta respuestaCustomer = (Respuesta)futureCustomer.get();
                        if (respuestaCustomer.getEstado().booleanValue()) {
                            Customer customer = (Customer)respuestaCustomer.getResultado(ESTADO.OK.VALUE());
                            if (!respuestaCustomer.getEstado().booleanValue()) {
                                this.selectedCustomer = customer;
                                this.txtNombre.setText(customer.getNombre());
                                this.txtIdentificacion.setText(customer.getTipoIdentificacion());
                                this.tipoIdentificacion = customer.getTipoIdentificacion();
                            }
                        }
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                });
                this.txtIdentificacion.setText(receptorSeleccionado.getNumeroIdentificacion());
            }
            this.txtNombre.setText(receptorSeleccionado.getNombre());
            this.txtCorreo.setText(receptorSeleccionado.getCorreo());
        }
    }

    private void buscarConReintentos(String identificacion) {
        if (this.validando) {
            return;
        }
        this.ultimaIdentificacionBuscada = identificacion;
        this.validando = true;
        this.actualizarEstadoValidacion("Validando identificaci\u00f3n...", false);
        this.mostrarBotonReintentar(false);
        this.txtNombre.setEditable(false);
        this.txtNombre.setText("");
        this.cbxActividades.setVisible(true);
        this.cbxActividades.setDisable(false);
        this.cbxActividades.getItems().clear();
        this.txtActividad.setVisible(false);
        this.txtActividad.setText("");
        this.lblNoActividades.setVisible(false);
        this.btnGuardar.setDisable(true);
        this.btnValidar.setVisible(true);
        CompletableFuture.runAsync(() -> {
            boolean exitoso = false;
            for (int intento = 0; intento < 3 && !exitoso; ++intento) {
                try {
                    int intentoActual = intento;
                    Platform.runLater(() -> {
                        if (intentoActual > 1) {
                            this.actualizarEstadoValidacion("Reintentando validaci\u00f3n... (Intento " + intentoActual + " de " + 3 + ")", false);
                        }
                    });
                    AtomicBoolean terminado = new AtomicBoolean(false);
                    AtomicBoolean tuvoExito = new AtomicBoolean(false);
                    Platform.runLater(() -> this.getReceptorCedula(this.idEmisor, identificacion));
                    Thread.sleep(3500L);
                    Platform.runLater(() -> {
                        if (!this.txtNombre.getText().isEmpty()) {
                            tuvoExito.set(true);
                            this.actualizarEstadoValidacion("Validaci\u00f3n exitosa", false);
                            this.mostrarBotonReintentar(false);
                            this.txtNombre.setEditable(false);
                            this.cbxActividades.setVisible(true);
                            this.cbxActividades.setDisable(false);
                            this.txtActividad.setVisible(false);
                        }
                        terminado.set(true);
                    });
                    Thread.sleep(500L);
                    if (!tuvoExito.get()) continue;
                    exitoso = true;
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    System.err.println("Error en intento " + intento + ": " + e.getMessage());
                    if (intento >= 3) continue;
                    try {
                        Thread.sleep(1500L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
            if (!exitoso) {
                Platform.runLater(() -> {
                    this.actualizarEstadoValidacion("Error al validar. Intenta de nuevo o ingresa los datos manualmente.", true);
                    this.mostrarBotonReintentar(true);
                    this.txtNombre.setEditable(true);
                    this.txtNombre.requestFocus();
                    this.cbxActividades.setVisible(false);
                    this.cbxActividades.setDisable(true);
                    this.txtActividad.setVisible(true);
                    this.txtActividad.setDisable(false);
                    this.lblNoActividades.setVisible(false);
                    this.btnGuardar.setDisable(false);
                });
            }
            this.validando = false;
        });
    }

    private void actualizarEstadoValidacion(String mensaje, boolean esError) {
        if (this.lblEstadoValidacion != null) {
            Platform.runLater(() -> {
                this.lblEstadoValidacion.setText(mensaje);
                this.lblEstadoValidacion.setStyle(esError ? "-fx-text-fill: #D32F2F; -fx-font-weight: bold;" : "-fx-text-fill: #616161;");
                this.lblEstadoValidacion.setVisible(true);
            });
        }
    }

    private void mostrarBotonReintentar(boolean mostrar) {
        if (this.btnReintentarValidacion != null && this.btnValidar != null) {
            Platform.runLater(() -> {
                this.btnReintentarValidacion.setVisible(mostrar);
                this.btnValidar.setVisible(!mostrar);
            });
        }
    }

    private void getReceptorCedula(Integer idEmisor, String numero) {
        this.btnValidar.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.txtCorreoRequerido.setVisible(false);
        ReceptorService receptorService = (ReceptorService)AppContext.getInstance().get("ReceptorService");
        CustomerService customerService = (CustomerService)AppContext.getInstance().get("CustomerService");
        CompletableFuture<Respuesta> futureReceptor = CompletableFuture.supplyAsync(() -> receptorService.getReceptorIdenificacion(idEmisor, numero));
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        CompletableFuture<Respuesta> futureCustomerBase = CompletableFuture.supplyAsync(() -> customerService.getCustomer(numero));
        CompletionStage futureCustomer = ClienteViewController.withTimeout(futureCustomerBase, 3L, TimeUnit.SECONDS, scheduler).whenComplete((r, ex) -> scheduler.shutdownNow());
        AtomicBoolean receptorExito = new AtomicBoolean(false);
        AtomicBoolean customerExito = new AtomicBoolean(false);
        ReceptorDto[] receptorData = new ReceptorDto[1];
        Customer[] customerData = new Customer[1];
        CompletableFuture.allOf(new CompletableFuture[]{futureReceptor, futureCustomer}).whenComplete((arg_0, arg_1) -> this.lambda$getReceptorCedula$17(futureReceptor, receptorExito, receptorData, (CompletableFuture)futureCustomer, customerExito, customerData, numero, arg_0, arg_1));
    }

    private static <T> CompletableFuture<T> withTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit, ScheduledExecutorService scheduler) {
        CompletableFuture killer = new CompletableFuture();
        scheduler.schedule(() -> killer.completeExceptionally(new TimeoutException("Timeout " + timeout + " " + (Object)((Object)unit))), timeout, unit);
        return future.applyToEither((CompletionStage)killer, Function.identity());
    }

    public void setReceptor(ReceptorDto rec) {
        if (rec.getId() != null) {
            this.idReceptor = rec.getId();
            IdentificacionDto ide = new IdentificacionDto();
            this.txtIdentificacion.setText(rec.getNumeroIdentificacion());
            this.txtNombre.setText(rec.getNombre());
            this.txtCorreo.setText(rec.getCorreo());
        } else {
            this.idReceptor = null;
        }
    }

    public void validateCustomer(String identificacion) {
        this.btnValidar.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.txtCorreo.setDisable(true);
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        CompletionStage future = ClienteViewController.withTimeout(FuncionesGenerales.fetchCustomerAsync(identificacion), 3L, TimeUnit.SECONDS, scheduler).whenComplete((r, ex) -> scheduler.shutdownNow());
        ((CompletableFuture)future).whenComplete((customerOpt, ex) -> {
            if (ex == null && customerOpt != null && customerOpt.isPresent()) {
                Customer customer = (Customer)customerOpt.get();
                Platform.runLater(() -> {
                    this.txtIdentificacion.setText(identificacion);
                    this.cbxActividades.setItems(FXCollections.observableArrayList(customer.getActividades()));
                    this.cbxActividades.getSelectionModel().select(0);
                    this.btnGuardar.setDisable(false);
                    this.btnValidar.setVisible(false);
                    this.txtCorreo.setDisable(false);
                });
            } else {
                Platform.runLater(() -> {
                    this.btnValidar.setVisible(false);
                    this.btnGuardar.setDisable(false);
                    this.txtCorreo.setDisable(false);
                });
            }
        });
    }

    private String stringOf(Integer var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "";
        }
        return string;
    }

    private void guardarReceptor() {
        Stage stage = (Stage)this.txtCorreo.getScene().getWindow();
        if (this.validaReceptor()) {
            String textoActividad;
            if (this.idReceptor == null) {
                this.receptorDto.setId(0);
            } else {
                this.receptorDto.setId(this.idReceptor);
            }
            this.receptorDto.setTipoIdentificacion(this.tipoIdentificacion);
            this.receptorDto.setNumeroIdentificacion(this.txtIdentificacion.getText());
            this.receptorDto.setNombre(this.txtNombre.getText());
            this.receptorDto.setCorreo(this.txtCorreo.getText());
            String codigoActividad = null;
            if (this.cbxActividades.isVisible() && !this.cbxActividades.isDisable()) {
                CustomerActivity actividad = (CustomerActivity)this.cbxActividades.getSelectionModel().getSelectedItem();
                codigoActividad = actividad != null ? actividad.getCodigo() : null;
            } else if (this.txtActividad.isVisible() && !this.txtActividad.isDisable() && (textoActividad = this.txtActividad.getText()) != null && !textoActividad.trim().isEmpty()) {
                codigoActividad = textoActividad.trim();
            }
            this.receptorDto.setCodigoActividad(codigoActividad);
            EmpresaDto empresaDto = new EmpresaDto(GlobalApp.idEmpresa);
            this.receptorDto.setEmpresa(empresaDto);
            EmisorDto emisorDto = new EmisorDto(this.idEmisor);
            this.receptorDto.setEmisor(emisorDto);
            if (this.desdeFacturacion) {
                stage.hide();
            }
        }
    }

    private Integer getIntergerOf(String value) {
        Integer response;
        try {
            response = Integer.valueOf(value);
        }
        catch (Exception ex) {
            response = null;
        }
        return response;
    }

    private boolean validaReceptor() {
        if (this.txtNombre.getText().isEmpty()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Debe de ingresar un nombre para el cliente.");
            return false;
        }
        if (!this.txtCorreo.getText().isEmpty()) {
            if (FuncionesGenerales.validateEmail(this.txtCorreo.getText())) {
                return true;
            }
            this.txtCorreoRequerido.setVisible(true);
            this.txtCorreoRequerido.setText("El formato de correo electr\u00f3nico no es v\u00e1lido.");
            return false;
        }
        this.txtCorreoRequerido.setVisible(true);
        return false;
    }

    private boolean validaCedula(String tipo) {
        if (!this.txtIdentificacion.getText().isEmpty() || this.txtIdentificacion.getText() != null) {
            if (tipo.equalsIgnoreCase("01")) {
                if (this.txtIdentificacion.getText().length() != 9) {
                    NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "La c\u00e9dula f\u00edsica debe de contener 9 digitos.");
                    return false;
                }
            } else if (tipo.equalsIgnoreCase("02")) {
                if (this.txtIdentificacion.getText().length() != 10) {
                    NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "La c\u00e9dula jur\u00eddica debe de contener 10 digitos.");
                    return false;
                }
            } else if (tipo.equalsIgnoreCase("03")) {
                if (this.txtIdentificacion.getText().length() < 11 || this.txtIdentificacion.getText().length() > 12) {
                    NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "El DIMEX debe de contener 11 o 12 digitos sin ceros al inicio.");
                    return false;
                }
            } else if (tipo.equalsIgnoreCase("04") && this.txtIdentificacion.getText().length() != 10) {
                NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "El NITE debe de contener 10 digitos.");
                return false;
            }
        }
        return true;
    }

    public Integer getIdEmisor() {
        return this.idEmisor;
    }

    public void setIdEmisor(Integer idEmisor) {
        this.idEmisor = idEmisor;
    }

    private /* synthetic */ void lambda$getReceptorCedula$17(CompletableFuture futureReceptor, AtomicBoolean receptorExito, ReceptorDto[] receptorData, CompletableFuture futureCustomer, AtomicBoolean customerExito, Customer[] customerData, String numero, Void v, Throwable ex) {
        Platform.runLater(() -> {
            try {
                Respuesta respuestaReceptor = (Respuesta)futureReceptor.get();
                if (respuestaReceptor != null && respuestaReceptor.getEstado().booleanValue()) {
                    receptorExito.set(true);
                    receptorData[0] = (ReceptorDto)respuestaReceptor.getResultado(ESTADO.OK.VALUE());
                }
            }
            catch (Exception respuestaReceptor) {
                // empty catch block
            }
            try {
                Respuesta respuestaCustomer = (Respuesta)futureCustomer.get();
                if (respuestaCustomer != null && respuestaCustomer.getEstado().booleanValue()) {
                    customerExito.set(true);
                    customerData[0] = (Customer)respuestaCustomer.getResultado(ESTADO.OK.VALUE());
                }
            }
            catch (Exception respuestaCustomer) {
                // empty catch block
            }
            this.btnValidar.setContentDisplay(ContentDisplay.TEXT_ONLY);
            if (!receptorExito.get() && !customerExito.get()) {
                NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "No existe un cliente registrado con el n\u00famero de identificaci\u00f3n ingresado.");
                this.txtNombre.setText("");
                this.txtCorreo.setText("");
            } else {
                Customer customer;
                if (receptorExito.get()) {
                    ReceptorDto receptor = receptorData[0];
                    this.idReceptor = receptor.getId();
                    this.txtIdentificacion.setText(receptor.getNumeroIdentificacion());
                    this.txtNombre.setText(receptor.getNombre());
                    this.txtCorreo.setText(receptor.getCorreo());
                    this.tipoIdentificacion = receptor.getTipoIdentificacion();
                } else if (customerExito.get()) {
                    customer = customerData[0];
                    this.txtNombre.setText(customer.getNombre());
                    this.txtIdentificacion.setText(numero);
                    this.tipoIdentificacion = customer.getTipoIdentificacion();
                }
                if (customerExito.get()) {
                    this.selectedCustomer = customer = customerData[0];
                    List<CustomerActivity> actividades = customer.getActividades();
                    if (actividades != null && !actividades.isEmpty()) {
                        this.cbxActividades.setItems(FXCollections.observableArrayList(actividades));
                        this.cbxActividades.getSelectionModel().select(0);
                        this.cbxActividades.setVisible(true);
                        this.cbxActividades.setDisable(false);
                        this.txtActividad.setVisible(false);
                        this.lblNoActividades.setVisible(false);
                    } else {
                        this.cbxActividades.setItems(FXCollections.observableArrayList());
                        this.lblNoActividades.setVisible(true);
                    }
                } else if (receptorExito.get()) {
                    this.cbxActividades.setVisible(false);
                    this.cbxActividades.setDisable(true);
                    this.txtActividad.setVisible(true);
                    this.txtActividad.setDisable(false);
                    this.lblNoActividades.setVisible(false);
                    System.out.println("API de Hacienda no disponible. Ingrese c\u00f3digo de actividad manualmente.");
                }
                this.btnGuardar.setDisable(false);
            }
        });
    }
}

