/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.Colaborador;
import electricpos.model.ColaboradorDto;
import electricpos.model.GlobalApp;
import electricpos.service.ColaboradoresService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class ColaboradorFacViewController
implements Initializable {
    @FXML
    private ComboBox<ColaboradorDto> cbxColaborador;
    @FXML
    private TextField txtPorcentajeColaborador;
    @FXML
    private TextField txtPorcentajeNegocio;
    ObservableList<ColaboradorDto> colaboradores;
    private Colaborador colaboradorActual = new Colaborador();
    public Boolean aplico = false;

    public void initialize(URL url, ResourceBundle rb) {
        this.txtPorcentajeColaborador.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,3}([\\.]\\d{0,0})?")) {
                    ColaboradorFacViewController.this.txtPorcentajeColaborador.setText(oldValue);
                } else {
                    Integer porcentajeColaborador = Integer.valueOf(newValue);
                    Integer porcentajeNegocio = ColaboradorFacViewController.this.getPorcentajeRestante(porcentajeColaborador);
                    ColaboradorFacViewController.this.txtPorcentajeNegocio.setText(porcentajeNegocio.toString());
                }
            }
        });
        this.getColaboradores();
    }

    @FXML
    private void OnBtnAplicar() {
        this.colaboradorActual.setId(((ColaboradorDto)this.cbxColaborador.getSelectionModel().getSelectedItem()).getId());
        this.colaboradorActual.setPorcentaje(Integer.valueOf(this.txtPorcentajeColaborador.getText()));
        String[] name = ((ColaboradorDto)this.cbxColaborador.getSelectionModel().getSelectedItem()).getNombre().split(" ");
        this.colaboradorActual.setNombre(name[0]);
        this.aplico = true;
        Stage stage = (Stage)this.cbxColaborador.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void OnBtnCancelar() {
        this.aplico = false;
        Stage stage = (Stage)this.cbxColaborador.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onCbxColaboradorChanged() {
        if (this.cbxColaborador.getSelectionModel().getSelectedItem() != null) {
            ColaboradorDto colaboradorDto = (ColaboradorDto)this.cbxColaborador.getSelectionModel().getSelectedItem();
            this.txtPorcentajeColaborador.setText(colaboradorDto.getPorcentaje().toPlainString());
            Integer porcentajeColaborador = colaboradorDto.getPorcentaje().intValue();
            Integer porcentajeNegocio = this.getPorcentajeRestante(porcentajeColaborador);
            this.txtPorcentajeNegocio.setText(porcentajeNegocio.toString());
            this.txtPorcentajeColaborador.setText(porcentajeColaborador.toString());
        }
    }

    private void getColaboradores() {
        ColaboradoresService service = (ColaboradoresService)AppContext.getInstance().get("ColaboradoresService");
        Respuesta respuesta = service.getColaboradores(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.colaboradores = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.cbxColaborador.setItems(this.colaboradores);
            this.cbxColaborador.getSelectionModel().selectFirst();
        }
        if (this.cbxColaborador.getSelectionModel().getSelectedItem() != null) {
            ColaboradorDto colaboradorDto = (ColaboradorDto)this.cbxColaborador.getSelectionModel().getSelectedItem();
            Integer porcentajeColaborador = colaboradorDto.getPorcentaje().intValue();
            Integer porcentajeNegocio = this.getPorcentajeRestante(porcentajeColaborador);
            this.txtPorcentajeNegocio.setText(porcentajeNegocio.toString());
            this.txtPorcentajeColaborador.setText(porcentajeColaborador.toString());
        }
    }

    private Integer getPorcentajeRestante(Integer porcentaje) {
        Integer base = 100;
        if (porcentaje != null) {
            if (porcentaje <= 100) {
                return base - porcentaje;
            }
            return 0;
        }
        return base;
    }

    public Colaborador getColaboradorActual() {
        return this.colaboradorActual;
    }

    public void setColaboradorActual(Colaborador colaboradorActual) {
        this.colaboradorActual = colaboradorActual;
        if (colaboradorActual.getId() != null) {
            Integer porcentajeNegocio = this.getPorcentajeRestante(colaboradorActual.getPorcentaje());
            this.txtPorcentajeNegocio.setText(porcentajeNegocio.toString());
            this.txtPorcentajeColaborador.setText(colaboradorActual.getPorcentaje().toString());
        }
    }
}

