/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.MantColaboradorViewController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.model.ColaboradorDto;
import electricpos.model.ColaboradorTv;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.service.ColaboradoresService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class ColaboradoresViewController
implements Initializable {
    @FXML
    private TableView<ColaboradorTv> tv_colaboradores;
    @FXML
    private TableColumn<ColaboradorTv, String> tbcNombre;
    @FXML
    private TableColumn<ColaboradorTv, String> tbcRol;
    @FXML
    private TableColumn<ColaboradorTv, Number> tbcPorcentaje;
    @FXML
    private TableColumn<ColaboradorTv, String> tbcEstado;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    ObservableList<ColaboradorDto> colaboradores;
    private ColaboradorDto colaboradorSeleccionado;

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.getColaboradores();
    }

    private void crearRelacionTv() {
        this.tbcNombre.setCellValueFactory(cd -> ((ColaboradorTv)cd.getValue()).nombre);
        this.tbcRol.setCellValueFactory(cd -> ((ColaboradorTv)cd.getValue()).rol);
        this.tbcPorcentaje.setCellValueFactory(cd -> ((ColaboradorTv)cd.getValue()).porcentaje);
        this.tbcEstado.setCellValueFactory(cd -> ((ColaboradorTv)cd.getValue()).estado);
    }

    private void getColaboradores() {
        ColaboradoresService service = (ColaboradoresService)AppContext.getInstance().get("ColaboradoresService");
        Respuesta respuesta = service.getColaboradores(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.colaboradores = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_colaboradores.getItems().clear();
            this.tv_colaboradores.setItems(this.converterTv(this.colaboradores));
        } else {
            this.tv_colaboradores.getItems().clear();
        }
    }

    private ObservableList<ColaboradorTv> converterTv(ObservableList<ColaboradorDto> colaboradores) {
        ObservableList colaboradoresTv = FXCollections.observableArrayList();
        for (ColaboradorDto objDto : colaboradores) {
            ColaboradorTv objTv = new ColaboradorTv(objDto);
            colaboradoresTv.add((Object)objTv);
        }
        return colaboradoresTv;
    }

    @FXML
    private void OnBtnCrear() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantColaboradorView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        FuncionesGenerales.showView(root1);
        this.getColaboradores();
    }

    @FXML
    private void onBtnVerEditar() {
        if (this.tv_colaboradores.getSelectionModel().getSelectedItem() != null) {
            this.colaboradorSeleccionado = ((ColaboradorTv)this.tv_colaboradores.getSelectionModel().getSelectedItem()).getColaboradorDto();
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantColaboradorView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            MantColaboradorViewController controller = (MantColaboradorViewController)fxmlLoader.getController();
            controller.setColaboradorDto(this.colaboradorSeleccionado);
            FuncionesGenerales.showView(root1);
            this.getColaboradores();
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe seleccionar un colaborador a ver/editar.");
        }
    }

    @FXML
    private void onBtnEliminar() {
        if (this.tv_colaboradores.getSelectionModel().getSelectedItem() != null) {
            this.colaboradorSeleccionado = ((ColaboradorTv)this.tv_colaboradores.getSelectionModel().getSelectedItem()).getColaboradorDto();
            if (this.funcionesGenerales.getConfirmacionEliminacion()) {
                ColaboradoresService service = (ColaboradoresService)AppContext.getInstance().get("ColaboradoresService");
                Respuesta respuesta = service.deleteColaborador(this.colaboradorSeleccionado.getId());
                if (respuesta.getEstado().booleanValue()) {
                    NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "El colaborador se elimin\u00f3 satisfactoriamente.");
                } else {
                    NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un problema al eliminar el colaborador.");
                }
                this.getColaboradores();
            }
        }
    }
}

