/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.customcontrol.ComprobanteCCController;
import electricpos.model.ComprobanteHaciendaDto;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.ComprobanteHaciendaService;
import electricpos.service.EmisorService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.Respuesta;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.layout.VBox;

public class ComprobanteHaciendaViewController
implements Initializable {
    @FXML
    JFXButton btnVerficar;
    @FXML
    VBox vboxComprobantes;
    ObservableList<ComprobanteHaciendaDto> comprobanteHaciendaLista;
    EmisorDto emisorSeleccionado = null;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<SucursalEmisorDto> sucursalLista;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    DatePicker dpFechaIni;
    @FXML
    DatePicker dpFechaFin;
    String tipoComprobante = null;
    boolean interno = true;

    public String getTipoComprobante() {
        return this.tipoComprobante;
    }

    public void setTipoComprobante(String tipoComprobante) {
        this.tipoComprobante = tipoComprobante;
    }

    public void cargarComprobantes() {
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        this.cargarComprobantesHacienda();
    }

    public void initialize(URL url, ResourceBundle rb) {
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaIni.setValue((Object)localDate);
        this.dpFechaFin.setValue((Object)localDate);
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
        try {
            this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    private void cargarComprobantesHacienda() {
        ComprobanteHaciendaService comprobanteHaciendaService = (ComprobanteHaciendaService)AppContext.getInstance().get("ComprobanteHaciendaService");
        Respuesta respuesta = this.interno ? comprobanteHaciendaService.getComprobanteHaciendaFechas(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), this.tipoComprobante, ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString()) : comprobanteHaciendaService.getComprobanteHaciendaRecepcion(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString());
        this.vboxComprobantes.getChildren().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.comprobanteHaciendaLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Comprobantes")));
            if (!this.comprobanteHaciendaLista.isEmpty()) {
                for (ComprobanteHaciendaDto com : this.comprobanteHaciendaLista) {
                    ComprobanteCCController ccComprobante = new ComprobanteCCController(com);
                    this.vboxComprobantes.getChildren().add((Object)ccComprobante);
                }
            }
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void verificarEstado() {
        Integer response = 0;
        ComprobanteHaciendaService comprobanteHaciendaService = (ComprobanteHaciendaService)AppContext.getInstance().get("ComprobanteHaciendaService");
        response = comprobanteHaciendaService.getVerificarEstadoComp(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        if (response == 0) {
            // empty if block
        }
        if (response == 1) {
            this.cargarComprobantesHacienda();
        }
        if (response == 2) {
            // empty if block
        }
    }

    @FXML
    private void OnbtnVerficar(ActionEvent event) {
        this.verificarEstado();
    }

    @FXML
    private void onBtnBuscar(ActionEvent event) {
        this.cargarComprobantesHacienda();
    }

    public boolean isInterno() {
        return this.interno;
    }

    public void setInterno(boolean interno) {
        this.interno = interno;
    }
}

