/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.DetalleComElectronicoDto;
import electricpos.model.DetalleComprobanteTv;
import electricpos.service.ComprobanteService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;

public class ComprobanteResumenViewController
implements Initializable {
    @FXML
    private TableView<DetalleComprobanteTv> tv_detalleComprobante;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcDetalle;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcCantidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcPrecioUnidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcDescuento;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcTotalLinea;
    @FXML
    Label lblConsecutivo;
    @FXML
    Label lblIdentificacion;
    @FXML
    Label lblCorreo;
    @FXML
    Label lblCliente;
    @FXML
    Label lblFecha;
    @FXML
    Label lblClave;
    @FXML
    Label lblEstado;
    @FXML
    Label lblUsuario;
    @FXML
    Label lblSubTotal;
    @FXML
    Label lblTitulo;
    @FXML
    Label lblDescuentos;
    @FXML
    Label lblImpuestos;
    @FXML
    Label lblTotalcom;
    @FXML
    TextArea txtObservaciones;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    String claveComprobante = null;
    ComprobanteElectronicoDto comprobanteSeleccionado = new ComprobanteElectronicoDto();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionDetalle();
    }

    private void crearRelacionDetalle() {
        this.tv_detalleComprobante.setEditable(false);
        this.tbcDetalle.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).detalle);
        this.tbcCantidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).cantidad);
        this.tbcPrecioUnidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).precioUnitario);
        this.tbcDescuento.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoDescuento);
        this.tbcTotalLinea.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoTotalLinea);
    }

    @FXML
    private void onBtnCerrar() {
        Stage stage = (Stage)this.lblConsecutivo.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnReimprimir() {
        this.reimprimirComprobante();
    }

    @FXML
    private void onBtnReimprimirPDF() {
        this.reimprimirComprobantePDF();
    }

    private void reimprimirComprobante() {
        try {
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            Respuesta respuesta = service.getInvoiceId(this.comprobanteSeleccionado.getId());
            JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
            this.funcionesGenerales.printInvoice(reporte);
            this.funcionesGenerales.MostrarModalInfo("El comprobante se reimprimi\u00f3 correctamnete.");
        }
        catch (Exception ex) {
            this.funcionesGenerales.MostrarModalInfo("No se pudo reimprimir el comprobante, reintente m\u00e1s tarde.");
        }
    }

    private void reimprimirComprobantePDF() {
        block7: {
            try {
                ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
                Respuesta respuesta = service.getcomprobantePDF(this.comprobanteSeleccionado.getId());
                if (respuesta.getEstado().booleanValue()) {
                    JasperPrint reporte = (JasperPrint)respuesta.getResultado(ESTADO.OK.VALUE());
                    try {
                        File file = File.createTempFile("comprobante", ".pdf");
                        FileOutputStream output = new FileOutputStream(file);
                        JasperExportManager.exportReportToPdfStream((JasperPrint)reporte, (OutputStream)output);
                        if (!Desktop.isDesktopSupported()) break block7;
                        try {
                            Desktop.getDesktop().open(file);
                            this.funcionesGenerales.MostrarModalInfo("Comprobante electr\u00f3nico generado correctamente.");
                            break block7;
                        }
                        catch (IOException ex) {
                            this.funcionesGenerales.MostrarModalInfo("Error al intentar mostrar el reporte generado.");
                        }
                    }
                    catch (Exception ex) {
                        this.funcionesGenerales.MostrarModalInfo("Error generando el PDF del comprobante electr\u00f3nico.");
                    }
                    break block7;
                }
                this.funcionesGenerales.MostrarModalInfo("Error generando el PDF del comprobante electr\u00f3nico.");
            }
            catch (Exception ex) {
                this.funcionesGenerales.MostrarModalInfo("No se pudo reimprimir el comprobante, reintente m\u00e1s tarde.");
            }
        }
    }

    private String stringOf(String var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "-";
        }
        return string;
    }

    private Integer getIntergerOf(String value) {
        Integer response;
        try {
            response = Integer.valueOf(value);
        }
        catch (Exception ex) {
            response = null;
        }
        return response;
    }

    public String getClaveComprobante() {
        return this.claveComprobante;
    }

    public void setClaveComprobante(String claveComprobante, int id) {
        this.claveComprobante = claveComprobante;
        this.comprobanteSeleccionado = claveComprobante.isEmpty() || claveComprobante.equalsIgnoreCase("0") ? this.getComprobanteId(id) : this.getComprobanteClave(claveComprobante);
        if (this.comprobanteSeleccionado != null) {
            this.lblConsecutivo.setText(this.comprobanteSeleccionado.getNumeroConsecutivo());
            this.lblClave.setText(this.stringOf(claveComprobante));
            String tipoMean = null;
            if (this.comprobanteSeleccionado.getTipoCom().equals("01")) {
                tipoMean = "Factura";
            }
            if (this.comprobanteSeleccionado.getTipoCom().equals("02")) {
                tipoMean = "Nota de d\u00e9bito";
            }
            if (this.comprobanteSeleccionado.getTipoCom().equals("03")) {
                tipoMean = "Nota de cr\u00e9dito";
            }
            if (this.comprobanteSeleccionado.getTipoCom().equals("04")) {
                tipoMean = "Tiquete";
            }
            this.lblTitulo.setText(tipoMean + " N\u00b0:");
            if (this.comprobanteSeleccionado.getReceptor() != null) {
                this.lblIdentificacion.setText(this.stringOf(this.comprobanteSeleccionado.getReceptor().getNumeroIdentificacion()));
                this.lblCorreo.setText(this.stringOf(this.comprobanteSeleccionado.getReceptor().getCorreo()));
                this.lblCliente.setText(this.stringOf(this.comprobanteSeleccionado.getReceptor().getNombre()));
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss a");
            this.lblFecha.setText(this.comprobanteSeleccionado.getFechaEmision().format(formatter));
            this.lblUsuario.setText(this.comprobanteSeleccionado.getNombreUsuario());
            this.lblClave.setText(this.stringOf(claveComprobante));
            String mean = this.comprobanteSeleccionado.getReversadoTotal().equalsIgnoreCase("N") ? "Aplicada" : "Reversada";
            this.lblEstado.setText(this.stringOf(mean));
            this.lblSubTotal.setText(this.comprobanteSeleccionado.getTotalVentaResumen().toString());
            this.lblDescuentos.setText(this.comprobanteSeleccionado.getTotalDescuentosResumen().toString());
            this.lblImpuestos.setText(this.comprobanteSeleccionado.getMontoImpuestoResumen().toString());
            this.lblTotalcom.setText(this.comprobanteSeleccionado.getTotalComprobanteResumen().toString());
            this.txtObservaciones.setText(this.comprobanteSeleccionado.getDocumentoReferencia());
            try {
                for (DetalleComElectronicoDto det : this.comprobanteSeleccionado.getListaDetalleComprobantes()) {
                    DetalleComprobanteTv nuevo = new DetalleComprobanteTv();
                    nuevo.detalle.set(det.getDetalle());
                    nuevo.cantidad.set(det.getCantidad().doubleValue());
                    nuevo.precioUnitario.set(det.getPrecioUnitario().doubleValue());
                    try {
                        nuevo.montoDescuento.set(det.getMontoDescuento().doubleValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    nuevo.montoTotalLinea.set(det.getMontoTotalLinea().doubleValue());
                    this.tv_detalleComprobante.getItems().add((Object)nuevo);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ComprobanteElectronicoDto getComprobanteClave(String clave) {
        ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
        Respuesta respuesta = service.getComprobanteClave(clave);
        ComprobanteElectronicoDto comprobanteDto = null;
        if (respuesta.getEstado().booleanValue()) {
            comprobanteDto = (ComprobanteElectronicoDto)respuesta.getResultado("ComprobanteElectronico");
        } else {
            comprobanteDto = null;
            this.funcionesGenerales.MostrarModalInfo("Error: no se pudo obtener los datos del comprobante.");
        }
        return comprobanteDto;
    }

    private ComprobanteElectronicoDto getComprobanteId(int id) {
        ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
        Respuesta respuesta = service.getComprobanteById(id);
        ComprobanteElectronicoDto comprobanteDto = null;
        if (respuesta.getEstado().booleanValue()) {
            comprobanteDto = (ComprobanteElectronicoDto)respuesta.getResultado("ComprobanteElectronico");
        } else {
            comprobanteDto = null;
            this.funcionesGenerales.MostrarModalInfo("Error: no se pudo obtener los datos del comprobante.");
        }
        return comprobanteDto;
    }
}

