/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.CajaDto;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.CajasService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class CrearCajaViewController
implements Initializable {
    @FXML
    private TextField txtFechaCierre;
    @FXML
    private TextField txtMontoAperturaCierre;
    @FXML
    private TextArea txtObservaciones;
    @FXML
    private TextField txtUsuarioCierre;
    @FXML
    private TextField txtTotalCierre;
    @FXML
    private TextField txtFechaApertura;
    @FXML
    private TextField txtUsuarioApertura;
    @FXML
    private TextField txtMontoApertura;

    public void initialize(URL url, ResourceBundle rb) {
        this.txtUsuarioApertura.setText(GlobalApp.usuarioLogueado.getNombreUsuario());
        this.txtFechaApertura.setText(FuncionesGenerales.getDateFormated(LocalDateTime.now()));
        this.txtMontoApertura.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,13}([\\.]\\d{0,5})?")) {
                    CrearCajaViewController.this.txtMontoApertura.setText(oldValue);
                }
            }
        });
    }

    public void setUltimaCaja(CajaDto caja) {
        if (caja != null && caja.getId() != null) {
            this.txtFechaCierre.setText(FuncionesGenerales.getDateFormated(caja.getFechaCierre()));
            this.txtFechaApertura.setText(FuncionesGenerales.getDateFormated(LocalDateTime.now()));
            this.txtUsuarioCierre.setText(caja.getUsuarioCierre());
            this.txtUsuarioApertura.setText(GlobalApp.usuarioLogueado.getNombreUsuario());
            this.txtMontoAperturaCierre.setText(caja.getMontoApertura().toEngineeringString());
            this.txtTotalCierre.setText(caja.getMontoCierre().toEngineeringString());
            this.txtMontoApertura.setText(caja.getMontoCierre().toEngineeringString());
        }
    }

    @FXML
    private void onBtnGuardar() {
        CajaDto caja = new CajaDto();
        caja.setEstado("A");
        caja.setUsuarioApertura(GlobalApp.usuarioLogueado.getNombreUsuario());
        SucursalEmisorDto sucursalEmisorDto = new SucursalEmisorDto(GlobalApp.idSucursal);
        caja.setSucursal(sucursalEmisorDto);
        caja.setMontoCierre(BigDecimal.ZERO);
        caja.setObservaciones(this.txtObservaciones.getText());
        caja.setMontoApertura(new BigDecimal(this.txtMontoApertura.getText()));
        CajasService service = (CajasService)AppContext.getInstance().get("CajasService");
        Respuesta respuesta = service.save(caja, "A");
        if (respuesta.getEstado().booleanValue()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Caja abierta correctamente.");
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error al abrir la caja, intentente de nuevo.");
        }
        Stage stage = (Stage)this.txtFechaCierre.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnCancelar() {
        Stage stage = (Stage)this.txtFechaCierre.getScene().getWindow();
        stage.hide();
    }
}

