/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.SucursalEmisorDto;
import electricpos.model.UsuarioDto;
import electricpos.service.EmisorService;
import electricpos.service.SucursalEmisorService;
import electricpos.service.UsuarioService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;

public class CuentaViewController
implements Initializable {
    @FXML
    ImageView imgEditarNombre;
    @FXML
    ImageView imgEditarApellido;
    @FXML
    ImageView imgEditarContrasena;
    @FXML
    ImageView imgEditarSucursal;
    @FXML
    Label txtNombre;
    @FXML
    Label txtApellido;
    @FXML
    Label txtCuenta;
    @FXML
    Label txtSucursal;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    ComboBox<SucursalEmisorDto> cbxSucursal;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    ObservableList<SucursalEmisorDto> sucursalLista;
    ObservableList<EmisorDto> emisoresLista;
    UsuarioDto usuarioSeleccionado = new UsuarioDto();
    String nuevaContrase\u00f1a = null;

    public void initialize(URL url, ResourceBundle rb) {
        FuncionesGenerales funGenerales = new FuncionesGenerales();
        this.cargarEmisores();
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        this.imgEditarNombre.setOnMouseClicked(event -> this.txtNombre.setText(funGenerales.MostrarInputModal(this.txtNombre.getText(), "Nombre")));
        this.imgEditarApellido.setOnMouseClicked(event -> this.txtApellido.setText(funGenerales.MostrarInputModal(this.txtApellido.getText(), "Apellido")));
        this.imgEditarContrasena.setOnMouseClicked(event -> {
            this.nuevaContrase\u00f1a = funGenerales.MostrarInputModal(null, "Nueva ccontrase\u00f1a");
        });
        this.usuarioSeleccionado = this.getUsuarioId(GlobalApp.idUsuario);
    }

    private UsuarioDto getUsuarioId(Integer idUsuario) {
        UsuarioService service = (UsuarioService)AppContext.getInstance().get("UsuarioService");
        Respuesta respuesta = service.getUsuario(idUsuario);
        if (respuesta.getEstado().booleanValue()) {
            UsuarioDto usuarioDto = (UsuarioDto)respuesta.getResultado(ESTADO.OK.VALUE());
            this.txtNombre.setText(usuarioDto.getNombre());
            this.txtApellido.setText(usuarioDto.getPrimerApellido());
            this.txtCuenta.setText(usuarioDto.getCorreo());
            try {
                if (usuarioDto.getEmisor() != null) {
                    EmisorDto emi = new EmisorDto();
                    emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == usuarioDto.getEmisor().getId()).findAny().orElse(null);
                    this.cbxEmisor.getSelectionModel().select((Object)emi);
                    this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
                    if (!this.cbxSucursal.getSelectionModel().isEmpty() && usuarioDto.getSucursal() != null) {
                        SucursalEmisorDto suc = new SucursalEmisorDto();
                        suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == usuarioDto.getSucursal().getId()).findAny().orElse(null);
                        this.cbxSucursal.getSelectionModel().select((Object)suc);
                    }
                }
            }
            catch (Exception ex) {
                this.txtSucursal.setText("Sin asignar");
            }
            try {
                this.txtSucursal.setText(usuarioDto.getSucursal().getNombre());
            }
            catch (Exception ex) {
                this.txtSucursal.setText("Sin asignar");
            }
            return usuarioDto;
        }
        this.funcionesGenerales.MostrarModalInfo("Ocurri\u00f3 un error obteniendo la informaci\u00f3n de la cuenta.");
        return null;
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    @FXML
    private void onCbxSucursalChanged(ActionEvent event) {
        if (!this.cbxSucursal.getSelectionModel().isEmpty()) {
            this.txtSucursal.setText(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getNombre());
        }
    }

    @FXML
    private void obBtnGuardarInfo(ActionEvent event) {
        this.usuarioSeleccionado.setNombre(this.txtNombre.getText());
        this.usuarioSeleccionado.setPrimerApellido(this.txtApellido.getText());
        if (this.nuevaContrase\u00f1a != null) {
            this.usuarioSeleccionado.setHash(this.nuevaContrase\u00f1a);
        }
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.usuarioSeleccionado.setEmisor((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem());
            if (!this.cbxSucursal.getSelectionModel().isEmpty()) {
                this.usuarioSeleccionado.setSucursal((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem());
            }
        }
        UsuarioService service = (UsuarioService)AppContext.getInstance().get("UsuarioService");
        Respuesta respuesta = service.saveUsuario(this.usuarioSeleccionado);
        GlobalApp.idEmisor = ((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId();
        GlobalApp.idSucursal = ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId();
        if (respuesta.getEstado().booleanValue()) {
            this.funcionesGenerales.MostrarModalInfo("La informaci\u00f3n de la cuenta se actualiz\u00f3 correctamente.");
        } else {
            this.funcionesGenerales.MostrarModalInfo("Ocurri\u00f3 un error actualizando la informaci\u00f3n de la cuenta.");
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }
}

