/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.FacturacionColViewController;
import electricpos.controller.FacturacionPosViewController;
import electricpos.controller.FacturacionViewController;
import electricpos.controller.FacturasViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.PrincipalController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.model.DashboardDataDto;
import electricpos.model.EmisorDto;
import electricpos.model.EmpresaFacturacion;
import electricpos.model.GlobalApp;
import electricpos.model.UsuarioMenuDto;
import electricpos.service.EmisorService;
import electricpos.service.EmpresaService;
import electricpos.service.StatsService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class DashboardViewController
implements Initializable {
    @FXML
    private Label lblFecha;
    @FXML
    private Label lblNombreEmisor;
    @FXML
    private Label lblCedula;
    @FXML
    private Label lblTotalVentas;
    @FXML
    private Label lblTotalComprobantes;
    @FXML
    private Label lblDiferenciaVentas;
    @FXML
    private Label lblDiferenciaComprobantes;
    @FXML
    private Label lblCertificado;
    @FXML
    private JFXButton btnEmisor;
    @FXML
    private JFXButton btnReporteInventario;
    @FXML
    private Label txtPrueba;
    @FXML
    private Label lblMes;
    @FXML
    private Label lblMensualidad;
    @FXML
    private Label lblCuentaActiva;
    @FXML
    private Label lblCuentaPendiente;
    @FXML
    private Label lblCuentaVencida;
    @FXML
    private Label lblMensajePago;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    EmisorDto emisorSeleccionado = new EmisorDto();
    DashboardDataDto dashboardDataDto = new DashboardDataDto();
    ObservableList<EmisorDto> emisoresLista;
    DecimalFormat formatter = new DecimalFormat("#,##0.00");

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarEmisores();
        this.btnEmisor.setText(GlobalApp.empresa.getNombre());
        if (GlobalApp.idEmisor != null) {
            this.emisorSeleccionado = this.emisoresLista.stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
        }
        if (this.emisorSeleccionado != null) {
            if (this.emisorSeleccionado.getInventarioActivo().equalsIgnoreCase("S")) {
                this.btnReporteInventario.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.REPORTESINV));
            } else {
                this.btnReporteInventario.setDisable(true);
            }
        }
        this.cargarStats();
        this.cargarCompanyStatus();
    }

    private void cargarStats() {
        StatsService statsService = (StatsService)AppContext.getInstance().get("StatsService");
        Respuesta respuesta = statsService.getDashboardData(GlobalApp.idEmisor, GlobalApp.idSucursal);
        if (respuesta.getEstado().booleanValue()) {
            this.dashboardDataDto = (DashboardDataDto)respuesta.getResultado(ESTADO.OK.VALUE());
            this.lblFecha.setText(this.dashboardDataDto.getFecha());
            this.lblTotalComprobantes.setText(this.dashboardDataDto.getCantidadComprobantes().toString());
            this.lblDiferenciaComprobantes.setText(" " + this.dashboardDataDto.getComprobantesDiferenciaSimbolo() + this.dashboardDataDto.getComprobantesDiferencia().toString() + "%");
            this.lblTotalVentas.setText("\u20a1" + this.formatter.format(this.dashboardDataDto.getTotalVentas()));
            this.lblDiferenciaVentas.setText(" " + this.dashboardDataDto.getVentasDiferenciaSimbolo() + this.dashboardDataDto.getVentasDiferencia().toString() + "%");
            this.lblCedula.setText(this.emisorSeleccionado.getNumeroIdentificacion());
            this.lblNombreEmisor.setText(this.emisorSeleccionado.getNombre());
            if (this.dashboardDataDto.getDiasExpiraCertificado() == -1) {
                GlobalApp.isCertificadoSeguridadVigente = false;
                this.lblCertificado.setText("\u274c El certificado de seguridad de Hacienda ha vencido. Debe renovarse para poder facturar nuevamente.");
                this.lblCertificado.setTextFill((Paint)Color.RED);
            } else if (this.dashboardDataDto.getDiasExpiraCertificado() <= 30) {
                GlobalApp.isCertificadoSeguridadVigente = true;
                this.lblCertificado.setText("\u26a0 El certificado de seguridad de Hacienda vencer\u00e1 en " + this.dashboardDataDto.getDiasExpiraCertificado() + " d\u00eda(s). Recomendamos renovarlo cuanto antes para evitar interrupciones en la facturaci\u00f3n.");
                this.lblCertificado.setTextFill((Paint)Color.ORANGE);
            } else {
                GlobalApp.isCertificadoSeguridadVigente = true;
                this.lblCertificado.setText("");
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al cargar los datos del dashboard.");
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al cargar los emisores.");
        }
    }

    private boolean getPermisoMenu(UsuarioMenuDto.MENU menu) {
        if (GlobalApp.usuarioAdmin.booleanValue()) {
            return true;
        }
        return GlobalApp.menusUsuarioGlobal.stream().filter(m -> m.getMenu().equals((Object)menu)).findFirst().orElse(null) != null;
    }

    @FXML
    private void onBtnNueva() {
        GlobalApp.stackMenuGlobal.setVisible(false);
        try {
            AnchorPane ancho;
            GlobalApp.lblRutaGlobal.setText("Inicio > Facturaci\u00f3n > Facturar");
            if (GlobalApp.empresa.getUsaColaboradores().equalsIgnoreCase("N")) {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionView.fxml"));
                ancho = (AnchorPane)fxmlLoader.load();
                FacturacionViewController controller = (FacturacionViewController)fxmlLoader.getController();
                controller.setTipoComprobanteGlobal("01");
            } else {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionColView.fxml"));
                ancho = (AnchorPane)fxmlLoader.load();
                FacturacionColViewController controller = (FacturacionColViewController)fxmlLoader.getController();
                controller.setTipoComprobanteGlobal("01");
            }
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnCuenta() {
        try {
            GlobalApp.lblRutaGlobal.setText("Inicio > Ajustes > Mi cuenta");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CuentaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnMnuVerProductos() {
        try {
            GlobalApp.lblRutaGlobal.setText("Inicio > Inventario > Productos");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ProductoServicioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ProductoServicioViewController controller = (ProductoServicioViewController)fxmlLoader.getController();
            controller.setTipo("P");
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnReporteInventario() {
        try {
            GlobalApp.lblRutaGlobal.setText("Inicio > Inventario > Reportes");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReportesInventarioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnMnuVerServicios() {
        try {
            GlobalApp.lblRutaGlobal.setText("Inicio > Inventario > Servicios");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ProductoServicioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ProductoServicioViewController controller = (ProductoServicioViewController)fxmlLoader.getController();
            controller.setTipo("S");
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnMnuInfoEmpresa() {
        this.openInfoEmpresa();
    }

    private void openInfoEmpresa() {
        try {
            GlobalApp.lblRutaGlobal.setText("Inicio > Par\u00e1metros > Empresa");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ParametrosGeneView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnClientes() {
        GlobalApp.stackMenuGlobal.setVisible(false);
        try {
            GlobalApp.lblRutaGlobal.setText("Inicio > Par\u00e1metros > Clientes");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReceptorView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnAccFactPos() {
        GlobalApp.stackMenuGlobal.setVisible(false);
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionPosView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        FacturacionPosViewController controller = (FacturacionPosViewController)fxmlLoader.getController();
        controller.setTipoComprobanteGlobal("04");
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.getIcons().add((Object)new Image("/electricpos/resources/space.jpg"));
        stage.setTitle("Facturaci\u00f3n electr\u00f3nica SPACE");
        stage.initModality(Modality.NONE);
        stage.show();
    }

    @FXML
    private void onBtnAccVerFact() {
        GlobalApp.stackMenuGlobal.setVisible(false);
        try {
            GlobalApp.lblRutaGlobal.setText("Inicio > Facturaci\u00f3n > Facturas");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturasView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FacturasViewController controller = (FacturasViewController)fxmlLoader.getController();
            controller.setTipoComprobante("01");
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnAccInv() {
        GlobalApp.stackMenuGlobal.setVisible(false);
        try {
            GlobalApp.lblRutaGlobal.setText("Inicio > Inventario > Productos");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ProductoServicioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ProductoServicioViewController controller = (ProductoServicioViewController)fxmlLoader.getController();
            controller.setTipo("P");
            GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cargarCompanyStatus() {
        EmpresaService service = (EmpresaService)AppContext.getInstance().get("EmpresaService");
        Respuesta respuesta = service.getEmpresaStatus(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            EmpresaFacturacion obj = (EmpresaFacturacion)respuesta.getResultado(ESTADO.OK.VALUE());
            this.lblMes.setText(obj.getMes());
            DecimalFormat formato = new DecimalFormat("#,##0.00");
            String valorFormateado = formato.format(obj.getMonto());
            this.lblMensualidad.setText("\u20a1" + valorFormateado + " / mes");
            this.lblMensajePago.setText(obj.getMensaje());
            switch (obj.getEstado()) {
                case "Activo": {
                    this.lblCuentaActiva.setVisible(true);
                    this.lblCuentaPendiente.setVisible(false);
                    this.lblCuentaVencida.setVisible(false);
                    GlobalApp.alDia = true;
                    break;
                }
                case "Pendiente de Pago": {
                    this.lblCuentaActiva.setVisible(false);
                    this.lblCuentaPendiente.setVisible(true);
                    this.lblCuentaVencida.setVisible(false);
                    GlobalApp.alDia = true;
                    break;
                }
                case "Vencido": {
                    this.lblCuentaActiva.setVisible(false);
                    this.lblCuentaPendiente.setVisible(false);
                    this.lblCuentaVencida.setVisible(true);
                    GlobalApp.alDia = false;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al cargar los datos de pago de la empresa.");
        }
    }
}

