/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.DetalleComprobanteTv;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;

class EditingCellColInterno
extends TableCell<DetalleComprobanteTv, Number> {
    private TextField textField;

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf((Number)this.getItem()));
        this.setGraphic(null);
    }

    public void updateItem(Number item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    EditingCellColInterno.this.commitEdit(Double.valueOf(EditingCellColInterno.this.textField.getText()));
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Number)this.getItem()).toString();
    }
}

