/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.DetalleComprobanteTv;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;

class EditingCellStringPro
extends TableCell<DetalleComprobanteTv, String> {
    private TextField textField;

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf((String)this.getItem()));
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    EditingCellStringPro.this.commitEdit(EditingCellStringPro.this.textField.getText());
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
    }
}

