/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.ActividadesEmisorViewController;
import electricpos.controller.MantEmisorViewController;
import electricpos.controller.PreferenciasEmisorViewController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.model.EmisorDto;
import electricpos.model.EmisorTv;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.service.EmisorService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class EmisorViewController
implements Initializable {
    ObservableList<EmisorTv> emisoresTv;
    ObservableList<EmisorDto> emisores;
    public EmisorDto emisorSeleccionado = new EmisorDto();
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    @FXML
    private TableView<EmisorTv> tv_emisores;
    @FXML
    private TableColumn<EmisorTv, String> tbcEstado;
    @FXML
    private TableColumn<EmisorTv, String> tbcCorreo;
    @FXML
    private TableColumn<EmisorTv, String> tbcTelefono;
    @FXML
    private TableColumn<EmisorTv, String> tbcIdentificacion;
    @FXML
    private TableColumn<EmisorTv, String> tbcNombreComercial;
    @FXML
    private TableColumn<EmisorTv, String> tbcNombre;

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.getEmisores();
    }

    private void getEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisores = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.tv_emisores.getItems().clear();
            this.tv_emisores.setItems(this.converterTv(this.emisores));
        }
    }

    @FXML
    private void OnBtnCrearEmisor(ActionEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantEmisorView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantEmisorViewController mantEmisorViewController = (MantEmisorViewController)fxmlLoader.getController();
        mantEmisorViewController.nuevoEmisor = true;
        FuncionesGenerales.showView(root1);
        this.getEmisores();
    }

    @FXML
    private void OnBtnPreferencias() {
        if (this.tv_emisores.getSelectionModel().getSelectedItem() != null) {
            this.emisorSeleccionado = ((EmisorTv)this.tv_emisores.getSelectionModel().getSelectedItem()).getEmisorDto();
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/PreferenciasEmisorView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            PreferenciasEmisorViewController controller = (PreferenciasEmisorViewController)fxmlLoader.getController();
            controller.setEmisorDto(this.emisorSeleccionado);
            FuncionesGenerales.showView(root1);
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "Debe de seleccionar un emisor.");
        }
    }

    @FXML
    private void OnBtnActividades() {
        this.emisorSeleccionado = ((EmisorTv)this.tv_emisores.getSelectionModel().getSelectedItem()).getEmisorDto();
        if (this.emisorSeleccionado != null) {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ActividadesEmisorView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            ActividadesEmisorViewController controller = (ActividadesEmisorViewController)fxmlLoader.getController();
            controller.setEmisorDto(this.emisorSeleccionado);
            FuncionesGenerales.showView(root1);
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "Debe de seleccionar un emisor para continuar.");
        }
    }

    @FXML
    private void onBtnVerEditar(ActionEvent event) {
        if (this.tv_emisores.getSelectionModel().getSelectedItem() != null) {
            this.emisorSeleccionado = ((EmisorTv)this.tv_emisores.getSelectionModel().getSelectedItem()).getEmisorDto();
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantEmisorView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            MantEmisorViewController mantEmisorViewController = (MantEmisorViewController)fxmlLoader.getController();
            mantEmisorViewController.nuevoEmisor = false;
            mantEmisorViewController.setEmisorSeleccionado(this.emisorSeleccionado);
            FuncionesGenerales.showView(root1);
            this.getEmisores();
        }
    }

    private void crearRelacionTv() {
        this.tbcTelefono.setCellValueFactory(cd -> ((EmisorTv)cd.getValue()).telefono);
        this.tbcCorreo.setCellValueFactory(cd -> ((EmisorTv)cd.getValue()).correo);
        this.tbcEstado.setCellValueFactory(cd -> ((EmisorTv)cd.getValue()).estado);
        this.tbcIdentificacion.setCellValueFactory(cd -> ((EmisorTv)cd.getValue()).numeroIdentificacion);
        this.tbcNombreComercial.setCellValueFactory(cd -> ((EmisorTv)cd.getValue()).nombreComercial);
        this.tbcNombre.setCellValueFactory(cd -> ((EmisorTv)cd.getValue()).nombre);
    }

    private ObservableList<EmisorTv> converterTv(ObservableList<EmisorDto> emisores) {
        ObservableList emisoresTv = FXCollections.observableArrayList();
        for (EmisorDto emiDto : emisores) {
            EmisorTv emiTv = new EmisorTv(emiDto);
            emisoresTv.add((Object)emiTv);
        }
        return emisoresTv;
    }
}

