/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.model.ExoneracionDto;
import electricpos.model.InstitucionExoneracionDto;
import electricpos.model.TipoExoneracionDto;
import electricpos.service.InstitucionesExoneracionService;
import electricpos.service.TipoExoneracionService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FacturacionUtil;
import electricpos.util.Formato;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class ExoneracionViewController
implements Initializable {
    @FXML
    private TextField txtNumeroDoc;
    @FXML
    private TextField txtPorcentaje;
    @FXML
    private DatePicker dpFecha;
    @FXML
    private JFXButton btnCancelar;
    @FXML
    private JFXButton btnGuardar;
    @FXML
    private ComboBox<InstitucionExoneracionDto> cbxInstituciones;
    @FXML
    ComboBox<TipoExoneracionDto> cbxTipoExoneracion;
    ObservableList<TipoExoneracionDto> tipoExoneracionLista;
    ObservableList<InstitucionExoneracionDto> listaInstituciones;
    public boolean modifico = false;
    public String tipoDocumentoExoneracion;
    public String numeroDocumentoExoneracion;
    public String institucionExoneracion;
    public LocalDateTime fechaDocExoneracion;
    public Integer porcentajeCompraExoneracion;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.getInstitucionExoneracion();
        this.txtNumeroDoc.setTextFormatter(Formato.getInstance().maxLengthFormat(17));
        this.txtPorcentaje.setTextFormatter(Formato.getInstance().integerFormat(3));
    }

    public Boolean validar() {
        Boolean verificar = true;
        if (this.dpFecha.getValue() == null) {
            verificar = false;
        }
        if (this.txtNumeroDoc.getText().isEmpty()) {
            verificar = false;
        }
        if (this.txtPorcentaje.getText().isEmpty()) {
            verificar = false;
        }
        if (!verificar.booleanValue()) {
            this.funcionesGenerales.MostrarModalInfo("Es necesario llenar todos los campos.");
        }
        return verificar;
    }

    @FXML
    private void onBtnCancelar() {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
        this.modifico = false;
    }

    @FXML
    private void onBtnBuscar() {
        this.onBtnSincronizar();
    }

    @FXML
    private void onBtnGuardar(ActionEvent event) {
        if (this.validar().booleanValue()) {
            Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
            this.modifico = true;
            this.obtenerDatos();
            stage.hide();
        }
    }

    private void getInstitucionExoneracion() {
        InstitucionesExoneracionService service = (InstitucionesExoneracionService)AppContext.getInstance().get("InstitucionesExoneracionService");
        new Thread(() -> {
            Respuesta respuesta = service.getInstituciones();
            if (respuesta.getEstado().booleanValue()) {
                this.listaInstituciones = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
                Platform.runLater(() -> {
                    this.cbxInstituciones.getItems().clear();
                    this.cbxInstituciones.setItems(this.listaInstituciones);
                    this.cbxInstituciones.getSelectionModel().selectFirst();
                });
            } else {
                Platform.runLater(() -> System.err.println("Error cargando descuentos: " + respuesta.getMensaje()));
            }
        }).start();
    }

    public void cargarExoneracion(String tipoDocumento, String numeroDocumento, String institucion, LocalDateTime fecha, Integer porcentaje) {
        if (tipoDocumento != null) {
            this.cargarTiposExoneracion(tipoDocumento);
            this.tipoDocumentoExoneracion = tipoDocumento;
            this.numeroDocumentoExoneracion = numeroDocumento;
            this.institucionExoneracion = institucion;
            this.fechaDocExoneracion = fecha;
            this.porcentajeCompraExoneracion = porcentaje;
            this.txtNumeroDoc.setText(numeroDocumento);
            Optional<InstitucionExoneracionDto> institucionSeleccionada = this.cbxInstituciones.getItems().stream().filter(inst -> inst.getCodigo().equalsIgnoreCase(institucion)).findFirst();
            institucionSeleccionada.ifPresent(inst -> this.cbxInstituciones.getSelectionModel().select(inst));
            this.txtPorcentaje.setText(porcentaje.toString());
            this.dpFecha.setValue((Object)fecha.toLocalDate());
        } else {
            this.cargarTiposExoneracion(null);
            this.tipoDocumentoExoneracion = null;
            this.numeroDocumentoExoneracion = null;
            this.institucionExoneracion = null;
            this.fechaDocExoneracion = null;
            this.porcentajeCompraExoneracion = null;
        }
    }

    public void devolverExoneracion(String tipoDocumento, String numeroDocumento, String institucion, LocalDateTime fecha, Integer porcentaje) {
        if (this.modifico) {
            tipoDocumento = this.tipoDocumentoExoneracion;
            numeroDocumento = this.numeroDocumentoExoneracion;
            institucion = this.institucionExoneracion;
            fecha = this.fechaDocExoneracion;
            porcentaje = this.porcentajeCompraExoneracion;
        }
    }

    private void cargarTiposExoneracion(String codigo) {
        try {
            TipoExoneracionService tipoExoneracionService = (TipoExoneracionService)AppContext.getInstance().get("TipoExoneracionService");
            Respuesta respuesta = tipoExoneracionService.getTiposExoneracion();
            if (respuesta.getEstado().booleanValue()) {
                this.tipoExoneracionLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Tipos")));
                this.cbxTipoExoneracion.setItems(this.tipoExoneracionLista);
                if (codigo == null) {
                    this.cbxTipoExoneracion.getSelectionModel().selectFirst();
                } else {
                    TipoExoneracionDto tip = new TipoExoneracionDto();
                    tip = this.cbxTipoExoneracion.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(codigo)).findAny().orElse(null);
                    this.cbxTipoExoneracion.getSelectionModel().select((Object)tip);
                }
            } else {
                this.cbxTipoExoneracion.getItems().clear();
            }
        }
        catch (Exception e) {
            this.cbxTipoExoneracion.getItems().clear();
        }
    }

    private void obtenerDatos() {
        this.tipoDocumentoExoneracion = ((TipoExoneracionDto)this.cbxTipoExoneracion.getSelectionModel().getSelectedItem()).getCodigo();
        this.numeroDocumentoExoneracion = this.txtNumeroDoc.getText();
        this.institucionExoneracion = ((InstitucionExoneracionDto)this.cbxInstituciones.getSelectionModel().getSelectedItem()).getCodigo();
        this.fechaDocExoneracion = ((LocalDate)this.dpFecha.getValue()).atTime(0, 0);
        this.porcentajeCompraExoneracion = Integer.valueOf(this.txtPorcentaje.getText());
    }

    private void onBtnSincronizar() {
        try {
            String url = "https://api.hacienda.go.cr/fe/ex?autorizacion=" + this.txtNumeroDoc.getText();
            Request request = new Request(url, true);
            request.get();
            if (!request.isError().booleanValue()) {
                ExoneracionDto exo = (ExoneracionDto)request.readEntity(ExoneracionDto.class);
                String codigoInstitucion = FacturacionUtil.extraerCodigoInstitucion(exo.getNombreInstitucion());
                Optional<InstitucionExoneracionDto> institucionSeleccionada = this.cbxInstituciones.getItems().stream().filter(inst -> inst.getCodigo().equalsIgnoreCase(codigoInstitucion)).findFirst();
                institucionSeleccionada.ifPresent(inst -> this.cbxInstituciones.getSelectionModel().select(inst));
                this.dpFecha.setValue((Object)exo.getFechaEmisionFormat().toLocalDate());
                this.txtPorcentaje.setText(exo.getPorcentajeExoneracion().toString());
                TipoExoneracionDto tip = new TipoExoneracionDto();
                tip = this.cbxTipoExoneracion.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(exo.getTipoDocumento().getCodigo())).findAny().orElse(null);
                this.cbxTipoExoneracion.getSelectionModel().select((Object)tip);
            } else {
                this.funcionesGenerales.MostrarModalInfo("El n\u00famero de exoneraci\u00f3n ingresado no existe.");
            }
        }
        catch (Exception ex) {
            this.funcionesGenerales.MostrarModalInfo("Error desconocido al consultar informaci\u00f3n de la exoneraci\u00f3n. " + ex.getLocalizedMessage());
        }
    }
}

