/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.EditingCellCompra;
import electricpos.controller.EditingCellStringCompra;
import electricpos.controller.ExoneracionViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.PrincipalController;
import electricpos.controller.WaitingViewController;
import electricpos.model.ComprobanteCompraDto;
import electricpos.model.CondicionVentaDto;
import electricpos.model.DetalleComCompraDto;
import electricpos.model.DetalleComprobanteTv;
import electricpos.model.EmisorDto;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.model.MedioPagoDto;
import electricpos.model.MonedaDto;
import electricpos.model.ProductoServicioDto;
import electricpos.model.ReceptorDto;
import electricpos.model.ResolucionHaciendaDto;
import electricpos.model.SucursalEmisorDto;
import electricpos.model.TarifaImpuestoDto;
import electricpos.model.TipoComprobante;
import electricpos.service.CondicionVentaService;
import electricpos.service.EmisorService;
import electricpos.service.MonedaService;
import electricpos.service.ProductoServicioService;
import electricpos.service.ReceptorService;
import electricpos.service.SucursalEmisorService;
import electricpos.service.TarifaImpuestoService;
import electricpos.util.AppContext;
import electricpos.util.CabysUtil;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Mensaje;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;

public class FacturacionCompraViewController
implements Initializable {
    ObservableList<CondicionVentaDto> condicionesVentaLista;
    ObservableList<MonedaDto> monedasLista;
    @FXML
    JFXButton btnEnviarFactura;
    @FXML
    ComboBox<CondicionVentaDto> cbxCondicionVenta;
    @FXML
    ComboBox<MonedaDto> cbxMoneda;
    @FXML
    DatePicker dpFechaEmision;
    @FXML
    ImageView imgEditarPlazoCredito;
    @FXML
    ImageView imgEditarMedioPago;
    @FXML
    ImageView imgEditarEmisor;
    @FXML
    Label txtPlazoCredito;
    @FXML
    Label txtReceptor;
    @FXML
    Label txtMedioPago;
    @FXML
    Label lblTotalcom;
    @FXML
    Label lblImpuestos;
    @FXML
    Label lblDescuentos;
    @FXML
    Label lblSubTotal;
    @FXML
    TextField txtCodigoPS;
    @FXML
    TextField txtCantidad;
    @FXML
    TextField txtMinutos;
    @FXML
    TextField txtDocReferencia;
    @FXML
    TextField txtTipoCambio;
    ReceptorDto receptorFactura = new ReceptorDto();
    List<MedioPagoDto> mediosPago = new ArrayList<MedioPagoDto>();
    ObservableList<SucursalEmisorDto> sucursalLista;
    ProductoServicioDto productoServicioAgregar = new ProductoServicioDto();
    ObservableList<EmisorDto> emisoresLista;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    ComboBox<TipoComprobante> cbxTipoComprobante;
    @FXML
    ComboBox<SucursalEmisorDto> cbxSucursal;
    DecimalFormat formatter = new DecimalFormat("#,##0.00");
    @FXML
    private TableView<DetalleComprobanteTv> tv_detalleComprobante;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcCodigo;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcDetalle;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcUnidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcCantidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcPrecioUnidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcTotal;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcDescuento;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcSubTotal;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcImpuesto;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcTotalLinea;
    String tipoComprobanteGlobal = null;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionDetalle();
        this.cargarEmisores();
        this.cargarTiposComprobante();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        FuncionesGenerales funGenerales = new FuncionesGenerales();
        this.mediosPago = funGenerales.llenarMedioPagos();
        this.cargarMonedas();
        this.imgEditarPlazoCredito.setOnMouseClicked(event -> this.txtPlazoCredito.setText(funGenerales.MostrarInputModal(this.txtPlazoCredito.getText(), "Plazo del cr\u00e9dito")));
        this.imgEditarMedioPago.setOnMouseClicked(event -> {
            this.mediosPago = funGenerales.MostrarModalMedioPago(this.mediosPago, new BigDecimal(BigInteger.ZERO));
            String medios = "";
            for (MedioPagoDto m : this.mediosPago) {
                if (!m.isActivo()) continue;
                medios = medios + " - " + m.getDescripcion();
            }
            this.txtMedioPago.setText(medios);
        });
        this.imgEditarEmisor.setOnMouseClicked(event -> {
            this.receptorFactura = funGenerales.ClienteViewController(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), this.receptorFactura, false);
            if (this.receptorFactura.getId() != null) {
                this.txtReceptor.setText(this.receptorFactura.getNombre());
            } else {
                this.txtReceptor.setText("Sin cliente");
            }
        });
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaEmision.setValue((Object)localDate);
        CondicionVentaService condicionVentaService = (CondicionVentaService)AppContext.getInstance().get("CondicionVentaService");
        Respuesta respuesta = condicionVentaService.getCondicionesVenta();
        if (respuesta.getEstado().booleanValue()) {
            this.condicionesVentaLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Condiciones")));
            this.cbxCondicionVenta.setItems(this.condicionesVentaLista);
            this.cbxCondicionVenta.getSelectionModel().selectFirst();
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    private void cargarMonedas() {
        MonedaService monedaService = (MonedaService)AppContext.getInstance().get("MonedaService");
        Respuesta respuesta = monedaService.getMonedas();
        if (respuesta.getEstado().booleanValue()) {
            this.monedasLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Moneda")));
            this.cbxMoneda.setItems(this.monedasLista);
            this.cbxMoneda.getSelectionModel().selectFirst();
        }
    }

    private Double getMontoImpuesto(Double precio, Double impuesto) {
        Double monto = precio * impuesto / 100.0;
        return monto;
    }

    @FXML
    public void onEnterTxtCodigoPS(ActionEvent ae) {
        this.productoServicioAgregar = this.getProductoServicio(this.txtCodigoPS.getText());
        if (this.productoServicioAgregar != null) {
            this.agregarProducto();
        }
    }

    @FXML
    private void onBtnAgregarProducto(ActionEvent event) {
        this.productoServicioAgregar = this.getProductoServicio(this.txtCodigoPS.getText());
        if (!this.txtCodigoPS.getText().isEmpty()) {
            this.agregarProducto();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de ingresar un c\u00f3digo.");
        }
    }

    private void agregarProducto() {
        if (this.funcionesGenerales.mostrarModalValidaCabys(this.productoServicioAgregar)) {
            if (this.isProductoServicioValidoIVA(this.productoServicioAgregar).booleanValue()) {
                Double cantidad = Double.valueOf(this.txtCantidad.getText());
                Double minutos = Double.valueOf(this.txtMinutos.getText());
                minutos = minutos / 60.0;
                cantidad = cantidad + minutos;
                Double precioUni = this.productoServicioAgregar.getPrecioSinImp().doubleValue();
                Double montoImpuesto = this.productoServicioAgregar.getMontoImpuesto().doubleValue() * cantidad;
                Double precioConImpuesto = precioUni * cantidad + montoImpuesto;
                DetalleComprobanteTv nuevo = new DetalleComprobanteTv(cantidad, this.productoServicioAgregar.getUnidadMedida(), this.productoServicioAgregar.getDescripcion(), precioUni, precioUni * cantidad, 0.0, precioUni * cantidad, montoImpuesto, precioConImpuesto, this.productoServicioAgregar.getCodigo(), this.productoServicioAgregar);
                nuevo.setTipo(this.productoServicioAgregar.getTipo());
                nuevo.setExento(this.productoServicioAgregar.getExento());
                this.tv_detalleComprobante.getItems().add((Object)nuevo);
                this.obtenerResumen();
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("El producto/servicio no se pudo agregar por falta de c\u00f3digo CABYS.");
        }
    }

    @FXML
    private void onBtnEliminarLinea(ActionEvent event) {
        this.tv_detalleComprobante.getItems().remove(this.tv_detalleComprobante.getSelectionModel().getSelectedItem());
        this.obtenerResumen();
    }

    @FXML
    private void onBtnBuscarPS(ActionEvent event) {
        if (!this.txtCodigoPS.getText().isEmpty()) {
            this.productoServicioAgregar = this.getProductoServicio(this.txtCodigoPS.getText());
            if (this.productoServicioAgregar != null) {
                this.agregarProducto();
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de ingresar un c\u00f3digo.");
        }
    }

    @FXML
    private void onBtnFiltrar(ActionEvent event) {
        EmisorDto emisorDto = (EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem();
        this.productoServicioAgregar = this.funcionesGenerales.mostrarBusquedaPS(emisorDto.getId(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), emisorDto.getInventarioCompartido());
        if (this.productoServicioAgregar != null) {
            this.agregarProducto();
        }
    }

    @FXML
    private void onBtnExonerarLinea(ActionEvent event) {
        if (this.tv_detalleComprobante.getSelectionModel().getSelectedItem() != null) {
            if (((DetalleComprobanteTv)this.tv_detalleComprobante.getSelectionModel().getSelectedItem()).exento.equalsIgnoreCase("N")) {
                this.mostrarExoneracionLinea();
            } else {
                this.funcionesGenerales.MostrarModalInfo("El producto/servicio se encuentra exento de impuestos.");
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar una l\u00ednea del detalle.");
        }
    }

    public void mostrarExoneracionLinea() {
        DetalleComprobanteTv detalleTv = (DetalleComprobanteTv)this.tv_detalleComprobante.getSelectionModel().getSelectedItem();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ExoneracionView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ExoneracionViewController exoneracionViewController = (ExoneracionViewController)fxmlLoader.getController();
        exoneracionViewController.cargarExoneracion(detalleTv.getTipoDocumentoExoneracion(), detalleTv.getNumeroDocumentoExoneracion(), detalleTv.getInstitucionExoneracion(), detalleTv.getFechaDocExoneracion(), detalleTv.getPorcentajeCompraExoneracion());
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
        if (exoneracionViewController.modifico) {
            detalleTv.setTipoDocumentoExoneracion(exoneracionViewController.tipoDocumentoExoneracion);
            detalleTv.setNumeroDocumentoExoneracion(exoneracionViewController.numeroDocumentoExoneracion);
            detalleTv.setInstitucionExoneracion(exoneracionViewController.institucionExoneracion);
            detalleTv.setFechaDocExoneracion(exoneracionViewController.fechaDocExoneracion);
            detalleTv.setPorcentajeCompraExoneracion(exoneracionViewController.porcentajeCompraExoneracion);
            detalleTv.setMontoImpuestoExoneracion(new BigDecimal(this.getMontoExonerado(detalleTv.ivaDefecto, detalleTv.getMontoImpuesto(), detalleTv.getSubTotal())).setScale(5, RoundingMode.HALF_UP));
            double impuestoNeto = detalleTv.getMontoImpuesto() - detalleTv.getMontoImpuestoExoneracion().doubleValue();
            detalleTv.setMontoImpuestoNeto(new BigDecimal(impuestoNeto));
            detalleTv.setIva(this.calcularNuevoImpuesto(detalleTv.getIvaDefecto(), exoneracionViewController.porcentajeCompraExoneracion));
            this.refrescarDetalle(detalleTv);
            this.obtenerResumen();
        }
    }

    private Double calcularNuevoImpuesto(Double impuestoActual, Integer porcentaje) {
        Double impuestoNuevo = 0.0;
        Double aux = 0.0;
        try {
            aux = impuestoActual * (double)porcentaje.intValue() / 100.0;
            impuestoNuevo = impuestoActual - aux;
        }
        catch (Exception ex) {
            impuestoNuevo = 0.0;
        }
        return impuestoNuevo;
    }

    private void refrescarDetalle(DetalleComprobanteTv det) {
        Double subTotal = det.getSubTotal();
        Double iva = det.getIva();
        Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_UP).doubleValue();
        det.setMontoImpuesto(montoImpuesto);
        Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_UP).doubleValue();
        det.setMontoTotalLinea(totalLinea);
    }

    public boolean mostrarComprobanteHilo(ComprobanteCompraDto comp) {
        try {
            FuncionesGenerales.procesaVBoxNotificaciones();
            GlobalApp.vBoxNotificaciones.setVisible(true);
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/WaitingView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.vBoxNotificaciones.getChildren().add((Object)ancho);
            WaitingViewController waitingViewController = (WaitingViewController)fxmlLoader.getController();
            waitingViewController.setAnchorPane(ancho);
            waitingViewController.setTipo(comp.getTipoCom());
            waitingViewController.setComprobanteCompraDto(comp);
            waitingViewController.enviarComprobanteCompra();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @FXML
    private void OnEnviarFactura() {
        String codigoActividad = ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getCodigoActividad();
        if (codigoActividad != null) {
            if (!this.tv_detalleComprobante.getItems().isEmpty()) {
                ComprobanteCompraDto comprobante = new ComprobanteCompraDto();
                comprobante.setVersion(GlobalApp.parametrosSistema.getVersionDoc());
                comprobante.setFechaEmision(((LocalDate)this.dpFechaEmision.getValue()).atTime(LocalTime.now()));
                TipoComprobante tipoComprobante = (TipoComprobante)this.cbxTipoComprobante.getValue();
                comprobante.setTipoCom(tipoComprobante.getCodigo());
                comprobante.setCondicionVenta(((CondicionVentaDto)this.cbxCondicionVenta.getSelectionModel().getSelectedItem()).getCodigo());
                comprobante.setPlazoCredito(this.txtPlazoCredito.getText());
                try {
                    if (this.receptorFactura.getId() == 0) {
                        this.funcionesGenerales.MostrarModalInfo("El emisor debe de estra registrado previamente para facturas electr\u00f3nicas de compra.");
                        return;
                    }
                    this.receptorFactura = this.getReceptorId(this.receptorFactura.getId());
                    comprobante.setReceptor(this.receptorFactura);
                }
                catch (Exception e) {
                    comprobante.setReceptor(null);
                }
                if (comprobante.getReceptor() == null && tipoComprobante.getCodigo().equals("08")) {
                    this.funcionesGenerales.MostrarModalInfo("El dato del Emisor es obligatorio en facturas electr\u00f3nicas de compra.");
                    return;
                }
                if (comprobante.getReceptor().getCodigoProvincia() == null || comprobante.getReceptor().getCodigoCanton() == null || comprobante.getReceptor().getCodigoDistrito() == null || comprobante.getReceptor().getCodigoBarrio() == null) {
                    this.funcionesGenerales.MostrarModalInfo("Los datos de ubicaci\u00f3n del Emisor son obligatorios en facturas electr\u00f3nicas de compra.");
                    return;
                }
                if (comprobante.getReceptor().getCorreo() == null) {
                    this.funcionesGenerales.MostrarModalInfo("Los datos del correo del Emisor son obligatorios en facturas electr\u00f3nicas de compra.");
                    return;
                }
                EmpresaDto empresaDto = new EmpresaDto(GlobalApp.idEmpresa);
                comprobante.setEmpresa(empresaDto);
                EmisorDto emisorDto = new EmisorDto(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
                emisorDto.setEmpresa(empresaDto);
                comprobante.setEmisor(emisorDto);
                ResolucionHaciendaDto resolucionHaciendaDto = new ResolucionHaciendaDto(1);
                comprobante.setNormativa(resolucionHaciendaDto);
                comprobante.setSucursal((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem());
                List<DetalleComCompraDto> listaDetalleComprobante = this.getDetalleComprobante();
                comprobante.setListaDetalleComprobantes(listaDetalleComprobante);
                comprobante.setTipoDocReferencia(null);
                comprobante.setNumeroDocReferencia(null);
                comprobante.setFechaEmisionReferencia(null);
                comprobante.setCodigoReferencia(null);
                comprobante.setRazonReferencia(null);
                int cont = 1;
                for (MedioPagoDto m : this.mediosPago) {
                    if (!m.isActivo()) continue;
                    if (cont == 1) {
                        comprobante.setMedioPago1(m.getCodigo());
                    }
                    if (cont == 2) {
                        comprobante.setMedioPago2(m.getCodigo());
                    }
                    if (cont == 3) {
                        comprobante.setMedioPago3(m.getCodigo());
                    }
                    if (cont == 4) {
                        comprobante.setMedioPago4(m.getCodigo());
                    }
                    ++cont;
                }
                comprobante.setCodigoMonedaResumen(((MonedaDto)this.cbxMoneda.getSelectionModel().getSelectedItem()).getCodigo());
                comprobante.setTipoCambioResumen(new BigDecimal(this.txtTipoCambio.getText()));
                this.setResumenComprobante(comprobante);
                comprobante.setDocumentoReferencia(this.txtDocReferencia.getText());
                comprobante.setReversadoTotal("N");
                this.mostrarComprobanteHilo(comprobante);
                try {
                    FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionCompraView.fxml"));
                    AnchorPane ancho = (AnchorPane)fxmlLoader.load();
                    FacturacionCompraViewController controller = (FacturacionCompraViewController)fxmlLoader.getController();
                    controller.setTipoComprobanteGlobal(comprobante.getTipoCom());
                    GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
                }
                catch (IOException ex) {
                    Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.funcionesGenerales.MostrarModalInfo("Debe de ingresar como m\u00ednimo un producto o servicio.");
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("La sucursal seleccionada no posee un c\u00f3digo de actividad asignado, configurelo para continuar.");
        }
    }

    private ReceptorDto guardarReceptorService(ReceptorDto receptorDto) {
        Stage stage = (Stage)this.btnEnviarFactura.getScene().getWindow();
        ReceptorService service = (ReceptorService)AppContext.getInstance().get("ReceptorService");
        Respuesta respuesta = service.saveReceptor(receptorDto);
        if (respuesta.getEstado().booleanValue()) {
            receptorDto = (ReceptorDto)respuesta.getResultado("Receptor");
            return receptorDto;
        }
        Mensaje.getInstance().showModal(Alert.AlertType.ERROR, "Guardar Receptor", (Window)stage, respuesta.getMensaje());
        return null;
    }

    private ReceptorDto getReceptorId(Integer id) {
        ReceptorDto receptorDto = new ReceptorDto();
        ReceptorService service = (ReceptorService)AppContext.getInstance().get("ReceptorService");
        Respuesta respuesta = service.getReceptorId(id);
        if (respuesta.getEstado().booleanValue()) {
            receptorDto = (ReceptorDto)respuesta.getResultado(ESTADO.OK.VALUE());
            return receptorDto;
        }
        return null;
    }

    private void crearRelacionDetalle() {
        this.tv_detalleComprobante.setEditable(true);
        Callback<TableColumn<DetalleComprobanteTv, Number>, TableCell<DetalleComprobanteTv, Number>> cellFactory = new Callback<TableColumn<DetalleComprobanteTv, Number>, TableCell<DetalleComprobanteTv, Number>>(){

            public TableCell call(TableColumn p) {
                return new EditingCellCompra();
            }
        };
        Callback<TableColumn<DetalleComprobanteTv, String>, TableCell<DetalleComprobanteTv, String>> cellFactoryString = new Callback<TableColumn<DetalleComprobanteTv, String>, TableCell<DetalleComprobanteTv, String>>(){

            public TableCell call(TableColumn p) {
                return new EditingCellStringCompra();
            }
        };
        this.tbcCodigo.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).codigoProducto);
        this.tbcUnidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).unidadMedida);
        this.tbcDetalle.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).detalle);
        this.tbcDetalle.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tbcDetalle.setEditable(true);
        this.tbcCantidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).cantidad);
        this.tbcCantidad.setCellFactory((Callback)cellFactory);
        this.tbcCantidad.setEditable(true);
        this.tbcCantidad.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<DetalleComprobanteTv, Number>>(){

            public void handle(TableColumn.CellEditEvent<DetalleComprobanteTv, Number> t) {
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setCantidad(((Number)t.getNewValue()).doubleValue());
                Double cantidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getCantidad();
                Double precioUnidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getPrecioUnitario();
                Double total = new BigDecimal(cantidad * precioUnidad).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotal(total);
                Double descuento = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoDescuento();
                Double subTotal = new BigDecimal(total - descuento).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSubTotal(subTotal);
                Double iva = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getIva();
                Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoImpuesto(montoImpuesto);
                Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotalLinea(totalLinea);
                FacturacionCompraViewController.this.obtenerResumen();
            }
        });
        this.tbcPrecioUnidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).precioUnitario);
        this.tbcTotal.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoTotal);
        this.tbcDescuento.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoDescuento);
        this.tbcDescuento.setCellFactory((Callback)cellFactory);
        this.tbcDescuento.setEditable(true);
        this.tbcDescuento.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<DetalleComprobanteTv, Number>>(){

            public void handle(TableColumn.CellEditEvent<DetalleComprobanteTv, Number> t) {
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoDescuento(((Number)t.getNewValue()).doubleValue());
                Double cantidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getCantidad();
                Double total = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoTotal();
                Double descuento = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoDescuento();
                Double subTotal = new BigDecimal(total - descuento).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSubTotal(subTotal);
                Double iva = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getIva();
                Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoImpuesto(montoImpuesto);
                Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotalLinea(totalLinea);
                FacturacionCompraViewController.this.obtenerResumen();
            }
        });
        this.tbcSubTotal.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).subTotal);
        this.tbcImpuesto.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoImpuesto);
        this.tbcTotalLinea.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoTotalLinea);
        this.tbcTotalLinea.setCellFactory((Callback)cellFactory);
        this.tbcTotalLinea.setEditable(true);
        this.tbcTotalLinea.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<DetalleComprobanteTv, Number>>(){

            public void handle(TableColumn.CellEditEvent<DetalleComprobanteTv, Number> t) {
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotalLinea(((Number)t.getNewValue()).doubleValue());
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setCantidad(1.0);
                if (((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getProductoServicioDto().getImpuestoIncluido().equalsIgnoreCase("S")) {
                    double tarifaImpuesto = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getProductoServicioDto().getTarifaImpuesto().doubleValue();
                    double variableImpuesto = tarifaImpuesto / 100.0 + 1.0;
                    double precioSinImpuesto = new BigDecimal(((Number)t.getNewValue()).doubleValue() / variableImpuesto).setScale(5, RoundingMode.HALF_UP).doubleValue();
                    ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPrecioUnitario(precioSinImpuesto);
                } else {
                    ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPrecioUnitario(((Number)t.getNewValue()).doubleValue());
                }
                Double cantidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getCantidad();
                Double precioUnidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getPrecioUnitario();
                Double total = new BigDecimal(cantidad * precioUnidad).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotal(total);
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoDescuento(0.0);
                Double descuento = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoDescuento();
                Double subTotal = new BigDecimal(total - descuento).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSubTotal(subTotal);
                Double iva = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getIva();
                Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoImpuesto(montoImpuesto);
                Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotalLinea(totalLinea);
                FacturacionCompraViewController.this.obtenerResumen();
            }
        });
    }

    public String getTipoComprobanteGlobal() {
        return this.tipoComprobanteGlobal;
    }

    public void setTipoComprobanteGlobal(String tipoComprobanteGlobal) {
        this.tipoComprobanteGlobal = tipoComprobanteGlobal;
    }

    private void obtenerResumen() {
        ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
        Double totalServiciosGravados = 0.0;
        Double totalServiciosExentos = 0.0;
        Double totalServiciosExonerado = 0.0;
        Double totalMercanciaGravados = 0.0;
        Double totalMercanciaExentos = 0.0;
        Double totalMercanciaExonerado = 0.0;
        Double totalGravado = 0.0;
        Double totalExento = 0.0;
        Double totalExonerado = 0.0;
        Double totalVenta = 0.0;
        Double totalDescuentos = 0.0;
        Double totalVentaNeta = 0.0;
        Double totalImpuestos = 0.0;
        Double totalComprobante = 0.0;
        for (DetalleComprobanteTv detalle : listaDetalle) {
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalServiciosGravados = totalServiciosGravados + detalle.getMontoTotal();
            }
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalServiciosExentos = totalServiciosExentos + detalle.getMontoTotal();
            }
            if (detalle.getMontoImpuestoExoneracion() != null && CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalServiciosExonerado = totalServiciosExonerado + detalle.getMontoImpuestoExoneracion().doubleValue();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalMercanciaGravados = totalMercanciaGravados + detalle.getMontoTotal();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalMercanciaExentos = totalMercanciaExentos + detalle.getMontoTotal();
            }
            if (detalle.getMontoImpuestoExoneracion() != null && CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalMercanciaExonerado = totalMercanciaExonerado + detalle.getMontoImpuestoExoneracion().doubleValue();
            }
            totalDescuentos = new BigDecimal(totalDescuentos + detalle.getMontoDescuento()).setScale(5, RoundingMode.HALF_UP).doubleValue();
            totalImpuestos = new BigDecimal(totalImpuestos + detalle.getMontoImpuesto()).setScale(5, RoundingMode.HALF_UP).doubleValue();
        }
        totalGravado = totalServiciosGravados + totalMercanciaGravados;
        totalExento = totalServiciosExentos + totalMercanciaExentos;
        totalExonerado = totalServiciosExonerado + totalMercanciaExonerado;
        totalVenta = new BigDecimal(totalGravado + totalExento).setScale(5, RoundingMode.HALF_UP).doubleValue();
        totalVentaNeta = new BigDecimal(totalVenta - totalDescuentos).setScale(5, RoundingMode.HALF_UP).doubleValue();
        totalComprobante = new BigDecimal(totalVentaNeta + totalImpuestos).setScale(5, RoundingMode.HALF_UP).doubleValue();
        this.lblSubTotal.setText(this.formatter.format(totalVenta));
        this.lblDescuentos.setText(this.formatter.format(totalDescuentos));
        this.lblImpuestos.setText(this.formatter.format(totalImpuestos));
        this.lblTotalcom.setText(this.formatter.format(totalComprobante));
    }

    private void cargarTiposComprobante() {
        ArrayList<TipoComprobante> lista = new ArrayList<TipoComprobante>();
        TipoComprobante tps1 = new TipoComprobante("08", "Factura compra");
        lista.add(tps1);
        ObservableList tipoPsLsista = FXCollections.observableArrayList(lista);
        this.cbxTipoComprobante.setItems(tipoPsLsista);
        this.cbxTipoComprobante.getSelectionModel().selectFirst();
    }

    private void setResumenComprobante(ComprobanteCompraDto comp) {
        ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
        Double totalServiciosGravados = 0.0;
        Double totalServiciosExentos = 0.0;
        Double totalServiciosExonerado = 0.0;
        Double totalMercanciaGravados = 0.0;
        Double totalMercanciaExentos = 0.0;
        Double totalMercanciaExonerado = 0.0;
        Double totalGravado = 0.0;
        Double totalExento = 0.0;
        Double totalExonerado = 0.0;
        Double totalVenta = 0.0;
        Double totalDescuentos = 0.0;
        Double totalVentaNeta = 0.0;
        Double totalImpuestos = 0.0;
        Double totalComprobante = 0.0;
        for (DetalleComprobanteTv detalle : listaDetalle) {
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                if (detalle.getMontoImpuestoExoneracion() == null && detalle.getTipoDocumentoExoneracion() == null) {
                    totalServiciosGravados = new BigDecimal(totalServiciosGravados + detalle.getMontoTotal()).setScale(5, RoundingMode.HALF_UP).doubleValue();
                } else {
                    Double gravadoExo = (100.0 - Double.valueOf(detalle.getPorcentajeCompraExoneracion().intValue())) / 100.0;
                    gravadoExo = new BigDecimal(gravadoExo * detalle.getMontoTotal()).setScale(5, RoundingMode.HALF_UP).doubleValue();
                    totalServiciosGravados = totalServiciosGravados + new BigDecimal(gravadoExo).setScale(5, RoundingMode.HALF_UP).doubleValue();
                }
            }
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalServiciosExentos = new BigDecimal(totalServiciosExentos + detalle.getMontoTotal()).setScale(5, RoundingMode.HALF_UP).doubleValue();
            }
            if (detalle.getMontoImpuestoExoneracion() != null && detalle.getTipoDocumentoExoneracion() != null && CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                Double exonerado = Double.valueOf(detalle.getPorcentajeCompraExoneracion().intValue()) / 100.0;
                exonerado = new BigDecimal(exonerado * detalle.getMontoTotal()).setScale(5, RoundingMode.HALF_UP).doubleValue();
                totalServiciosExonerado = totalServiciosExonerado + new BigDecimal(exonerado).setScale(5, RoundingMode.HALF_UP).doubleValue();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalMercanciaGravados = new BigDecimal(totalMercanciaGravados + detalle.getMontoTotal()).setScale(5, RoundingMode.HALF_UP).doubleValue();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalMercanciaExentos = new BigDecimal(totalMercanciaExentos + detalle.getMontoTotal()).setScale(5, RoundingMode.HALF_UP).doubleValue();
            }
            if (detalle.getMontoImpuestoExoneracion() != null && CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalMercanciaExonerado = new BigDecimal(totalMercanciaExonerado + detalle.getMontoImpuestoExoneracion().doubleValue()).setScale(5, RoundingMode.HALF_UP).doubleValue();
            }
            totalDescuentos = totalDescuentos + detalle.getMontoDescuento();
            if (detalle.getMontoImpuestoExoneracion() == null && detalle.getTipoDocumentoExoneracion() == null) {
                totalImpuestos = new BigDecimal(totalImpuestos + detalle.getMontoImpuesto()).setScale(5, RoundingMode.HALF_UP).doubleValue();
                continue;
            }
            totalImpuestos = new BigDecimal(totalImpuestos + detalle.getMontoImpuesto()).setScale(5, RoundingMode.HALF_UP).doubleValue();
        }
        totalGravado = new BigDecimal(totalServiciosGravados + totalMercanciaGravados).setScale(5, RoundingMode.HALF_UP).doubleValue();
        totalExento = new BigDecimal(totalServiciosExentos + totalMercanciaExentos).setScale(5, RoundingMode.HALF_UP).doubleValue();
        totalExonerado = new BigDecimal(totalServiciosExonerado + totalMercanciaExonerado).setScale(5, RoundingMode.HALF_UP).doubleValue();
        totalVenta = new BigDecimal(totalGravado + totalExento + totalExonerado).setScale(5, RoundingMode.HALF_UP).doubleValue();
        totalVentaNeta = new BigDecimal(totalVenta - totalDescuentos).setScale(5, RoundingMode.HALF_UP).doubleValue();
        totalComprobante = new BigDecimal(totalVentaNeta + totalImpuestos).setScale(5, RoundingMode.HALF_UP).doubleValue();
        comp.setTotalServGravadosResumen(new BigDecimal(totalServiciosGravados).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalServExentosResumen(new BigDecimal(totalServiciosExentos).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalServExoneradosResumen(new BigDecimal(totalServiciosExonerado).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalMercanciasGravadasResumen(new BigDecimal(totalMercanciaGravados).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalMercanciasExentasResumen(new BigDecimal(totalMercanciaExentos).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalMercanciasExoneradasResumen(new BigDecimal(totalMercanciaExonerado).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalGravadoResumen(new BigDecimal(totalGravado).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalExentoResumen(new BigDecimal(totalExento).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalExoneradoResumen(new BigDecimal(totalExonerado).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalVentaResumen(new BigDecimal(totalVenta).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalDescuentosResumen(new BigDecimal(totalDescuentos).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalVentaNetaResumen(new BigDecimal(totalVentaNeta).setScale(5, RoundingMode.HALF_UP));
        comp.setMontoImpuestoResumen(new BigDecimal(totalImpuestos).setScale(5, RoundingMode.HALF_UP).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalComprobanteResumen(new BigDecimal(totalComprobante).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalOtrosCargosResumen(new BigDecimal(0));
        comp.setTotalIvaDevueltoResumen(new BigDecimal(0));
    }

    private ProductoServicioDto getProductoServicio(String codigo) {
        EmisorDto emisorDto = (EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem();
        String invCompartido = emisorDto.getInventarioCompartido();
        ProductoServicioDto productoServicioDto = new ProductoServicioDto();
        ProductoServicioService service = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
        Respuesta respuesta = null;
        respuesta = invCompartido.equalsIgnoreCase("S") ? service.getProductoServicioCodigo(emisorDto.getId(), codigo) : service.getProductoServicioCodigoSucursal(emisorDto.getId(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), codigo);
        if (respuesta.getEstado().booleanValue()) {
            productoServicioDto = (ProductoServicioDto)respuesta.getResultado("ProductoServicio");
        } else {
            productoServicioDto = null;
            this.funcionesGenerales.MostrarModalInfo("No se encontr\u00f3 ning\u00fan producto o servicio con el c\u00f3digo digitado.");
        }
        return productoServicioDto;
    }

    private List<DetalleComCompraDto> getDetalleComprobante() {
        ArrayList<DetalleComCompraDto> listaDetalleComprobante = new ArrayList<DetalleComCompraDto>();
        ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
        Integer linea = 0;
        for (DetalleComprobanteTv det : listaDetalle) {
            Integer n = linea;
            Integer n2 = linea = Integer.valueOf(linea + 1);
            DetalleComCompraDto detalle = new DetalleComCompraDto();
            detalle.setNumeroLinea(linea);
            detalle.setTipoCodigo(det.getProductoServicioDto().getTipoCodigo());
            detalle.setCodigo(det.getProductoServicioDto().getCodigo());
            detalle.setCantidad(new BigDecimal(det.getCantidad()).setScale(3, RoundingMode.HALF_UP));
            detalle.setUnidadMedida(det.getProductoServicioDto().getUnidadMedida());
            detalle.setUnidadMedidaComercial(null);
            detalle.setDetalle(det.getDetalle().get());
            detalle.setPrecioUnitario(new BigDecimal(det.getPrecioUnitario()).setScale(5, RoundingMode.HALF_UP));
            detalle.setMontoTotal(new BigDecimal(det.getMontoTotal()).setScale(5, RoundingMode.HALF_UP));
            detalle.setMontoDescuento(new BigDecimal(det.getMontoDescuento()).setScale(5, RoundingMode.HALF_UP));
            if (Double.compare(det.getMontoDescuento(), 0.0) != 0) {
                detalle.setNaturlezaDescuento("Descuento");
            }
            detalle.setSubTotal(new BigDecimal(det.getSubTotal()).setScale(5, RoundingMode.HALF_UP));
            BigDecimal impuestoNeto = new BigDecimal(BigInteger.ZERO);
            if (det.getProductoServicioDto().getExento().equalsIgnoreCase("N")) {
                detalle.setCodigoImpuesto(det.getProductoServicioDto().getTipoImpuesto());
                detalle.setCodigoTarifa(det.getProductoServicioDto().getCodigoTarifa());
                detalle.setTarifaImpuesto(det.getProductoServicioDto().getTarifaImpuesto());
                detalle.setMontoImpuesto(new BigDecimal(det.getMontoImpuesto()).setScale(5, RoundingMode.HALF_UP));
                impuestoNeto = new BigDecimal(det.getMontoImpuesto()).setScale(5, RoundingMode.HALF_UP);
                if (det.getTipoDocumentoExoneracion() != null) {
                    detalle.setTipoDocumentoExoneracion(det.getTipoDocumentoExoneracion());
                    detalle.setInstitucionExoneracion(det.getInstitucionExoneracion());
                    detalle.setNumeroDocumentoExoneracion(det.getNumeroDocumentoExoneracion());
                    detalle.setFechaDocExoneracion(det.getFechaDocExoneracion());
                    BigDecimal impuestoExo = new BigDecimal(this.getMontoExonerado(det.ivaDefecto, det.getMontoImpuesto(), det.getSubTotal())).setScale(5, RoundingMode.HALF_UP);
                    detalle.setMontoImpuestoExoneracion(impuestoExo);
                    det.setMontoImpuestoExoneracion(impuestoExo);
                    detalle.setPorcentajeCompraExoneracion(det.getPorcentajeCompraExoneracion());
                    detalle.setTarifaImpuesto(det.getProductoServicioDto().getTarifaImpuesto());
                    impuestoNeto.subtract(impuestoExo);
                    BigDecimal montoImpuesto = new BigDecimal(0);
                    montoImpuesto = detalle.getMontoImpuesto().add(detalle.getMontoImpuestoExoneracion().setScale(5, RoundingMode.HALF_UP));
                    detalle.setMontoImpuesto(montoImpuesto);
                } else {
                    impuestoNeto = null;
                }
            } else {
                impuestoNeto = null;
            }
            detalle.setImpuestoNeto(impuestoNeto);
            detalle.setMontoTotalLinea(new BigDecimal(det.getMontoTotalLinea()).setScale(5, RoundingMode.HALF_UP));
            detalle.setEmpresa(new EmpresaDto(GlobalApp.idEmpresa));
            detalle.setProductoServicio(det.getProductoServicioDto());
            listaDetalleComprobante.add(detalle);
        }
        return listaDetalleComprobante;
    }

    private Double getMontoExonerado(Double ivaDefecto, Double montoImpuestoActual, Double subTotal) {
        Double value = 0.0;
        Double montoImpuesto = new BigDecimal(subTotal * ivaDefecto).setScale(5, RoundingMode.HALF_UP).doubleValue();
        value = montoImpuesto - montoImpuestoActual;
        return value;
    }

    private Double calcularIvaSinExonerar(Double ivaDefecto, Integer porcentaje) {
        Double value = 0.0;
        Double aux = ivaDefecto * (double)porcentaje.intValue() / 100.0;
        value = ivaDefecto - aux;
        return value;
    }

    private Boolean isProductoServicioValidoIVA(ProductoServicioDto ps) {
        Boolean isValid;
        block6: {
            if (ps.getExento().equalsIgnoreCase("N")) {
                try {
                    TarifaImpuestoService tarifaImpuestoService = (TarifaImpuestoService)AppContext.getInstance().get("TarifaImpuestoService");
                    Respuesta respuesta = tarifaImpuestoService.getTarifasImpuesto();
                    List tarifasImpuesto = respuesta.getEstado() != false ? (List)respuesta.getResultado(ESTADO.OK.VALUE()) : null;
                    if (tarifasImpuesto != null && !tarifasImpuesto.isEmpty()) {
                        TarifaImpuestoDto tarifaImpuestoDto = tarifasImpuesto.stream().filter(e -> e.getCodigo().equalsIgnoreCase(ps.getCodigoTarifa())).findAny().orElse(null);
                        isValid = tarifaImpuestoDto != null ? (tarifaImpuestoDto.getTarifa().compareTo(ps.getTarifaImpuesto()) != 0 ? Boolean.valueOf(false) : Boolean.valueOf(true)) : Boolean.valueOf(false);
                        break block6;
                    }
                    isValid = false;
                }
                catch (Exception ex) {
                    this.funcionesGenerales.MostrarModalInfo("Error al validar el producto con I.V.A, revise el producto o servicio antes de factrar.");
                    isValid = false;
                }
            } else {
                isValid = true;
            }
        }
        if (!isValid.booleanValue()) {
            this.funcionesGenerales.MostrarModalInfo("El producto o servicio no esta configurado corectamente con el I.V.A, debe actualizarlo antes de continuar.");
        }
        return isValid;
    }
}

