/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import electricpos.controller.EditingCell;
import electricpos.controller.EditingCellString;
import electricpos.controller.ExoneracionViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.PostFacturacionViewController;
import electricpos.controller.WaitingViewController;
import electricpos.model.CajaDto;
import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.CondicionVentaDto;
import electricpos.model.DetalleComElectronicoDto;
import electricpos.model.DetalleComprobanteTv;
import electricpos.model.EmisorDto;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.model.MedioPagoDto;
import electricpos.model.MonedaDto;
import electricpos.model.NotificacionType;
import electricpos.model.ProductoServicioDto;
import electricpos.model.ReceptorDto;
import electricpos.model.ResolucionHaciendaDto;
import electricpos.model.SucursalDto;
import electricpos.model.SucursalEmisorDto;
import electricpos.model.TarifaImpuestoDto;
import electricpos.model.TipoComprobante;
import electricpos.service.CondicionVentaService;
import electricpos.service.EmisorService;
import electricpos.service.ProductoServicioService;
import electricpos.service.ReceptorService;
import electricpos.service.SucursalEmisorService;
import electricpos.service.TarifaImpuestoService;
import electricpos.util.AppContext;
import electricpos.util.CabysUtil;
import electricpos.util.ESTADO;
import electricpos.util.FacturacionUtil;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Mensaje;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import electricpos.util.VALIDACION;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;

public class FacturacionPosViewController
implements Initializable {
    ObservableList<CondicionVentaDto> condicionesVentaLista;
    ObservableList<MonedaDto> monedasLista;
    @FXML
    JFXButton btnEnviarFactura;
    @FXML
    ComboBox<CondicionVentaDto> cbxCondicionVenta;
    @FXML
    DatePicker dpFechaEmision;
    @FXML
    ImageView imgEditarPlazoCredito;
    @FXML
    ImageView imgEditarMedioPago;
    @FXML
    ImageView imgEditarEmisor;
    @FXML
    TextField txtCodigoPS;
    @FXML
    TextField txtPlazoCredito;
    @FXML
    TextField txtCantidad;
    @FXML
    TextField txtPagoEfectivo;
    @FXML
    TextField txtPagoOtro;
    @FXML
    Label lblTotalcom;
    @FXML
    Label lblDescuentos;
    @FXML
    Label lblSubTotal;
    @FXML
    Label lblVuelto;
    ReceptorDto receptorFactura = new ReceptorDto();
    List<MedioPagoDto> mediosPago = new ArrayList<MedioPagoDto>();
    ObservableList<SucursalEmisorDto> sucursalLista;
    ProductoServicioDto productoServicioAgregar = new ProductoServicioDto();
    ObservableList<EmisorDto> emisoresLista;
    @FXML
    Text txtReceptor;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    private JFXCheckBox checkOtros;
    @FXML
    private JFXCheckBox checkEfectivo;
    @FXML
    private JFXCheckBox checkPlataformaDigital;
    @FXML
    private JFXCheckBox checkTarjeta;
    @FXML
    private JFXCheckBox checkSinpeMovil;
    @FXML
    private JFXCheckBox checkTransferencia;
    @FXML
    private JFXCheckBox checkModoRomana;
    @FXML
    private JFXCheckBox checkImprimeCopia;
    @FXML
    ComboBox<TipoComprobante> cbxTipoComprobante;
    @FXML
    private TableView<DetalleComprobanteTv> tv_detalleComprobante;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcCodigo;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcDetalle;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcUnidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcCantidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcPrecioUnidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcTotal;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcDescuento;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcSubTotal;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcImpuesto;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcTotalLinea;
    String tipoComprobanteGlobal = null;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    FuncionesGenerales funGenerales = new FuncionesGenerales();
    BigDecimal montoFactura = new BigDecimal(BigInteger.ZERO);
    DecimalFormat formatter = new DecimalFormat("#,##0.00");

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionDetalle();
        this.cargarEmisores();
        this.cargarTiposComprobante();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        if (!this.cbxSucursal.getSelectionModel().isEmpty()) {
            this.checkModoRomana.setSelected(this.getBooleanValue(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getUsaRomana()));
        }
        this.mediosPago = this.funGenerales.llenarMedioPagos();
        FuncionesGenerales.setValidationTextField(this.txtPagoEfectivo, VALIDACION.DECIMAL_5);
        FuncionesGenerales.setValidationTextField(this.txtPagoOtro, VALIDACION.DECIMAL_5);
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaEmision.setValue((Object)localDate);
        CondicionVentaService condicionVentaService = (CondicionVentaService)AppContext.getInstance().get("CondicionVentaService");
        Respuesta respuesta = condicionVentaService.getCondicionesVenta();
        if (respuesta.getEstado().booleanValue()) {
            this.condicionesVentaLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Condiciones")));
            this.cbxCondicionVenta.setItems(this.condicionesVentaLista);
            this.cbxCondicionVenta.getSelectionModel().selectFirst();
        }
        this.txtCantidad.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,16}([\\.]\\d{0,3})?")) {
                    FacturacionPosViewController.this.txtCantidad.setText(oldValue);
                }
            }
        });
        this.txtPagoEfectivo.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String vuelto = FacturacionPosViewController.this.validaPago(FacturacionPosViewController.this.montoFactura, false);
                FacturacionPosViewController.this.lblVuelto.setText(vuelto);
            }
        });
        this.txtPagoOtro.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String vuelto = FacturacionPosViewController.this.validaPago(FacturacionPosViewController.this.montoFactura, false);
                FacturacionPosViewController.this.lblVuelto.setText(vuelto);
            }
        });
    }

    private void cargarTiposComprobante() {
        ArrayList<TipoComprobante> lista = new ArrayList<TipoComprobante>();
        TipoComprobante tps1 = new TipoComprobante("01", "Factura electr\u00f3nica");
        TipoComprobante tps2 = new TipoComprobante("04", "Tiquete electr\u00f3nico");
        lista.add(tps2);
        lista.add(tps1);
        ObservableList tipoPsLsista = FXCollections.observableArrayList(lista);
        this.cbxTipoComprobante.setItems(tipoPsLsista);
        this.cbxTipoComprobante.getSelectionModel().selectFirst();
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    public void guardarMediosPago() {
        for (MedioPagoDto medio : this.mediosPago) {
            if (medio.getCodigo().equalsIgnoreCase("01")) {
                medio.setActivo(this.checkEfectivo.isSelected());
            }
            if (medio.getCodigo().equalsIgnoreCase("02")) {
                medio.setActivo(this.checkTarjeta.isSelected());
            }
            if (medio.getCodigo().equalsIgnoreCase("03")) {
                medio.setActivo(this.checkSinpeMovil.isSelected());
            }
            if (medio.getCodigo().equalsIgnoreCase("04")) {
                medio.setActivo(this.checkTransferencia.isSelected());
            }
            if (medio.getCodigo().equalsIgnoreCase("05")) {
                medio.setActivo(this.checkPlataformaDigital.isSelected());
            }
            if (!medio.getCodigo().equalsIgnoreCase("99")) continue;
            medio.setActivo(this.checkOtros.isSelected());
        }
    }

    private Double getMontoImpuesto(Double precio, Double impuesto) {
        Double monto = precio * impuesto / 100.0;
        return monto;
    }

    @FXML
    public void onEnterTxtCodigoPS(ActionEvent ae) {
        String codigoProducto = null;
        codigoProducto = this.checkModoRomana.isSelected() ? this.descomponerCodigoRomana(this.txtCodigoPS.getText()) : this.txtCodigoPS.getText();
        this.productoServicioAgregar = this.getProductoServicio(codigoProducto);
        if (this.productoServicioAgregar != null) {
            this.agregarProducto();
        }
    }

    private String descomponerCodigoRomana(String codigoRomana) {
        if (codigoRomana.length() != 13) {
            return null;
        }
        String codigo = codigoRomana.substring(1, 7);
        String cantidad = codigoRomana.substring(7, 12);
        Double can = Double.valueOf(cantidad);
        can = can / 1000.0;
        this.txtCantidad.setText(can.toString());
        return codigo;
    }

    private void agregarProducto() {
        EmisorDto emisor = (EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem();
        String producto = this.productoServicioAgregar.getDescripcion();
        BigDecimal existencia = this.productoServicioAgregar.getExistencia();
        if (this.productoServicioAgregar.getExento().equalsIgnoreCase("S")) {
            this.funcionesGenerales.MostrarModalInfo("El producto/servicio debe se tener almenos un impuesto configurado.");
            return;
        }
        if (emisor.getInvNotificaStock().equalsIgnoreCase("S") && this.productoServicioAgregar.getExistencia().compareTo(emisor.getInvMinStock()) <= 0) {
            this.funcionesGenerales.MostrarModalInfo("El producto/servicio [" + producto + "] esta a punto de agotarse. Cantidad restante [" + existencia.toEngineeringString() + "]");
        }
        if (this.funcionesGenerales.mostrarModalValidaCabys(this.productoServicioAgregar)) {
            if (this.isProductoServicioValidoIVA(this.productoServicioAgregar).booleanValue()) {
                Double cantidad = Double.valueOf(this.txtCantidad.getText());
                Double precioUni = this.productoServicioAgregar.getPrecioSinImp().doubleValue();
                Double montoImpuesto = this.productoServicioAgregar.getMontoImpuesto().doubleValue() * cantidad;
                Double precioConImpuesto = precioUni * cantidad + montoImpuesto;
                ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
                Optional<DetalleComprobanteTv> matchingObject = listaDetalle.stream().filter(p -> p.getCodigoProducto().equals(this.productoServicioAgregar.getCodigo())).findFirst();
                if (matchingObject.isPresent()) {
                    Double newCantidad = Double.valueOf(matchingObject.get().getCantidad()) + 1.0;
                    Double precioUnidad = matchingObject.get().getPrecioUnitario();
                    Double total = new BigDecimal(newCantidad * precioUnidad).setScale(5, RoundingMode.HALF_UP).doubleValue();
                    matchingObject.get().setMontoTotal(total);
                    matchingObject.get().getMontoDescuento();
                    Double subTotal = new BigDecimal(total).setScale(5, RoundingMode.HALF_UP).doubleValue();
                    matchingObject.get().setSubTotal(subTotal);
                    Double iva = matchingObject.get().getIva();
                    Double montoImpuesto2 = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_UP).doubleValue();
                    matchingObject.get().setMontoImpuesto(montoImpuesto2);
                    Double totalLinea = new BigDecimal(montoImpuesto2 + subTotal).setScale(5, RoundingMode.HALF_UP).doubleValue();
                    matchingObject.get().setMontoTotalLinea(totalLinea);
                    matchingObject.get().setCantidad((double)newCantidad);
                } else {
                    DetalleComprobanteTv nuevo = new DetalleComprobanteTv(Double.valueOf(this.txtCantidad.getText()), this.productoServicioAgregar.getUnidadMedida(), this.productoServicioAgregar.getDescripcion(), precioUni, precioUni * cantidad, 0.0, precioUni * cantidad, montoImpuesto, precioConImpuesto, this.productoServicioAgregar.getCodigo(), this.productoServicioAgregar);
                    nuevo.setTipo(this.productoServicioAgregar.getTipo());
                    nuevo.setExento(this.productoServicioAgregar.getExento());
                    this.tv_detalleComprobante.getItems().add((Object)nuevo);
                }
                this.obtenerResumen();
                this.txtCodigoPS.clear();
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("El producto/servicio no se pudo agregar por falta de c\u00f3digo CABYS.");
        }
    }

    @FXML
    private void onBtnEliminarLinea() {
        this.tv_detalleComprobante.getItems().remove(this.tv_detalleComprobante.getSelectionModel().getSelectedItem());
        this.obtenerResumen();
    }

    @FXML
    private void onBtnBuscarPS() {
        if (!this.txtCodigoPS.getText().isEmpty()) {
            String codigoProducto = null;
            codigoProducto = this.checkModoRomana.isSelected() ? this.descomponerCodigoRomana(this.txtCodigoPS.getText()) : this.txtCodigoPS.getText();
            this.productoServicioAgregar = this.getProductoServicio(codigoProducto);
            if (this.productoServicioAgregar != null) {
                this.agregarProducto();
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de ingresar un c\u00f3digo.");
        }
    }

    @FXML
    private void onBtnFiltrar() {
        EmisorDto emisorDto = (EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem();
        this.productoServicioAgregar = this.funcionesGenerales.mostrarBusquedaPS(emisorDto.getId(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), emisorDto.getInventarioCompartido());
        if (this.productoServicioAgregar != null) {
            this.agregarProducto();
        }
    }

    @FXML
    private void onBtnCliente() {
        this.receptorFactura = this.funGenerales.ClienteViewController(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), this.receptorFactura, false);
        if (this.receptorFactura.getId() != null) {
            this.txtReceptor.setText(this.receptorFactura.getNombre());
        } else {
            this.txtReceptor.setText("Sin cliente");
        }
    }

    @FXML
    private void onBtnExonerarLinea() {
        if (this.tv_detalleComprobante.getSelectionModel().getSelectedItem() != null) {
            if (((DetalleComprobanteTv)this.tv_detalleComprobante.getSelectionModel().getSelectedItem()).exento.equalsIgnoreCase("N")) {
                this.mostrarExoneracionLinea();
            } else {
                this.funcionesGenerales.MostrarModalInfo("El producto/servicio se encuentra exento de impuestos.");
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar una l\u00ednea del detalle.");
        }
    }

    public void mostrarExoneracionLinea() {
        DetalleComprobanteTv detalleTv = (DetalleComprobanteTv)this.tv_detalleComprobante.getSelectionModel().getSelectedItem();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ExoneracionView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ExoneracionViewController exoneracionViewController = (ExoneracionViewController)fxmlLoader.getController();
        exoneracionViewController.cargarExoneracion(detalleTv.getTipoDocumentoExoneracion(), detalleTv.getNumeroDocumentoExoneracion(), detalleTv.getInstitucionExoneracion(), detalleTv.getFechaDocExoneracion(), detalleTv.getPorcentajeCompraExoneracion());
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
        if (exoneracionViewController.modifico) {
            detalleTv.setTipoDocumentoExoneracion(exoneracionViewController.tipoDocumentoExoneracion);
            detalleTv.setNumeroDocumentoExoneracion(exoneracionViewController.numeroDocumentoExoneracion);
            detalleTv.setInstitucionExoneracion(exoneracionViewController.institucionExoneracion);
            detalleTv.setFechaDocExoneracion(exoneracionViewController.fechaDocExoneracion);
            detalleTv.setPorcentajeCompraExoneracion(exoneracionViewController.porcentajeCompraExoneracion);
            detalleTv.setIva(this.calcularNuevoImpuesto(detalleTv.getIvaDefecto(), exoneracionViewController.porcentajeCompraExoneracion));
            this.refrescarDetalle(detalleTv);
            this.obtenerResumen();
        }
    }

    private Double calcularNuevoImpuesto(Double impuestoActual, Integer porcentaje) {
        Double impuestoNuevo = 0.0;
        Double aux = 0.0;
        try {
            aux = impuestoActual * (double)porcentaje.intValue() / 100.0;
            impuestoNuevo = impuestoActual - aux;
        }
        catch (Exception ex) {
            impuestoNuevo = 0.0;
        }
        return impuestoNuevo;
    }

    private void refrescarDetalle(DetalleComprobanteTv det) {
        Double subTotal = det.getSubTotal();
        Double iva = det.getIva();
        Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_UP).doubleValue();
        det.setMontoImpuesto(montoImpuesto);
        Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_UP).doubleValue();
        det.setMontoTotalLinea(totalLinea);
    }

    public void mostrarPostFacturacion(ComprobanteElectronicoDto comp, String vuelto) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/PostFacturacionView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        PostFacturacionViewController controller = (PostFacturacionViewController)fxmlLoader.getController();
        Integer copiesInvoice = 1;
        if (this.checkImprimeCopia.isSelected()) {
            copiesInvoice = 2;
        }
        controller.mostrarComprobanteHilo(comp, vuelto, copiesInvoice);
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
    }

    public boolean mostrarComprobanteHilo(ComprobanteElectronicoDto comp) {
        try {
            FuncionesGenerales.procesaVBoxNotificaciones();
            GlobalApp.vBoxNotificaciones.setVisible(true);
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/WaitingView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.vBoxNotificaciones.getChildren().add((Object)ancho);
            Integer copiesInvoice = 1;
            if (this.checkImprimeCopia.isSelected()) {
                copiesInvoice = 2;
            }
            WaitingViewController waitingViewController = (WaitingViewController)fxmlLoader.getController();
            waitingViewController.setAnchorPane(ancho);
            waitingViewController.setTipo(comp.getTipoCom());
            waitingViewController.setCopies(copiesInvoice);
            waitingViewController.setComprobanteElectronicoDto(comp);
            waitingViewController.enviarComprobanteElectronico();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @FXML
    private void onCbxEmisorChanged() {
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    @FXML
    private void OnEnviarFactura() {
        if (!this.funcionesGenerales.isValidSession().booleanValue()) {
            this.funcionesGenerales.closeSession(this.cbxEmisor.getScene());
        } else {
            if (!FacturacionUtil.isValidCertificate()) {
                return;
            }
            String codigoActividad = ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getCodigoActividad();
            if (codigoActividad != null) {
                if (!this.tv_detalleComprobante.getItems().isEmpty()) {
                    ComprobanteElectronicoDto comprobante = new ComprobanteElectronicoDto();
                    comprobante.setVersion(GlobalApp.parametrosSistema.getVersionDoc());
                    comprobante.setCodigoActividadEmisor(codigoActividad);
                    comprobante.setFechaEmision(((LocalDate)this.dpFechaEmision.getValue()).atTime(LocalTime.now()));
                    TipoComprobante tipoComprobante = (TipoComprobante)this.cbxTipoComprobante.getValue();
                    comprobante.setTipoCom(tipoComprobante.getCodigo());
                    comprobante.setCondicionVenta(((CondicionVentaDto)this.cbxCondicionVenta.getSelectionModel().getSelectedItem()).getCodigo());
                    comprobante.setPlazoCredito(this.txtPlazoCredito.getText());
                    try {
                        if (this.receptorFactura.getId() == 0) {
                            ReceptorDto creado = new ReceptorDto();
                            this.receptorFactura.setId(null);
                            this.receptorFactura.setEmisor(new EmisorDto(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId()));
                            this.receptorFactura.setEmpresa(new EmpresaDto(GlobalApp.idEmpresa));
                            creado = this.guardarReceptorService(this.receptorFactura);
                            if (creado != null) {
                                comprobante.setReceptor(creado);
                                Object var5_6 = null;
                            }
                        } else {
                            comprobante.setReceptor(this.receptorFactura);
                        }
                    }
                    catch (Exception e) {
                        comprobante.setReceptor(null);
                    }
                    if (comprobante.getReceptor() == null) {
                        comprobante.setTipoCom("04");
                    } else {
                        comprobante.setTipoCom("01");
                    }
                    CajaDto cajaActual = this.funcionesGenerales.getUltimaCaja();
                    if (cajaActual != null && cajaActual.getEstado().equalsIgnoreCase("A")) {
                        comprobante.setIdCaja(cajaActual.getId());
                    } else {
                        comprobante.setIdCaja(null);
                        if (GlobalApp.empresa.getReqCaja().equalsIgnoreCase("S")) {
                            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "No existe ninguna caja abierta para las facturas.");
                            return;
                        }
                    }
                    EmpresaDto empresaDto = new EmpresaDto(GlobalApp.idEmpresa);
                    comprobante.setEmpresa(empresaDto);
                    EmisorDto emisorDto = new EmisorDto(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
                    emisorDto.setEmpresa(empresaDto);
                    comprobante.setEmisor(emisorDto);
                    ResolucionHaciendaDto resolucionHaciendaDto = new ResolucionHaciendaDto(1);
                    comprobante.setNormativa(resolucionHaciendaDto);
                    SucursalDto sucursalDto = new SucursalDto(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
                    sucursalDto.setEmpresa(empresaDto);
                    comprobante.setSucursal(sucursalDto);
                    List<DetalleComElectronicoDto> listaDetalleComprobante = this.getDetalleComprobante();
                    comprobante.setListaDetalleComprobantes(listaDetalleComprobante);
                    comprobante.setTipoDocReferencia(null);
                    comprobante.setNumeroDocReferencia(null);
                    comprobante.setFechaEmisionReferencia(null);
                    comprobante.setCodigoReferencia(null);
                    comprobante.setRazonReferencia(null);
                    comprobante.setEmailUsuario(GlobalApp.usuarioLogueado.getCorreo());
                    comprobante.setNombreUsuario(GlobalApp.usuarioLogueado.getNombreUsuario());
                    comprobante.setMontoEfectivo(this.montoFactura);
                    comprobante.setCodigoMonedaResumen("CRC");
                    comprobante.setTipoCambioResumen(new BigDecimal(1));
                    this.setResumenComprobante(comprobante);
                    this.guardarMediosPago();
                    BigDecimal total = comprobante.getTotalComprobanteResumen().setScale(5, RoundingMode.HALF_UP);
                    boolean asignado = false;
                    for (MedioPagoDto m : this.mediosPago) {
                        if (!m.isActivo()) continue;
                        comprobante.setMedioPago1(m.getCodigo() + ":" + total);
                        asignado = true;
                        break;
                    }
                    if (!asignado) {
                        comprobante.setMedioPago1("01:" + total);
                    }
                    comprobante.setDocumentoReferencia(null);
                    comprobante.setReversadoTotal("N");
                    comprobante.setBorrador("N");
                    String vuelto = this.validaPago(comprobante.getTotalComprobanteResumen(), true);
                    if (vuelto != null) {
                        this.mostrarComprobanteHilo(comprobante);
                        Stage stage = (Stage)this.btnEnviarFactura.getScene().getWindow();
                        stage.close();
                        this.mostrarFacturacionPos();
                    }
                } else {
                    this.funcionesGenerales.MostrarModalInfo("Debe de ingresar como m\u00ednimo un producto o servicio.");
                }
            } else {
                this.funcionesGenerales.MostrarModalInfo("La sucursal seleccionada no posee un c\u00f3digo de actividad asignado, configurelo para continuar.");
            }
        }
    }

    private void mostrarFacturacionPos() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionPosView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        FacturacionPosViewController controller = (FacturacionPosViewController)fxmlLoader.getController();
        controller.setTipoComprobanteGlobal("04");
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.getIcons().add((Object)new Image("/electricpos/resources/space.jpg"));
        stage.setTitle("Facturaci\u00f3n electr\u00f3nica SPACE");
        stage.initModality(Modality.NONE);
        stage.show();
    }

    private String validaPago(BigDecimal totalComprobante, boolean mensaje) {
        String vueltoFormatter = null;
        Double pagoEfectivo = Double.valueOf(this.txtPagoEfectivo.getText());
        Double pagoOtro = Double.valueOf(this.txtPagoOtro.getText());
        Double total = totalComprobante.doubleValue();
        Double aPagarEfectivo = total - pagoOtro;
        Double vuelto = pagoEfectivo - aPagarEfectivo;
        if (vuelto < 0.0 && !mensaje) {
            return "0.00";
        }
        vueltoFormatter = this.formatter.format(vuelto);
        if (!mensaje) {
            return vueltoFormatter;
        }
        if (aPagarEfectivo <= pagoEfectivo) {
            return vueltoFormatter;
        }
        vuelto = 0.0;
        this.funcionesGenerales.MostrarModalInfo("El monto a pagar no cubre el total de la factura.");
        return null;
    }

    private ReceptorDto guardarReceptorService(ReceptorDto receptorDto) {
        EmpresaDto empresa = new EmpresaDto(1);
        receptorDto.setEmpresa(empresa);
        Stage stage = (Stage)this.btnEnviarFactura.getScene().getWindow();
        ReceptorService service = (ReceptorService)AppContext.getInstance().get("ReceptorService");
        Respuesta respuesta = service.saveReceptor(receptorDto);
        if (respuesta.getEstado().booleanValue()) {
            receptorDto = (ReceptorDto)respuesta.getResultado("Receptor");
            return receptorDto;
        }
        Mensaje.getInstance().showModal(Alert.AlertType.ERROR, "Guardar Receptor", (Window)stage, respuesta.getMensaje());
        return null;
    }

    private void crearRelacionDetalle() {
        this.tv_detalleComprobante.setEditable(true);
        Callback<TableColumn<DetalleComprobanteTv, Number>, TableCell<DetalleComprobanteTv, Number>> cellFactory = new Callback<TableColumn<DetalleComprobanteTv, Number>, TableCell<DetalleComprobanteTv, Number>>(){

            public TableCell call(TableColumn p) {
                return new EditingCell();
            }
        };
        Callback<TableColumn<DetalleComprobanteTv, String>, TableCell<DetalleComprobanteTv, String>> cellFactoryString = new Callback<TableColumn<DetalleComprobanteTv, String>, TableCell<DetalleComprobanteTv, String>>(){

            public TableCell call(TableColumn p) {
                return new EditingCellString();
            }
        };
        this.tbcCodigo.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).codigoProducto);
        this.tbcUnidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).unidadMedida);
        this.tbcDetalle.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).detalle);
        this.tbcDetalle.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tbcDetalle.setEditable(true);
        this.tbcCantidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).cantidad);
        this.tbcCantidad.setCellFactory((Callback)cellFactory);
        this.tbcCantidad.setEditable(true);
        this.tbcCantidad.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<DetalleComprobanteTv, Number>>(){

            public void handle(TableColumn.CellEditEvent<DetalleComprobanteTv, Number> t) {
                DetalleComprobanteTv detalle = (DetalleComprobanteTv)t.getRowValue();
                double cantidad = ((Number)t.getNewValue()).doubleValue();
                detalle.setCantidad(cantidad);
                double precioUnitario = detalle.getPrecioUnitario();
                double montoTotal = this.round(cantidad * precioUnitario);
                detalle.setMontoTotal(montoTotal);
                double descuento = detalle.getMontoDescuento() != null ? detalle.getMontoDescuento() : 0.0;
                double subTotal = this.round(montoTotal - descuento);
                detalle.setSubTotal(subTotal);
                ProductoServicioDto ps = detalle.getProductoServicioDto();
                double iva = detalle.getIva();
                double tarifaImpuesto = ps.getTarifaImpuesto().doubleValue();
                double variableImpuesto = tarifaImpuesto / 100.0 + 1.0;
                boolean usaMontoTotalComoBaseImponible = "01".equals(detalle.getCodigoDescuento()) || "03".equals(detalle.getCodigoDescuento());
                boolean esIVA = "01".equals(ps.getTipoImpuesto());
                BigDecimal baseImponible = usaMontoTotalComoBaseImponible && esIVA ? BigDecimal.valueOf(montoTotal).divide(BigDecimal.valueOf(variableImpuesto), 5, RoundingMode.HALF_UP) : BigDecimal.valueOf(subTotal);
                detalle.setBaseImponible(baseImponible);
                double montoImpuesto = baseImponible.multiply(BigDecimal.valueOf(iva)).setScale(5, RoundingMode.HALF_UP).doubleValue();
                detalle.setMontoImpuesto(montoImpuesto);
                if (usaMontoTotalComoBaseImponible && esIVA) {
                    detalle.setImpuestoAsumidoEmisor(BigDecimal.valueOf(montoImpuesto));
                    detalle.setMontoImpuestoNeto(BigDecimal.ZERO);
                } else {
                    detalle.setImpuestoAsumidoEmisor(BigDecimal.ZERO);
                    detalle.setMontoImpuestoNeto(BigDecimal.valueOf(montoImpuesto));
                }
                double totalLinea = this.round(subTotal + detalle.getMontoImpuestoNeto().doubleValue());
                detalle.setMontoTotalLinea(totalLinea);
                FacturacionPosViewController.this.obtenerResumen();
            }

            private double round(double value) {
                return new BigDecimal(value).setScale(5, RoundingMode.HALF_UP).doubleValue();
            }
        });
        this.tbcPrecioUnidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).precioUnitario);
        this.tbcTotal.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoTotal);
        this.tbcDescuento.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoDescuento);
        this.tbcDescuento.setCellFactory((Callback)cellFactory);
        this.tbcDescuento.setEditable(true);
        this.tbcDescuento.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<DetalleComprobanteTv, Number>>(){

            public void handle(TableColumn.CellEditEvent<DetalleComprobanteTv, Number> t) {
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoDescuento(((Number)t.getNewValue()).doubleValue());
                Double cantidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getCantidad();
                Double total = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoTotal();
                Double descuento = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoDescuento();
                Double subTotal = new BigDecimal(total - descuento).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSubTotal(subTotal);
                Double iva = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getIva();
                Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoImpuesto(montoImpuesto);
                Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_UP).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotalLinea(totalLinea);
                FacturacionPosViewController.this.obtenerResumen();
            }
        });
        this.tbcSubTotal.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).subTotal);
        this.tbcImpuesto.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoImpuesto);
        this.tbcTotalLinea.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoTotalLinea);
        this.tbcTotalLinea.setCellFactory((Callback)cellFactory);
        this.tbcTotalLinea.setEditable(true);
        this.tbcTotalLinea.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<DetalleComprobanteTv, Number>>(){

            public void handle(TableColumn.CellEditEvent<DetalleComprobanteTv, Number> t) {
                BigDecimal baseImponible;
                double subTotal;
                DetalleComprobanteTv detalle = (DetalleComprobanteTv)t.getRowValue();
                double nuevoTotalLinea = ((Number)t.getNewValue()).doubleValue();
                detalle.setMontoTotalLinea(nuevoTotalLinea);
                detalle.setCantidad(1.0);
                ProductoServicioDto ps = detalle.getProductoServicioDto();
                double tarifaImpuesto = ps.getTarifaImpuesto().doubleValue();
                double iva = detalle.getIva();
                double variableImpuesto = tarifaImpuesto / 100.0 + 1.0;
                if ("S".equalsIgnoreCase(ps.getImpuestoIncluido())) {
                    double precioUnitario = new BigDecimal(nuevoTotalLinea / variableImpuesto).setScale(5, RoundingMode.HALF_UP).doubleValue();
                    detalle.setPrecioUnitario(precioUnitario);
                    double montoTotal = new BigDecimal(precioUnitario * detalle.getCantidad()).setScale(5, RoundingMode.HALF_UP).doubleValue();
                    detalle.setMontoTotal(montoTotal);
                    detalle.setMontoDescuento(0.0);
                    subTotal = montoTotal;
                    baseImponible = BigDecimal.valueOf(subTotal);
                } else {
                    double precioUnitario = nuevoTotalLinea;
                    detalle.setPrecioUnitario(precioUnitario);
                    double montoTotal = new BigDecimal(precioUnitario * detalle.getCantidad()).setScale(5, RoundingMode.HALF_UP).doubleValue();
                    detalle.setMontoTotal(montoTotal);
                    detalle.setMontoDescuento(0.0);
                    subTotal = montoTotal;
                    baseImponible = BigDecimal.valueOf(subTotal);
                }
                detalle.setSubTotal(subTotal);
                boolean usaMontoTotalComoBaseImponible = "01".equals(detalle.getCodigoDescuento()) || "03".equals(detalle.getCodigoDescuento());
                boolean esIVA = "01".equals(ps.getTipoImpuesto());
                if (usaMontoTotalComoBaseImponible && esIVA) {
                    baseImponible = BigDecimal.valueOf(nuevoTotalLinea).divide(BigDecimal.valueOf(variableImpuesto), 5, RoundingMode.HALF_UP);
                }
                detalle.setBaseImponible(baseImponible);
                double montoImpuesto = baseImponible.multiply(BigDecimal.valueOf(iva)).setScale(5, RoundingMode.HALF_UP).doubleValue();
                detalle.setMontoImpuesto(montoImpuesto);
                if (usaMontoTotalComoBaseImponible && esIVA) {
                    detalle.setImpuestoAsumidoEmisor(BigDecimal.valueOf(montoImpuesto));
                    detalle.setMontoImpuestoNeto(BigDecimal.ZERO);
                } else {
                    detalle.setImpuestoAsumidoEmisor(BigDecimal.ZERO);
                    detalle.setMontoImpuestoNeto(BigDecimal.valueOf(montoImpuesto));
                }
                double totalLinea = BigDecimal.valueOf(subTotal).add(detalle.getMontoImpuestoNeto()).setScale(5, RoundingMode.HALF_UP).doubleValue();
                detalle.setMontoTotalLinea(totalLinea);
                FacturacionPosViewController.this.obtenerResumen();
            }
        });
    }

    public String getTipoComprobanteGlobal() {
        return this.tipoComprobanteGlobal;
    }

    public void setTipoComprobanteGlobal(String tipoComprobanteGlobal) {
        this.tipoComprobanteGlobal = tipoComprobanteGlobal;
    }

    private void obtenerResumen() {
        ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
        Double totalServiciosGravados = 0.0;
        Double totalServiciosExentos = 0.0;
        Double totalServiciosExonerado = 0.0;
        Double totalMercanciaGravados = 0.0;
        Double totalMercanciaExentos = 0.0;
        Double totalMercanciaExonerado = 0.0;
        Double totalGravado = 0.0;
        Double totalExento = 0.0;
        Double totalExonerado = 0.0;
        Double totalVenta = 0.0;
        Double totalDescuentos = 0.0;
        Double totalVentaNeta = 0.0;
        Double totalImpuestos = 0.0;
        Double totalComprobante = 0.0;
        for (DetalleComprobanteTv detalle : listaDetalle) {
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalServiciosGravados = totalServiciosGravados + detalle.getMontoTotal();
            }
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalServiciosExentos = totalServiciosExentos + detalle.getMontoTotal();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalMercanciaGravados = totalMercanciaGravados + detalle.getMontoTotal();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalMercanciaExentos = totalMercanciaExentos + detalle.getMontoTotal();
            }
            totalDescuentos = new BigDecimal(totalDescuentos + detalle.getMontoDescuento()).setScale(5, RoundingMode.HALF_UP).doubleValue();
            totalImpuestos = new BigDecimal(totalImpuestos + detalle.getMontoImpuesto()).setScale(5, RoundingMode.HALF_UP).doubleValue();
        }
        totalGravado = totalServiciosGravados + totalMercanciaGravados;
        totalExento = totalServiciosExentos + totalMercanciaExentos;
        totalExonerado = totalServiciosExonerado + totalMercanciaExonerado;
        totalVenta = new BigDecimal(totalGravado + totalExento).setScale(5, RoundingMode.HALF_UP).doubleValue();
        totalVentaNeta = new BigDecimal(totalVenta - totalDescuentos).setScale(5, RoundingMode.HALF_UP).doubleValue();
        totalComprobante = new BigDecimal(totalVentaNeta + totalImpuestos).setScale(5, RoundingMode.HALF_UP).doubleValue();
        this.lblSubTotal.setText(this.formatter.format(totalVenta));
        this.lblDescuentos.setText(this.formatter.format(totalDescuentos));
        this.lblTotalcom.setText(this.formatter.format(totalComprobante));
        this.montoFactura = new BigDecimal(totalComprobante);
        String vuelto = this.validaPago(this.montoFactura, false);
        this.lblVuelto.setText(vuelto);
    }

    private void setResumenComprobante(ComprobanteElectronicoDto comp) {
        ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
        Double totalServiciosGravados = 0.0;
        Double totalServiciosExentos = 0.0;
        Double totalServiciosExonerado = 0.0;
        Double totalMercanciaGravados = 0.0;
        Double totalMercanciaExentos = 0.0;
        Double totalMercanciaExonerado = 0.0;
        Double totalImpuestosAsumidos = 0.0;
        Double totalGravado = 0.0;
        Double totalExento = 0.0;
        Double totalExonerado = 0.0;
        Double totalVenta = 0.0;
        Double totalDescuentos = 0.0;
        Double totalVentaNeta = 0.0;
        Double totalImpuestos = 0.0;
        Double totalComprobante = 0.0;
        for (DetalleComprobanteTv detalle : listaDetalle) {
            Double exonerado;
            Double gravadoExo;
            BigDecimal total = new BigDecimal(detalle.getMontoTotal()).setScale(5, RoundingMode.HALF_UP);
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys())) {
                if (detalle.getExento().equalsIgnoreCase("N")) {
                    if (detalle.getMontoImpuestoExoneracion() == null && detalle.getTipoDocumentoExoneracion() == null) {
                        totalServiciosGravados = totalServiciosGravados + total.doubleValue();
                    } else {
                        gravadoExo = (1.0 - Double.valueOf(detalle.getPorcentajeCompraExoneracion().intValue()) / (detalle.getIvaDefecto() * 100.0)) * total.doubleValue();
                        totalServiciosGravados = totalServiciosGravados + gravadoExo;
                    }
                } else {
                    totalServiciosExentos = totalServiciosExentos + total.doubleValue();
                }
                if (detalle.getMontoImpuestoExoneracion() != null && detalle.getTipoDocumentoExoneracion() != null && detalle.getExento().equalsIgnoreCase("N")) {
                    exonerado = Double.valueOf(detalle.getPorcentajeCompraExoneracion().intValue()) / (detalle.getIvaDefecto() * 100.0) * total.doubleValue();
                    totalServiciosExonerado = totalServiciosExonerado + exonerado;
                }
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys())) {
                if (detalle.getExento().equalsIgnoreCase("N")) {
                    if (detalle.getMontoImpuestoExoneracion() == null && detalle.getTipoDocumentoExoneracion() == null) {
                        totalMercanciaGravados = totalMercanciaGravados + total.doubleValue();
                    } else {
                        gravadoExo = (1.0 - Double.valueOf(detalle.getPorcentajeCompraExoneracion().intValue()) / (detalle.getIvaDefecto() * 100.0)) * total.doubleValue();
                        totalMercanciaGravados = totalMercanciaGravados + gravadoExo;
                    }
                } else {
                    totalMercanciaExentos = totalMercanciaExentos + total.doubleValue();
                }
                if (detalle.getMontoImpuestoExoneracion() != null && detalle.getExento().equalsIgnoreCase("N")) {
                    exonerado = Double.valueOf(detalle.getPorcentajeCompraExoneracion().intValue()) / (detalle.getIvaDefecto() * 100.0) * total.doubleValue();
                    totalMercanciaExonerado = totalMercanciaExonerado + exonerado;
                }
            }
            totalDescuentos = totalDescuentos + detalle.getMontoDescuento();
            totalImpuestosAsumidos = totalImpuestosAsumidos + detalle.getImpuestoAsumidoEmisor().doubleValue();
            totalImpuestos = totalImpuestos + detalle.getMontoImpuesto();
        }
        comp.setTotalImpAsumidoEmisor(new BigDecimal(totalImpuestosAsumidos).setScale(5, RoundingMode.HALF_UP));
        totalImpuestos = totalImpuestos - totalImpuestosAsumidos;
        totalGravado = totalServiciosGravados + totalMercanciaGravados;
        totalExento = totalServiciosExentos + totalMercanciaExentos;
        totalExonerado = totalServiciosExonerado + totalMercanciaExonerado;
        totalVenta = totalGravado + totalExento + totalExonerado;
        totalVentaNeta = totalVenta - totalDescuentos;
        totalComprobante = totalVentaNeta + totalImpuestos;
        comp.setTotalServGravadosResumen(BigDecimal.valueOf(totalServiciosGravados).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalServExentosResumen(BigDecimal.valueOf(totalServiciosExentos).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalServExoneradosResumen(BigDecimal.valueOf(totalServiciosExonerado).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalMercanciasGravadasResumen(BigDecimal.valueOf(totalMercanciaGravados).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalMercanciasExentasResumen(BigDecimal.valueOf(totalMercanciaExentos).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalMercanciasExoneradasResumen(BigDecimal.valueOf(totalMercanciaExonerado).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalGravadoResumen(BigDecimal.valueOf(totalGravado).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalExentoResumen(BigDecimal.valueOf(totalExento).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalExoneradoResumen(BigDecimal.valueOf(totalExonerado).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalVentaResumen(BigDecimal.valueOf(totalVenta).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalDescuentosResumen(BigDecimal.valueOf(totalDescuentos).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalVentaNetaResumen(BigDecimal.valueOf(totalVentaNeta).setScale(5, RoundingMode.HALF_UP));
        comp.setMontoImpuestoResumen(BigDecimal.valueOf(totalImpuestos).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalComprobanteResumen(BigDecimal.valueOf(totalComprobante).setScale(5, RoundingMode.HALF_UP));
        comp.setTotalOtrosCargosResumen(BigDecimal.ZERO);
        comp.setTotalIvaDevueltoResumen(BigDecimal.ZERO);
    }

    private ProductoServicioDto getProductoServicio(String codigo) {
        EmisorDto emisorDto = (EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem();
        String invCompartido = emisorDto.getInventarioCompartido();
        ProductoServicioDto productoServicioDto = new ProductoServicioDto();
        ProductoServicioService service = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
        Respuesta respuesta = null;
        respuesta = invCompartido.equalsIgnoreCase("S") ? service.getProductoServicioCodigo(emisorDto.getId(), codigo) : service.getProductoServicioCodigoSucursal(emisorDto.getId(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), codigo);
        if (respuesta.getEstado().booleanValue()) {
            productoServicioDto = (ProductoServicioDto)respuesta.getResultado("ProductoServicio");
        } else {
            productoServicioDto = null;
            this.funcionesGenerales.MostrarModalInfo("No se encontr\u00f3 ning\u00fan producto o servicio con el c\u00f3digo digitado.");
        }
        return productoServicioDto;
    }

    private List<DetalleComElectronicoDto> getDetalleComprobante() {
        ArrayList<DetalleComElectronicoDto> listaDetalleComprobante = new ArrayList<DetalleComElectronicoDto>();
        ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
        Integer linea = 0;
        for (DetalleComprobanteTv det : listaDetalle) {
            Integer n = linea;
            Integer n2 = linea = Integer.valueOf(linea + 1);
            DetalleComElectronicoDto detalle = new DetalleComElectronicoDto();
            detalle.setNumeroLinea(linea);
            detalle.setTipoCodigo(det.getProductoServicioDto().getTipoCodigo());
            detalle.setCodigo(det.getProductoServicioDto().getCodigo());
            detalle.setCantidad(new BigDecimal(det.getCantidad()).setScale(3, RoundingMode.HALF_UP));
            detalle.setUnidadMedida(det.getProductoServicioDto().getUnidadMedida());
            detalle.setUnidadMedidaComercial(null);
            detalle.setDetalle(det.getDetalle().get());
            detalle.setPrecioUnitario(new BigDecimal(det.getPrecioUnitario()).setScale(5, RoundingMode.HALF_UP));
            detalle.setMontoTotal(new BigDecimal(det.getMontoTotal()).setScale(5, RoundingMode.HALF_UP));
            detalle.setMontoDescuento(new BigDecimal(det.getMontoDescuento()).setScale(5, RoundingMode.HALF_UP));
            detalle.setCodigoDescuento(det.getCodigoDescuento());
            if (Double.compare(det.getMontoDescuento(), 0.0) != 0) {
                detalle.setNaturalezaDescuento("Descuento");
            }
            detalle.setSubTotal(new BigDecimal(det.getSubTotal()).setScale(5, RoundingMode.HALF_UP));
            detalle.setImpAsumidoEmisorFabrica(det.getImpuestoAsumidoEmisor().setScale(5, RoundingMode.HALF_UP));
            detalle.setBaseImponible(det.getBaseImponible().setScale(5, RoundingMode.HALF_UP));
            detalle.setImpuestoNeto(det.getMontoImpuestoNeto().setScale(5, RoundingMode.HALF_UP));
            if (det.getProductoServicioDto().getExento().equalsIgnoreCase("N")) {
                detalle.setCodigoImpuesto(det.getProductoServicioDto().getTipoImpuesto());
                detalle.setCodigoTarifa(det.getProductoServicioDto().getCodigoTarifa());
                detalle.setTarifaImpuesto(det.getProductoServicioDto().getTarifaImpuesto());
                detalle.setMontoImpuesto(new BigDecimal(det.getMontoImpuesto()).setScale(5, RoundingMode.HALF_UP));
                if (det.getTipoDocumentoExoneracion() != null) {
                    detalle.setTipoDocumentoExoneracion(det.getTipoDocumentoExoneracion());
                    detalle.setInstitucionExoneracion(det.getInstitucionExoneracion());
                    detalle.setNumeroDocumentoExoneracion(det.getNumeroDocumentoExoneracion());
                    detalle.setFechaDocExoneracion(det.getFechaDocExoneracion());
                    BigDecimal impuestoExo = new BigDecimal(this.getMontoExonerado(det.ivaDefecto, det.getPorcentajeCompraExoneracion(), det.getSubTotal())).setScale(5, RoundingMode.HALF_UP);
                    detalle.setMontoImpuestoExoneracion(impuestoExo);
                    det.setMontoImpuestoExoneracion(impuestoExo);
                    detalle.setPorcentajeCompraExoneracion(det.getPorcentajeCompraExoneracion());
                    detalle.setTarifaImpuesto(det.getProductoServicioDto().getTarifaImpuesto());
                    detalle.setImpuestoNeto(detalle.getImpuestoNeto().subtract(impuestoExo));
                    BigDecimal montoImpuesto = new BigDecimal(0);
                    montoImpuesto = detalle.getMontoImpuesto().add(detalle.getMontoImpuestoExoneracion().setScale(5, RoundingMode.HALF_UP));
                    detalle.setMontoImpuesto(montoImpuesto);
                }
            }
            detalle.setMontoTotalLinea(new BigDecimal(det.getMontoTotalLinea()).setScale(5, RoundingMode.HALF_UP));
            detalle.setEmpresa(new EmpresaDto(GlobalApp.idEmpresa));
            detalle.setProductoServicio(det.getProductoServicioDto());
            detalle.setCodigoCabys(det.getProductoServicioDto().getCodigoCabys());
            listaDetalleComprobante.add(detalle);
        }
        return listaDetalleComprobante;
    }

    private Double getMontoExonerado(Double ivaDefecto, Integer montoImpuestoActual, Double subTotal) {
        Double value = 0.0;
        Double montoImpuesto = new BigDecimal(subTotal * ivaDefecto).setScale(5, RoundingMode.HALF_UP).doubleValue();
        value = montoImpuesto - (double)montoImpuestoActual.intValue();
        return value;
    }

    private Double calcularIvaSinExonerar(Double ivaDefecto, Integer porcentaje) {
        Double value = 0.0;
        Double aux = ivaDefecto * (double)porcentaje.intValue() / 100.0;
        value = ivaDefecto - aux;
        return value;
    }

    private boolean getBooleanValue(String value) {
        return value.equalsIgnoreCase("S");
    }

    private Boolean isProductoServicioValidoIVA(ProductoServicioDto ps) {
        Boolean isValid;
        block6: {
            if (ps.getExento().equalsIgnoreCase("N")) {
                try {
                    TarifaImpuestoService tarifaImpuestoService = (TarifaImpuestoService)AppContext.getInstance().get("TarifaImpuestoService");
                    Respuesta respuesta = tarifaImpuestoService.getTarifasImpuesto();
                    List tarifasImpuesto = respuesta.getEstado() != false ? (List)respuesta.getResultado(ESTADO.OK.VALUE()) : null;
                    if (tarifasImpuesto != null && !tarifasImpuesto.isEmpty()) {
                        TarifaImpuestoDto tarifaImpuestoDto = tarifasImpuesto.stream().filter(e -> e.getCodigo().equalsIgnoreCase(ps.getCodigoTarifa())).findAny().orElse(null);
                        isValid = tarifaImpuestoDto != null ? (tarifaImpuestoDto.getTarifa().compareTo(ps.getTarifaImpuesto()) != 0 ? Boolean.valueOf(false) : Boolean.valueOf(true)) : Boolean.valueOf(false);
                        break block6;
                    }
                    isValid = false;
                }
                catch (Exception ex) {
                    this.funcionesGenerales.MostrarModalInfo("Error al validar el producto con I.V.A, revise el producto o servicio antes de factrar.");
                    isValid = false;
                }
            } else {
                isValid = true;
            }
        }
        if (!isValid.booleanValue()) {
            this.funcionesGenerales.MostrarModalInfo("El producto o servicio no esta configurado corectamente con el I.V.A, debe actualizarlo antes de continuar.");
        }
        return isValid;
    }
}

