/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.EditingCellPro;
import electricpos.controller.EditingCellStringPro;
import electricpos.controller.ExoneracionViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.PrincipalController;
import electricpos.controller.WaitingViewController;
import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.ComprobanteProformaDto;
import electricpos.model.CondicionVentaDto;
import electricpos.model.DetalleComProformaDto;
import electricpos.model.DetalleComprobanteTv;
import electricpos.model.EmisorDto;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.model.MedioPagoDto;
import electricpos.model.MonedaDto;
import electricpos.model.ProductoServicioDto;
import electricpos.model.ReceptorDto;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.EmisorService;
import electricpos.service.MonedaService;
import electricpos.service.ProductoServicioService;
import electricpos.service.ReceptorService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.CabysUtil;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Mensaje;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;

public class FacturacionProformaViewController
implements Initializable {
    ObservableList<CondicionVentaDto> condicionesVentaLista;
    ObservableList<MonedaDto> monedasLista;
    @FXML
    JFXButton btnEnviarFactura;
    @FXML
    ComboBox<MonedaDto> cbxMoneda;
    @FXML
    DatePicker dpFechaEmision;
    @FXML
    TextArea txtDocReferencia;
    @FXML
    ImageView imgEditarMedioPago;
    @FXML
    ImageView imgEditarEmisor;
    @FXML
    Label txtReceptor;
    @FXML
    Label txtMedioPago;
    @FXML
    Label lblTotalcom;
    @FXML
    Label lblImpuestos;
    @FXML
    Label lblDescuentos;
    @FXML
    Label lblSubTotal;
    @FXML
    TextField txtTipoCambio;
    @FXML
    TextField txtCodigoPS;
    @FXML
    TextField txtCantidad;
    @FXML
    TextField txtMinutos;
    ReceptorDto receptorFactura = new ReceptorDto();
    List<MedioPagoDto> mediosPago = new ArrayList<MedioPagoDto>();
    ObservableList<SucursalEmisorDto> sucursalLista;
    ProductoServicioDto productoServicioAgregar = new ProductoServicioDto();
    ObservableList<EmisorDto> emisoresLista;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    ComboBox<SucursalEmisorDto> cbxSucursal;
    DecimalFormat formatter = new DecimalFormat("#,##0.00");
    Integer idProforma = null;
    @FXML
    private TableView<DetalleComprobanteTv> tv_detalleComprobante;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcCodigo;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcDetalle;
    @FXML
    private TableColumn<DetalleComprobanteTv, String> tbcUnidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcCantidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcPrecioUnidad;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcTotal;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcDescuento;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcSubTotal;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcImpuesto;
    @FXML
    private TableColumn<DetalleComprobanteTv, Number> tbcTotalLinea;
    String tipoComprobanteGlobal = null;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionDetalle();
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        FuncionesGenerales funGenerales = new FuncionesGenerales();
        this.mediosPago = funGenerales.llenarMedioPagos();
        this.cargarMonedas();
        this.imgEditarMedioPago.setOnMouseClicked(event -> {
            this.mediosPago = funGenerales.MostrarModalMedioPago(this.mediosPago, new BigDecimal(BigInteger.ZERO));
            String medios = "";
            for (MedioPagoDto m : this.mediosPago) {
                if (!m.isActivo()) continue;
                medios = medios + " - " + m.getDescripcion();
            }
            this.txtMedioPago.setText(medios);
        });
        this.imgEditarEmisor.setOnMouseClicked(event -> {
            this.receptorFactura = funGenerales.ClienteViewController(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), this.receptorFactura, false);
            if (this.receptorFactura.getId() != null) {
                this.txtReceptor.setText(this.receptorFactura.getNombre());
            } else {
                this.txtReceptor.setText("Sin cliente");
            }
        });
        this.txtTipoCambio.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,4}([\\.]\\d{0,2})?")) {
                    FacturacionProformaViewController.this.txtTipoCambio.setText(oldValue);
                }
            }
        });
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaEmision.setValue((Object)localDate);
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    private void cargarMonedas() {
        MonedaService monedaService = (MonedaService)AppContext.getInstance().get("MonedaService");
        Respuesta respuesta = monedaService.getMonedas();
        if (respuesta.getEstado().booleanValue()) {
            this.monedasLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Moneda")));
            this.cbxMoneda.setItems(this.monedasLista);
            this.cbxMoneda.getSelectionModel().selectFirst();
        }
    }

    private Double getMontoImpuesto(Double precio, Double impuesto) {
        Double monto = precio * impuesto / 100.0;
        return monto;
    }

    @FXML
    public void onEnterTxtCodigoPS(ActionEvent ae) {
        this.productoServicioAgregar = this.getProductoServicio(this.txtCodigoPS.getText());
        if (this.productoServicioAgregar != null) {
            this.agregarProducto();
        }
    }

    @FXML
    private void onBtnAgregarProducto(ActionEvent event) {
        this.productoServicioAgregar = this.getProductoServicio(this.txtCodigoPS.getText());
        if (!this.txtCodigoPS.getText().isEmpty()) {
            this.agregarProducto();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de ingresar un c\u00f3digo.");
        }
    }

    private void agregarProducto() {
        Double cantidad = Double.valueOf(this.txtCantidad.getText());
        Double minutos = Double.valueOf(this.txtMinutos.getText());
        minutos = minutos / 60.0;
        cantidad = cantidad + minutos;
        Double precioUni = this.productoServicioAgregar.getPrecioSinImp().doubleValue();
        Double montoImpuesto = this.productoServicioAgregar.getMontoImpuesto().doubleValue() * cantidad;
        Double precioConImpuesto = precioUni * cantidad + montoImpuesto;
        DetalleComprobanteTv nuevo = new DetalleComprobanteTv(cantidad, this.productoServicioAgregar.getUnidadMedida(), this.productoServicioAgregar.getDescripcion(), precioUni, precioUni * cantidad, 0.0, precioUni * cantidad, montoImpuesto, precioConImpuesto, this.productoServicioAgregar.getCodigo(), this.productoServicioAgregar);
        nuevo.setTipo(this.productoServicioAgregar.getTipo());
        nuevo.setExento(this.productoServicioAgregar.getExento());
        this.tv_detalleComprobante.getItems().add((Object)nuevo);
        this.obtenerResumen();
    }

    @FXML
    private void onBtnEliminarLinea(ActionEvent event) {
        this.tv_detalleComprobante.getItems().remove(this.tv_detalleComprobante.getSelectionModel().getSelectedItem());
        this.obtenerResumen();
    }

    @FXML
    private void onBtnBuscarPS(ActionEvent event) {
        if (!this.txtCodigoPS.getText().isEmpty()) {
            this.productoServicioAgregar = this.getProductoServicio(this.txtCodigoPS.getText());
            if (this.productoServicioAgregar != null) {
                this.agregarProducto();
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de ingresar un c\u00f3digo.");
        }
    }

    @FXML
    private void onBtnFiltrar(ActionEvent event) {
        EmisorDto emisorDto = (EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem();
        this.productoServicioAgregar = this.funcionesGenerales.mostrarBusquedaPS(emisorDto.getId(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), emisorDto.getInventarioCompartido());
        if (this.productoServicioAgregar != null) {
            this.agregarProducto();
        }
    }

    @FXML
    private void onBtnExonerarLinea(ActionEvent event) {
        if (this.tv_detalleComprobante.getSelectionModel().getSelectedItem() != null) {
            if (((DetalleComprobanteTv)this.tv_detalleComprobante.getSelectionModel().getSelectedItem()).exento.equalsIgnoreCase("N")) {
                this.mostrarExoneracionLinea();
            } else {
                this.funcionesGenerales.MostrarModalInfo("El producto/servicio se encuentra exento de impuestos.");
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de seleccionar una l\u00ednea del detalle.");
        }
    }

    public void mostrarExoneracionLinea() {
        DetalleComprobanteTv detalleTv = (DetalleComprobanteTv)this.tv_detalleComprobante.getSelectionModel().getSelectedItem();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ExoneracionView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ExoneracionViewController exoneracionViewController = (ExoneracionViewController)fxmlLoader.getController();
        exoneracionViewController.cargarExoneracion(detalleTv.getTipoDocumentoExoneracion(), detalleTv.getNumeroDocumentoExoneracion(), detalleTv.getInstitucionExoneracion(), detalleTv.getFechaDocExoneracion(), detalleTv.getPorcentajeCompraExoneracion());
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
        if (exoneracionViewController.modifico) {
            detalleTv.setTipoDocumentoExoneracion(exoneracionViewController.tipoDocumentoExoneracion);
            detalleTv.setNumeroDocumentoExoneracion(exoneracionViewController.numeroDocumentoExoneracion);
            detalleTv.setInstitucionExoneracion(exoneracionViewController.institucionExoneracion);
            detalleTv.setFechaDocExoneracion(exoneracionViewController.fechaDocExoneracion);
            detalleTv.setPorcentajeCompraExoneracion(exoneracionViewController.porcentajeCompraExoneracion);
            detalleTv.setIva(this.calcularNuevoImpuesto(detalleTv.getIvaDefecto(), exoneracionViewController.porcentajeCompraExoneracion));
            this.refrescarDetalle(detalleTv);
            this.obtenerResumen();
        }
    }

    private Double calcularNuevoImpuesto(Double impuestoActual, Integer porcentaje) {
        Double impuestoNuevo = 0.0;
        Double aux = 0.0;
        try {
            aux = impuestoActual * (double)porcentaje.intValue() / 100.0;
            impuestoNuevo = impuestoActual - aux;
        }
        catch (Exception ex) {
            impuestoNuevo = 0.0;
        }
        return impuestoNuevo;
    }

    private void refrescarDetalle(DetalleComprobanteTv det) {
        Double subTotal = det.getSubTotal();
        Double iva = det.getIva();
        Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
        det.setMontoImpuesto(montoImpuesto);
        Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
        det.setMontoTotalLinea(totalLinea);
    }

    public boolean mostrarComprobanteHilo(ComprobanteElectronicoDto comp) {
        try {
            FuncionesGenerales.procesaVBoxNotificaciones();
            GlobalApp.vBoxNotificaciones.setVisible(true);
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/WaitingView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.vBoxNotificaciones.getChildren().add((Object)ancho);
            WaitingViewController waitingViewController = (WaitingViewController)fxmlLoader.getController();
            waitingViewController.setAnchorPane(ancho);
            waitingViewController.setTipo(comp.getTipoCom());
            waitingViewController.setComprobanteElectronicoDto(comp);
            waitingViewController.enviarComprobanteElectronico();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean mostrarComprobanteProformaHilo(ComprobanteProformaDto comp) {
        try {
            FuncionesGenerales.procesaVBoxNotificaciones();
            GlobalApp.vBoxNotificaciones.setVisible(true);
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/WaitingView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            GlobalApp.vBoxNotificaciones.getChildren().add((Object)ancho);
            WaitingViewController waitingViewController = (WaitingViewController)fxmlLoader.getController();
            waitingViewController.setAnchorPane(ancho);
            waitingViewController.setTipo(comp.getTipoCom());
            waitingViewController.setComprobanteProformaDto(comp);
            waitingViewController.enviarComprobanteProforma();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @FXML
    private void OnEnviarFactura(ActionEvent event) {
        if (!this.tv_detalleComprobante.getItems().isEmpty()) {
            ComprobanteProformaDto comprobante = new ComprobanteProformaDto();
            comprobante.setId(this.idProforma);
            comprobante.setFechaEmision(((LocalDate)this.dpFechaEmision.getValue()).atTime(LocalTime.now()));
            comprobante.setTipoCom(this.tipoComprobanteGlobal);
            comprobante.setCondicionVenta("01");
            comprobante.setPlazoCredito("0");
            try {
                if (this.receptorFactura.getId() == 0) {
                    ReceptorDto creado = new ReceptorDto();
                    this.receptorFactura.setId(null);
                    this.receptorFactura.setEmisor(new EmisorDto(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId()));
                    this.receptorFactura.setEmpresa(new EmpresaDto(GlobalApp.idEmpresa));
                    creado = this.guardarReceptorService(this.receptorFactura);
                    if (creado != null) {
                        comprobante.setReceptor(creado);
                        Object var4_5 = null;
                    }
                } else {
                    comprobante.setReceptor(this.receptorFactura);
                }
            }
            catch (Exception e) {
                comprobante.setReceptor(null);
            }
            EmpresaDto empresaDto = new EmpresaDto(GlobalApp.idEmpresa);
            comprobante.setEmpresa(empresaDto);
            EmisorDto emisorDto = new EmisorDto(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
            emisorDto.setEmpresa(empresaDto);
            comprobante.setEmisor(emisorDto);
            SucursalEmisorDto sucursalDto = new SucursalEmisorDto(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
            comprobante.setSucursal(sucursalDto);
            List<DetalleComProformaDto> listaDetalleComprobante = this.getDetalleComprobante();
            comprobante.setListaDetalleComprobantes(listaDetalleComprobante);
            comprobante.setTipoDocReferencia(null);
            comprobante.setNumeroDocReferencia(null);
            comprobante.setFechaEmisionReferencia(null);
            comprobante.setCodigoReferencia(null);
            comprobante.setRazonReferencia(null);
            int cont = 1;
            for (MedioPagoDto m : this.mediosPago) {
                if (!m.isActivo()) continue;
                if (cont == 1) {
                    comprobante.setMedioPago1(m.getCodigo());
                }
                if (cont == 2) {
                    comprobante.setMedioPago2(m.getCodigo());
                }
                if (cont == 3) {
                    comprobante.setMedioPago3(m.getCodigo());
                }
                if (cont == 4) {
                    comprobante.setMedioPago4(m.getCodigo());
                }
                ++cont;
            }
            comprobante.setCodigoMonedaResumen(((MonedaDto)this.cbxMoneda.getSelectionModel().getSelectedItem()).getCodigo());
            comprobante.setTipoCambioResumen(new BigDecimal(this.txtTipoCambio.getText()));
            this.setResumenComrpobante(comprobante);
            comprobante.setDocumentoReferencia(this.txtDocReferencia.getText());
            comprobante.setReversadoTotal("N");
            this.mostrarComprobanteProformaHilo(comprobante);
            try {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionProformaView.fxml"));
                AnchorPane ancho = (AnchorPane)fxmlLoader.load();
                FacturacionProformaViewController controller = (FacturacionProformaViewController)fxmlLoader.getController();
                controller.setTipoComprobanteGlobal(comprobante.getTipoCom());
                GlobalApp.panelPrincipalGlobal.getChildren().setAll((Object[])new Node[]{ancho});
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Debe de ingresar como m\u00ednimo un producto o servicio.");
        }
    }

    private ReceptorDto guardarReceptorService(ReceptorDto receptorDto) {
        Stage stage = (Stage)this.btnEnviarFactura.getScene().getWindow();
        ReceptorService service = (ReceptorService)AppContext.getInstance().get("ReceptorService");
        Respuesta respuesta = service.saveReceptor(receptorDto);
        if (respuesta.getEstado().booleanValue()) {
            receptorDto = (ReceptorDto)respuesta.getResultado("Receptor");
            return receptorDto;
        }
        Mensaje.getInstance().showModal(Alert.AlertType.ERROR, "Guardar Receptor", (Window)stage, respuesta.getMensaje());
        return null;
    }

    private void crearRelacionDetalle() {
        this.tv_detalleComprobante.setEditable(true);
        Callback<TableColumn<DetalleComprobanteTv, Number>, TableCell<DetalleComprobanteTv, Number>> cellFactory = new Callback<TableColumn<DetalleComprobanteTv, Number>, TableCell<DetalleComprobanteTv, Number>>(){

            public TableCell call(TableColumn p) {
                return new EditingCellPro();
            }
        };
        Callback<TableColumn<DetalleComprobanteTv, String>, TableCell<DetalleComprobanteTv, String>> cellFactoryString = new Callback<TableColumn<DetalleComprobanteTv, String>, TableCell<DetalleComprobanteTv, String>>(){

            public TableCell call(TableColumn p) {
                return new EditingCellStringPro();
            }
        };
        this.tbcCodigo.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).codigoProducto);
        this.tbcUnidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).unidadMedida);
        this.tbcDetalle.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).detalle);
        this.tbcDetalle.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tbcDetalle.setEditable(true);
        this.tbcCantidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).cantidad);
        this.tbcCantidad.setCellFactory((Callback)cellFactory);
        this.tbcCantidad.setEditable(true);
        this.tbcCantidad.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<DetalleComprobanteTv, Number>>(){

            public void handle(TableColumn.CellEditEvent<DetalleComprobanteTv, Number> t) {
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setCantidad(((Number)t.getNewValue()).doubleValue());
                Double cantidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getCantidad();
                Double precioUnidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getPrecioUnitario();
                Double total = new BigDecimal(cantidad * precioUnidad).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotal(total);
                Double descuento = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoDescuento();
                Double subTotal = new BigDecimal(total - descuento).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSubTotal(subTotal);
                Double iva = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getIva();
                Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoImpuesto(montoImpuesto);
                Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotalLinea(totalLinea);
                FacturacionProformaViewController.this.obtenerResumen();
            }
        });
        this.tbcPrecioUnidad.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).precioUnitario);
        this.tbcTotal.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoTotal);
        this.tbcDescuento.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoDescuento);
        this.tbcDescuento.setCellFactory((Callback)cellFactory);
        this.tbcDescuento.setEditable(true);
        this.tbcDescuento.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<DetalleComprobanteTv, Number>>(){

            public void handle(TableColumn.CellEditEvent<DetalleComprobanteTv, Number> t) {
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoDescuento(((Number)t.getNewValue()).doubleValue());
                Double cantidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getCantidad();
                Double total = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoTotal();
                Double descuento = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoDescuento();
                Double subTotal = new BigDecimal(total - descuento).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSubTotal(subTotal);
                Double iva = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getIva();
                Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoImpuesto(montoImpuesto);
                Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotalLinea(totalLinea);
                FacturacionProformaViewController.this.obtenerResumen();
            }
        });
        this.tbcSubTotal.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).subTotal);
        this.tbcImpuesto.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoImpuesto);
        this.tbcTotalLinea.setCellValueFactory(cd -> ((DetalleComprobanteTv)cd.getValue()).montoTotalLinea);
        this.tbcTotalLinea.setCellFactory((Callback)cellFactory);
        this.tbcTotalLinea.setEditable(true);
        this.tbcTotalLinea.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<DetalleComprobanteTv, Number>>(){

            public void handle(TableColumn.CellEditEvent<DetalleComprobanteTv, Number> t) {
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotalLinea(((Number)t.getNewValue()).doubleValue());
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setCantidad(1.0);
                if (((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getProductoServicioDto().getImpuestoIncluido().equalsIgnoreCase("S")) {
                    double tarifaImpuesto = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getProductoServicioDto().getTarifaImpuesto().doubleValue();
                    double variableImpuesto = tarifaImpuesto / 100.0 + 1.0;
                    double precioSinImpuesto = new BigDecimal(((Number)t.getNewValue()).doubleValue() / variableImpuesto).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                    ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPrecioUnitario(precioSinImpuesto);
                } else {
                    ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPrecioUnitario(((Number)t.getNewValue()).doubleValue());
                }
                Double cantidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getCantidad();
                Double precioUnidad = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getPrecioUnitario();
                Double total = new BigDecimal(cantidad * precioUnidad).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotal(total);
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoDescuento(0.0);
                Double descuento = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getMontoDescuento();
                Double subTotal = new BigDecimal(total - descuento).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSubTotal(subTotal);
                Double iva = ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).getIva();
                Double montoImpuesto = new BigDecimal(subTotal * iva).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoImpuesto(montoImpuesto);
                Double totalLinea = new BigDecimal(montoImpuesto + subTotal).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
                ((DetalleComprobanteTv)t.getTableView().getItems().get(t.getTablePosition().getRow())).setMontoTotalLinea(totalLinea);
                FacturacionProformaViewController.this.obtenerResumen();
            }
        });
    }

    public String getTipoComprobanteGlobal() {
        return this.tipoComprobanteGlobal;
    }

    public void setTipoComprobanteGlobal(String tipoComprobanteGlobal) {
        this.tipoComprobanteGlobal = tipoComprobanteGlobal;
    }

    private void obtenerResumen() {
        ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
        Double totalServiciosGravados = 0.0;
        Double totalServiciosExentos = 0.0;
        Double totalMercanciaGravados = 0.0;
        Double totalMercanciaExentos = 0.0;
        Double totalGravado = 0.0;
        Double totalExento = 0.0;
        Double totalVenta = 0.0;
        Double totalDescuentos = 0.0;
        Double totalVentaNeta = 0.0;
        Double totalImpuestos = 0.0;
        Double totalComprobante = 0.0;
        for (DetalleComprobanteTv detalle : listaDetalle) {
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalServiciosGravados = totalServiciosGravados + detalle.getMontoTotal();
            }
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalServiciosExentos = totalServiciosExentos + detalle.getMontoTotal();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalMercanciaGravados = totalMercanciaGravados + detalle.getMontoTotal();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalMercanciaExentos = totalMercanciaExentos + detalle.getMontoTotal();
            }
            totalDescuentos = new BigDecimal(totalDescuentos + detalle.getMontoDescuento()).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
            totalImpuestos = new BigDecimal(totalImpuestos + detalle.getMontoImpuesto()).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
        }
        totalGravado = totalServiciosGravados + totalMercanciaGravados;
        totalExento = totalServiciosExentos + totalMercanciaExentos;
        totalVenta = new BigDecimal(totalGravado + totalExento).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
        totalVentaNeta = new BigDecimal(totalVenta - totalDescuentos).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
        totalComprobante = new BigDecimal(totalVentaNeta + totalImpuestos).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
        this.lblSubTotal.setText(this.formatter.format(totalVenta));
        this.lblDescuentos.setText(this.formatter.format(totalDescuentos));
        this.lblImpuestos.setText(this.formatter.format(totalImpuestos));
        this.lblTotalcom.setText(this.formatter.format(totalComprobante));
    }

    private void setResumenComrpobante(ComprobanteProformaDto comp) {
        ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
        Double totalServiciosGravados = 0.0;
        Double totalServiciosExentos = 0.0;
        Double totalMercanciaGravados = 0.0;
        Double totalMercanciaExentos = 0.0;
        Double totalGravado = 0.0;
        Double totalExento = 0.0;
        Double totalVenta = 0.0;
        Double totalDescuentos = 0.0;
        Double totalVentaNeta = 0.0;
        Double totalImpuestos = 0.0;
        Double totalComprobante = 0.0;
        for (DetalleComprobanteTv detalle : listaDetalle) {
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalServiciosGravados = totalServiciosGravados + detalle.getMontoTotal();
            }
            if (CabysUtil.esServicio(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalServiciosExentos = totalServiciosExentos + detalle.getMontoTotal();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("N")) {
                totalMercanciaGravados = totalMercanciaGravados + detalle.getMontoTotal();
            }
            if (CabysUtil.esMercancia(detalle.getProductoServicioDto().getCodigoCabys()) && detalle.getExento().equalsIgnoreCase("S")) {
                totalMercanciaExentos = totalMercanciaExentos + detalle.getMontoTotal();
            }
            totalDescuentos = totalDescuentos + detalle.getMontoDescuento();
            totalImpuestos = totalImpuestos + detalle.getMontoImpuesto();
        }
        totalGravado = totalServiciosGravados + totalMercanciaGravados;
        totalExento = totalServiciosExentos + totalMercanciaExentos;
        totalVenta = totalGravado + totalExento;
        totalVentaNeta = totalVenta - totalDescuentos;
        totalComprobante = totalVentaNeta + totalImpuestos;
        comp.setTotalServGravadosResumen(new BigDecimal(totalServiciosGravados).setScale(5, RoundingMode.HALF_EVEN));
        comp.setTotalServExentosResumen(new BigDecimal(totalServiciosExentos).setScale(5, RoundingMode.HALF_EVEN));
        comp.setTotalMercanciasGravadasResumen(new BigDecimal(totalMercanciaGravados).setScale(5, RoundingMode.HALF_EVEN));
        comp.setTotalMercanciasExentasResumen(new BigDecimal(totalMercanciaExentos).setScale(5, RoundingMode.HALF_EVEN));
        comp.setTotalGravadoResumen(new BigDecimal(totalGravado).setScale(5, RoundingMode.HALF_EVEN));
        comp.setTotalExentoResumen(new BigDecimal(totalExento).setScale(5, RoundingMode.HALF_EVEN));
        comp.setTotalVentaResumen(new BigDecimal(totalVenta).setScale(5, RoundingMode.HALF_EVEN));
        comp.setTotalDescuentosResumen(new BigDecimal(totalDescuentos).setScale(5, RoundingMode.HALF_EVEN));
        comp.setTotalVentaNetaResumen(new BigDecimal(totalVentaNeta).setScale(5, RoundingMode.HALF_EVEN));
        comp.setMontoImpuestoResumen(new BigDecimal(totalImpuestos).setScale(5, RoundingMode.HALF_EVEN).setScale(5, RoundingMode.HALF_EVEN));
        comp.setTotalComprobanteResumen(new BigDecimal(totalComprobante).setScale(5, RoundingMode.HALF_EVEN));
    }

    private ProductoServicioDto getProductoServicio(String codigo) {
        EmisorDto emisorDto = (EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem();
        String invCompartido = emisorDto.getInventarioCompartido();
        ProductoServicioDto productoServicioDto = new ProductoServicioDto();
        ProductoServicioService service = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
        Respuesta respuesta = null;
        respuesta = invCompartido.equalsIgnoreCase("S") ? service.getProductoServicioCodigo(emisorDto.getId(), codigo) : service.getProductoServicioCodigoSucursal(emisorDto.getId(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), codigo);
        if (respuesta.getEstado().booleanValue()) {
            productoServicioDto = (ProductoServicioDto)respuesta.getResultado("ProductoServicio");
        } else {
            productoServicioDto = null;
            this.funcionesGenerales.MostrarModalInfo("No se encontr\u00f3 ning\u00fan producto o servicio con el c\u00f3digo digitado.");
        }
        return productoServicioDto;
    }

    public void cargarProforma(ComprobanteProformaDto proformaDto) {
        this.idProforma = proformaDto.getId();
        this.receptorFactura = proformaDto.getReceptor();
        this.txtDocReferencia.setText(proformaDto.getDocumentoReferencia());
        if (this.receptorFactura != null && this.receptorFactura.getId() != null) {
            this.txtReceptor.setText(this.receptorFactura.getNombre());
        } else {
            this.txtReceptor.setText("Sin cliente");
        }
        if (!proformaDto.getListaDetalleComprobantes().isEmpty()) {
            for (DetalleComProformaDto det : proformaDto.getListaDetalleComprobantes()) {
                Double montoImpuesto;
                Double cantidad = det.getCantidad().doubleValue();
                Double precioUni = det.getPrecioUnitario().doubleValue();
                try {
                    montoImpuesto = det.getMontoImpuesto().doubleValue();
                }
                catch (Exception e) {
                    montoImpuesto = 0.0;
                }
                DetalleComprobanteTv nuevo = new DetalleComprobanteTv(cantidad, det.getProductoServicio().getUnidadMedida(), det.getDetalle(), precioUni, det.getMontoTotal().doubleValue(), det.getMontoDescuento().doubleValue(), det.getSubTotal().doubleValue(), montoImpuesto, det.getMontoTotalLinea().doubleValue(), det.getProductoServicio().getCodigo(), det.getProductoServicio());
                nuevo.setTipo(det.getProductoServicio().getTipo());
                nuevo.setExento(det.getProductoServicio().getExento());
                this.tv_detalleComprobante.getItems().add((Object)nuevo);
                this.obtenerResumen();
            }
        }
    }

    private List<DetalleComProformaDto> getDetalleComprobante() {
        ArrayList<DetalleComProformaDto> listaDetalleComprobante = new ArrayList<DetalleComProformaDto>();
        ObservableList listaDetalle = this.tv_detalleComprobante.getItems();
        Integer linea = 0;
        for (DetalleComprobanteTv det : listaDetalle) {
            Integer n = linea;
            Integer n2 = linea = Integer.valueOf(linea + 1);
            DetalleComProformaDto detalle = new DetalleComProformaDto();
            detalle.setNumeroLinea(linea);
            detalle.setTipoCodigo(det.getProductoServicioDto().getTipoCodigo());
            detalle.setCodigo(det.getProductoServicioDto().getCodigo());
            detalle.setCantidad(new BigDecimal(det.getCantidad()).setScale(3, RoundingMode.HALF_EVEN));
            detalle.setUnidadMedida(det.getProductoServicioDto().getUnidadMedida());
            detalle.setUnidadMedidaComercial(null);
            detalle.setDetalle(det.getDetalle().get());
            detalle.setPrecioUnitario(new BigDecimal(det.getPrecioUnitario()).setScale(5, RoundingMode.HALF_EVEN));
            detalle.setMontoTotal(new BigDecimal(det.getMontoTotal()).setScale(5, RoundingMode.HALF_EVEN));
            detalle.setMontoDescuento(new BigDecimal(det.getMontoDescuento()).setScale(5, RoundingMode.HALF_EVEN));
            detalle.setSubTotal(new BigDecimal(det.getSubTotal()).setScale(5, RoundingMode.HALF_EVEN));
            if (det.getProductoServicioDto().getExento().equalsIgnoreCase("N")) {
                detalle.setCodigoImpuesto(det.getProductoServicioDto().getTipoImpuesto());
                detalle.setTarifaImpuesto(det.getProductoServicioDto().getTarifaImpuesto());
                detalle.setMontoImpuesto(new BigDecimal(det.getMontoImpuesto()).setScale(5, RoundingMode.HALF_EVEN));
                if (det.getTipoDocumentoExoneracion() != null) {
                    detalle.setTipoDocumentoExoneracion(det.getTipoDocumentoExoneracion());
                    detalle.setInstitucionExoneracion(det.getInstitucionExoneracion());
                    detalle.setNumeroDocumentoExoneracion(det.getNumeroDocumentoExoneracion());
                    detalle.setFechaDocExoneracion(det.getFechaDocExoneracion());
                    detalle.setMontoImpuestoExoneracion(new BigDecimal(this.getMontoExonerado(det.ivaDefecto, det.getMontoImpuesto(), det.getSubTotal())).setScale(5, RoundingMode.HALF_EVEN));
                    detalle.setPorcentajeCompraExoneracion(det.getPorcentajeCompraExoneracion());
                    detalle.setTarifaImpuesto(new BigDecimal(this.calcularIvaSinExonerar(det.getProductoServicioDto().getTarifaImpuesto().doubleValue(), det.getPorcentajeCompraExoneracion())).setScale(5, RoundingMode.HALF_EVEN));
                }
            }
            detalle.setMontoTotalLinea(new BigDecimal(det.getMontoTotalLinea()).setScale(5, RoundingMode.HALF_EVEN));
            detalle.setEmpresa(new EmpresaDto(GlobalApp.idEmpresa));
            detalle.setProductoServicio(det.getProductoServicioDto());
            listaDetalleComprobante.add(detalle);
        }
        return listaDetalleComprobante;
    }

    private Double getMontoExonerado(Double ivaDefecto, Double montoImpuestoActual, Double subTotal) {
        Double value = 0.0;
        Double montoImpuesto = new BigDecimal(subTotal * ivaDefecto).setScale(5, RoundingMode.HALF_EVEN).doubleValue();
        value = montoImpuesto - montoImpuestoActual;
        return value;
    }

    private Double calcularIvaSinExonerar(Double ivaDefecto, Integer porcentaje) {
        Double value = 0.0;
        Double aux = ivaDefecto * (double)porcentaje.intValue() / 100.0;
        value = ivaDefecto - aux;
        return value;
    }
}

