/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.ComprobanteResumenViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.ReenvioCorreoViewController;
import electricpos.controller.ResumenContableViewController;
import electricpos.controller.WaitingViewController;
import electricpos.model.ActividadDto;
import electricpos.model.ActividadEmisorDto;
import electricpos.model.ComprobanteElectronicoDto;
import electricpos.model.ComprobanteResumenDto;
import electricpos.model.EmisorDto;
import electricpos.model.FacturasTv;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.ActividadService;
import electricpos.service.ComprobanteService;
import electricpos.service.EmisorService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;

public class FacturasViewController
implements Initializable {
    ObservableList<FacturasTv> facturasTv;
    ObservableList<ComprobanteResumenDto> facturas;
    public ComprobanteResumenDto facturaSeleccionada = new ComprobanteResumenDto();
    @FXML
    private JFXButton btnNotaCredito;
    EmisorDto emisorSeleccionado = null;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<SucursalEmisorDto> sucursalLista;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    DatePicker dpFechaIni;
    @FXML
    DatePicker dpFechaFin;
    public String tipoComprobante;
    @FXML
    private TableView<FacturasTv> tv_facturas;
    @FXML
    private TableColumn<FacturasTv, String> tbcTipo;
    @FXML
    private TableColumn<FacturasTv, String> tbcCodigo;
    @FXML
    private TableColumn<FacturasTv, String> tbcFecha;
    @FXML
    private TableColumn<FacturasTv, String> tbcCliente;
    @FXML
    private TableColumn<FacturasTv, String> tbcEstado;
    @FXML
    private TableColumn<FacturasTv, Number> tbcTotal;
    @FXML
    private ComboBox<ActividadEmisorDto> cbxActividad;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    ObservableList<ActividadEmisorDto> actividadesLista;
    SucursalEmisorDto sucursalPrincipal = new SucursalEmisorDto();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (GlobalApp.empresa.getEsSimplificado().equalsIgnoreCase("S")) {
            this.btnNotaCredito.setText("GENERAR DEVOLUCI\u00d3N");
        }
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        this.cargarActividadesEmisor((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem());
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaIni.setValue((Object)localDate);
        this.dpFechaFin.setValue((Object)localDate);
    }

    private void cargarActividadesEmisor(EmisorDto emisor) {
        this.actividadesLista = FXCollections.observableArrayList();
        this.cbxActividad.getItems().clear();
        ActividadEmisorDto allFilter = new ActividadEmisorDto();
        allFilter.setCodigo("%");
        allFilter.setDescripcion("Todas las actividades");
        allFilter.setPrincipal("N");
        if (emisor.getActividadesEconomicas() != null && !emisor.getActividadesEconomicas().isEmpty()) {
            this.actividadesLista = FXCollections.observableArrayList(emisor.getActividadesEconomicas());
            this.actividadesLista.add(0, (Object)allFilter);
            this.cbxActividad.setItems(this.actividadesLista);
            this.cbxActividad.getSelectionModel().selectFirst();
        } else {
            ActividadService actividadService = (ActividadService)AppContext.getInstance().get("ActividadService");
            Respuesta respuesta = actividadService.getByActividad(this.sucursalPrincipal.getCodigoActividad());
            ActividadDto actividadDto = null;
            if (respuesta.getEstado().booleanValue()) {
                actividadDto = (ActividadDto)respuesta.getResultado(ESTADO.OK.VALUE());
                ActividadEmisorDto act = new ActividadEmisorDto();
                act.setCodigo(actividadDto.getCodigo());
                act.setDescripcion(actividadDto.getActividad());
                this.actividadesLista.add((Object)act);
                this.actividadesLista.add(0, (Object)allFilter);
                this.cbxActividad.setItems(this.actividadesLista);
                this.cbxActividad.getSelectionModel().selectFirst();
            }
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    @FXML
    private void onBtnVerFactura(ActionEvent event) {
        if (this.tv_facturas.getSelectionModel().getSelectedItem() != null) {
            this.mostrarVerFactura(((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getClave(), ((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getId());
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar un comprobante.");
        }
    }

    @FXML
    private void onBtnGenerarResumen(ActionEvent event) {
        if (!this.facturas.isEmpty()) {
            this.mostrarResumenContable(this.facturas);
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "No existen comprobantes para el rango de fechas indicado.");
        }
    }

    @FXML
    private void onBtnGeneraNotaDebito(ActionEvent event) {
        String obs = null;
        if (this.tv_facturas.getSelectionModel().getSelectedItem() != null) {
            if (!((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getTipoCom().equalsIgnoreCase("02")) {
                obs = this.funcionesGenerales.getConfirmacionMensajeInputView("\u00bfEsta seguro de crear una nota de d\u00e9bito para el movimiento?");
                if (obs != null) {
                    ComprobanteResumenDto comp = ((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura();
                    this.generarNota(comp.getClave(), comp.getId(), "02", obs);
                }
            } else {
                NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "No se puede generar una nota de d\u00e9bito a otra nota de d\u00e9bito.");
            }
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar un comprobante.");
        }
    }

    @FXML
    private void onBtnGeneraNotaCredito(ActionEvent event) {
        String obs = null;
        if (this.tv_facturas.getSelectionModel().getSelectedItem() != null) {
            if (!((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getTipoCom().equalsIgnoreCase("02")) {
                obs = this.funcionesGenerales.getConfirmacionMensajeInputView("\u00bfEsta seguro de crear una nota de cr\u00e9dito para la factura?");
                if (obs != null) {
                    ComprobanteResumenDto comp = ((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura();
                    this.generarNota(comp.getClave(), comp.getId(), "03", obs);
                }
            } else {
                NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "No se puede generar una nota de cr\u00e9dito a otra nota de cr\u00e9dito.");
            }
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar un comprobante.");
        }
    }

    @FXML
    private void onBtnReenviarFactura(ActionEvent event) {
        String obs = null;
        if (this.tv_facturas.getSelectionModel().getSelectedItem() != null) {
            if (((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getTipoCom().equalsIgnoreCase("01") || ((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getTipoCom().equalsIgnoreCase("04")) {
                obs = this.funcionesGenerales.getConfirmacionMensajeInputView("\u00bfEsta seguro de reenviar la factura?");
                if (obs != null) {
                    ComprobanteResumenDto comp = ((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura();
                    this.generarReenvioFactura(comp.getClave(), obs);
                }
            } else {
                NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe seleccionar una factura o tiquete para reenviar.");
            }
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar un comprobante.");
        }
    }

    @FXML
    private void onBtnReenviarCorreo(ActionEvent event) {
        if (this.tv_facturas.getSelectionModel().getSelectedItem() != null) {
            this.mostrarReenvioCorreo(((FacturasTv)this.tv_facturas.getSelectionModel().getSelectedItem()).getFactura().getId());
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar un comprobante.");
        }
    }

    public void mostrarReenvioCorreo(Integer idComp) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReenvioCorreoView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ReenvioCorreoViewController controller = (ReenvioCorreoViewController)fxmlLoader.getController();
        controller.setFuncion(ESTADO.COMPROBANTE.VALUE());
        controller.setIdComprobante(idComp);
        FuncionesGenerales.showView(root1);
    }

    public void mostrarVerFactura(String clave, int id) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ComprobanteResumenView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ComprobanteResumenViewController controller = (ComprobanteResumenViewController)fxmlLoader.getController();
        controller.setClaveComprobante(clave, id);
        FuncionesGenerales.showView(root1);
    }

    public void mostrarResumenContable(ObservableList<ComprobanteResumenDto> facturas) {
        Double totalFacturas = facturas.stream().filter(f -> f.getTipoCom().equals("01") || f.getTipoCom().equals("04")).mapToDouble(f -> f.getTotalComprobanteResumen().doubleValue()).sum();
        Double totalDebito = facturas.stream().filter(f -> f.getTipoCom().equals("02")).mapToDouble(f -> f.getTotalComprobanteResumen().doubleValue()).sum();
        Double totalCredito = facturas.stream().filter(f -> f.getTipoCom().equals("03")).mapToDouble(f -> f.getTotalComprobanteResumen().doubleValue()).sum();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ResumenContableView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ResumenContableViewController controller = (ResumenContableViewController)fxmlLoader.getController();
        controller.setTotalFacturas(totalFacturas);
        controller.setTotalCredito(totalCredito);
        controller.setTotalDebito(totalDebito);
        controller.setActividad(((ActividadEmisorDto)this.cbxActividad.getSelectionModel().getSelectedItem()).getCodigo());
        controller.setFechaIni((LocalDate)this.dpFechaIni.getValue());
        controller.setFechaFin((LocalDate)this.dpFechaFin.getValue());
        controller.setIdEmisor(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        controller.setIdSucursal(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        controller.setDatosResumen();
        FuncionesGenerales.showView(root1);
    }

    @FXML
    private void onBtnBuscar(ActionEvent event) {
        this.getFacturas(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), this.tipoComprobante);
    }

    @FXML
    private void onCbxEmisorChanged(ActionEvent event) {
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
    }

    private void crearRelacionTv() {
        this.tbcTipo.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).tipo);
        this.tbcCodigo.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).codigo);
        this.tbcFecha.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).fecha);
        this.tbcCliente.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).cliente);
        this.tbcEstado.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).estado);
        this.tbcTotal.setCellValueFactory(cd -> ((FacturasTv)cd.getValue()).montoTotal);
    }

    private void getFacturas(Integer idSucursal, String tipo) {
        this.tv_facturas.getItems().clear();
        ComprobanteService comprobanteService = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
        Respuesta respuesta = comprobanteService.getComprobanteFiltro(idSucursal, ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), tipo, ((ActividadEmisorDto)this.cbxActividad.getSelectionModel().getSelectedItem()).getCodigo());
        if (respuesta.getEstado().booleanValue()) {
            this.facturas = null;
            this.facturas = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_facturas.getItems().clear();
            this.tv_facturas.setItems(this.converterTv(this.facturas));
        } else {
            this.facturas = null;
        }
    }

    private ObservableList<FacturasTv> converterTv(ObservableList<ComprobanteResumenDto> facturas) {
        ObservableList facturasTv = FXCollections.observableArrayList();
        for (ComprobanteResumenDto compDto : facturas) {
            FacturasTv compTv = new FacturasTv(compDto);
            facturasTv.add((Object)compTv);
        }
        return facturasTv;
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    public void setTipoComprobante(String tipoComprobante) {
        this.tipoComprobante = tipoComprobante;
    }

    private void generarNota(String clave, int comId, String tipo, String obs) {
        ComprobanteElectronicoDto comprobanteReversar = GlobalApp.empresa.getEsSimplificado().equalsIgnoreCase("S") ? this.getComprobanteId(comId) : this.getComprobanteClave(clave);
        if (comprobanteReversar != null) {
            String tipoDocRef = comprobanteReversar.getTipoCom();
            ComprobanteElectronicoDto comprobanteNuevo = new ComprobanteElectronicoDto();
            comprobanteNuevo = comprobanteReversar;
            comprobanteNuevo.setVersion(GlobalApp.parametrosSistema.getVersionDoc());
            comprobanteNuevo.setId(null);
            LocalDateTime date = LocalDateTime.now();
            comprobanteNuevo.setFechaEmision(date);
            comprobanteNuevo.setTipoCom(tipo);
            comprobanteNuevo.setTipoDocReferencia(tipoDocRef);
            if (GlobalApp.empresa.getEsSimplificado().equalsIgnoreCase("S")) {
                comprobanteNuevo.setNumeroDocReferencia(String.valueOf(comId));
            } else {
                comprobanteNuevo.setNumeroDocReferencia(comprobanteReversar.getClave());
            }
            comprobanteNuevo.setFechaEmisionReferencia(comprobanteReversar.getFechaEmision());
            comprobanteNuevo.setCodigoReferencia("01");
            comprobanteNuevo.setRazonReferencia(obs);
            comprobanteNuevo.setReversadoTotal("N");
            this.mostrarComprobanteHilo(comprobanteNuevo);
        }
    }

    private void generarNotaSimplificada(String clave, int idComp, String tipo, String obs) {
        ComprobanteElectronicoDto comprobanteReversar = GlobalApp.empresa.getEsSimplificado().equalsIgnoreCase("S") ? this.getComprobanteId(idComp) : this.getComprobanteClave(clave);
        if (comprobanteReversar != null) {
            String tipoDocRef = comprobanteReversar.getTipoCom();
            ComprobanteElectronicoDto comprobanteNuevo = new ComprobanteElectronicoDto();
            comprobanteNuevo = comprobanteReversar;
            comprobanteNuevo.setVersion(GlobalApp.parametrosSistema.getVersionDoc());
            comprobanteNuevo.setId(null);
            LocalDateTime date = LocalDateTime.now();
            comprobanteNuevo.setFechaEmision(date);
            comprobanteNuevo.setTipoCom(tipo);
            comprobanteNuevo.setTipoDocReferencia(tipoDocRef);
            comprobanteNuevo.setNumeroDocReferencia(comprobanteReversar.getClave());
            comprobanteNuevo.setFechaEmisionReferencia(comprobanteReversar.getFechaEmision());
            comprobanteNuevo.setCodigoReferencia("01");
            comprobanteNuevo.setRazonReferencia(obs);
            comprobanteNuevo.setReversadoTotal("N");
            this.mostrarComprobanteHilo(comprobanteNuevo);
        }
    }

    private void generarReenvioFactura(String clave, String obs) {
        ComprobanteElectronicoDto comprobanteReversar = this.getComprobanteClave(clave);
        if (comprobanteReversar != null) {
            String tipoDocRef = comprobanteReversar.getTipoCom();
            ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
            ComprobanteElectronicoDto comprobanteNuevo = new ComprobanteElectronicoDto();
            comprobanteNuevo = comprobanteReversar;
            comprobanteNuevo.setId(null);
            LocalDateTime date = LocalDateTime.now();
            comprobanteNuevo.setFechaEmision(date);
            comprobanteNuevo.setTipoDocReferencia(tipoDocRef);
            comprobanteNuevo.setNumeroDocReferencia(comprobanteReversar.getClave());
            comprobanteNuevo.setFechaEmisionReferencia(comprobanteReversar.getFechaEmision());
            comprobanteNuevo.setCodigoReferencia("04");
            comprobanteNuevo.setRazonReferencia(obs);
            comprobanteNuevo.setReversadoTotal("N");
            this.mostrarComprobanteHilo(comprobanteNuevo);
        }
    }

    private ComprobanteElectronicoDto getComprobanteClave(String clave) {
        ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
        Respuesta respuesta = service.getComprobanteClave(clave);
        ComprobanteElectronicoDto comprobanteDto = null;
        if (respuesta.getEstado().booleanValue()) {
            comprobanteDto = (ComprobanteElectronicoDto)respuesta.getResultado("ComprobanteElectronico");
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al obtener los datos del comprobante.");
        }
        return comprobanteDto;
    }

    private ComprobanteElectronicoDto getComprobanteId(int id) {
        ComprobanteService service = (ComprobanteService)AppContext.getInstance().get("ComprobanteService");
        Respuesta respuesta = service.getComprobanteById(id);
        ComprobanteElectronicoDto comprobanteDto = null;
        if (respuesta.getEstado().booleanValue()) {
            comprobanteDto = (ComprobanteElectronicoDto)respuesta.getResultado("ComprobanteElectronico");
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al obtener los datos del comprobante.");
        }
        return comprobanteDto;
    }

    public boolean mostrarComprobanteHilo(ComprobanteElectronicoDto comp) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/WaitingView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FuncionesGenerales.procesaVBoxNotificaciones();
            GlobalApp.vBoxNotificaciones.setVisible(true);
            GlobalApp.vBoxNotificaciones.getChildren().add((Object)ancho);
            WaitingViewController waitingViewController = (WaitingViewController)fxmlLoader.getController();
            waitingViewController.setAnchorPane(ancho);
            waitingViewController.setTipo(comp.getTipoCom());
            waitingViewController.setComprobanteElectronicoDto(comp);
            if (GlobalApp.empresa.getEsSimplificado().equalsIgnoreCase("S")) {
                waitingViewController.enviarFacturaSimplificada();
            } else {
                waitingViewController.enviarComprobanteElectronico();
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

