/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.ParametrosGeneController;
import electricpos.controller.ResumenGastosViewController;
import electricpos.model.ComprobanteRecepcionResumenDto;
import electricpos.model.EmisorDto;
import electricpos.model.GastosTv;
import electricpos.model.GlobalApp;
import electricpos.service.ComprobanteRecepcionService;
import electricpos.service.EmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class GastosViewController
implements Initializable {
    @FXML
    private ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private DatePicker dpFechaIni;
    @FXML
    private DatePicker dpFechaFin;
    @FXML
    private TableView<GastosTv> tv_facturas;
    @FXML
    private TableColumn<GastosTv, String> tbcClave;
    @FXML
    private TableColumn<GastosTv, String> tbcTipo;
    @FXML
    private TableColumn<GastosTv, String> tbcEmisor;
    @FXML
    private TableColumn<GastosTv, String> tbcFechaFactura;
    @FXML
    private TableColumn<GastosTv, String> tbcFechaRecepcion;
    @FXML
    private TableColumn<GastosTv, Number> tbcImpuestos;
    @FXML
    private TableColumn<GastosTv, Number> tbcMontoTotal;
    EmisorDto emisorSeleccionado = null;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<ComprobanteRecepcionResumenDto> comprobantes;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaIni.setValue((Object)localDate);
        this.dpFechaFin.setValue((Object)localDate);
    }

    @FXML
    private void onBtnGenerarResumen(ActionEvent event) {
        if (!this.comprobantes.isEmpty()) {
            this.mostrarResumenContable(this.comprobantes);
        } else {
            this.funcionesGenerales.MostrarModalInfo("No existen comprobantes en para el rango de fechas indicado.");
        }
    }

    @FXML
    private void onBtnBuscar(ActionEvent event) {
        this.getComprobantes(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
    }

    private void crearRelacionTv() {
        this.tbcClave.setCellValueFactory(cd -> ((GastosTv)cd.getValue()).consecutivo);
        this.tbcEmisor.setCellValueFactory(cd -> ((GastosTv)cd.getValue()).emisor);
        this.tbcFechaFactura.setCellValueFactory(cd -> ((GastosTv)cd.getValue()).fechaFactura);
        this.tbcFechaRecepcion.setCellValueFactory(cd -> ((GastosTv)cd.getValue()).fechaRecepcion);
        this.tbcImpuestos.setCellValueFactory(cd -> ((GastosTv)cd.getValue()).montoImpuestos);
        this.tbcMontoTotal.setCellValueFactory(cd -> ((GastosTv)cd.getValue()).montoTotal);
        this.tbcTipo.setCellValueFactory(cd -> ((GastosTv)cd.getValue()).tipo);
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void getComprobantes(Integer idEmisor) {
        ComprobanteRecepcionService comprobanteService = (ComprobanteRecepcionService)AppContext.getInstance().get("ComprobanteRecepcionService");
        Respuesta respuesta = comprobanteService.getGastosEmisor(idEmisor, ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString());
        if (respuesta.getEstado().booleanValue()) {
            this.comprobantes = null;
            this.comprobantes = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_facturas.getItems().clear();
            this.tv_facturas.setItems(this.converterTv(this.comprobantes));
        } else {
            this.comprobantes = null;
        }
    }

    private ObservableList<GastosTv> converterTv(ObservableList<ComprobanteRecepcionResumenDto> facturas) {
        ObservableList facturasTv = FXCollections.observableArrayList();
        for (ComprobanteRecepcionResumenDto compDto : facturas) {
            GastosTv compTv = new GastosTv(compDto);
            facturasTv.add((Object)compTv);
        }
        return facturasTv;
    }

    public void mostrarResumenContable(ObservableList<ComprobanteRecepcionResumenDto> comprobantes) {
        Double totalGastos = comprobantes.stream().mapToDouble(f -> f.getTotalComprobante().doubleValue()).sum();
        Double totalIva = comprobantes.stream().mapToDouble(f -> f.getTotalImpuesto().doubleValue()).sum();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ResumenGastosView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ResumenGastosViewController controller = (ResumenGastosViewController)fxmlLoader.getController();
        controller.setTotalGastos(totalGastos);
        controller.setTotalImpuesto(totalIva);
        controller.setFechaIni((LocalDate)this.dpFechaIni.getValue());
        controller.setFechaFin((LocalDate)this.dpFechaFin.getValue());
        controller.setIdEmisor(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        controller.setDatosResumen();
        FuncionesGenerales.showView(root1);
    }
}

