/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import electricpos.controller.UpdateLogViewController;
import electricpos.model.CajaDto;
import electricpos.model.GlobalApp;
import electricpos.model.LocalMetaData;
import electricpos.model.ParametrosGeneralesDto;
import electricpos.model.UsuarioDto;
import electricpos.service.ParametroService;
import electricpos.service.SecurityService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.LocalStorageService;
import electricpos.util.Respuesta;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class LoginController
implements Initializable {
    @FXML
    private TextField txtUsuario;
    @FXML
    private JFXCheckBox checkRecordar;
    @FXML
    private PasswordField txtContrasena;
    @FXML
    private JFXButton btnIniciar;
    @FXML
    private AnchorPane paneBtnVersion;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    @FXML
    private void iniciar() {
        this.login();
    }

    public void initialize(URL url, ResourceBundle rb) {
        LocalMetaData localMetaData = LocalStorageService.getLocalMetaData();
        this.txtUsuario.setText(localMetaData.getKey());
        this.txtContrasena.setText(localMetaData.getBlocker());
        this.checkRecordar.setSelected(localMetaData.getChecked().booleanValue());
        this.txtContrasena.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.login();
            }
        });
        this.txtUsuario.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.txtContrasena.requestFocus();
            }
        });
        this.paneBtnVersion.setOnMouseClicked(event -> this.showUpdateLogView());
        this.verificarActualizacion();
    }

    private void login() {
        Stage stage = (Stage)this.btnIniciar.getScene().getWindow();
        stage.getIcons().add((Object)new Image("/electricpos/resources/space.jpg"));
        SecurityService securityService = (SecurityService)AppContext.getInstance().get("SecurityService");
        Respuesta respuesta = securityService.ingresar(this.txtUsuario.getText(), this.txtContrasena.getText());
        if (respuesta.getEstado().booleanValue()) {
            UsuarioDto usuarioDto = (UsuarioDto)respuesta.getResultado("UsuarioDto");
            if (usuarioDto.getEmpresa().getEstado().equalsIgnoreCase("P")) {
                this.funcionesGenerales.MostrarModalInfo("El cuenta ha sido inactivada por el sistema: [Pendiente de pago].");
            } else if (usuarioDto.getEmpresa().getEstado().equalsIgnoreCase("I")) {
                this.funcionesGenerales.MostrarModalInfo("La cuenta se encuentra inactiva: [Consulte al proveedor].");
            } else if (usuarioDto.getEstado().equalsIgnoreCase("I")) {
                this.funcionesGenerales.MostrarModalInfo("El usuario se encuentra inactivo: [Consulte a su administrador].");
            } else if (usuarioDto.getEmpresa().getEstado().equalsIgnoreCase("A")) {
                this.cargarParametrosGenerales();
                GlobalApp.idUsuario = usuarioDto.getId();
                GlobalApp.usuarioLogueado = usuarioDto;
                GlobalApp.usuarioAdmin = usuarioDto.getRolDescripcion().equalsIgnoreCase("A");
                GlobalApp.idEmpresa = usuarioDto.getEmpresa().getId();
                GlobalApp.empresa = usuarioDto.getEmpresa();
                if (usuarioDto.getEmisor() != null) {
                    GlobalApp.fechaExpiracionCert = usuarioDto.getEmisor().getFechaExpiracionCert();
                }
                try {
                    GlobalApp.idEmisor = usuarioDto.getEmisor().getId();
                }
                catch (Exception ex) {
                    GlobalApp.idEmisor = null;
                }
                try {
                    GlobalApp.idSucursal = usuarioDto.getSucursal().getId();
                    this.funcionesGenerales.getUltimaCaja();
                }
                catch (Exception ex) {
                    GlobalApp.idSucursal = null;
                    GlobalApp.cajaActual = new CajaDto();
                }
                try {
                    LocalMetaData data = new LocalMetaData();
                    data.setChecked(this.checkRecordar.isSelected());
                    if (this.checkRecordar.isSelected()) {
                        data.setKey(this.txtUsuario.getText());
                        data.setBlocker(this.txtContrasena.getText());
                    } else {
                        data.setKey("");
                        data.setBlocker("");
                    }
                    LocalStorageService.updateLocalMetaData(data);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.abrirView("PrincipalView");
                this.btnIniciar.getScene().getWindow().hide();
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo(respuesta.getMensaje());
        }
    }

    private void abrirView(String viewName) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/" + viewName + ".fxml"));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.setScene(new Scene(root1));
            stage.getIcons().add((Object)new Image("/electricpos/resources/space.jpg"));
            stage.setTitle("Facturaci\u00f3n electr\u00f3nica");
            stage.setMaximized(true);
            stage.show();
        }
        catch (IOException e) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Failed to create new Window.", e);
        }
    }

    private void verificarActualizacion() {
        try {
            ParametroService parametroService = (ParametroService)AppContext.getInstance().get("ParametroService");
            Respuesta respuesta2 = parametroService.getParametrosApp("EFE", "stag");
            if (respuesta2.getEstado().booleanValue()) {
                File file;
                ParametrosGeneralesDto parametrosGeneralesDto;
                GlobalApp.parametrosSistema = parametrosGeneralesDto = (ParametrosGeneralesDto)respuesta2.getResultado("ParametrosGenerales");
                Double bdVersion = Double.valueOf(parametrosGeneralesDto.getVersionApp());
                if (GlobalApp.appVersion < bdVersion && Files.exists(Paths.get((file = Files.exists(Paths.get("updaterv3.jar", new String[0]), new LinkOption[0]) ? new File("updaterv3.jar") : (Files.exists(Paths.get("updaterv2.jar", new String[0]), new LinkOption[0]) ? new File("updaterv2.jar") : new File("updater.jar"))).getAbsolutePath(), new String[0]), new LinkOption[0])) {
                    this.funcionesGenerales.MostrarModalActualizacion(file);
                }
            } else {
                GlobalApp.parametrosSistema = null;
                this.funcionesGenerales.MostrarModalInfo("Error al verificar versi\u00f3n de la aplicaci\u00f3n, verifique su conexi\u00f3n a interntet, o contacte al proveedor.");
            }
        }
        catch (Exception ex) {
            GlobalApp.parametrosSistema = null;
        }
    }

    private void cargarParametrosGenerales() {
        if (GlobalApp.parametrosSistema == null) {
            ParametroService parametroService = (ParametroService)AppContext.getInstance().get("ParametroService");
            Respuesta respuesta2 = parametroService.getParametrosApp("EFE", "stag");
            if (respuesta2.getEstado().booleanValue()) {
                ParametrosGeneralesDto parametrosGeneralesDto;
                GlobalApp.parametrosSistema = parametrosGeneralesDto = (ParametrosGeneralesDto)respuesta2.getResultado("ParametrosGenerales");
            } else {
                GlobalApp.parametrosSistema = null;
                this.funcionesGenerales.MostrarModalInfo("Error al obtener los p\u00e1rametros de la aplicaci\u00f3n, verifique su conexi\u00f3n a interntet, o contacte al proveedor.");
            }
        }
    }

    public void showUpdateLogView() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/UpdateLogView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        UpdateLogViewController controller = (UpdateLogViewController)fxmlLoader.getController();
        Stage stage = new Stage();
        Scene scene = new Scene(root1);
        scene.setFill((Paint)Color.TRANSPARENT);
        stage.setScene(scene);
        stage.initStyle(StageStyle.UNDECORATED);
        stage.setMaximized(true);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
    }
}

