/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.ColaboradorDto;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.service.ColaboradoresService;
import electricpos.util.AppContext;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class MantColaboradorViewController
implements Initializable {
    @FXML
    private TextField txtPorcentaje;
    @FXML
    private TextField txtNombre;
    @FXML
    private TextField txtRol;
    @FXML
    private ComboBox<String> cbxEstado;
    private ColaboradorDto colaboradorDto = new ColaboradorDto();

    public void initialize(URL url, ResourceBundle rb) {
        List<String> estados = Arrays.asList("Activo", "Inactivo");
        ObservableList listaEstados = FXCollections.observableArrayList(estados);
        this.cbxEstado.setItems(listaEstados);
        this.cbxEstado.getSelectionModel().selectFirst();
    }

    @FXML
    private void onBtnGuardar() {
        this.guardarColaborador();
        Stage stage = (Stage)this.txtNombre.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnCancelar() {
        Stage stage = (Stage)this.txtNombre.getScene().getWindow();
        stage.hide();
    }

    public void setColaboradorDto(ColaboradorDto colaboradorDto) {
        this.colaboradorDto = colaboradorDto;
        this.txtNombre.setText(colaboradorDto.getNombre());
        this.txtPorcentaje.setText(colaboradorDto.getPorcentaje().toPlainString());
        this.txtRol.setText(colaboradorDto.getRol());
        if (colaboradorDto.getEstado().equalsIgnoreCase("A")) {
            this.cbxEstado.getSelectionModel().selectFirst();
        } else {
            this.cbxEstado.getSelectionModel().selectLast();
        }
    }

    private void guardarColaborador() {
        this.colaboradorDto.setEmpresa(new EmpresaDto(GlobalApp.idEmpresa));
        this.colaboradorDto.setEstado("A");
        this.colaboradorDto.setNombre(this.txtNombre.getText());
        this.colaboradorDto.setRol(this.txtRol.getText());
        this.colaboradorDto.setPorcentaje(new BigDecimal(this.txtPorcentaje.getText()));
        this.colaboradorDto.setEstado(((String)this.cbxEstado.getSelectionModel().getSelectedItem()).equalsIgnoreCase("activo") ? "A" : "I");
        ColaboradoresService service = (ColaboradoresService)AppContext.getInstance().get("ColaboradoresService");
        Respuesta respuesta = service.save(this.colaboradorDto);
        if (respuesta.getEstado().booleanValue()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "El colaborador se guard\u00f3 satisfactoriamente.");
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un problema al guardar el colaborador.");
        }
    }
}

