/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import electricpos.model.CantonDto;
import electricpos.model.EmisorDto;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.model.IdentificacionDto;
import electricpos.model.ProvinciaDto;
import electricpos.model.VBarrioDto;
import electricpos.model.VDistritoDto;
import electricpos.service.BarrioService;
import electricpos.service.CantonService;
import electricpos.service.DistritoService;
import electricpos.service.EmisorService;
import electricpos.service.ParametroService;
import electricpos.service.ProvinciaService;
import electricpos.service.TipoIdentificacionService;
import electricpos.util.AppContext;
import electricpos.util.Formato;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Request;
import electricpos.util.Respuesta;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class MantEmisorViewController
implements Initializable {
    @FXML
    JFXButton btnGuardar;
    @FXML
    JFXButton btnCancelar;
    @FXML
    Label lblRespuesta;
    @FXML
    private TextField txtIdentificacion;
    @FXML
    private TextField txtNombre;
    @FXML
    private TextField txtTelefono;
    @FXML
    private TextField txtFax;
    @FXML
    private TextField txtUsuarioHacienda;
    @FXML
    private TextField txtTerminalDefecto;
    @FXML
    private TextField txtPaisDefecto;
    @FXML
    private TextField txtCertificado;
    @FXML
    private TextField txtPaisFax;
    @FXML
    private TextField txtPaisTelefono;
    @FXML
    private TextField txtNombreComercial;
    @FXML
    private TextField txtOtrasSenas;
    @FXML
    private TextField txtCorreo;
    @FXML
    private TextField txtRegistroFiscal8707;
    @FXML
    private PasswordField txtContrasenaHacienda;
    @FXML
    private PasswordField txtPinCertificado;
    @FXML
    ComboBox<IdentificacionDto> cbxTipoIdentificacion;
    @FXML
    JFXCheckBox actBarrio;
    @FXML
    ComboBox<ProvinciaDto> cbxProvincias;
    @FXML
    ComboBox<VDistritoDto> cbxDistritos;
    @FXML
    ComboBox<VBarrioDto> cbxBarrios;
    @FXML
    ComboBox<CantonDto> cbxCantones;
    @FXML
    private JFXCheckBox checkActivo;
    public EmisorDto emisorSeleccionado = new EmisorDto();
    ObservableList<IdentificacionDto> tipoIdentificacionesLista;
    ObservableList<ProvinciaDto> provinciasLista;
    ObservableList<CantonDto> cantonesLista;
    ObservableList<VDistritoDto> distritosLista;
    ObservableList<VBarrioDto> barrioLista;
    File certificadoSeleccionado = null;
    public boolean nuevoEmisor = false;
    public boolean cambioFile = false;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    List<TextField> camposVacios;
    List<PasswordField> contrase\u00f1asVacios;

    public void initialize(URL url, ResourceBundle rb) {
        this.llenarList();
        this.getTipoIdentificaciones();
        this.getProvincias();
        this.getCantones(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId(), false);
        this.getDistrito(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), false);
        this.getBarrio(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), ((VDistritoDto)this.cbxDistritos.getSelectionModel().getSelectedItem()).getCodigo());
        this.txtIdentificacion.setTextFormatter(Formato.getInstance().integerFormat(12));
        this.txtNombre.setTextFormatter(Formato.getInstance().letrasFormat(80));
        this.txtNombreComercial.setTextFormatter(Formato.getInstance().maxLengthFormat(80));
        this.txtOtrasSenas.setTextFormatter(Formato.getInstance().maxLengthFormat(160));
        this.txtPaisTelefono.setTextFormatter(Formato.getInstance().integerFormat(3));
        this.txtFax.setTextFormatter(Formato.getInstance().integerFormat(20));
        this.txtPaisFax.setTextFormatter(Formato.getInstance().integerFormat(3));
        this.txtTelefono.setTextFormatter(Formato.getInstance().integerFormat(20));
        this.txtCorreo.setTextFormatter(Formato.getInstance().maxLengthFormat(60));
        this.txtUsuarioHacienda.setTextFormatter(Formato.getInstance().maxLengthFormat(120));
        this.txtContrasenaHacienda.setTextFormatter(Formato.getInstance().maxLengthFormat(120));
        this.txtPinCertificado.setTextFormatter(Formato.getInstance().maxLengthFormat(120));
        this.txtRegistroFiscal8707.setTextFormatter(new TextFormatter(change -> change.getControlNewText().length() <= 12 ? change : null));
    }

    public void llenarList() {
        this.camposVacios = new ArrayList<TextField>();
        this.contrase\u00f1asVacios = new ArrayList<PasswordField>();
        this.camposVacios.add(this.txtIdentificacion);
        this.camposVacios.add(this.txtNombre);
        this.camposVacios.add(this.txtTelefono);
        this.camposVacios.add(this.txtTerminalDefecto);
        this.camposVacios.add(this.txtOtrasSenas);
        this.camposVacios.add(this.txtUsuarioHacienda);
        this.camposVacios.add(this.txtCertificado);
        this.camposVacios.add(this.txtPaisTelefono);
        this.camposVacios.add(this.txtCorreo);
        this.camposVacios.add(this.txtTerminalDefecto);
        this.camposVacios.add(this.txtOtrasSenas);
        this.camposVacios.add(this.txtUsuarioHacienda);
        this.contrase\u00f1asVacios.add(this.txtContrasenaHacienda);
        this.contrase\u00f1asVacios.add(this.txtPinCertificado);
    }

    @FXML
    private void OnBtnGuardar(ActionEvent event) {
        this.guardarEmisor();
    }

    @FXML
    private void activarBarrio(ActionEvent event) {
        if (!this.actBarrio.isSelected()) {
            this.cbxBarrios.setDisable(true);
            this.cbxBarrios.setValue(null);
        } else {
            this.cbxBarrios.setDisable(false);
            this.cbxBarrios.setValue(this.cbxBarrios.getItems().get(0));
        }
    }

    @FXML
    private void OnBtnCorreoPrueba(ActionEvent event) {
        ParametroService parametroService = (ParametroService)AppContext.getInstance().get("ParametroService");
    }

    @FXML
    private void OnBtnCancelar(ActionEvent event) {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void OnbtnCargarCertificado(ActionEvent event) {
        Stage stage = (Stage)this.btnGuardar.getScene().getWindow();
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("P12", new String[]{"*.p12"})});
        fileChooser.setTitle("Seleccione el certificado");
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            String path = file.getAbsolutePath();
            this.certificadoSeleccionado = file;
            this.cambioFile = true;
            this.txtCertificado.setText(file.getName());
        }
    }

    private boolean validaCedula(String tipo) {
        if (!this.txtIdentificacion.getText().isEmpty() || this.txtIdentificacion.getText() != null) {
            if (tipo.equalsIgnoreCase("01")) {
                if (this.txtIdentificacion.getText().length() != 9) {
                    this.funcionesGenerales.MostrarModalInfo("La c\u00e9dula f\u00edsica debe de contener 9 digitos.");
                    return false;
                }
            } else if (tipo.equalsIgnoreCase("02")) {
                if (this.txtIdentificacion.getText().length() != 10) {
                    this.funcionesGenerales.MostrarModalInfo("La c\u00e9dula jur\u00eddica debe de contener 10 digitos.");
                    return false;
                }
            } else if (tipo.equalsIgnoreCase("03")) {
                if (this.txtIdentificacion.getText().length() < 11 || this.txtIdentificacion.getText().length() > 12) {
                    this.funcionesGenerales.MostrarModalInfo("El DIMEX debe de contener 11 o 12 digitos sin ceros al inicio.");
                    return false;
                }
            } else if (tipo.equalsIgnoreCase("04") && this.txtIdentificacion.getText().length() != 10) {
                this.funcionesGenerales.MostrarModalInfo("El NITE debe de contener 10 digitos.");
                return false;
            }
        }
        if (this.txtPaisTelefono.getText().length() != 3 || this.txtPaisTelefono.getText() == null) {
            this.funcionesGenerales.MostrarModalInfo("El codigo del pa\u00eds del telefono debe de contener 3 digitos.");
            return false;
        }
        if (!this.txtCorreo.getText().matches("\\s*\\w+([-+.']\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*\\s*")) {
            this.funcionesGenerales.MostrarModalInfo("El formato de la direccion de correo es incorrecto.");
            return false;
        }
        if (this.txtTerminalDefecto.getText().length() != 5 || this.txtPaisTelefono.getText() == null) {
            this.funcionesGenerales.MostrarModalInfo("El codigo del pa\u00eds del telefono debe de contener 3 digitos.");
            return false;
        }
        return true;
    }

    private boolean validarCampos() {
        Boolean verificar = true;
        for (TextField textField : this.camposVacios) {
        }
        for (PasswordField passwordField : this.contrase\u00f1asVacios) {
        }
        for (TextField textField : this.camposVacios) {
            if (!textField.getText().isEmpty()) continue;
            verificar = false;
        }
        for (PasswordField passwordField : this.contrase\u00f1asVacios) {
            if (!passwordField.getText().isEmpty()) continue;
            verificar = false;
        }
        return verificar;
    }

    private void guardarEmisor() {
        if (this.validarCampos()) {
            if (this.validaCedula(((IdentificacionDto)this.cbxTipoIdentificacion.getSelectionModel().getSelectedItem()).getCodigo())) {
                Integer id = null;
                Object idCreado = null;
                id = this.nuevoEmisor ? null : this.emisorSeleccionado.getId();
                Stage stage = (Stage)this.btnGuardar.getScene().getWindow();
                EmisorDto emisorDto = new EmisorDto();
                String activo = this.checkActivo.isSelected() ? "A" : "I";
                emisorDto.setId(id);
                emisorDto.setNombre(this.txtNombre.getText());
                emisorDto.setNombreComercial(this.txtNombreComercial.getText());
                emisorDto.setNumeroIdentificacion(this.txtIdentificacion.getText());
                emisorDto.setCodigoProvincia(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getCodigo());
                emisorDto.setCodigoCanton(((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo());
                emisorDto.setCodigoDistrito(((VDistritoDto)this.cbxDistritos.getSelectionModel().getSelectedItem()).getCodigo());
                try {
                    emisorDto.setCodigoBarrio(((VBarrioDto)this.cbxBarrios.getSelectionModel().getSelectedItem()).getCodigo());
                }
                catch (Exception ex) {
                    emisorDto.setCodigoBarrio(null);
                }
                emisorDto.setOtrasSenas(this.txtOtrasSenas.getText());
                emisorDto.setPaisTelefono(this.intergerOf(this.txtPaisTelefono.getText()));
                emisorDto.setTelefono(this.intergerOf(this.txtTelefono.getText()));
                emisorDto.setPaisFax(this.intergerOf(this.txtPaisFax.getText()));
                emisorDto.setFax(this.intergerOf(this.txtFax.getText()));
                emisorDto.setCorreo(this.txtCorreo.getText());
                emisorDto.setPassCorreo("");
                emisorDto.setUsuarioHacienda(this.txtUsuarioHacienda.getText());
                emisorDto.setPassHacienda(this.txtContrasenaHacienda.getText());
                emisorDto.setNombreCertificado(this.txtIdentificacion.getText() + ".p12");
                emisorDto.setPassCertificado(this.txtPinCertificado.getText());
                emisorDto.setTerminalDefecto(this.txtTerminalDefecto.getText());
                emisorDto.setPaisDefecto(this.txtPaisDefecto.getText());
                emisorDto.setEstado(activo);
                emisorDto.setRegistroFiscal8707(this.txtRegistroFiscal8707.getText());
                emisorDto.setTipoIdentificacion(((IdentificacionDto)this.cbxTipoIdentificacion.getSelectionModel().getSelectedItem()).getCodigoHac());
                emisorDto.setEmpresa(new EmpresaDto(GlobalApp.idEmpresa));
                EmisorService service = (EmisorService)AppContext.getInstance().get("EmisorService");
                Respuesta respuesta = service.saveEmisor(emisorDto);
                if (respuesta.getEstado().booleanValue()) {
                    EmisorDto resp = (EmisorDto)respuesta.getResultado("Emisor");
                    Boolean respCrtificado = true;
                    id = resp.getId();
                    if (this.nuevoEmisor) {
                        if (this.certificadoSeleccionado != null) {
                            respCrtificado = this.subirCertificado(id);
                        }
                    } else if (this.certificadoSeleccionado != null && this.cambioFile) {
                        respCrtificado = this.subirCertificado(id);
                    }
                    if (respCrtificado.booleanValue()) {
                        this.funcionesGenerales.MostrarModalInfo("Emisor guardado correctamente.");
                        stage.hide();
                    } else {
                        this.funcionesGenerales.MostrarModalInfo("Error al guardar el certificado de seguridad.");
                    }
                } else {
                    this.funcionesGenerales.MostrarModalInfo("Error al guardar emisor");
                }
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Es obligatorio llenar los campos en rojo.");
        }
    }

    private Integer intergerOf(String var) {
        Integer integer = null;
        try {
            integer = Integer.valueOf(var);
        }
        catch (NumberFormatException ex) {
            integer = null;
        }
        return integer;
    }

    private String stringOf(Integer var) {
        String string = null;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = "";
        }
        return string;
    }

    @FXML
    private void onCbxProvincias(ActionEvent event) {
        this.getCantones(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId(), false);
    }

    @FXML
    private void onCbxCantones(ActionEvent event) {
        this.getDistrito(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), false);
    }

    @FXML
    private void onCbxDistritos(ActionEvent event) {
        this.getBarrio(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), ((VDistritoDto)this.cbxDistritos.getSelectionModel().getSelectedItem()).getCodigo());
    }

    private void cargarEmisorSeleccionado(EmisorDto emi) {
        this.txtNombre.setText(emi.getNombre());
        this.txtNombreComercial.setText(emi.getNombreComercial());
        this.txtIdentificacion.setText(emi.getNumeroIdentificacion());
        ProvinciaDto pro = new ProvinciaDto();
        pro = this.cbxProvincias.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(emi.getCodigoProvincia())).findAny().orElse(null);
        this.cbxProvincias.getSelectionModel().select((Object)pro);
        this.getCantones(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId(), false);
        CantonDto can = new CantonDto();
        can = this.cbxCantones.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(emi.getCodigoCanton())).findAny().orElse(null);
        this.cbxCantones.getSelectionModel().select((Object)can);
        this.getDistrito(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), false);
        VDistritoDto dis = new VDistritoDto();
        dis = this.cbxDistritos.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(emi.getCodigoDistrito())).findAny().orElse(null);
        this.cbxDistritos.getSelectionModel().select((Object)dis);
        this.getBarrio(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), ((VDistritoDto)this.cbxDistritos.getSelectionModel().getSelectedItem()).getCodigo());
        VBarrioDto bar = new VBarrioDto();
        bar = this.cbxBarrios.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(emi.getCodigoBarrio())).findAny().orElse(null);
        this.cbxBarrios.getSelectionModel().select((Object)bar);
        this.txtOtrasSenas.setText(emi.getOtrasSenas());
        this.txtPaisTelefono.setText(this.stringOf(emi.getPaisTelefono()));
        this.txtTelefono.setText(this.stringOf(emi.getTelefono()));
        this.txtPaisFax.setText(this.stringOf(emi.getPaisFax()));
        this.txtFax.setText(this.stringOf(emi.getFax()));
        this.txtCorreo.setText(emi.getCorreo());
        this.txtUsuarioHacienda.setText(emi.getUsuarioHacienda());
        this.txtContrasenaHacienda.setText(emi.getPassHacienda());
        this.txtCertificado.setText(emi.getNombreCertificado());
        this.txtPinCertificado.setText(emi.getPassCertificado());
        this.txtTerminalDefecto.setText(emi.getTerminalDefecto());
        this.txtPaisDefecto.setText(emi.getPaisDefecto());
        this.txtRegistroFiscal8707.setText(emi.getRegistroFiscal8707());
        if (emi.getEstado().equalsIgnoreCase("A")) {
            this.checkActivo.setSelected(true);
        } else {
            this.checkActivo.setSelected(false);
        }
        IdentificacionDto ide = new IdentificacionDto();
        ide = this.cbxTipoIdentificacion.getItems().stream().filter(c -> c.getCodigoHac().equalsIgnoreCase(emi.getTipoIdentificacion())).findAny().orElse(null);
        this.cbxTipoIdentificacion.getSelectionModel().select((Object)ide);
    }

    private void getTipoIdentificaciones() {
        TipoIdentificacionService identificacionService = (TipoIdentificacionService)AppContext.getInstance().get("TipoIdentificacionService");
        Respuesta respuesta = identificacionService.getTipoIdentificaciones();
        if (respuesta.getEstado().booleanValue()) {
            this.tipoIdentificacionesLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Identificaciones")));
            this.cbxTipoIdentificacion.setItems(this.tipoIdentificacionesLista);
            this.cbxTipoIdentificacion.getSelectionModel().selectFirst();
        }
    }

    private void getProvincias() {
        ProvinciaService provinciaService = (ProvinciaService)AppContext.getInstance().get("ProvinciaService");
        Respuesta respuesta = provinciaService.getProvincias();
        if (respuesta.getEstado().booleanValue()) {
            this.provinciasLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Provincias")));
            this.cbxProvincias.setItems(this.provinciasLista);
            this.cbxProvincias.getSelectionModel().selectFirst();
        }
    }

    private void getCantones(Integer idProvincia, boolean defecto) {
        CantonService cantonService = (CantonService)AppContext.getInstance().get("CantonService");
        Respuesta respuesta = cantonService.getCantonIdProvincia(idProvincia);
        if (respuesta.getEstado().booleanValue()) {
            this.cantonesLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Cantones")));
            this.cbxCantones.setItems(this.cantonesLista);
            this.cbxCantones.getSelectionModel().selectFirst();
        }
    }

    private void getDistrito(String codigoProvincia, String codigoCanton, boolean defecto) {
        DistritoService distritoService = (DistritoService)AppContext.getInstance().get("DistritoService");
        Respuesta respuesta = distritoService.getDistritos(codigoProvincia, codigoCanton);
        if (respuesta.getEstado().booleanValue()) {
            this.distritosLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Distritos")));
            this.cbxDistritos.setItems(this.distritosLista);
            this.cbxDistritos.getSelectionModel().selectFirst();
        }
    }

    private void getBarrio(String codigoProvincia, String codigoCanton, String codigoDistrito) {
        BarrioService barrioService = (BarrioService)AppContext.getInstance().get("BarrioService");
        Respuesta respuesta = barrioService.getBarrios(codigoProvincia, codigoCanton, codigoDistrito);
        if (respuesta.getEstado().booleanValue()) {
            this.barrioLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Barrios")));
            this.cbxBarrios.setItems(this.barrioLista);
            this.cbxBarrios.getSelectionModel().selectFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean subirCertificado(Integer idEmisor) {
        Request re = new Request();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.certificadoSeleccionado);
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost httppost = new HttpPost(re.urlBase + "Parametro/subircertificado/" + idEmisor.toString());
            FileEntity fe = new FileEntity(this.certificadoSeleccionado, ContentType.APPLICATION_OCTET_STREAM);
            httppost.setEntity((HttpEntity)fe);
            HttpResponse response = client.execute((HttpUriRequest)httppost);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity responseEntity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
            System.out.println("[" + statusCode + "] " + responseString);
            boolean bl = true;
            return bl;
        }
        catch (ClientProtocolException e) {
            System.err.println("Unable to make connection");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            System.err.println("Unable to read file");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public EmisorDto getEmisorSeleccionado() {
        return this.emisorSeleccionado;
    }

    public void setEmisorSeleccionado(EmisorDto emisorSeleccionado) {
        this.emisorSeleccionado = emisorSeleccionado;
        this.cargarEmisorSeleccionado(emisorSeleccionado);
    }
}

