/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.model.CajaDto;
import electricpos.model.GlobalApp;
import electricpos.model.MovimientoCajaDto;
import electricpos.model.NotificacionType;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.MovimientoCajaService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class MantMovCajaViewController
implements Initializable {
    @FXML
    private TextArea txtObservaciones;
    @FXML
    private Label lblTipo;
    @FXML
    private TextField txtMonto;
    private String tipo;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void onBtnGuardar() {
        this.guardarMovimiento();
        Stage stage = (Stage)this.txtObservaciones.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnCancelar() {
        Stage stage = (Stage)this.txtObservaciones.getScene().getWindow();
        stage.hide();
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
        if (tipo.equalsIgnoreCase("E")) {
            this.lblTipo.setText("egreso");
        }
        if (tipo.equalsIgnoreCase("I")) {
            this.lblTipo.setText("ingreso");
        }
        if (tipo.equalsIgnoreCase("R")) {
            this.lblTipo.setText("retiro efectivo");
        }
    }

    private void guardarMovimiento() {
        MovimientoCajaDto mov = new MovimientoCajaDto();
        mov.setDetalle(this.txtObservaciones.getText());
        mov.setEstado("A");
        mov.setMonto(new BigDecimal(this.txtMonto.getText()));
        mov.setSucursalEmisor(new SucursalEmisorDto(GlobalApp.idSucursal));
        mov.setTipo(this.tipo);
        CajaDto cajaActual = this.funcionesGenerales.getUltimaCaja();
        if (cajaActual != null && cajaActual.getEstado().equalsIgnoreCase("A")) {
            mov.setIdCaja(cajaActual.getId());
        } else {
            mov.setIdCaja(null);
            if (GlobalApp.empresa.getReqCaja().equalsIgnoreCase("S")) {
                NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "No existe ninguna caja abierta para asociar el " + this.lblTipo.getText() + ".");
                return;
            }
        }
        MovimientoCajaService service = (MovimientoCajaService)AppContext.getInstance().get("MovimientoCajaService");
        Respuesta respuesta = service.save(mov);
        if (respuesta.getEstado().booleanValue()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "El " + this.lblTipo.getText() + " se guard\u00f3 satisfactoriamente.");
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un problema al guardar el " + this.lblTipo.getText() + ".");
        }
    }
}

