/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import electricpos.model.MovimientoInventarioTv;
import electricpos.model.NotificacionType;
import electricpos.model.ProductoServicioDto;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.MovimientoInventarioService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class MantMovInvViewController
implements Initializable {
    @FXML
    private Label lblTitulo;
    @FXML
    private Label lblTitulo2;
    @FXML
    private Label lblCantidadMov;
    @FXML
    private TextField txtCodigo;
    @FXML
    private JFXButton btnCancelar;
    @FXML
    private TextField txtDescripcion;
    @FXML
    private TextField txtPrecioU;
    @FXML
    private TextField txtExistencia;
    @FXML
    private JFXCheckBox checkActivo;
    @FXML
    private TextField txtCantidadMov;
    @FXML
    private TextField txtNuevoStock;
    @FXML
    private TextField txtCantiddActual;
    @FXML
    private TextArea txtObservaciones;
    @FXML
    private ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    private TextField txtUnidadMedida;
    private ProductoServicioDto productoServicioDto = new ProductoServicioDto();
    private SucursalEmisorDto sucursalEmisorDto = new SucursalEmisorDto();
    private ObservableList<SucursalEmisorDto> sucursalLista;
    private FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    String tipoMovimiento = null;

    public void initialize(URL url, ResourceBundle rb) {
        this.txtCantidadMov.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,13}([\\.]\\d{0,5})?")) {
                    MantMovInvViewController.this.txtCantidadMov.setText(oldValue);
                }
                MantMovInvViewController.this.calcularNuevoStock(MantMovInvViewController.this.tipoMovimiento);
            }
        });
    }

    @FXML
    private void OnAplicar() {
        MovimientoInventarioTv mov = new MovimientoInventarioTv();
        mov.setCantidad(Double.valueOf(this.txtCantidadMov.getText()));
        mov.setTipo(this.tipoMovimiento);
        mov.setObservaciones(this.txtObservaciones.getText());
        mov.setIdSucursal(this.sucursalEmisorDto.getId());
        mov.productoServicio = this.productoServicioDto;
        MovimientoInventarioService service = (MovimientoInventarioService)AppContext.getInstance().get("MovimientoInventarioService");
        Respuesta respuesta = service.save(mov);
        if (respuesta.getEstado().booleanValue()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, (this.tipoMovimiento.equalsIgnoreCase("ENT") ? "Entrada" : "Salida") + " aplicada correctamente.");
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error al aplicar la " + (this.tipoMovimiento.equalsIgnoreCase("ENT") ? "Entrada." : "Salida."));
        }
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void OnBtnCancelar() {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnBuscar() {
        this.productoServicioDto = this.funcionesGenerales.mostrarBusquedaPS(this.sucursalEmisorDto.getEmisor().getId(), this.sucursalEmisorDto.getId(), this.sucursalEmisorDto.getEmisor().getInventarioCompartido());
        if (this.productoServicioDto != null) {
            this.txtCodigo.setText(this.productoServicioDto.getCodigo());
            this.txtDescripcion.setText(this.productoServicioDto.getDescripcion());
            this.txtPrecioU.setText(this.productoServicioDto.getPrecioConImp().toString());
            this.txtUnidadMedida.setText(this.productoServicioDto.getUnidadMedida());
            this.txtExistencia.setText(this.productoServicioDto.getExistencia().toString());
            this.txtCantiddActual.setText(this.productoServicioDto.getExistencia().toString());
            this.txtNuevoStock.setText(this.productoServicioDto.getExistencia().toString());
            if (this.productoServicioDto.getActivo().equalsIgnoreCase("S")) {
                this.checkActivo.setSelected(true);
            } else {
                this.checkActivo.setSelected(false);
            }
        }
    }

    private void calcularNuevoStock(String tipo) {
        double mov;
        double actual = new BigDecimal(this.txtCantiddActual.getText()).setScale(5, RoundingMode.HALF_UP).doubleValue();
        try {
            mov = new BigDecimal(this.txtCantidadMov.getText()).setScale(5, RoundingMode.HALF_UP).doubleValue();
        }
        catch (Exception ex) {
            mov = 0.0;
        }
        double nuevo = 0.0;
        if (tipo.equalsIgnoreCase("ENT")) {
            nuevo = actual + mov;
        } else if (tipo.equalsIgnoreCase("SAL")) {
            nuevo = actual - mov;
        }
        this.txtNuevoStock.setText(Double.toString(nuevo));
    }

    public void setSucursalEmisorDto(SucursalEmisorDto sucursalEmisorDto) {
        this.sucursalEmisorDto = sucursalEmisorDto;
        if (sucursalEmisorDto != null) {
            ArrayList<SucursalEmisorDto> lista = new ArrayList<SucursalEmisorDto>();
            lista.add(sucursalEmisorDto);
            this.sucursalLista = FXCollections.observableArrayList(lista);
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    public String getTipoMovimiento() {
        return this.tipoMovimiento;
    }

    public void setTipoMovimiento(String tipoMovimiento) {
        this.tipoMovimiento = tipoMovimiento;
        if (tipoMovimiento != null) {
            if (tipoMovimiento.equalsIgnoreCase("ENT")) {
                this.lblTitulo.setText("Entrada de inventario");
                this.lblTitulo2.setText("Movimiento de entrada");
                this.lblCantidadMov.setText("Cantidad a ingresar");
                this.txtObservaciones.setText("Entrada manual [" + LocalDate.now().format(DateTimeFormatter.ofPattern("dd-MMM-yyyy")) + "].");
            } else if (tipoMovimiento.equalsIgnoreCase("SAL")) {
                this.lblTitulo.setText("Salida de inventario");
                this.lblTitulo2.setText("Movimiento de salida");
                this.lblCantidadMov.setText("Cantidad a retirar");
                this.txtObservaciones.setText("Salida manual [" + LocalDate.now().format(DateTimeFormatter.ofPattern("dd-MMM-yyyy")) + "].");
            }
        }
    }
}

