/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import electricpos.controller.CabysViewController;
import electricpos.model.CabysTv;
import electricpos.model.EmisorDto;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.model.ProductoServicioDto;
import electricpos.model.SucursalDto;
import electricpos.model.SucursalEmisorDto;
import electricpos.model.TarifaImpuestoDto;
import electricpos.model.TipoCodigoPsDto;
import electricpos.model.TipoImpuestoDto;
import electricpos.model.TipoPS;
import electricpos.model.UnidadMedidaDto;
import electricpos.service.CabysService;
import electricpos.service.ProductoServicioService;
import electricpos.service.SucursalEmisorService;
import electricpos.service.TarifaImpuestoService;
import electricpos.service.TipoCodigoPsService;
import electricpos.service.TipoImpuestoService;
import electricpos.service.UnidadMedidaService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.Formato;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class MantProductoServicioViewController
implements Initializable {
    @FXML
    JFXButton btnGuardar;
    @FXML
    JFXButton btnCancelar;
    @FXML
    ComboBox<UnidadMedidaDto> cbxUnidadMedida;
    @FXML
    ComboBox<TipoCodigoPsDto> cbxTipoCodigo;
    @FXML
    ComboBox<TarifaImpuestoDto> cbxTarifaImpuesto;
    @FXML
    ComboBox<TipoImpuestoDto> cbxTipoImpuesto;
    @FXML
    ComboBox<TipoPS> cbxTipoPS;
    @FXML
    TextField txtFactorIVA;
    @FXML
    TextField txtCodigoCabys;
    @FXML
    TextField txtDescripcionCabys;
    @FXML
    TextField txtImpuestoCabys;
    @FXML
    TextField txtBaseImponible;
    @FXML
    TextField txtTarifaImpuestoIVA;
    @FXML
    TextField txtCodigo;
    @FXML
    TextField txtDescripcion;
    @FXML
    TextField txtPrecioU;
    @FXML
    TextField txtExistencia;
    @FXML
    TextField txtTarifaImpuesto;
    @FXML
    TextField txtMontoImp;
    @FXML
    TextField txtPrecioConImp;
    @FXML
    TextField txtPrecioSinImp;
    @FXML
    TextField txtPrecioCosto;
    @FXML
    TextField txtTag;
    @FXML
    private JFXCheckBox checkExento;
    @FXML
    private JFXCheckBox checkActivo;
    @FXML
    private JFXCheckBox checkIncluyeImp;
    @FXML
    private JFXCheckBox checkActivarIva;
    @FXML
    private AnchorPane anPaneImp;
    @FXML
    Label lblEmisor;
    @FXML
    ComboBox<SucursalEmisorDto> cbxSucursal;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<UnidadMedidaDto> unidadMedidaLista;
    ObservableList<TipoCodigoPsDto> tiposCodigoLista;
    ObservableList<TipoImpuestoDto> tiposImpuestoLista;
    ObservableList<TarifaImpuestoDto> tarifasImpuestoLista;
    ObservableList<TipoPS> tipoPsLsista;
    List<TextField> txtList;
    String codigoDefecto = null;
    Integer idSucursalDefecto = null;
    ObservableList<SucursalEmisorDto> sucursalLista;
    private Boolean nuevo = true;
    private ProductoServicioDto psSeleccionado = null;
    public EmisorDto emisor = null;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.txtList = new ArrayList<TextField>();
        this.txtList.add(this.txtCodigo);
        this.txtList.add(this.txtDescripcion);
        this.txtList.add(this.txtPrecioU);
        this.txtList.add(this.txtExistencia);
        this.cargarTiposPS();
        this.cargarTiposCodigo();
        this.cargarUnidadesMedida();
        this.cargarTiposImpuesto();
        this.cargarTarifasImpuesto();
        this.txtDescripcion.setTextFormatter(Formato.getInstance().maxLengthFormat(160));
        this.txtCodigo.setTextFormatter(Formato.getInstance().maxLengthFormat(20));
        this.txtExistencia.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,13}([\\.]\\d{0,2})?")) {
                    MantProductoServicioViewController.this.txtExistencia.setText(oldValue);
                }
            }
        });
        this.txtPrecioU.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,13}([\\.]\\d{0,5})?")) {
                    MantProductoServicioViewController.this.txtPrecioU.setText(oldValue);
                }
                MantProductoServicioViewController.this.calcularPrecios();
            }
        });
        this.txtTarifaImpuesto.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,2}([\\.]\\d{0,2})?")) {
                    MantProductoServicioViewController.this.txtTarifaImpuesto.setText(oldValue);
                }
                if (!MantProductoServicioViewController.this.txtTarifaImpuesto.getText().isEmpty()) {
                    MantProductoServicioViewController.this.calcularPrecios();
                }
            }
        });
        this.txtFactorIVA.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,1}([\\.]\\d{0,4})?")) {
                    MantProductoServicioViewController.this.txtFactorIVA.setText(oldValue);
                }
            }
        });
        this.txtBaseImponible.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d{0,13}([\\.]\\d{0,5})?")) {
                    MantProductoServicioViewController.this.txtBaseImponible.setText(oldValue);
                }
            }
        });
    }

    public Boolean validar() {
        Boolean verificar = true;
        for (TextField j : this.txtList) {
            if (!j.getText().isEmpty()) continue;
            verificar = false;
        }
        if (!verificar.booleanValue()) {
            this.funcionesGenerales.MostrarModalInfo("Es necesario llenar los campos requeridos.");
        }
        return verificar;
    }

    public Boolean validaTarifaImpuesto() {
        if (!this.checkExento.isSelected()) {
            TipoImpuestoDto tipoImpuesto = (TipoImpuestoDto)this.cbxTipoImpuesto.getSelectionModel().getSelectedItem();
            if (tipoImpuesto.getCodigo().equalsIgnoreCase("01") || tipoImpuesto.getCodigo().equalsIgnoreCase("07")) {
                TarifaImpuestoDto tarifaImpuestoDto = (TarifaImpuestoDto)this.cbxTarifaImpuesto.getSelectionModel().getSelectedItem();
                BigDecimal impuesto = new BigDecimal(this.txtTarifaImpuesto.getText());
                BigDecimal tarifaIva = tarifaImpuestoDto.getTarifa();
                if (tarifaIva.compareTo(impuesto) == 0) {
                    return true;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    @FXML
    private void OnGuardarPS() {
        if (this.validar().booleanValue()) {
            if (this.validaTarifaImpuesto().booleanValue()) {
                this.guardarProductoServicio();
            } else {
                this.funcionesGenerales.MostrarModalInfo("El impuesto debe corresponder al tipo de tarifa seleccionado.");
            }
        }
    }

    @FXML
    private void onBtnBuscarCabys() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CabysView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(MantProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        CabysViewController controller = (CabysViewController)fxmlLoader.getController();
        controller.setDescripcion(this.txtDescripcion.getText());
        FuncionesGenerales.showView(root1);
        if (controller.selecciono) {
            this.txtCodigoCabys.setText(controller.cabysSeleccionado.getCodigo());
            this.txtDescripcionCabys.setText(controller.cabysSeleccionado.getDescripcion());
            this.txtImpuestoCabys.setText(controller.cabysSeleccionado.getImpuesto());
        }
    }

    @FXML
    private void OnBtnCalcularPrecios() {
        if (!this.txtPrecioU.getText().isEmpty()) {
            this.calcularPrecios();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Ingrese un precio por unidad.");
        }
    }

    private void calcularPrecios() {
        if (this.txtMontoImp.getText().isEmpty()) {
            this.txtMontoImp.setText("0");
        }
        if (this.txtPrecioU.getText().isEmpty()) {
            this.txtPrecioConImp.setText("0");
            this.txtPrecioSinImp.setText("0");
        }
        boolean incluyeImp = this.checkIncluyeImp.isSelected();
        double precioU = new BigDecimal(this.txtPrecioU.getText()).setScale(5, RoundingMode.HALF_UP).doubleValue();
        double tarifaImpuesto = new BigDecimal(this.txtTarifaImpuesto.getText()).setScale(2, RoundingMode.HALF_UP).doubleValue();
        if (incluyeImp) {
            double variableImpuesto = tarifaImpuesto / 100.0 + 1.0;
            double precioSinImpuesto = new BigDecimal(precioU / variableImpuesto).setScale(5, RoundingMode.HALF_UP).doubleValue();
            this.txtPrecioSinImp.setText(String.valueOf(precioSinImpuesto));
            double montoImpuesto = new BigDecimal(precioSinImpuesto * (tarifaImpuesto / 100.0)).setScale(5, RoundingMode.HALF_UP).doubleValue();
            this.txtMontoImp.setText(String.valueOf(montoImpuesto));
            double precioConImpuesto = new BigDecimal(precioSinImpuesto + montoImpuesto).setScale(5, RoundingMode.HALF_UP).doubleValue();
            this.txtPrecioConImp.setText(String.valueOf(precioConImpuesto));
        } else {
            double variableImpuesto = tarifaImpuesto / 100.0;
            double precioSinImpuesto = precioU;
            this.txtPrecioSinImp.setText(String.valueOf(precioU));
            double montoImpuesto = new BigDecimal(precioSinImpuesto * variableImpuesto).setScale(5, RoundingMode.HALF_UP).doubleValue();
            this.txtMontoImp.setText(String.valueOf(montoImpuesto));
            double precioConImpuesto = new BigDecimal(precioSinImpuesto + montoImpuesto).setScale(5, RoundingMode.HALF_UP).doubleValue();
            this.txtPrecioConImp.setText(String.valueOf(precioConImpuesto));
        }
    }

    @FXML
    private void OnBtnCancelar() {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onIncluyeImpuesto() {
        if (!this.txtPrecioU.getText().isEmpty()) {
            this.calcularPrecios();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Ingrese un precio por unidad.");
        }
    }

    @FXML
    private void onCbxTipoPSChange() {
        this.cargarUnidadesMedida();
    }

    @FXML
    private void exentoImpuestos() {
        if (this.checkExento.isSelected()) {
            this.anPaneImp.setDisable(true);
            this.txtTarifaImpuesto.setText("0.0");
            this.txtTarifaImpuestoIVA.setText("0.0");
            this.txtFactorIVA.setText("0.0");
            this.txtBaseImponible.setText("0.0");
            this.cbxTipoImpuesto.getSelectionModel().selectFirst();
            this.cbxTarifaImpuesto.getSelectionModel().selectFirst();
            this.calcularPrecios();
        } else {
            this.anPaneImp.setDisable(false);
        }
    }

    private void cargarTiposCodigo() {
        TipoCodigoPsService codigoPsService = (TipoCodigoPsService)AppContext.getInstance().get("TipoCodigoPsService");
        Respuesta respuesta = codigoPsService.getTiposCodigoPs();
        if (respuesta.getEstado().booleanValue()) {
            this.tiposCodigoLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Tipos")));
            this.cbxTipoCodigo.setItems(this.tiposCodigoLista);
            this.cbxTipoCodigo.getSelectionModel().selectFirst();
        }
    }

    private void cargarUnidadesMedida() {
        TipoPS tipoPS = (TipoPS)this.cbxTipoPS.getValue();
        UnidadMedidaService medidaService = (UnidadMedidaService)AppContext.getInstance().get("UnidadMedidaService");
        Respuesta respuesta = medidaService.getUnidadesMedida(tipoPS.getCodigo());
        if (respuesta.getEstado().booleanValue()) {
            this.unidadMedidaLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Unidades")));
            this.cbxUnidadMedida.setItems(this.unidadMedidaLista);
            this.cbxUnidadMedida.getSelectionModel().selectFirst();
        }
    }

    private void cargarTiposImpuesto() {
        TipoImpuestoService impuestoService = (TipoImpuestoService)AppContext.getInstance().get("TipoImpuestoService");
        Respuesta respuesta = impuestoService.getTiposImpuesto();
        if (respuesta.getEstado().booleanValue()) {
            this.tiposImpuestoLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Tipos")));
            this.cbxTipoImpuesto.setItems(this.tiposImpuestoLista);
            this.cbxTipoImpuesto.getSelectionModel().selectFirst();
        }
    }

    private void cargarTarifasImpuesto() {
        TarifaImpuestoService tarifaImpuestoService = (TarifaImpuestoService)AppContext.getInstance().get("TarifaImpuestoService");
        Respuesta respuesta = tarifaImpuestoService.getTarifasImpuesto();
        if (respuesta.getEstado().booleanValue()) {
            this.tarifasImpuestoLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.cbxTarifaImpuesto.setItems(this.tarifasImpuestoLista);
            this.cbxTarifaImpuesto.getSelectionModel().selectFirst();
        }
    }

    private void cargarTiposPS() {
        ArrayList<TipoPS> lista = new ArrayList<TipoPS>();
        TipoPS tps1 = new TipoPS("P", "Producto");
        TipoPS tps2 = new TipoPS("S", "Servicio");
        lista.add(tps1);
        lista.add(tps2);
        this.tipoPsLsista = FXCollections.observableArrayList(lista);
        this.cbxTipoPS.setItems(this.tipoPsLsista);
        this.cbxTipoPS.getSelectionModel().selectFirst();
    }

    private boolean existeCodigoProductoServicio(String codigo, String comparteInventario, Integer idSucursal) {
        ProductoServicioService service = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
        Respuesta respuesta = null;
        if (comparteInventario.equalsIgnoreCase("S")) {
            respuesta = service.getProductoServicioCodigo(this.emisor.getId(), codigo);
        } else if (comparteInventario.equalsIgnoreCase("N")) {
            respuesta = service.getProductoServicioCodigoSucursal(this.emisor.getId(), idSucursal, codigo);
        }
        return respuesta.getEstado() != false;
    }

    private void guardarProductoServicio() {
        boolean existe = this.nuevo == false && this.codigoDefecto.equalsIgnoreCase(this.txtCodigo.getText()) && ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId() == this.idSucursalDefecto ? false : this.existeCodigoProductoServicio(this.txtCodigo.getText(), this.emisor.getInventarioCompartido(), ((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId());
        if (!existe) {
            Stage stage = (Stage)this.btnGuardar.getScene().getWindow();
            ProductoServicioDto productoServicioDto = new ProductoServicioDto();
            Integer id = null;
            id = this.nuevo != false ? null : this.psSeleccionado.getId();
            String activo = this.checkActivo.isSelected() ? "S" : "N";
            String exento = this.checkExento.isSelected() ? "S" : "N";
            String incluyeImp = this.checkIncluyeImp.isSelected() ? "S" : "N";
            String activaIva = this.checkActivarIva.isSelected() ? "S" : "N";
            productoServicioDto.setId(id);
            productoServicioDto.setCodigo(this.txtCodigo.getText());
            productoServicioDto.setDescripcion(this.txtDescripcion.getText());
            productoServicioDto.setPrecioUnidad(new BigDecimal(this.txtPrecioU.getText()));
            productoServicioDto.setExistencia(this.getBigDecimalOf(this.txtExistencia.getText()));
            productoServicioDto.setCodigoCabys(this.txtCodigoCabys.getText());
            productoServicioDto.setTarifaImpuesto(new BigDecimal(this.txtTarifaImpuesto.getText()));
            productoServicioDto.setMontoImpuesto(new BigDecimal(this.txtMontoImp.getText()));
            productoServicioDto.setPrecioConImp(new BigDecimal(this.txtPrecioConImp.getText()));
            productoServicioDto.setPrecioSinImp(new BigDecimal(this.txtPrecioSinImp.getText()));
            productoServicioDto.setTag(this.txtTag.getText());
            productoServicioDto.setPrecioCosto(Optional.ofNullable(this.txtPrecioCosto.getText()).filter(text -> !text.trim().isEmpty()).map(BigDecimal::new).orElse(null));
            productoServicioDto.setActivo(activo);
            productoServicioDto.setExento(exento);
            productoServicioDto.setImpuestoIncluido(incluyeImp);
            productoServicioDto.setTipo(((TipoPS)this.cbxTipoPS.getSelectionModel().getSelectedItem()).getCodigo());
            productoServicioDto.setEmisor(this.emisor);
            productoServicioDto.setTipoCodigo(((TipoCodigoPsDto)this.cbxTipoCodigo.getSelectionModel().getSelectedItem()).getCodigo());
            productoServicioDto.setUnidadMedida(((UnidadMedidaDto)this.cbxUnidadMedida.getSelectionModel().getSelectedItem()).getCodigo());
            try {
                productoServicioDto.setTipoImpuesto(((TipoImpuestoDto)this.cbxTipoImpuesto.getSelectionModel().getSelectedItem()).getCodigo());
            }
            catch (Exception ex) {
                productoServicioDto.setTipoImpuesto("01");
            }
            productoServicioDto.setCodigoTarifa(((TarifaImpuestoDto)this.cbxTarifaImpuesto.getSelectionModel().getSelectedItem()).getCodigo());
            productoServicioDto.setFactorIva(new BigDecimal(this.txtFactorIVA.getText()));
            productoServicioDto.setBaseImponible(new BigDecimal(this.txtBaseImponible.getText()));
            productoServicioDto.setEmpresa(new EmpresaDto(GlobalApp.idEmpresa));
            productoServicioDto.setSucursal(new SucursalDto(2));
            productoServicioDto.setActivaIva(activaIva);
            try {
                SucursalEmisorDto suc = new SucursalEmisorDto();
                suc = (SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem();
                productoServicioDto.setSucursalEmisor(suc);
            }
            catch (Exception suc) {
                // empty catch block
            }
            ProductoServicioService service = (ProductoServicioService)AppContext.getInstance().get("ProductoServicioService");
            Respuesta respuesta = service.saveProductoServicio(productoServicioDto);
            if (respuesta.getEstado().booleanValue()) {
                NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "La  informaci\u00f3n del Producto/Servicio se guard\u00f3 correctamente.");
                this.codigoDefecto = this.txtCodigo.getText();
            } else {
                NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al guardar el Producto/Servicio, intente de nuevo.");
            }
            stage.hide();
        } else {
            this.funcionesGenerales.MostrarModalInfo("El c\u00f3digo del producto/Servicio ya se encuentra registrado, intente un c\u00f3digo distinto.");
        }
    }

    public EmisorDto getEmisor() {
        return this.emisor;
    }

    public void setEmisor(EmisorDto emisor) {
        this.emisor = emisor;
        if (emisor != null) {
            this.lblEmisor.setText(emisor.getNombre());
            this.cargarSucursales(emisor.getId());
            if (GlobalApp.idSucursal != null) {
                SucursalEmisorDto suc = new SucursalEmisorDto();
                suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
                this.cbxSucursal.getSelectionModel().select((Object)suc);
            }
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    public boolean isNuevo() {
        return this.nuevo;
    }

    public void setNuevo(boolean nuevo) {
        this.nuevo = nuevo;
    }

    public ProductoServicioDto getPsSeleccionado() {
        return this.psSeleccionado;
    }

    public void setPsSeleccionado(ProductoServicioDto psSeleccionado) {
        this.psSeleccionado = psSeleccionado;
        if (psSeleccionado != null) {
            this.txtCodigo.setText(psSeleccionado.getCodigo());
            this.txtExistencia.setText(psSeleccionado.getExistencia().toString());
            this.txtDescripcion.setText(psSeleccionado.getDescripcion());
            this.txtPrecioU.setText(psSeleccionado.getPrecioUnidad().toString());
            this.txtDescripcion.setText(psSeleccionado.getDescripcion());
            this.txtTarifaImpuesto.setText(psSeleccionado.getTarifaImpuesto().toString());
            this.txtPrecioConImp.setText(psSeleccionado.getPrecioConImp().toString());
            this.txtPrecioSinImp.setText(psSeleccionado.getPrecioSinImp().toString());
            this.txtMontoImp.setText(psSeleccionado.getMontoImpuesto().toString());
            this.txtTag.setText(psSeleccionado.getTag());
            Optional.ofNullable(psSeleccionado.getPrecioCosto()).ifPresent(precioCosto -> this.txtPrecioCosto.setText(precioCosto.toString()));
            if (psSeleccionado.getExento().equalsIgnoreCase("S")) {
                this.anPaneImp.setDisable(true);
                this.checkExento.setSelected(true);
            } else {
                this.checkExento.setSelected(false);
                this.anPaneImp.setDisable(false);
            }
            if (psSeleccionado.getImpuestoIncluido().equalsIgnoreCase("S")) {
                this.checkIncluyeImp.setSelected(true);
            } else {
                this.checkIncluyeImp.setSelected(false);
            }
            if (psSeleccionado.getActivo().equalsIgnoreCase("S")) {
                this.checkActivo.setSelected(true);
            } else {
                this.checkActivo.setSelected(false);
            }
            if (psSeleccionado.getActivaIva().equalsIgnoreCase("S")) {
                this.checkActivarIva.setSelected(true);
            } else {
                this.checkActivarIva.setSelected(false);
            }
            TipoCodigoPsDto tipoCodigo = new TipoCodigoPsDto();
            tipoCodigo = this.cbxTipoCodigo.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(psSeleccionado.getTipoCodigo())).findAny().orElse(null);
            this.cbxTipoCodigo.getSelectionModel().select((Object)tipoCodigo);
            TipoImpuestoDto tipoImpuesto = new TipoImpuestoDto();
            tipoImpuesto = this.cbxTipoImpuesto.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(psSeleccionado.getTipoImpuesto())).findAny().orElse(null);
            this.cbxTipoImpuesto.getSelectionModel().select((Object)tipoImpuesto);
            try {
                if (tipoImpuesto.getCodigo().equalsIgnoreCase("01") || tipoImpuesto.getCodigo().equalsIgnoreCase("07")) {
                    this.cbxTarifaImpuesto.setDisable(false);
                } else {
                    this.cbxTarifaImpuesto.setDisable(true);
                }
            }
            catch (Exception ex) {
                this.cbxTarifaImpuesto.setDisable(true);
            }
            TipoPS tipoPs = new TipoPS();
            tipoPs = this.cbxTipoPS.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(psSeleccionado.getTipo())).findAny().orElse(null);
            this.cbxTipoPS.getSelectionModel().select((Object)tipoPs);
            this.cargarUnidadesMedida();
            UnidadMedidaDto unidadMedidaDto = new UnidadMedidaDto();
            unidadMedidaDto = this.cbxUnidadMedida.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(psSeleccionado.getUnidadMedida())).findAny().orElse(null);
            this.cbxUnidadMedida.getSelectionModel().select((Object)unidadMedidaDto);
            if (psSeleccionado.getSucursalEmisor() != null) {
                SucursalEmisorDto suc = new SucursalEmisorDto();
                suc = this.cbxSucursal.getItems().stream().filter(c -> c.getId() == psSeleccionado.getSucursalEmisor().getId()).findAny().orElse(null);
                this.cbxSucursal.getSelectionModel().select((Object)suc);
            }
            if (psSeleccionado.getCodigoTarifa() != null) {
                TarifaImpuestoDto tarifaImpuestoDto = new TarifaImpuestoDto();
                tarifaImpuestoDto = this.cbxTarifaImpuesto.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(psSeleccionado.getCodigoTarifa())).findAny().orElse(null);
                this.cbxTarifaImpuesto.getSelectionModel().select((Object)tarifaImpuestoDto);
            }
            if (psSeleccionado.getCodigoCabys() != null && !psSeleccionado.getCodigoCabys().isEmpty()) {
                CabysService service = (CabysService)AppContext.getInstance().get("CabysService");
                Respuesta respuesta = service.getCabysByCodigoExternal(psSeleccionado.getCodigoCabys());
                CabysTv cabysTv = (CabysTv)respuesta.getResultado(ESTADO.OK.VALUE());
                if (respuesta.getEstado().booleanValue() && cabysTv != null) {
                    this.txtCodigoCabys.setText(psSeleccionado.getCodigoCabys());
                    this.txtDescripcionCabys.setText(cabysTv.getDescripcion());
                    this.txtImpuestoCabys.setText(cabysTv.getImpuesto());
                } else {
                    this.funcionesGenerales.MostrarModalInfo("No se pudo obtener los datos del Cabys del producto/servicio.");
                }
            }
        }
    }

    private BigDecimal getBigDecimalOf(String value) {
        BigDecimal response;
        try {
            response = new BigDecimal(value);
        }
        catch (Exception ex) {
            response = new BigDecimal(0);
        }
        return response;
    }

    public void setCodigoDefecto(String codigoDefecto) {
        this.codigoDefecto = codigoDefecto;
    }

    public void setIdSucursalDefecto(Integer idSucursalDefecto) {
        this.idSucursalDefecto = idSucursalDefecto;
    }

    @FXML
    private void onCbxTarifaImpuestoChanged() {
        if (!this.cbxTarifaImpuesto.getSelectionModel().isEmpty()) {
            try {
                this.txtTarifaImpuestoIVA.setText(((TarifaImpuestoDto)this.cbxTarifaImpuesto.getSelectionModel().getSelectedItem()).getTarifa().toPlainString());
                this.txtTarifaImpuesto.setText(((TarifaImpuestoDto)this.cbxTarifaImpuesto.getSelectionModel().getSelectedItem()).getTarifa().toPlainString());
            }
            catch (Exception e) {
                this.txtTarifaImpuestoIVA.setText("0.0");
                this.txtTarifaImpuesto.setText("0.0");
            }
        }
    }

    @FXML
    private void onCbxTipoImpuestoChanged() {
        if (!this.cbxTipoImpuesto.getSelectionModel().isEmpty()) {
            try {
                TipoImpuestoDto impuestoDto = (TipoImpuestoDto)this.cbxTipoImpuesto.getSelectionModel().getSelectedItem();
                if (impuestoDto.getCodigo().equalsIgnoreCase("01") || impuestoDto.getCodigo().equalsIgnoreCase("07")) {
                    this.cbxTarifaImpuesto.setDisable(false);
                } else {
                    this.cbxTarifaImpuesto.setDisable(true);
                }
                if (impuestoDto.getCodigo().equalsIgnoreCase("07")) {
                    this.txtBaseImponible.setDisable(false);
                } else {
                    this.txtBaseImponible.setDisable(true);
                }
                if (impuestoDto.getCodigo().equalsIgnoreCase("08")) {
                    this.txtFactorIVA.setDisable(false);
                } else {
                    this.txtFactorIVA.setDisable(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

