/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import electricpos.model.CantonDto;
import electricpos.model.EmisorDto;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.model.IdentificacionDto;
import electricpos.model.NotificacionType;
import electricpos.model.ProvinciaDto;
import electricpos.model.ReceptorDto;
import electricpos.model.VBarrioDto;
import electricpos.model.VDistritoDto;
import electricpos.service.BarrioService;
import electricpos.service.CantonService;
import electricpos.service.DistritoService;
import electricpos.service.ProvinciaService;
import electricpos.service.ReceptorService;
import electricpos.service.TipoIdentificacionService;
import electricpos.util.AppContext;
import electricpos.util.Formato;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import electricpos.util.VALIDACION;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class MantReceptorViewController
implements Initializable {
    @FXML
    private JFXButton btnCancelar;
    @FXML
    private TextField txtIdentificacion;
    @FXML
    private TextField txtNombre;
    @FXML
    private TextField txtNombreComercial;
    @FXML
    private TextField txtIdentificacionExtranjero;
    @FXML
    private TextField txtOtrasSenas;
    @FXML
    private TextField txtCorreo;
    @FXML
    private TextField txtFax;
    @FXML
    private TextField txtPaisFax;
    @FXML
    private TextField txtPaisTel;
    @FXML
    private TextField txtTel;
    @FXML
    ComboBox<IdentificacionDto> cbxTipoIdentificacion;
    @FXML
    ComboBox<ProvinciaDto> cbxProvincias;
    @FXML
    ComboBox<VDistritoDto> cbxDistritos;
    @FXML
    ComboBox<VBarrioDto> cbxBarrios;
    @FXML
    ComboBox<CantonDto> cbxCantones;
    @FXML
    private JFXCheckBox checkActivaBarrio;
    @FXML
    private JFXCheckBox checkActivaUbicacion;
    ObservableList<IdentificacionDto> tipoIdentificacionesLista;
    ObservableList<ProvinciaDto> provinciasLista;
    ObservableList<CantonDto> cantonesLista;
    ObservableList<VDistritoDto> distritosLista;
    ObservableList<VBarrioDto> barrioLista;
    public ReceptorDto receptorDto = new ReceptorDto();
    public Integer idReceptor;
    public boolean desdeFacturacion = true;
    public Integer idEmisor = null;
    private static final String EMPTY_STRING = "";
    StringBuilder mensajeValidacion = new StringBuilder();
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.getTipoIdentificaciones();
        this.getProvincias();
        this.getCantones(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId(), false);
        this.getDistrito(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), false);
        this.getBarrio(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), ((VDistritoDto)this.cbxDistritos.getSelectionModel().getSelectedItem()).getCodigo());
        FuncionesGenerales.setValidationTextField(this.txtIdentificacion, VALIDACION.IDENTIFICACION);
        this.txtPaisTel.setTextFormatter(Formato.getInstance().integerFormat(3));
        this.txtPaisFax.setTextFormatter(Formato.getInstance().integerFormat(3));
        this.txtFax.setTextFormatter(Formato.getInstance().integerFormat(20));
        this.txtTel.setTextFormatter(Formato.getInstance().integerFormat(20));
        this.txtNombre.setTextFormatter(Formato.getInstance().maxLengthFormat(80));
        this.txtNombreComercial.setTextFormatter(Formato.getInstance().maxLengthFormat(80));
        this.txtCorreo.setTextFormatter(Formato.getInstance().maxLengthFormat(60));
        this.txtOtrasSenas.setTextFormatter(Formato.getInstance().maxLengthFormat(160));
    }

    @FXML
    private void OnBtnCancelar(ActionEvent event) {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void OnBtnGuardar(ActionEvent event) {
        this.guardarReceptor();
    }

    @FXML
    private void onCheckBarrio(ActionEvent event) {
        this.desactivarBarrio(!this.checkActivaBarrio.isSelected());
    }

    @FXML
    private void onCheckUbicacion(ActionEvent event) {
        this.desactivarUbicacion(!this.checkActivaUbicacion.isSelected());
    }

    @FXML
    private void onCbxProvincias(ActionEvent event) {
        this.getCantones(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId(), false);
    }

    @FXML
    private void onCbxCantones(ActionEvent event) {
        this.getDistrito(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), false);
    }

    @FXML
    private void onCbxDistritos(ActionEvent event) {
        this.getBarrio(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), ((VDistritoDto)this.cbxDistritos.getSelectionModel().getSelectedItem()).getCodigo());
    }

    private boolean validaCedula(String tipo) {
        if (!this.txtIdentificacion.getText().isEmpty() || this.txtIdentificacion.getText() != null) {
            if (tipo.equalsIgnoreCase("01")) {
                if (this.txtIdentificacion.getText().length() != 9) {
                    this.funcionesGenerales.MostrarModalInfo("La c\u00e9dula f\u00edsica debe de contener 9 digitos.");
                    return false;
                }
            } else if (tipo.equalsIgnoreCase("02")) {
                if (this.txtIdentificacion.getText().length() != 10) {
                    this.funcionesGenerales.MostrarModalInfo("La c\u00e9dula jur\u00eddica debe de contener 10 digitos.");
                    return false;
                }
            } else if (tipo.equalsIgnoreCase("03")) {
                if (this.txtIdentificacion.getText().length() < 11 || this.txtIdentificacion.getText().length() > 12) {
                    this.funcionesGenerales.MostrarModalInfo("El DIMEX debe de contener 11 o 12 digitos sin ceros al inicio.");
                    return false;
                }
            } else if (tipo.equalsIgnoreCase("04") && this.txtIdentificacion.getText().length() != 10) {
                this.funcionesGenerales.MostrarModalInfo("El NITE debe de contener 10 digitos.");
                return false;
            }
        }
        return true;
    }

    public void setReceptor(ReceptorDto rec) {
        if (rec.getId() != null) {
            this.idReceptor = rec.getId();
            IdentificacionDto ide = new IdentificacionDto();
            ide = this.cbxTipoIdentificacion.getItems().stream().filter(c -> c.getCodigoHac().equalsIgnoreCase(rec.getTipoIdentificacion())).findAny().orElse(null);
            this.cbxTipoIdentificacion.getSelectionModel().select((Object)ide);
            if (rec.getCodigoProvincia() != null) {
                ProvinciaDto pro = new ProvinciaDto();
                pro = this.cbxProvincias.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(rec.getCodigoProvincia())).findAny().orElse(null);
                this.cbxProvincias.getSelectionModel().select((Object)pro);
                this.getCantones(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId(), false);
                CantonDto can = new CantonDto();
                can = this.cbxCantones.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(rec.getCodigoCanton())).findAny().orElse(null);
                this.cbxCantones.getSelectionModel().select((Object)can);
                this.getDistrito(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), false);
                VDistritoDto dis = new VDistritoDto();
                dis = this.cbxDistritos.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(rec.getCodigoDistrito())).findAny().orElse(null);
                this.cbxDistritos.getSelectionModel().select((Object)dis);
                if (rec.getCodigoBarrio() != null) {
                    this.getBarrio(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getId().toString(), ((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo(), ((VDistritoDto)this.cbxDistritos.getSelectionModel().getSelectedItem()).getCodigo());
                    VBarrioDto bar = new VBarrioDto();
                    bar = this.cbxBarrios.getItems().stream().filter(c -> c.getCodigo().equalsIgnoreCase(rec.getCodigoBarrio())).findAny().orElse(null);
                    this.cbxBarrios.getSelectionModel().select((Object)bar);
                    this.checkActivaBarrio.setSelected(true);
                    this.desactivarBarrio(false);
                } else {
                    this.checkActivaBarrio.setSelected(false);
                    this.desactivarBarrio(true);
                }
                this.checkActivaUbicacion.setSelected(true);
                this.desactivarUbicacion(false);
            } else {
                this.checkActivaUbicacion.setSelected(false);
                this.desactivarUbicacion(true);
            }
            this.txtIdentificacion.setText(rec.getNumeroIdentificacion());
            this.txtNombre.setText(rec.getNombre());
            this.txtNombreComercial.setText(rec.getNombreComercial());
            this.txtIdentificacionExtranjero.setText(rec.getIdentificacionExtranjero());
            this.txtOtrasSenas.setText(rec.getOtrasSenas());
            this.txtCorreo.setText(rec.getCorreo());
            this.setIntegerToTextField(this.txtTel, rec.getTelefono());
            this.setIntegerToTextField(this.txtPaisTel, rec.getPaisTelefono());
            this.setIntegerToTextField(this.txtFax, rec.getFax());
            this.setIntegerToTextField(this.txtPaisFax, rec.getPaisFax());
        } else {
            this.idReceptor = null;
        }
    }

    private void setIntegerToTextField(TextField field, Integer value) {
        try {
            field.setText(value.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String stringOf(Integer var) {
        String string = EMPTY_STRING;
        try {
            string = String.valueOf(var);
        }
        catch (Exception ex) {
            string = EMPTY_STRING;
        }
        return string;
    }

    private void guardarReceptor() {
        Stage stage = (Stage)this.txtCorreo.getScene().getWindow();
        if (this.validaReceptor()) {
            if (this.validaCedula(this.cbxTipoIdentificacion.getSelectionModel().toString())) {
                if (this.idReceptor == null) {
                    this.receptorDto.setId(0);
                } else {
                    this.receptorDto.setId(this.idReceptor);
                }
                this.receptorDto.setTipoIdentificacion(((IdentificacionDto)this.cbxTipoIdentificacion.getSelectionModel().getSelectedItem()).getCodigoHac());
                this.receptorDto.setNumeroIdentificacion(this.txtIdentificacion.getText());
                this.receptorDto.setIdentificacionExtranjero(this.txtIdentificacionExtranjero.getText());
                this.receptorDto.setNombreComercial(this.txtNombreComercial.getText());
                this.receptorDto.setNombre(this.txtNombre.getText());
                this.receptorDto.setCorreo(this.txtCorreo.getText());
                if (this.checkActivaUbicacion.isSelected()) {
                    this.receptorDto.setCodigoProvincia(((ProvinciaDto)this.cbxProvincias.getSelectionModel().getSelectedItem()).getCodigo());
                    this.receptorDto.setCodigoCanton(((CantonDto)this.cbxCantones.getSelectionModel().getSelectedItem()).getCodigo());
                    this.receptorDto.setCodigoDistrito(((VDistritoDto)this.cbxDistritos.getSelectionModel().getSelectedItem()).getCodigo());
                    if (this.checkActivaBarrio.isSelected()) {
                        try {
                            this.receptorDto.setCodigoBarrio(((VBarrioDto)this.cbxBarrios.getSelectionModel().getSelectedItem()).getCodigo());
                        }
                        catch (Exception ex) {
                            this.receptorDto.setCodigoBarrio(null);
                        }
                    }
                    this.receptorDto.setOtrasSenas(this.txtOtrasSenas.getText());
                }
                this.receptorDto.setPaisTelefono(this.getIntergerOf(this.txtPaisTel.getText()));
                this.receptorDto.setTelefono(this.getIntergerOf(this.txtTel.getText()));
                this.receptorDto.setPaisFax(this.getIntergerOf(this.txtPaisFax.getText()));
                this.receptorDto.setFax(this.getIntergerOf(this.txtFax.getText()));
                EmpresaDto empresaDto = new EmpresaDto(GlobalApp.idEmpresa);
                this.receptorDto.setEmpresa(empresaDto);
                EmisorDto emisorDto = new EmisorDto(this.idEmisor);
                this.receptorDto.setEmisor(emisorDto);
                if (this.desdeFacturacion) {
                    stage.hide();
                } else {
                    ReceptorService service = (ReceptorService)AppContext.getInstance().get("ReceptorService");
                    Respuesta respuesta = service.saveReceptor(this.receptorDto);
                    if (respuesta.getEstado().booleanValue()) {
                        this.receptorDto = (ReceptorDto)respuesta.getResultado("Receptor");
                        NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "La informaci\u00f3n del cliente se guard\u00f3 correctamente.");
                        stage.hide();
                    } else {
                        NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Ocurri\u00f3 un error al guardar el cliente, intente de nuevo.");
                        stage.hide();
                    }
                }
            }
        } else if (!this.mensajeValidacion.toString().isEmpty()) {
            this.funcionesGenerales.MostrarModalInfo(this.mensajeValidacion.toString());
        }
    }

    private Integer getIntergerOf(String value) {
        Integer response;
        try {
            response = Integer.valueOf(value);
        }
        catch (Exception ex) {
            response = null;
        }
        return response;
    }

    private boolean validaReceptor() {
        this.mensajeValidacion.setLength(0);
        boolean correcto = true;
        if (this.txtIdentificacion.getText().isEmpty()) {
            this.mensajeValidacion.append("* El campo de 'identificaci\u00f3n' es requerido. \n");
            correcto = false;
        } else {
            String tipo = ((IdentificacionDto)this.cbxTipoIdentificacion.getSelectionModel().getSelectedItem()).getCodigo();
            if (tipo.equalsIgnoreCase("01")) {
                if (this.txtIdentificacion.getText().length() != 9) {
                    this.mensajeValidacion.append("* La c\u00e9dula f\u00edsica debe de contener 9 digitos.\n");
                    correcto = false;
                }
            } else if (tipo.equalsIgnoreCase("02")) {
                if (this.txtIdentificacion.getText().length() != 10) {
                    this.mensajeValidacion.append("* La c\u00e9dula jur\u00eddica debe de contener 10 digitos.\n");
                    correcto = false;
                }
            } else if (tipo.equalsIgnoreCase("03")) {
                if (this.txtIdentificacion.getText().length() < 11 || this.txtIdentificacion.getText().length() > 12) {
                    this.mensajeValidacion.append("* El DIMEX debe de contener 11 o 12 digitos sin ceros al inicio.\n");
                    correcto = false;
                }
            } else if (tipo.equalsIgnoreCase("04") && this.txtIdentificacion.getText().length() != 10) {
                this.mensajeValidacion.append("* El NITE debe de contener 10 digitos.\ns");
                correcto = false;
            }
            if (!this.txtCorreo.getText().isEmpty() && !this.txtCorreo.getText().matches("\\s*\\w+([-+.']\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*\\s*")) {
                this.funcionesGenerales.MostrarModalInfo("El formato de la direccion de correo es incorrecto.");
                return false;
            }
        }
        if (this.txtNombre.getText().isEmpty()) {
            this.mensajeValidacion.append("* El campo 'nombre' es requerido. \n");
            correcto = false;
        }
        if (this.checkActivaUbicacion.isSelected() && this.txtOtrasSenas.getText().isEmpty()) {
            this.mensajeValidacion.append("* El campo 'Otras se\u00f1as' es requerido. \n");
            correcto = false;
        }
        return correcto;
    }

    private void getTipoIdentificaciones() {
        TipoIdentificacionService identificacionService = (TipoIdentificacionService)AppContext.getInstance().get("TipoIdentificacionService");
        Respuesta respuesta = identificacionService.getTipoIdentificaciones();
        if (respuesta.getEstado().booleanValue()) {
            this.tipoIdentificacionesLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Identificaciones")));
            this.cbxTipoIdentificacion.setItems(this.tipoIdentificacionesLista);
            this.cbxTipoIdentificacion.getSelectionModel().selectFirst();
        }
    }

    private void getProvincias() {
        ProvinciaService provinciaService = (ProvinciaService)AppContext.getInstance().get("ProvinciaService");
        Respuesta respuesta = provinciaService.getProvincias();
        if (respuesta.getEstado().booleanValue()) {
            this.provinciasLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Provincias")));
            this.cbxProvincias.setItems(this.provinciasLista);
            this.cbxProvincias.getSelectionModel().selectFirst();
        }
    }

    private void getCantones(Integer idProvincia, boolean defecto) {
        CantonService cantonService = (CantonService)AppContext.getInstance().get("CantonService");
        Respuesta respuesta = cantonService.getCantonIdProvincia(idProvincia);
        if (respuesta.getEstado().booleanValue()) {
            this.cantonesLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Cantones")));
            this.cbxCantones.setItems(this.cantonesLista);
            this.cbxCantones.getSelectionModel().selectFirst();
        }
    }

    private void getDistrito(String codigoProvincia, String codigoCanton, boolean defecto) {
        DistritoService distritoService = (DistritoService)AppContext.getInstance().get("DistritoService");
        Respuesta respuesta = distritoService.getDistritos(codigoProvincia, codigoCanton);
        if (respuesta.getEstado().booleanValue()) {
            this.distritosLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Distritos")));
            this.cbxDistritos.setItems(this.distritosLista);
            this.cbxDistritos.getSelectionModel().selectFirst();
        }
    }

    private void getBarrio(String codigoProvincia, String codigoCanton, String codigoDistrito) {
        BarrioService barrioService = (BarrioService)AppContext.getInstance().get("BarrioService");
        Respuesta respuesta = barrioService.getBarrios(codigoProvincia, codigoCanton, codigoDistrito);
        if (respuesta.getEstado().booleanValue()) {
            this.barrioLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Barrios")));
            this.cbxBarrios.setItems(this.barrioLista);
            this.cbxBarrios.getSelectionModel().selectFirst();
        }
    }

    private void desactivarUbicacion(boolean estado) {
        this.cbxProvincias.setDisable(estado);
        this.cbxCantones.setDisable(estado);
        this.cbxDistritos.setDisable(estado);
        this.checkActivaBarrio.setDisable(estado);
        this.txtOtrasSenas.setDisable(estado);
    }

    private void desactivarBarrio(boolean estado) {
        this.cbxBarrios.setDisable(estado);
    }

    public Integer getIdEmisor() {
        return this.idEmisor;
    }

    public void setIdEmisor(Integer idEmisor) {
        this.idEmisor = idEmisor;
    }
}

