/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.model.EmisorDto;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.Formato;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public class MantSucursalViewController
implements Initializable {
    @FXML
    JFXButton btnGuardar;
    @FXML
    JFXButton btnCancelar;
    @FXML
    private TextField txtTelefono;
    @FXML
    private TextField txtSenas;
    @FXML
    private TextField txtCodigo;
    @FXML
    private TextField txtNombre;
    @FXML
    private TextField txtFactura;
    @FXML
    private TextField txtTiquete;
    @FXML
    private TextField txtNotaDebito;
    @FXML
    private TextField txtNotaCredito;
    @FXML
    private TextField txtEmisor;
    @FXML
    private TextField txtRechazo;
    @FXML
    private TextField txtAceptacion;
    @FXML
    private TextField txtAceptacionParcial;
    @FXML
    ImageView btnCargarCertificado;
    ObservableList<EmisorDto> emisoresLista;
    private boolean nuevo = true;
    private SucursalEmisorDto sucursalSeleccionada = null;
    public Integer idSucursal = null;
    public EmisorDto emisor = null;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    String actividad = null;

    public void initialize(URL url, ResourceBundle rb) {
        this.txtCodigo.setTextFormatter(Formato.getInstance().integerFormat(3));
        this.txtNombre.setTextFormatter(Formato.getInstance().maxLengthFormat(140));
    }

    @FXML
    private void OnBtnGuardar(ActionEvent event) {
        this.guardarSucursal();
    }

    @FXML
    private void OnBtnCancelar(ActionEvent event) {
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    private void guardarSucursal() {
        if (this.validarSucursal().booleanValue()) {
            Integer id = this.nuevo ? null : this.sucursalSeleccionada.getId();
            Stage stage = (Stage)this.btnGuardar.getScene().getWindow();
            SucursalEmisorDto sucursalEmisorDto = new SucursalEmisorDto();
            sucursalEmisorDto.setId(id);
            sucursalEmisorDto.setNombre(this.txtNombre.getText());
            sucursalEmisorDto.setCodigo(Integer.valueOf(this.txtCodigo.getText()));
            sucursalEmisorDto.setSecuenciaFactura(Integer.valueOf(this.txtFactura.getText()));
            sucursalEmisorDto.setSecuenciaTiquete(Integer.valueOf(this.txtTiquete.getText()));
            sucursalEmisorDto.setSecuenciaNotaCredito(Integer.valueOf(this.txtNotaCredito.getText()));
            sucursalEmisorDto.setSecuenciaNotaDebito(Integer.valueOf(this.txtNotaDebito.getText()));
            sucursalEmisorDto.setSecuenciaAcepta(Integer.valueOf(this.txtAceptacion.getText()));
            sucursalEmisorDto.setSecuenciaAceptaParcial(Integer.valueOf(this.txtAceptacionParcial.getText()));
            sucursalEmisorDto.setSecuenciaRechaza(Integer.valueOf(this.txtRechazo.getText()));
            sucursalEmisorDto.setTelefono(this.txtTelefono.getText());
            sucursalEmisorDto.setSenas(this.txtSenas.getText());
            sucursalEmisorDto.setEmisor(this.emisor);
            sucursalEmisorDto.setCodigoActividad(this.actividad);
            SucursalEmisorService service = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
            Respuesta respuesta = service.saveSucursalEmisor(sucursalEmisorDto);
            if (respuesta.getEstado().booleanValue()) {
                this.funcionesGenerales.MostrarModalInfo("Sucursal guardada correctamente.");
            } else {
                this.funcionesGenerales.MostrarModalInfo("Error guardando la sucursal.");
            }
            stage.hide();
        }
    }

    public SucursalEmisorDto getSucursalSeleccionada() {
        return this.sucursalSeleccionada;
    }

    public void setSucursalSeleccionada(SucursalEmisorDto sucursalSeleccionada) {
        this.sucursalSeleccionada = sucursalSeleccionada;
        if (sucursalSeleccionada != null) {
            this.idSucursal = sucursalSeleccionada.getId();
            this.txtCodigo.setText(String.format("%03d", sucursalSeleccionada.getCodigo()));
            this.txtNombre.setText(sucursalSeleccionada.getNombre());
            this.txtFactura.setText(sucursalSeleccionada.getSecuenciaFactura().toString());
            this.txtTiquete.setText(sucursalSeleccionada.getSecuenciaTiquete().toString());
            this.txtNotaDebito.setText(sucursalSeleccionada.getSecuenciaNotaDebito().toString());
            this.txtNotaCredito.setText(sucursalSeleccionada.getSecuenciaNotaCredito().toString());
            this.txtAceptacion.setText(sucursalSeleccionada.getSecuenciaAcepta().toString());
            this.txtAceptacionParcial.setText(sucursalSeleccionada.getSecuenciaAceptaParcial().toString());
            this.txtRechazo.setText(sucursalSeleccionada.getSecuenciaRechaza().toString());
            this.txtTelefono.setText(sucursalSeleccionada.getTelefono());
            this.txtSenas.setText(sucursalSeleccionada.getSenas());
            this.actividad = sucursalSeleccionada.getCodigoActividad();
        }
    }

    public Boolean validarSucursal() {
        if (this.txtNombre.getText().isEmpty()) {
            this.funcionesGenerales.MostrarModalInfo("Es necesario llenar el nombre de la sucursal.");
            return false;
        }
        if (this.txtCodigo.getText().length() != 3 || this.txtCodigo.getText() == null) {
            this.funcionesGenerales.MostrarModalInfo("El codigo debe de tener 3 digitos.");
            return false;
        }
        return true;
    }

    public Integer getIdSucursal() {
        return this.idSucursal;
    }

    public void setIdSucursal(Integer idSucursal) {
        this.idSucursal = idSucursal;
    }

    public EmisorDto getEmisor() {
        return this.emisor;
    }

    public void setEmisor(EmisorDto emisor) {
        this.emisor = emisor;
        if (emisor != null) {
            this.txtEmisor.setText(emisor.getNombre());
        }
    }

    public boolean isNuevo() {
        return this.nuevo;
    }

    public void setNuevo(boolean nuevo) {
        this.nuevo = nuevo;
    }
}

