/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.model.UsuarioDto;
import electricpos.service.UsuarioService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class MantUsuarioViewController
implements Initializable {
    @FXML
    private TextField txtNombre;
    @FXML
    private TextField txtCorreo;
    @FXML
    private JFXCheckBox checkAdministrador;
    @FXML
    private TextField txtApellido;
    @FXML
    private PasswordField txtPass;
    @FXML
    private ComboBox<String> cbxEstado;
    @FXML
    private JFXButton btnCrear;
    UsuarioDto usuario = new UsuarioDto();
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        List<String> estados = Arrays.asList("Activo", "Inactivo");
        ObservableList listaEstados = FXCollections.observableArrayList(estados);
        this.cbxEstado.setItems(listaEstados);
        this.cbxEstado.getSelectionModel().selectFirst();
    }

    @FXML
    private void OnBtnCrear() {
        if (this.txtNombre.getText().isEmpty()) {
            this.funcionesGenerales.MostrarModalInfo("El campo [nombre] es requerido.");
            return;
        }
        if (this.txtApellido.getText().isEmpty()) {
            this.funcionesGenerales.MostrarModalInfo("El campo [apellido] es requerido.");
            return;
        }
        if (this.txtCorreo.getText().isEmpty()) {
            this.funcionesGenerales.MostrarModalInfo("El campo [correo electr\u00f3nico] es requerido.");
            return;
        }
        if (this.txtPass.getText().isEmpty()) {
            this.funcionesGenerales.MostrarModalInfo("El campo [contrase\u00f1a] electr\u00f3nico es requerido.");
            return;
        }
        this.usuario.setCorreo(this.txtCorreo.getText());
        this.usuario.setNombre(this.txtNombre.getText());
        this.usuario.setPrimerApellido(this.txtApellido.getText());
        this.usuario.setHash(this.txtPass.getText());
        this.usuario.setEstado(((String)this.cbxEstado.getSelectionModel().getSelectedItem()).equalsIgnoreCase("activo") ? "A" : "I");
        this.usuario.setRolDescripcion(this.checkAdministrador.isSelected() ? "A" : "P");
        this.usuario.setEmpresa(new EmpresaDto(GlobalApp.idEmpresa));
        UsuarioService service = (UsuarioService)AppContext.getInstance().get("UsuarioService");
        Respuesta respuesta = service.saveUsuario(this.usuario);
        if (respuesta.getEstado().booleanValue()) {
            this.funcionesGenerales.MostrarModalInfo("Usuario [" + this.txtCorreo.getText() + "] guardado correctamente.");
            if (GlobalApp.idUsuario.equals(this.usuario.getId())) {
                GlobalApp.usuarioAdmin = this.checkAdministrador.isSelected();
            }
            Stage stage = (Stage)this.txtNombre.getScene().getWindow();
            stage.hide();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Ocurri\u00f3 un error guardando el usuario: " + respuesta.getMensaje());
        }
    }

    @FXML
    private void OnBtnCancelar() {
        Stage stage = (Stage)this.txtNombre.getScene().getWindow();
        stage.hide();
    }

    public void setUsuario(UsuarioDto usuario) {
        this.usuario = usuario;
        this.btnCrear.setText("Actualizar");
        this.txtNombre.setText(usuario.getNombre());
        this.txtApellido.setText(usuario.getPrimerApellido());
        this.txtCorreo.setText(usuario.getCorreo());
        this.txtPass.setText(usuario.getHash());
        if (usuario.getRolDescripcion().equalsIgnoreCase("A")) {
            this.checkAdministrador.setSelected(true);
        }
        if (usuario.getEstado().equalsIgnoreCase("A")) {
            this.cbxEstado.getSelectionModel().selectFirst();
        } else {
            this.cbxEstado.getSelectionModel().selectLast();
        }
    }
}

