/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import electricpos.model.MedioPagoDto;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class MediosPagoViewController
implements Initializable {
    @FXML
    JFXButton btnGuardar;
    @FXML
    private JFXCheckBox checkOtros;
    @FXML
    private JFXCheckBox checkEfectivo;
    @FXML
    private JFXCheckBox checkTerceros;
    @FXML
    private JFXCheckBox checkTarjeta;
    @FXML
    private JFXCheckBox checkCheque;
    @FXML
    private JFXCheckBox checkTransferencia;
    @FXML
    private TextField txtMontoEfectivo;
    @FXML
    private TextField txtMontoTarjeta;
    @FXML
    private TextField txtMontoTransferencia;
    @FXML
    private Label lblTotal;
    @FXML
    private Label lblError;
    @FXML
    private Label lblErrorTitulo;
    public List<MedioPagoDto> mediosPago = new ArrayList<MedioPagoDto>();
    public BigDecimal montoFactura = new BigDecimal(BigInteger.ZERO);
    DecimalFormat formatter = new DecimalFormat("#,##0.00");

    public void initialize(URL url, ResourceBundle rb) {
        this.txtMontoEfectivo.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MediosPagoViewController.this.validarMontos();
            }
        });
        this.txtMontoTarjeta.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MediosPagoViewController.this.validarMontos();
            }
        });
        this.txtMontoTransferencia.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MediosPagoViewController.this.validarMontos();
            }
        });
    }

    @FXML
    private void onCheckEfectivo() {
        if (this.checkEfectivo.isSelected()) {
            this.txtMontoEfectivo.setDisable(false);
        } else {
            this.txtMontoEfectivo.setText("0.00");
            this.txtMontoEfectivo.setDisable(true);
        }
    }

    @FXML
    private void onCheckTarjeta() {
        if (this.checkTarjeta.isSelected()) {
            this.txtMontoTarjeta.setDisable(false);
        } else {
            this.txtMontoTarjeta.setText("0.00");
            this.txtMontoTarjeta.setDisable(true);
        }
    }

    @FXML
    private void onCheckTransferencia() {
        if (this.checkTransferencia.isSelected()) {
            this.txtMontoTransferencia.setDisable(false);
        } else {
            this.txtMontoTransferencia.setText("0.00");
            this.txtMontoTransferencia.setDisable(true);
        }
    }

    @FXML
    private void onBtnCancelar() {
        Stage stage = (Stage)this.checkEfectivo.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnGuardar() {
        this.guardarMediosPago();
        Stage stage = (Stage)this.checkEfectivo.getScene().getWindow();
        stage.hide();
    }

    private void validarMontos() {
        BigDecimal dif;
        Double efectivo = this.txtMontoEfectivo.getText().isEmpty() || this.txtMontoEfectivo.getText() == null ? 0.0 : Double.valueOf(this.txtMontoEfectivo.getText());
        Double tarjeta = this.txtMontoTarjeta.getText().isEmpty() || this.txtMontoTarjeta.getText() == null ? 0.0 : Double.valueOf(this.txtMontoTarjeta.getText());
        Double transferencia = this.txtMontoTransferencia.getText().isEmpty() || this.txtMontoTransferencia.getText() == null ? 0.0 : Double.valueOf(this.txtMontoTransferencia.getText());
        Double aux = efectivo + tarjeta + transferencia;
        BigDecimal total = new BigDecimal(aux);
        if (total.compareTo(this.montoFactura) == -1) {
            dif = this.montoFactura.subtract(total);
            this.lblErrorTitulo.setVisible(true);
            this.lblError.setVisible(true);
            this.btnGuardar.setDisable(true);
            this.lblError.setText("Debe completar el total del monto de la factura. Restante: " + this.formatter.format(dif));
        }
        if (total.compareTo(this.montoFactura) == 1) {
            dif = total.subtract(this.montoFactura);
            this.lblErrorTitulo.setVisible(true);
            this.lblError.setVisible(true);
            this.btnGuardar.setDisable(true);
            this.lblError.setText("No se puede superar el total del monto de la factura. Sobrante: " + this.formatter.format(dif));
        }
        if (total.compareTo(this.montoFactura) == 0) {
            this.lblErrorTitulo.setVisible(false);
            this.lblError.setVisible(false);
            this.btnGuardar.setDisable(false);
        }
    }

    public BigDecimal getMontoFactura() {
        return this.montoFactura;
    }

    public void cargarMediosPago(List<MedioPagoDto> medios, BigDecimal montoFactura) {
        montoFactura = montoFactura.setScale(2, RoundingMode.HALF_UP);
        this.mediosPago = medios;
        BigDecimal montoActual = medios.stream().map(x -> x.getMonto()).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (MedioPagoDto medio : medios) {
            if (medio.getCodigo().equalsIgnoreCase("01")) {
                this.checkEfectivo.setSelected(medio.isActivo());
                this.txtMontoEfectivo.setText(medio.getMonto().toString());
                montoActual.add(medio.getMonto());
            }
            if (medio.getCodigo().equalsIgnoreCase("02")) {
                this.checkTarjeta.setSelected(medio.isActivo());
                this.txtMontoTarjeta.setText(medio.getMonto().toString());
                montoActual.add(medio.getMonto());
            }
            if (medio.getCodigo().equalsIgnoreCase("03")) {
                this.checkCheque.setSelected(medio.isActivo());
            }
            if (medio.getCodigo().equalsIgnoreCase("04")) {
                this.checkTransferencia.setSelected(medio.isActivo());
                this.txtMontoTransferencia.setText(medio.getMonto().toString());
                montoActual.add(medio.getMonto());
            }
            if (medio.getCodigo().equalsIgnoreCase("05")) {
                this.checkTerceros.setSelected(medio.isActivo());
            }
            if (!medio.getCodigo().equalsIgnoreCase("99")) continue;
            this.checkOtros.setSelected(medio.isActivo());
        }
        if (this.checkEfectivo.isSelected()) {
            this.txtMontoEfectivo.setDisable(false);
        } else {
            this.txtMontoEfectivo.setText("0.00");
            this.txtMontoEfectivo.setDisable(true);
        }
        if (this.checkTarjeta.isSelected()) {
            this.txtMontoTarjeta.setDisable(false);
        } else {
            this.txtMontoTarjeta.setText("0.00");
            this.txtMontoTarjeta.setDisable(true);
        }
        if (this.checkTransferencia.isSelected()) {
            this.txtMontoTransferencia.setDisable(false);
        } else {
            this.txtMontoTransferencia.setText("0.00");
            this.txtMontoTransferencia.setDisable(true);
        }
        if (montoActual.compareTo(BigDecimal.ZERO) == 0) {
            this.checkEfectivo.setSelected(true);
            this.txtMontoEfectivo.setText(montoFactura.toString());
        }
        this.montoFactura = montoFactura;
        this.lblTotal.setText("Total factura:  " + this.formatter.format(montoFactura));
        this.validarMontos();
    }

    public void guardarMediosPago() {
        for (MedioPagoDto medio : this.mediosPago) {
            if (medio.getCodigo().equalsIgnoreCase("01")) {
                medio.setActivo(this.checkEfectivo.isSelected());
                if (this.checkEfectivo.isSelected()) {
                    medio.setMonto(new BigDecimal(this.txtMontoEfectivo.getText()));
                } else {
                    medio.setMonto(BigDecimal.ZERO);
                }
            }
            if (medio.getCodigo().equalsIgnoreCase("02")) {
                medio.setActivo(this.checkTarjeta.isSelected());
                if (this.checkTarjeta.isSelected()) {
                    medio.setMonto(new BigDecimal(this.txtMontoTarjeta.getText()));
                } else {
                    medio.setMonto(BigDecimal.ZERO);
                }
            }
            if (medio.getCodigo().equalsIgnoreCase("03")) {
                medio.setActivo(this.checkCheque.isSelected());
            }
            if (medio.getCodigo().equalsIgnoreCase("04")) {
                medio.setActivo(this.checkTransferencia.isSelected());
                if (this.checkTransferencia.isSelected()) {
                    medio.setMonto(new BigDecimal(this.txtMontoTransferencia.getText()));
                } else {
                    medio.setMonto(BigDecimal.ZERO);
                }
            }
            if (medio.getCodigo().equalsIgnoreCase("05")) {
                medio.setActivo(this.checkTerceros.isSelected());
            }
            if (!medio.getCodigo().equalsIgnoreCase("99")) continue;
            medio.setActivo(this.checkOtros.isSelected());
        }
    }
}

