/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.customcontrol.CicloFacturacionController;
import electricpos.model.CicloFacturacionDto;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.service.CicloFacturacionService;
import electricpos.service.EmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

public class MiFacturacionViewController
implements Initializable {
    @FXML
    private Label lblEmpresa;
    @FXML
    private Label lblTipoCuenta;
    @FXML
    private JFXButton btnEstado;
    @FXML
    private Label lblComprobantes;
    @FXML
    private Label lblTotal;
    @FXML
    private Label lblFecha;
    @FXML
    ComboBox<EmisorDto> cbxEmisor;
    @FXML
    VBox vboxCiclosAntiguos;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<CicloFacturacionDto> ciclosFacturacionLista;
    CicloFacturacionDto cicloFacturacionActualDto;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    DecimalFormat df = new DecimalFormat("\u20a1 ###,###.00");
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MMMM-yyyy", new Locale("es", "ES"));

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        if (!this.cbxEmisor.getSelectionModel().isEmpty()) {
            this.getCicloFacturacionActual(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
            this.getCicloFacturacionAnteriores(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        } else {
            this.funcionesGenerales.MostrarModalInfo("No existen emisores registrados a\u00fan.");
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al cargar los emisores.");
        }
    }

    private void getCicloFacturacionActual(int idEmisor) {
        CicloFacturacionService service = (CicloFacturacionService)AppContext.getInstance().get("CicloFacturacionService");
        Respuesta respuesta = service.getCicloFacturacionActivo(idEmisor);
        if (respuesta.getEstado().booleanValue()) {
            this.cicloFacturacionActualDto = (CicloFacturacionDto)respuesta.getResultado(ESTADO.OK.VALUE());
            this.lblTipoCuenta.setText(this.cicloFacturacionActualDto.getDescripcionPlan());
            this.lblComprobantes.setText(this.cicloFacturacionActualDto.getCompProcesados().toString());
            this.lblTotal.setText(this.df.format(this.cicloFacturacionActualDto.getTotal()));
            this.lblFecha.setText(this.cicloFacturacionActualDto.getFechaInicio().format(this.formatter) + " - " + this.cicloFacturacionActualDto.getFechaFin().format(this.formatter));
            if (this.cicloFacturacionActualDto.getEmisor().getNombreComercial() != null || !this.cicloFacturacionActualDto.getEmisor().getNombreComercial().isEmpty()) {
                this.lblEmpresa.setText(this.cicloFacturacionActualDto.getEmisor().getNombreComercial());
            } else {
                this.lblEmpresa.setText(this.cicloFacturacionActualDto.getEmisor().getNombre());
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("El emisor seleccionado no tiene ning\u00fan ciclo de facturaci\u00f3n activo.");
        }
    }

    private void getCicloFacturacionAnteriores(int idEmisor) {
        this.vboxCiclosAntiguos.getChildren().clear();
        CicloFacturacionService service = (CicloFacturacionService)AppContext.getInstance().get("CicloFacturacionService");
        Respuesta respuesta = service.getCiclosFacturacion(idEmisor);
        if (respuesta.getEstado().booleanValue()) {
            this.ciclosFacturacionLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            if (!this.ciclosFacturacionLista.isEmpty()) {
                for (CicloFacturacionDto ciclo : this.ciclosFacturacionLista) {
                    CicloFacturacionController cicloFacturacionController = new CicloFacturacionController(ciclo);
                    this.vboxCiclosAntiguos.getChildren().add((Object)cicloFacturacionController);
                }
            }
        }
    }
}

