/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class ModalPlazoCreditoController
implements Initializable {
    @FXML
    private TextField txtValor;
    @FXML
    private JFXButton btnCancelar;
    @FXML
    private JFXButton btnEnviar;
    private String valorAnterior;
    private String valor;

    public void initialize(URL url, ResourceBundle rb) {
        this.txtValor.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d{0,5}")) {
                this.txtValor.setText(oldValue);
            } else {
                try {
                    int val;
                    if (!newValue.isEmpty() && (val = Integer.parseInt(newValue)) <= 0) {
                        this.txtValor.setText(oldValue);
                    }
                }
                catch (NumberFormatException e) {
                    this.txtValor.setText(oldValue);
                }
            }
        });
    }

    @FXML
    private void onBtnReenviar(ActionEvent event) {
        String texto = this.txtValor.getText().trim();
        if (texto.isEmpty()) {
            this.txtValor.setText("1");
            this.valor = "1";
        } else {
            this.valor = texto;
        }
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnCancelar(ActionEvent event) {
        this.valor = this.valorAnterior;
        Stage stage = (Stage)this.btnCancelar.getScene().getWindow();
        stage.hide();
    }

    public String getTxtValor() {
        return this.valor;
    }

    public void setTxtValor(String txtValor) {
        this.txtValor.setText(txtValor);
        this.valorAnterior = txtValor;
    }
}

