/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXRadioButton;
import electricpos.model.CodigoDescuentoDto;
import electricpos.model.DetalleComprobanteTv;
import electricpos.service.TipoDescuentoService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.stage.Stage;

public class ModalTipoDescuentoViewController
implements Initializable {
    @FXML
    private JFXButton btnGuardar;
    @FXML
    private TextField txtMontoOriginal;
    @FXML
    private Label lblDetalle;
    @FXML
    private JFXRadioButton cbxPorcentaje;
    @FXML
    private ToggleGroup tipo;
    @FXML
    private JFXRadioButton cbxFijo;
    @FXML
    private TextField txtDescuento;
    @FXML
    private Label lblPrecioFinal;
    @FXML
    private Label lblMontoDescuento;
    @FXML
    private Label lblOriginal;
    @FXML
    private ComboBox<CodigoDescuentoDto> cbxTipoDescuento;
    DetalleComprobanteTv detalleComprobanteTv;
    ObservableList<CodigoDescuentoDto> listaDescuentos;
    private boolean cancelled = false;
    private double montoDesc = 0.0;
    private String codigoDescuento = null;

    public void initialize(URL url, ResourceBundle rb) {
        this.getDescuentos();
        this.txtDescuento.textProperty().addListener((obs, oldVal, newVal) -> this.calcularDescuento());
        this.tipo.selectedToggleProperty().addListener((obs, oldToggle, newToggle) -> this.calcularDescuento());
        this.tipo.selectedToggleProperty().addListener((o, ov, nv) -> {
            double current;
            double original;
            try {
                original = Double.parseDouble(this.txtMontoOriginal.getText());
            }
            catch (NumberFormatException e) {
                original = 0.0;
            }
            try {
                current = Double.parseDouble(this.txtDescuento.getText());
            }
            catch (NumberFormatException e) {
                current = 0.0;
            }
            double converted = this.cbxPorcentaje.isSelected() ? (original == 0.0 ? 0.0 : current / original * 100.0) : current / 100.0 * original;
            this.txtDescuento.setText(String.format("%.2f", converted));
            this.calcularDescuento();
        });
    }

    @FXML
    private void onBtnGuardar(ActionEvent event) {
        this.codigoDescuento = ((CodigoDescuentoDto)this.cbxTipoDescuento.getSelectionModel().getSelectedItem()).getCodigo();
        Stage stage = (Stage)this.btnGuardar.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnCancelar(ActionEvent event) {
        this.cancelled = true;
        Stage stage = (Stage)this.btnGuardar.getScene().getWindow();
        stage.hide();
    }

    public void setDetalleComprobanteTv(DetalleComprobanteTv detalle) {
        this.detalleComprobanteTv = detalle;
        double original = detalle.getMontoTotal();
        this.txtMontoOriginal.setText(String.format("%.2f", original));
        this.lblOriginal.setText(String.format("%.2f", original));
        this.lblDetalle.setText(detalle.getDetalle().get());
        this.txtDescuento.setText(String.format("%.2f", detalle.getMontoDescuento()));
        this.cbxFijo.setSelected(true);
        this.calcularDescuento();
        this.lblMontoDescuento.setText("0.00");
        this.lblPrecioFinal.setText(String.format("%.2f", original));
    }

    private void calcularDescuento() {
        double descuentoInput;
        double original;
        try {
            original = Double.parseDouble(this.txtMontoOriginal.getText());
        }
        catch (NumberFormatException e) {
            original = 0.0;
        }
        try {
            descuentoInput = Double.parseDouble(this.txtDescuento.getText());
        }
        catch (NumberFormatException e) {
            descuentoInput = 0.0;
        }
        this.montoDesc = this.cbxPorcentaje.isSelected() ? original * (descuentoInput / 100.0) : descuentoInput;
        this.montoDesc = Math.min(this.montoDesc, original);
        double subtotal = original - this.montoDesc;
        double impuesto = subtotal * this.detalleComprobanteTv.getIva();
        double totalLinea = subtotal + impuesto;
        this.lblMontoDescuento.setText(String.format("%.2f", this.montoDesc));
        this.lblPrecioFinal.setText(String.format("%.2f", subtotal));
        this.lblMontoDescuento.getStyleClass().remove((Object)"error");
        this.txtDescuento.getStyleClass().remove((Object)"error");
    }

    public CodigoDescuentoDto getDescuento() {
        return new CodigoDescuentoDto(this.codigoDescuento, this.montoDesc);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void getDescuentos() {
        TipoDescuentoService descuentoService = (TipoDescuentoService)AppContext.getInstance().get("TipoDescuentoService");
        new Thread(() -> {
            Respuesta respuesta = descuentoService.getTiposDescuento();
            if (respuesta.getEstado().booleanValue()) {
                this.listaDescuentos = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
                Platform.runLater(() -> {
                    this.cbxTipoDescuento.getItems().clear();
                    this.cbxTipoDescuento.setItems(this.listaDescuentos);
                    CodigoDescuentoDto descuentoSeleccionado = this.listaDescuentos.stream().filter(dto -> "06".equals(dto.getCodigo())).findFirst().orElse(null);
                    if (descuentoSeleccionado != null) {
                        this.cbxTipoDescuento.getSelectionModel().select((Object)descuentoSeleccionado);
                    }
                });
            } else {
                Platform.runLater(() -> System.err.println("Error cargando descuentos: " + respuesta.getMensaje()));
            }
        }).start();
    }

    public String getCodigoDescuento() {
        return this.codigoDescuento;
    }
}

