/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.AbonoCreditoViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.MovimientoCreditoDto;
import electricpos.model.MovimientoCreditoTv;
import electricpos.model.NotificacionType;
import electricpos.model.ReceptorDto;
import electricpos.service.EmisorService;
import electricpos.service.MovimientoCreditoService;
import electricpos.service.ReceptorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class MovCreditoViewController
implements Initializable {
    @FXML
    private ComboBox<ReceptorDto> cbxCliente;
    @FXML
    private Label lblSaldo;
    @FXML
    private ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private TableView<MovimientoCreditoTv> tv_movimientos;
    @FXML
    private TableColumn<MovimientoCreditoTv, String> tbcTipo;
    @FXML
    private TableColumn<MovimientoCreditoTv, String> tbcFecha;
    @FXML
    private TableColumn<MovimientoCreditoTv, String> tbcEstado;
    @FXML
    private TableColumn<MovimientoCreditoTv, String> tbcProducto;
    @FXML
    private TableColumn<MovimientoCreditoTv, Number> tbcTotal;
    @FXML
    private TableColumn<MovimientoCreditoTv, Number> tbcAbono;
    @FXML
    private TableColumn<MovimientoCreditoTv, Number> tbcSaldo;
    @FXML
    DatePicker dpFechaIni;
    @FXML
    DatePicker dpFechaFin;
    ObservableList<EmisorDto> emisores;
    ObservableList<ReceptorDto> receptores;
    ObservableList<MovimientoCreditoDto> movimientos;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (!this.cbxEmisor.getItems().isEmpty()) {
            this.getReceptores(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
            if (!this.cbxCliente.getItems().isEmpty()) {
                this.getMovimientos();
            }
        }
    }

    @FXML
    private void onBtnAbono() {
        if (this.cbxCliente.getSelectionModel().getSelectedItem() != null) {
            if (this.movimientos == null || this.movimientos.isEmpty()) {
                NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "No existe un saldo al cual abonar para el cliente seleccionado.");
            } else {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/AbonoCreditoView.fxml"));
                Parent root1 = null;
                try {
                    root1 = (Parent)fxmlLoader.load();
                }
                catch (IOException ex) {
                    Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
                }
                AbonoCreditoViewController controller = (AbonoCreditoViewController)fxmlLoader.getController();
                controller.setEmisor((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem());
                controller.setCliente((ReceptorDto)this.cbxCliente.getSelectionModel().getSelectedItem());
                FuncionesGenerales.showView(root1);
                this.getMovimientos();
            }
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar un cliente para agregar un abono.");
        }
    }

    @FXML
    private void onBtnDevolucion() {
        if (this.cbxCliente.getSelectionModel().getSelectedItem() != null) {
            if (this.tv_movimientos.getSelectionModel().getSelectedItem() != null) {
                MovimientoCreditoTv selected = (MovimientoCreditoTv)this.tv_movimientos.getSelectionModel().getSelectedItem();
                if (selected.getMovimientoCreditoDto().getTipo().equalsIgnoreCase("V")) {
                    if (selected.getMovimientoCreditoDto().getDevuelto().equalsIgnoreCase("N")) {
                        if (this.funcionesGenerales.getConfirmacionMensajeView("\u00bfEsta seguro de generar la devoluci\u00f3n del producto: [" + selected.getNombreProducto() + "] por un monto de " + selected.getTotalMovimiento() + " ?")) {
                            this.generarDevolucion(selected.getMovimientoCreditoDto());
                        }
                    } else {
                        NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "La venta seleccionada ya fue devuelta anteriormente.");
                    }
                } else {
                    NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar una venta para generar la devoluci\u00f3n.");
                }
            } else {
                NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar un movimiento a devolver.");
            }
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Debe de seleccionar un cliente para agregar un abono.");
        }
    }

    @FXML
    private void onCbxClienteChanged() {
        this.getMovimientos();
    }

    @FXML
    private void onCbxEmisorChanged() {
        this.getReceptores(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisores = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisores);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void getReceptores(Integer idEmisor) {
        ReceptorService receptorService = (ReceptorService)AppContext.getInstance().get("ReceptorService");
        Respuesta respuesta = receptorService.getReceptorIdEmisor(idEmisor);
        if (respuesta.getEstado().booleanValue()) {
            this.receptores = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Receptor")));
            this.cbxCliente.setItems(this.receptores);
            this.cbxCliente.getSelectionModel().selectFirst();
        }
    }

    private void getMovimientos(Integer idEmisor, Integer idCliente) {
        MovimientoCreditoService service = (MovimientoCreditoService)AppContext.getInstance().get("MovimientoCreditoService");
        Respuesta respuesta = service.getMovimientos(idEmisor, idCliente);
        if (respuesta.getEstado().booleanValue()) {
            this.movimientos = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_movimientos.getItems().clear();
            this.tv_movimientos.setItems(this.converterTv(this.movimientos));
            if (this.movimientos == null || this.movimientos.isEmpty()) {
                NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "El cliente [" + ((ReceptorDto)this.cbxCliente.getSelectionModel().getSelectedItem()).getNombre() + "] no posee cr\u00e9ditos.");
            }
        } else {
            this.tv_movimientos.getItems().clear();
        }
        this.calcularSaldo();
    }

    private void crearRelacionTv() {
        this.tbcTipo.setCellValueFactory(cd -> ((MovimientoCreditoTv)cd.getValue()).tipo);
        this.tbcFecha.setCellValueFactory(cd -> ((MovimientoCreditoTv)cd.getValue()).fecha);
        this.tbcProducto.setCellValueFactory(cd -> ((MovimientoCreditoTv)cd.getValue()).producto);
        this.tbcAbono.setCellValueFactory(cd -> ((MovimientoCreditoTv)cd.getValue()).abono);
        this.tbcTotal.setCellValueFactory(cd -> ((MovimientoCreditoTv)cd.getValue()).total);
        this.tbcSaldo.setCellValueFactory(cd -> ((MovimientoCreditoTv)cd.getValue()).saldo);
        this.tbcEstado.setCellValueFactory(cd -> ((MovimientoCreditoTv)cd.getValue()).estado);
    }

    private ObservableList<MovimientoCreditoTv> converterTv(ObservableList<MovimientoCreditoDto> movs) {
        ObservableList movsTv = FXCollections.observableArrayList();
        for (MovimientoCreditoDto movDto : movs) {
            MovimientoCreditoTv movTv = new MovimientoCreditoTv(movDto);
            movsTv.add((Object)movTv);
        }
        return movsTv;
    }

    private void generarDevolucion(MovimientoCreditoDto venta) {
        MovimientoCreditoDto mov = new MovimientoCreditoDto();
        mov.setId(venta.getId());
        mov.setEmisor(venta.getEmisor());
        mov.setCliente(venta.getCliente());
        mov.setProductoServicio(venta.getProductoServicio());
        mov.setIdSucursal(venta.getIdSucursal());
        mov.setCantidadProducto(venta.getCantidadProducto());
        mov.setPrecio(venta.getPrecio());
        mov.setAbono(BigDecimal.ZERO);
        mov.setTipo("D");
        mov.setEstado("A");
        MovimientoCreditoService service = (MovimientoCreditoService)AppContext.getInstance().get("MovimientoCreditoService");
        Respuesta respuesta = service.save(mov);
        if (respuesta.getEstado().booleanValue()) {
            NotificacionHelper.dispararNotificacion(NotificacionType.SUCCESS, "Devoluci\u00f3n aplicada correctamente.");
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Error al aplicar la devoluci\u00f3n, intente m\u00e1s tarde.");
        }
    }

    private void calcularSaldo() {
        DecimalFormat formatter = new DecimalFormat("#,##0.00");
        if (this.movimientos == null || this.movimientos.isEmpty()) {
            this.lblSaldo.setText(formatter.format(0L));
        } else {
            this.lblSaldo.setText(formatter.format(((MovimientoCreditoDto)this.movimientos.get(0)).getSaldo()));
        }
    }

    private void getMovimientos() {
        this.getMovimientos(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId(), ((ReceptorDto)this.cbxCliente.getSelectionModel().getSelectedItem()).getId());
    }
}

