/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.controller.MantMovInvViewController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.controller.ShowMovInvViewController;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.MovimientoInventarioTv;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.EmisorService;
import electricpos.service.MovimientoInventarioService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class MovimientoInventarioViewController
implements Initializable {
    @FXML
    private JFXButton btnCrear;
    @FXML
    private JFXButton btnVer;
    @FXML
    private ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    private DatePicker dpFechaIni;
    @FXML
    private DatePicker dpFechaFin;
    @FXML
    private ComboBox<String> cbxTipo;
    @FXML
    private Label lblTitulo;
    @FXML
    private TableView<MovimientoInventarioTv> tv_movimientos;
    @FXML
    private TableColumn<MovimientoInventarioTv, String> tbcCodigo;
    @FXML
    private TableColumn<MovimientoInventarioTv, String> tbcProducto;
    @FXML
    private TableColumn<MovimientoInventarioTv, Number> tbcCantidad;
    @FXML
    private TableColumn<MovimientoInventarioTv, String> tbcFecha;
    @FXML
    private TableColumn<MovimientoInventarioTv, String> tbcObs;
    DecimalFormat formatter = new DecimalFormat("#,##0.00");
    ObservableList<SucursalEmisorDto> sucursalLista;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<MovimientoInventarioTv> movimientosInventario;
    SucursalEmisorDto sucursalPrincipal = new SucursalEmisorDto();
    String tipoMovimiento = null;

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            this.sucursalPrincipal = suc = (SucursalEmisorDto)this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        Date date = new Date();
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.dpFechaIni.setValue((Object)localDate);
        this.dpFechaFin.setValue((Object)localDate);
    }

    private void getMovimientos(Integer idSucursal, String ini, String fin, String tipo) {
        MovimientoInventarioService service = (MovimientoInventarioService)AppContext.getInstance().get("MovimientoInventarioService");
        Respuesta respuesta = service.getMovimientoInventarioFiltro(idSucursal, ini, fin, tipo);
        if (respuesta.getEstado().booleanValue()) {
            this.movimientosInventario = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_movimientos.getItems().clear();
            this.tv_movimientos.setItems(this.movimientosInventario);
        } else {
            this.tv_movimientos.getItems().clear();
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.sucursalPrincipal = (SucursalEmisorDto)this.sucursalLista.get(0);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    private void crearRelacionTv() {
        this.tbcCodigo.setCellValueFactory(cd -> ((MovimientoInventarioTv)cd.getValue()).codigo);
        this.tbcObs.setCellValueFactory(cd -> ((MovimientoInventarioTv)cd.getValue()).observaciones);
        this.tbcFecha.setCellValueFactory(cd -> ((MovimientoInventarioTv)cd.getValue()).fechaFormat);
        this.tbcProducto.setCellValueFactory(cd -> ((MovimientoInventarioTv)cd.getValue()).producto);
        this.tbcCantidad.setCellValueFactory(cd -> ((MovimientoInventarioTv)cd.getValue()).cantidad);
    }

    @FXML
    private void onBtnVerMov() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ShowMovInvView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(MovimientoInventarioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ShowMovInvViewController controller = (ShowMovInvViewController)fxmlLoader.getController();
        controller.setMovimiento((MovimientoInventarioTv)this.tv_movimientos.getSelectionModel().getSelectedItem(), (SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem());
        FuncionesGenerales.showView(root1);
    }

    @FXML
    private void onBtnCrear() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantMovInvView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantMovInvViewController controller = (MantMovInvViewController)fxmlLoader.getController();
        controller.setSucursalEmisorDto((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem());
        controller.setTipoMovimiento(this.tipoMovimiento);
        FuncionesGenerales.showView(root1);
        this.getMovimientos(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), this.tipoMovimiento);
    }

    @FXML
    private void onBtnBuscar() {
        this.getMovimientos(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), this.tipoMovimiento);
    }

    @FXML
    private void onCbxEmisorChanged() {
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
    }

    @FXML
    private void onCbxSucursalChanged() {
        this.getMovimientos(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), this.tipoMovimiento);
    }

    public String getTipoMovimiento() {
        return this.tipoMovimiento;
    }

    public void setTipoMovimiento(String tipoMovimiento) {
        this.tipoMovimiento = tipoMovimiento;
        if (tipoMovimiento != null) {
            ArrayList<String> lista = new ArrayList<String>();
            if (tipoMovimiento.equalsIgnoreCase("ENT")) {
                this.lblTitulo.setText("Movimiento de Entrada al inventario");
                this.btnCrear.setText("Crear entrada");
                this.btnVer.setText("Ver entrada");
                lista.add("Entrada");
            } else if (tipoMovimiento.equalsIgnoreCase("SAL")) {
                this.lblTitulo.setText("Movimiento de Salida del inventario");
                this.btnCrear.setText("Crear salida");
                this.btnVer.setText("Ver salida");
                lista.add("Salida");
            }
            ObservableList tipoLista = FXCollections.observableArrayList(lista);
            this.cbxTipo.setItems(tipoLista);
            this.cbxTipo.getSelectionModel().selectFirst();
            this.getMovimientos(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), this.tipoMovimiento);
        }
    }
}

