/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import electricpos.controller.MantMovCajaViewController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.model.EmisorDto;
import electricpos.model.GlobalApp;
import electricpos.model.MovimientoCajaDto;
import electricpos.model.MovimientoCajaTv;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.EmisorService;
import electricpos.service.MovimientoCajaService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class MovimientosCajaViewController
implements Initializable {
    @FXML
    private ComboBox<EmisorDto> cbxEmisor;
    @FXML
    private ComboBox<SucursalEmisorDto> cbxSucursal;
    @FXML
    private DatePicker dpFechaIni;
    @FXML
    private DatePicker dpFechaFin;
    @FXML
    private Label lblTipo;
    @FXML
    private TableView<MovimientoCajaTv> tv_movimientos;
    @FXML
    private TableColumn<MovimientoCajaTv, String> tbcDetalle;
    @FXML
    private TableColumn<MovimientoCajaTv, Number> tbcMonto;
    @FXML
    private TableColumn<MovimientoCajaTv, String> tbcFecha;
    DecimalFormat formatter = new DecimalFormat("#,##0.00");
    ObservableList<SucursalEmisorDto> sucursalLista;
    ObservableList<EmisorDto> emisoresLista;
    ObservableList<MovimientoCajaDto> movimientosCaja;
    SucursalEmisorDto sucursalPrincipal = new SucursalEmisorDto();
    String tipoMovimiento = null;
    Date date = new Date();
    Instant instant = this.date.toInstant();
    LocalDate localDate = this.instant.atZone(ZoneId.systemDefault()).toLocalDate();

    public void initialize(URL url, ResourceBundle rb) {
        this.crearRelacionTv();
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            EmisorDto emi = new EmisorDto();
            emi = this.cbxEmisor.getItems().stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
            this.cbxEmisor.getSelectionModel().select((Object)emi);
        }
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
        if (GlobalApp.idSucursal != null) {
            SucursalEmisorDto suc = new SucursalEmisorDto();
            this.sucursalPrincipal = suc = (SucursalEmisorDto)this.cbxSucursal.getItems().stream().filter(c -> c.getId() == GlobalApp.idSucursal).findAny().orElse(null);
            this.cbxSucursal.getSelectionModel().select((Object)suc);
        }
        this.dpFechaIni.setValue((Object)this.localDate);
        this.dpFechaFin.setValue((Object)this.localDate);
    }

    @FXML
    private void onBtnVerMovimiento() {
    }

    @FXML
    private void onBtnCrearMovimiento() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MantMovCajaView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ProductoServicioViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        MantMovCajaViewController controller = (MantMovCajaViewController)fxmlLoader.getController();
        controller.setTipo(this.tipoMovimiento);
        FuncionesGenerales.showView(root1);
        this.getMovimientos(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), this.tipoMovimiento);
    }

    @FXML
    private void onBtnBuscar() {
        this.getMovimientos(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), this.tipoMovimiento);
    }

    @FXML
    private void onCbxEmisorChanged() {
        this.cargarSucursales(((EmisorDto)this.cbxEmisor.getSelectionModel().getSelectedItem()).getId());
    }

    @FXML
    private void onCbxSucursalChanged() {
        this.getMovimientos(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), ((LocalDate)this.dpFechaIni.getValue()).toString(), ((LocalDate)this.dpFechaFin.getValue()).toString(), this.tipoMovimiento);
    }

    public void setTipoMovimiento(String tipoMovimiento) {
        this.tipoMovimiento = tipoMovimiento;
        if (tipoMovimiento.equalsIgnoreCase("E")) {
            this.lblTipo.setText("Gastos (No efectivo)");
        }
        if (tipoMovimiento.equalsIgnoreCase("I")) {
            this.lblTipo.setText("Ingresos");
        }
        if (tipoMovimiento.equalsIgnoreCase("R")) {
            this.lblTipo.setText("Retiros efectivo");
        }
        if (!this.cbxEmisor.getSelectionModel().isEmpty() && !this.cbxSucursal.getSelectionModel().isEmpty()) {
            this.getMovimientos(((SucursalEmisorDto)this.cbxSucursal.getSelectionModel().getSelectedItem()).getId(), this.localDate.toString(), this.localDate.toString(), this.tipoMovimiento);
        }
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
            this.cbxEmisor.setItems(this.emisoresLista);
            this.cbxEmisor.getSelectionModel().selectFirst();
        }
    }

    private void cargarSucursales(Integer IdEmisor) {
        SucursalEmisorService sucursalEmisorService = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService");
        Respuesta respuesta = sucursalEmisorService.getSucursalesEmi(IdEmisor);
        this.cbxSucursal.getItems().clear();
        if (respuesta.getEstado().booleanValue()) {
            this.sucursalLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("SucursalEmisor")));
            this.cbxSucursal.setItems(this.sucursalLista);
            this.sucursalPrincipal = (SucursalEmisorDto)this.sucursalLista.get(0);
            this.cbxSucursal.getSelectionModel().selectFirst();
        }
    }

    private void getMovimientos(Integer idSucursal, String ini, String fin, String tipo) {
        MovimientoCajaService service = (MovimientoCajaService)AppContext.getInstance().get("MovimientoCajaService");
        Respuesta respuesta = service.getMovimientosCajaFiltro(idSucursal, ini, fin, tipo);
        if (respuesta.getEstado().booleanValue()) {
            this.movimientosCaja = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado(ESTADO.OK.VALUE())));
            this.tv_movimientos.getItems().clear();
            this.tv_movimientos.setItems(this.converterTv(this.movimientosCaja));
        } else {
            this.tv_movimientos.getItems().clear();
        }
    }

    private ObservableList<MovimientoCajaTv> converterTv(ObservableList<MovimientoCajaDto> cajas) {
        ObservableList cajasTv = FXCollections.observableArrayList();
        for (MovimientoCajaDto cajaDto : cajas) {
            MovimientoCajaTv cajTv = new MovimientoCajaTv(cajaDto);
            cajasTv.add((Object)cajTv);
        }
        return cajasTv;
    }

    private void crearRelacionTv() {
        this.tbcFecha.setCellValueFactory(cd -> ((MovimientoCajaTv)cd.getValue()).fecha);
        this.tbcDetalle.setCellValueFactory(cd -> ((MovimientoCajaTv)cd.getValue()).detalle);
        this.tbcMonto.setCellValueFactory(cd -> ((MovimientoCajaTv)cd.getValue()).monto);
    }
}

