/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.victorlaerte.asynctask.AsyncTask;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.util.FuncionesGenerales;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;

public class NotificacionViewController
implements Initializable {
    @FXML
    private Label lblTipo;
    @FXML
    private ImageView imgIco;
    @FXML
    private Label txtMensaje;
    @FXML
    private Pane paneSuccess;
    @FXML
    private Pane paneInfo;
    @FXML
    private Pane paneError;
    @FXML
    private Pane paneWarning;
    AnchorPane anchorPane;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();

    public void initialize(URL url, ResourceBundle rb) {
        AsynckAutoClose asynckAutoClose = new AsynckAutoClose();
        asynckAutoClose.setDaemon(false);
        asynckAutoClose.execute(new String[0]);
    }

    @FXML
    private void onBtnEliminarNot() {
        GlobalApp.vBoxNotificaciones.getChildren().remove((Object)this.anchorPane);
        FuncionesGenerales.procesaVBoxNotificaciones();
    }

    public void setAnchorPane(AnchorPane anchorPane) {
        this.anchorPane = anchorPane;
    }

    public void setNotificacion(NotificacionType tipo, String mensaje) {
        if (tipo == NotificacionType.SUCCESS) {
            this.paneSuccess.setVisible(true);
            this.lblTipo.setText("Satisfactorio");
            this.imgIco.setImage(this.funcionesGenerales.obtenerImagen("ok_not.png"));
        }
        if (tipo == NotificacionType.INFO) {
            this.paneInfo.setVisible(true);
            this.lblTipo.setText("Informaci\u00f3n");
            this.imgIco.setImage(this.funcionesGenerales.obtenerImagen("info_not.png"));
        }
        if (tipo == NotificacionType.ERROR) {
            this.paneError.setVisible(true);
            this.lblTipo.setText("Problema");
            this.imgIco.setImage(this.funcionesGenerales.obtenerImagen("error_not.png"));
        }
        if (tipo == NotificacionType.WARNING) {
            this.paneWarning.setVisible(true);
            this.lblTipo.setText("Advertencia");
            this.imgIco.setImage(this.funcionesGenerales.obtenerImagen("warning_not.png"));
        }
        this.txtMensaje.setText(mensaje);
    }

    private class AsynckAutoClose
    extends AsyncTask<String, Integer, Boolean> {
        private AsynckAutoClose() {
        }

        public void onPreExecute() {
        }

        public Boolean doInBackground(String ... params) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(NotificacionViewController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            GlobalApp.vBoxNotificaciones.getChildren().remove((Object)NotificacionViewController.this.anchorPane);
            FuncionesGenerales.procesaVBoxNotificaciones();
        }

        public void progressCallback(Integer ... params) {
        }
    }
}

