/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import electricpos.model.EmpresaDto;
import electricpos.model.GlobalApp;
import electricpos.service.EmpresaService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Mensaje;
import electricpos.util.Respuesta;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class ParametrosGeneController
implements Initializable {
    @FXML
    ImageView imgEditarEmpresa;
    @FXML
    ImageView imgLogo;
    @FXML
    ImageView imgEditarCedula;
    @FXML
    ImageView imgEditarTelefono;
    @FXML
    Label txtNombreEmpresa;
    @FXML
    Label txtPrinter;
    @FXML
    Label txtCedulaEmpresa;
    @FXML
    Label txtTelefonoEmpresa;
    @FXML
    Label txtEstadoEmpresa;
    @FXML
    JFXButton btnRestaurar;
    @FXML
    ComboBox<String> cbxImpresoras;
    final FileChooser fileChooser = new FileChooser();
    String base64Image = null;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    String impresoraSeleccionada = null;
    EmpresaDto empresaDtoSeleccionada = null;

    public void initialize(URL url, ResourceBundle rb) {
        FuncionesGenerales funGenerales = new FuncionesGenerales();
        this.imgLogo.setOnMouseClicked(t -> {
            try {
                this.addTeamImg();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        });
        this.imgEditarEmpresa.setOnMouseClicked(event -> this.txtNombreEmpresa.setText(funGenerales.MostrarInputModal(this.txtNombreEmpresa.getText(), "Nomnre de la empresa")));
        this.imgEditarCedula.setOnMouseClicked(event -> this.txtCedulaEmpresa.setText(funGenerales.MostrarInputModal(this.txtCedulaEmpresa.getText(), "Identificaci\u00f3n de la empresa")));
        this.imgEditarTelefono.setOnMouseClicked(event -> this.txtTelefonoEmpresa.setText(funGenerales.MostrarInputModal(this.txtTelefonoEmpresa.getText(), "Tel\u00e9fono")));
        this.getParametrosEmpresa();
        this.cbxImpresoras.setItems(FXCollections.observableArrayList(this.obtenerImpresoras()));
    }

    private List<String> obtenerImpresoras() {
        PrintService[] printServiceDefault;
        ArrayList<String> list = new ArrayList<String>();
        for (PrintService printService : printServiceDefault = PrintServiceLookup.lookupPrintServices(null, null)) {
            list.add(printService.getName());
        }
        return list;
    }

    public void Iniciar() {
    }

    @FXML
    private void OnBtnRestaurar(ActionEvent event) {
    }

    @FXML
    private void obBtnSetPrinter(ActionEvent event) {
        GlobalApp.printerDefult = this.impresoraSeleccionada = (String)this.cbxImpresoras.getSelectionModel().getSelectedItem();
        this.txtPrinter.setText(this.impresoraSeleccionada);
    }

    private void addTeamImg() throws MalformedURLException {
        Window primaryStage = null;
        File file1 = this.fileChooser.showOpenDialog(primaryStage);
        if (file1 != null) {
            String thumbURL1 = file1.toURI().toURL().toString();
            Image img = new Image(thumbURL1);
            this.imgLogo.setImage(img);
            this.base64Image = ParametrosGeneController.encoder(file1.getAbsolutePath());
        }
    }

    public static String encoder(String imagePath) {
        String base64Image2 = "";
        File file = new File(imagePath);
        try (FileInputStream imageInFile = new FileInputStream(file);){
            byte[] imageData = new byte[(int)file.length()];
            imageInFile.read(imageData);
            base64Image2 = Base64.getEncoder().encodeToString(imageData);
        }
        catch (FileNotFoundException e) {
            System.out.println("Image not found" + e);
        }
        catch (IOException ioe) {
            System.out.println("Exception while reading the Image " + ioe);
        }
        return base64Image2;
    }

    private void getParametrosEmpresa() {
        EmpresaService service = (EmpresaService)AppContext.getInstance().get("EmpresaService");
        Respuesta respuesta = service.getEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.empresaDtoSeleccionada = (EmpresaDto)respuesta.getResultado("Empresa");
            this.txtNombreEmpresa.setText(this.empresaDtoSeleccionada.getNombre());
            this.txtTelefonoEmpresa.setText(this.empresaDtoSeleccionada.getTelefono());
            this.txtCedulaEmpresa.setText(this.empresaDtoSeleccionada.getIdentificacion());
            this.txtPrinter.setText(this.empresaDtoSeleccionada.getImpresoraService());
            this.base64Image = this.empresaDtoSeleccionada.getImgaeBase64();
            if (this.empresaDtoSeleccionada.getImgaeBase64() != null) {
                try {
                    this.imgLogo.setImage((Image)ParametrosGeneController.decodeToImage(this.base64Image));
                }
                catch (Exception exception) {}
            }
        } else {
            Stage stage = (Stage)this.btnRestaurar.getScene().getWindow();
            Mensaje.getInstance().showModal(Alert.AlertType.ERROR, "Cargar Empleado", (Window)stage, respuesta.getMensaje());
        }
    }

    public static WritableImage decodeToImage(String imageString) {
        BufferedImage image = null;
        try {
            byte[] imageByte = Base64.getDecoder().decode(imageString);
            try (ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);){
                image = ImageIO.read(bis);
            }
        }
        catch (IOException e) {
            return null;
        }
        return SwingFXUtils.toFXImage((BufferedImage)image, null);
    }

    @FXML
    private void obBtnGuardarInfo(ActionEvent event) {
        EmpresaDto empresaDto = this.empresaDtoSeleccionada;
        empresaDto.setNombre(this.txtNombreEmpresa.getText());
        empresaDto.setIdentificacion(this.txtCedulaEmpresa.getText());
        empresaDto.setTelefono(this.txtTelefonoEmpresa.getText());
        empresaDto.setImgaeBase64(this.base64Image);
        empresaDto.setImpresoraService(this.txtPrinter.getText());
        EmpresaService service = (EmpresaService)AppContext.getInstance().get("EmpresaService");
        Respuesta respuesta = service.saveEmpresa(empresaDto);
        if (respuesta.getEstado().booleanValue()) {
            this.funcionesGenerales.MostrarModalInfo("La informaci\u00f3n de la empresa se actualiz\u00f3 correctamente.");
        } else {
            this.funcionesGenerales.MostrarModalInfo("Ocurri\u00f3 un error actualizando la informaci\u00f3n de la empresa.");
        }
    }
}

