/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXCheckBox;
import electricpos.model.EmisorDto;
import electricpos.service.EmisorService;
import electricpos.util.AppContext;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.stage.Stage;

public class PreferenciasEmisorViewController
implements Initializable {
    @FXML
    JFXCheckBox checkInvCompartido;
    @FXML
    JFXCheckBox checkInventario;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    private EmisorDto emisorDto;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void onBtnCerrar() {
        Stage stage = (Stage)this.checkInvCompartido.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnGuardar() {
        this.guardarEmisor();
    }

    @FXML
    private void onBtnVerInv() {
    }

    public void setEmisorDto(EmisorDto emisorDto) {
        this.emisorDto = emisorDto;
        if (emisorDto != null) {
            this.checkInvCompartido.setSelected(this.getBooleanValue(emisorDto.getInventarioCompartido()));
            this.checkInventario.setSelected(this.getBooleanValue(emisorDto.getInventarioActivo()));
        }
    }

    private boolean getBooleanValue(String value) {
        return value.equalsIgnoreCase("S");
    }

    private String getStringValue(Boolean value) {
        return value != false ? "S" : "N";
    }

    private void guardarEmisor() {
        Stage stage = (Stage)this.checkInvCompartido.getScene().getWindow();
        EmisorService service = (EmisorService)AppContext.getInstance().get("EmisorService");
        this.emisorDto.setInventarioCompartido(this.getStringValue(this.checkInvCompartido.isSelected()));
        this.emisorDto.setInventarioActivo(this.getStringValue(this.checkInventario.isSelected()));
        Respuesta respuesta = service.saveEmisor(this.emisorDto);
        if (respuesta.getEstado().booleanValue()) {
            this.funcionesGenerales.MostrarModalInfo("Preferencias del emisor guardadas correctamente.");
            stage.hide();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al guardar preferencias: " + respuesta.getMensaje());
        }
    }
}

