/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXCheckBox;
import electricpos.controller.ActividadesViewController;
import electricpos.model.ActividadDto;
import electricpos.model.SucursalEmisorDto;
import electricpos.service.ActividadService;
import electricpos.service.SucursalEmisorService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class PreferenciasSucursalViewController
implements Initializable {
    @FXML
    JFXCheckBox checkUsaRomana;
    @FXML
    Label txtDescripcionActividad;
    @FXML
    Label txtCodigoActividad;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    private SucursalEmisorDto sucursalEmisorDto;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void onBtnCerrar(ActionEvent event) {
        Stage stage = (Stage)this.checkUsaRomana.getScene().getWindow();
        stage.hide();
    }

    @FXML
    private void onBtnGuardar(ActionEvent event) {
        this.guardarSucursal();
    }

    @FXML
    private void onBtnBuscarActividad(ActionEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ActividadesView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(PreferenciasSucursalViewController.class.getName()).log(Level.SEVERE, null, ex);
        }
        ActividadesViewController controller = (ActividadesViewController)fxmlLoader.getController();
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.showAndWait();
        if (controller.isSelected.booleanValue()) {
            this.txtCodigoActividad.setText(controller.getActividadSeleccionada().getCodigo());
            this.txtDescripcionActividad.setText(controller.getActividadSeleccionada().getActividad());
        }
    }

    private boolean getBooleanValue(String value) {
        return value.equalsIgnoreCase("S");
    }

    private String getStringValue(Boolean value) {
        return value != false ? "S" : "N";
    }

    private void guardarSucursal() {
        SucursalEmisorService service;
        Respuesta respuesta;
        Stage stage = (Stage)this.checkUsaRomana.getScene().getWindow();
        this.sucursalEmisorDto.setUsaRomana(this.getStringValue(this.checkUsaRomana.isSelected()));
        if (!this.txtCodigoActividad.getText().equalsIgnoreCase("000000")) {
            this.sucursalEmisorDto.setCodigoActividad(this.txtCodigoActividad.getText());
        }
        if ((respuesta = (service = (SucursalEmisorService)AppContext.getInstance().get("SucursalEmisorService")).saveSucursalEmisor(this.sucursalEmisorDto)).getEstado().booleanValue()) {
            this.funcionesGenerales.MostrarModalInfo("Preferencias de la sucursal guardadas correctamente.");
            stage.hide();
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al guardar preferencias: " + respuesta.getMensaje());
        }
    }

    public void setSucursalEmisorDto(SucursalEmisorDto sucursalEmisorDto) {
        this.sucursalEmisorDto = sucursalEmisorDto;
        if (sucursalEmisorDto != null) {
            this.checkUsaRomana.setSelected(this.getBooleanValue(sucursalEmisorDto.getUsaRomana()));
            if (sucursalEmisorDto.getCodigoActividad() != null) {
                this.txtCodigoActividad.setText(sucursalEmisorDto.getCodigoActividad());
                this.txtDescripcionActividad.setText(this.getDescripcionActividad(sucursalEmisorDto.getCodigoActividad()));
            }
        }
    }

    private String getDescripcionActividad(String codigo) {
        ActividadService actividadService = (ActividadService)AppContext.getInstance().get("ActividadService");
        Respuesta respuesta = actividadService.getByActividad(codigo);
        ActividadDto actividadDto = null;
        if (respuesta.getEstado().booleanValue()) {
            actividadDto = (ActividadDto)respuesta.getResultado(ESTADO.OK.VALUE());
            return actividadDto.getActividad();
        }
        return "Descripcion de la actividad...";
    }
}

