/*
 * Decompiled with CFR 0.152.
 */
package electricpos.controller;

import com.jfoenix.controls.JFXButton;
import com.victorlaerte.asynctask.AsyncTask;
import electricpos.controller.AjustesInventarioViewController;
import electricpos.controller.CerrarCajaViewController;
import electricpos.controller.CierresMesViewController;
import electricpos.controller.ComprobanteHaciendaViewController;
import electricpos.controller.CrearCajaViewController;
import electricpos.controller.FacturacionColViewController;
import electricpos.controller.FacturacionCompraViewController;
import electricpos.controller.FacturacionPosSimpliViewController;
import electricpos.controller.FacturacionPosViewController;
import electricpos.controller.FacturacionProformaViewController;
import electricpos.controller.FacturacionViewController;
import electricpos.controller.FacturasViewController;
import electricpos.controller.MovimientoInventarioViewController;
import electricpos.controller.MovimientosCajaViewController;
import electricpos.controller.ParametrosGeneController;
import electricpos.controller.ProductoServicioViewController;
import electricpos.controller.ProformasViewController;
import electricpos.controller.ReceptorViewController;
import electricpos.controller.RegistroInternoViewController;
import electricpos.controller.ReporteVentasViewController;
import electricpos.model.CicloFacturacionDto;
import electricpos.model.DashboardDataDto;
import electricpos.model.EmisorDto;
import electricpos.model.EmpresaFacturacion;
import electricpos.model.GlobalApp;
import electricpos.model.NotificacionType;
import electricpos.model.UsuarioMenuDto;
import electricpos.service.CicloFacturacionService;
import electricpos.service.EmisorService;
import electricpos.service.EmpresaService;
import electricpos.service.StatsService;
import electricpos.service.UsuarioService;
import electricpos.util.AppContext;
import electricpos.util.ESTADO;
import electricpos.util.FuncionesGenerales;
import electricpos.util.NotificacionHelper;
import electricpos.util.Respuesta;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class PrincipalController
implements Initializable {
    @FXML
    private Label lblFecha;
    @FXML
    private Label lblNombreEmisor;
    @FXML
    private Label lblCedula;
    @FXML
    private Label lblTotalVentas;
    @FXML
    private Label lblTotalComprobantes;
    @FXML
    private Label lblDiferenciaVentas;
    @FXML
    private Label lblDiferenciaComprobantes;
    @FXML
    private Label txtPrueba;
    @FXML
    private Label lblMes;
    @FXML
    private Label lblMensualidad;
    @FXML
    private Label lblCuentaActiva;
    @FXML
    private Label lblCuentaPendiente;
    @FXML
    private Label lblCuentaVencida;
    @FXML
    private Label lblMensajePago;
    @FXML
    private Label lblRuta;
    @FXML
    private Label lblCertificado;
    @FXML
    private StackPane stackMenu;
    @FXML
    private ScrollPane spa;
    @FXML
    private ScrollPane spaCajas;
    @FXML
    private ScrollPane spaClientes;
    @FXML
    private ScrollPane spaFacturacion;
    @FXML
    private ScrollPane spaComprobantes;
    @FXML
    private ScrollPane spaProductos;
    @FXML
    private AnchorPane paneLoading;
    @FXML
    private AnchorPane paneBtnCajas;
    @FXML
    private AnchorPane paneBtnFacturacion;
    @FXML
    private AnchorPane paneBtnPS;
    @FXML
    private AnchorPane paneBtnMenu;
    @FXML
    private AnchorPane paneBtnComprobantes;
    @FXML
    private AnchorPane paneBtnCuenta;
    @FXML
    private AnchorPane paneBtnDashboard;
    @FXML
    private AnchorPane panelPrincipal;
    @FXML
    private AnchorPane paneBtnParametros;
    @FXML
    private AnchorPane paneBtnClientes;
    @FXML
    private VBox vBoxUsu;
    @FXML
    private VBox vbxNotificaciones;
    @FXML
    private JFXButton btnCuenta;
    @FXML
    private JFXButton btnMnuInfoEmpresa;
    @FXML
    private JFXButton btnEmisores;
    @FXML
    private JFXButton btnSucursales;
    @FXML
    private JFXButton btnUsuarios;
    @FXML
    private JFXButton btnColaboradores;
    @FXML
    private JFXButton btnReporteSalarios;
    @FXML
    private JFXButton btnRoles;
    @FXML
    private JFXButton btnClientes;
    @FXML
    private JFXButton btnCreditos;
    @FXML
    private JFXButton btnEmisor;
    @FXML
    private JFXButton btnCajas;
    @FXML
    private JFXButton btnCerrarCaja;
    @FXML
    private JFXButton btnAbrirCaja;
    @FXML
    private JFXButton btnRetiroEfectivo;
    @FXML
    private JFXButton btnOtrosEgresos;
    @FXML
    private JFXButton btnOtrosIngresos;
    @FXML
    private JFXButton btnVerCierresMes;
    @FXML
    private JFXButton btnCrearCierresMes;
    @FXML
    private JFXButton btnInvSalidas;
    @FXML
    private JFXButton btnInvEntradas;
    @FXML
    private JFXButton btnReporteInventario;
    @FXML
    private JFXButton btnProductos;
    @FXML
    private JFXButton btnServicios;
    @FXML
    private JFXButton btnAjustesInv;
    @FXML
    private JFXButton btnFacturar;
    @FXML
    private JFXButton btnRegistroInterno;
    @FXML
    private JFXButton btnPOS;
    @FXML
    private JFXButton btnCrearFacturaCompra;
    @FXML
    private JFXButton btnCrearProforma;
    @FXML
    private JFXButton btnVerFacturas;
    @FXML
    private JFXButton btnVerGastos;
    @FXML
    private JFXButton btnVerProformas;
    @FXML
    private JFXButton btnMH_facturas;
    @FXML
    private JFXButton btnMH_tiquete;
    @FXML
    private JFXButton btnMH_credito;
    @FXML
    private JFXButton btnMH_debito;
    @FXML
    private JFXButton btnMH_recibidos;
    @FXML
    private JFXButton btnMH_recepcion;
    @FXML
    private JFXButton btnReporteInventarioDash;
    public String tipoCom = null;
    FuncionesGenerales funcionesGenerales = new FuncionesGenerales();
    @FXML
    private AnchorPane apAcercaInventario;
    @FXML
    private Label lblComprobantes;
    ObservableList<EmisorDto> emisoresLista;
    @FXML
    private Label lblTipoCuenta;
    @FXML
    private Label lblFechaIni;
    @FXML
    private Label lblFechaFin;
    CicloFacturacionDto cicloFacturacionActualDto;
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MMMM-yyyy", new Locale("es", "ES"));
    EmisorDto emisorSeleccionado = new EmisorDto();
    DashboardDataDto dashboardDataDto = new DashboardDataDto();
    DecimalFormat formatterMoney = new DecimalFormat("#,##0.00");

    public void initialize(URL url, ResourceBundle rb) {
        this.vbxNotificaciones.setVisible(false);
        GlobalApp.txtPruebaLabel = this.txtPrueba;
        GlobalApp.vBoxNotificaciones = this.vbxNotificaciones;
        GlobalApp.vBoxUsu = this.vBoxUsu;
        GlobalApp.panelPrincipalGlobal = this.panelPrincipal;
        GlobalApp.stackMenuGlobal = this.stackMenu;
        GlobalApp.lblRutaGlobal = this.lblRuta;
        this.procesarNotificaciones();
        this.paneBtnParametros.setOnMouseClicked(event -> {
            this.actualizarMenu();
            this.spa.setVisible(true);
            this.spaClientes.setVisible(false);
            this.spaCajas.setVisible(false);
            this.spaFacturacion.setVisible(false);
            this.spaComprobantes.setVisible(false);
            this.spaProductos.setVisible(false);
            this.btnCuenta.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.MICUENTA));
            this.btnMnuInfoEmpresa.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.EMPRESA));
            this.btnEmisores.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.EMISORES));
            this.btnSucursales.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.SUCURSALES));
            this.btnUsuarios.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.USUARIOS));
            this.btnUsuarios.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.USUARIOS));
            if (GlobalApp.empresa.getUsaColaboradores().equalsIgnoreCase("N")) {
                this.btnColaboradores.setVisible(false);
                this.btnReporteSalarios.setVisible(false);
            } else {
                this.btnColaboradores.setVisible(true);
                this.btnReporteSalarios.setVisible(true);
                this.btnColaboradores.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.COLABORADORES));
                this.btnReporteSalarios.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.REPORTE_SALARIOS));
            }
        });
        this.paneBtnClientes.setOnMouseClicked(event -> {
            this.actualizarMenu();
            this.spaClientes.setVisible(true);
            this.spaCajas.setVisible(false);
            this.spa.setVisible(false);
            this.spaFacturacion.setVisible(false);
            this.spaComprobantes.setVisible(false);
            this.spaProductos.setVisible(false);
            this.btnClientes.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.CLIENTES));
            if (GlobalApp.empresa.getAppFull().equalsIgnoreCase("N")) {
                this.btnCreditos.setVisible(false);
            } else {
                this.btnCreditos.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.CREDITOS));
            }
        });
        if (GlobalApp.empresa.getAppFull().equalsIgnoreCase("N")) {
            this.paneBtnCajas.setDisable(true);
        }
        this.paneBtnCajas.setOnMouseClicked(event -> {
            this.actualizarMenu();
            this.spaCajas.setVisible(true);
            this.spaClientes.setVisible(false);
            this.spa.setVisible(false);
            this.spaFacturacion.setVisible(false);
            this.spaComprobantes.setVisible(false);
            this.spaProductos.setVisible(false);
            this.btnCajas.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.CAJAS));
            this.btnCerrarCaja.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.CERRAR_CAJA));
            this.btnAbrirCaja.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.ABRIR_CAJA));
            this.btnRetiroEfectivo.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.RETIROS_EFECTIVO));
            this.btnOtrosEgresos.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.OTROS_EGRESOS));
            this.btnOtrosIngresos.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.OTROS_INGRESOS));
            this.btnVerCierresMes.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.VER_CIERRES_MES));
            this.btnCrearCierresMes.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.CREAR_CIERRES_MES));
        });
        this.paneBtnCuenta.setOnMouseClicked(event -> {
            if (GlobalApp.vBoxUsu.isVisible()) {
                GlobalApp.vBoxUsu.setVisible(false);
            } else {
                GlobalApp.vBoxUsu.setVisible(true);
            }
        });
        this.paneBtnFacturacion.setOnMouseClicked(event -> {
            this.actualizarMenu();
            this.spa.setVisible(false);
            this.spaClientes.setVisible(false);
            this.spaCajas.setVisible(false);
            this.spaComprobantes.setVisible(false);
            this.spaProductos.setVisible(false);
            this.spaFacturacion.setVisible(true);
            if (GlobalApp.empresa.getUsaColaboradores().equalsIgnoreCase("N")) {
                this.btnRegistroInterno.setVisible(false);
            } else {
                this.btnRegistroInterno.setVisible(true);
            }
            this.btnFacturar.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.FACTURAR));
            this.btnPOS.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.POS));
            this.btnCrearFacturaCompra.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.FACTURACOMPRA));
            this.btnCrearProforma.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.CREARPROFORMA));
            this.btnVerFacturas.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.VERFACTURAS));
            this.btnVerGastos.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.VERGASTOS));
            this.btnVerProformas.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.VERPROFORMAS));
        });
        this.paneBtnPS.setOnMouseClicked(event -> {
            this.actualizarMenu();
            this.spa.setVisible(false);
            this.spaCajas.setVisible(false);
            this.spaClientes.setVisible(false);
            this.spaFacturacion.setVisible(false);
            this.spaComprobantes.setVisible(false);
            this.spaProductos.setVisible(true);
            if (this.emisorSeleccionado != null) {
                if (this.emisorSeleccionado.getId() == null) {
                    this.emisorSeleccionado = (EmisorDto)this.emisoresLista.get(0);
                }
                if (this.emisorSeleccionado.getInventarioActivo().equalsIgnoreCase("S")) {
                    this.btnInvSalidas.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.SALIDAS));
                    this.btnInvEntradas.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.ENTRADAS));
                    this.btnAjustesInv.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.AJUSTES_INV));
                    this.btnReporteInventario.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.REPORTESINV));
                    this.apAcercaInventario.setVisible(false);
                } else {
                    this.apAcercaInventario.setVisible(true);
                    this.btnInvSalidas.setDisable(true);
                    this.btnInvEntradas.setDisable(true);
                    this.btnReporteInventario.setDisable(true);
                    this.btnAjustesInv.setDisable(true);
                }
            }
            this.btnProductos.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.PRODUCTOS));
            this.btnServicios.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.SERVICIOS));
        });
        this.paneBtnComprobantes.setOnMouseClicked(event -> {
            this.actualizarMenu();
            this.spa.setVisible(false);
            this.spaCajas.setVisible(false);
            this.spaClientes.setVisible(false);
            this.spaFacturacion.setVisible(false);
            this.spaProductos.setVisible(false);
            this.spaComprobantes.setVisible(true);
            this.btnMH_facturas.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.MH_FACTURAS));
            this.btnMH_tiquete.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.MH_TIQUETES));
            this.btnMH_credito.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.MH_CREDITO));
            this.btnMH_debito.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.MH_DEBITO));
            this.btnMH_recibidos.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.MH_RECIBIDOS));
            this.btnMH_recepcion.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.MH_RECEPCION));
        });
        this.paneBtnMenu.setOnMouseClicked(event -> this.closeMenu());
        this.paneBtnDashboard.setOnMouseClicked(event -> {
            try {
                this.lblRuta.setText("Inicio / Dashboard");
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/DashboardView.fxml"));
                AnchorPane ancho = (AnchorPane)fxmlLoader.load();
                this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.getParametrosEmpresa();
        this.getMenusUsuario();
        if (this.emisorSeleccionado.getId() != null) {
            if (this.emisorSeleccionado.getId() == null) {
                this.emisorSeleccionado = (EmisorDto)this.emisoresLista.get(0);
            }
            if (this.emisorSeleccionado.getInventarioActivo() != null && this.emisorSeleccionado.getInventarioActivo().equalsIgnoreCase("S")) {
                this.btnReporteInventarioDash.setDisable(!this.getPermisoMenu(UsuarioMenuDto.MENU.REPORTESINV));
            } else {
                this.btnReporteInventarioDash.setDisable(true);
            }
        }
        this.cargarEmisores();
        if (GlobalApp.idEmisor != null) {
            this.emisorSeleccionado = this.emisoresLista.stream().filter(c -> c.getId() == GlobalApp.idEmisor).findAny().orElse(null);
        }
        this.cargarStats();
        this.cargarCompanyStatus();
    }

    private void cargarStats() {
        StatsService statsService = (StatsService)AppContext.getInstance().get("StatsService");
        Respuesta respuesta = statsService.getDashboardData(GlobalApp.idEmisor, GlobalApp.idSucursal);
        if (respuesta.getEstado().booleanValue()) {
            this.dashboardDataDto = (DashboardDataDto)respuesta.getResultado(ESTADO.OK.VALUE());
            this.lblFecha.setText(this.dashboardDataDto.getFecha());
            this.lblTotalComprobantes.setText(this.dashboardDataDto.getCantidadComprobantes().toString());
            this.lblDiferenciaComprobantes.setText(" " + this.dashboardDataDto.getComprobantesDiferenciaSimbolo() + this.dashboardDataDto.getComprobantesDiferencia().toString() + "%");
            this.lblTotalVentas.setText("\u20a1" + this.formatterMoney.format(this.dashboardDataDto.getTotalVentas()));
            this.lblDiferenciaVentas.setText(" " + this.dashboardDataDto.getVentasDiferenciaSimbolo() + this.dashboardDataDto.getVentasDiferencia().toString() + "%");
            this.lblCedula.setText(GlobalApp.empresa.getIdentificacion());
            this.lblNombreEmisor.setText(this.emisorSeleccionado.getNombre());
            if (this.dashboardDataDto.getDiasExpiraCertificado() == -1) {
                GlobalApp.isCertificadoSeguridadVigente = false;
                this.lblCertificado.setText("\u274c El certificado de seguridad de Hacienda ha vencido. Debe renovarse para poder facturar nuevamente.");
                this.lblCertificado.setTextFill((Paint)Color.RED);
            } else if (this.dashboardDataDto.getDiasExpiraCertificado() <= 30) {
                GlobalApp.isCertificadoSeguridadVigente = true;
                this.lblCertificado.setText("\u26a0 El certificado de seguridad de Hacienda vencer\u00e1 en " + this.dashboardDataDto.getDiasExpiraCertificado() + " d\u00eda(s). Recomendamos renovarlo cuanto antes para evitar interrupciones en la facturaci\u00f3n.");
                this.lblCertificado.setTextFill((Paint)Color.ORANGE);
            } else {
                GlobalApp.isCertificadoSeguridadVigente = true;
                this.lblCertificado.setText("");
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al cargar los datos del dashboard.");
        }
    }

    private void cargarCompanyStatus() {
        EmpresaService service = (EmpresaService)AppContext.getInstance().get("EmpresaService");
        Respuesta respuesta = service.getEmpresaStatus(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            EmpresaFacturacion obj = (EmpresaFacturacion)respuesta.getResultado(ESTADO.OK.VALUE());
            this.lblMes.setText(obj.getMes());
            DecimalFormat formato = new DecimalFormat("#,##0.00");
            String valorFormateado = formato.format(obj.getMonto());
            this.lblMensualidad.setText("\u20a1" + valorFormateado + " / mes");
            this.lblMensajePago.setText(obj.getMensaje());
            switch (obj.getEstado()) {
                case "Activo": {
                    this.lblCuentaActiva.setVisible(true);
                    this.lblCuentaPendiente.setVisible(false);
                    this.lblCuentaVencida.setVisible(false);
                    GlobalApp.alDia = true;
                    break;
                }
                case "Pendiente de Pago": {
                    this.lblCuentaActiva.setVisible(false);
                    this.lblCuentaPendiente.setVisible(true);
                    this.lblCuentaVencida.setVisible(false);
                    GlobalApp.alDia = true;
                    break;
                }
                case "Vencido": {
                    this.lblCuentaActiva.setVisible(false);
                    this.lblCuentaPendiente.setVisible(false);
                    this.lblCuentaVencida.setVisible(true);
                    GlobalApp.alDia = false;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al cargar los datos de pago de la empresa.");
        }
    }

    private void getMenusUsuario() {
        UsuarioService service = (UsuarioService)AppContext.getInstance().get("UsuarioService");
        Respuesta respuesta = service.getMenusUsuario(GlobalApp.idUsuario);
        if (respuesta.getEstado().booleanValue()) {
            GlobalApp.menusUsuarioGlobal = (List)respuesta.getResultado(ESTADO.OK.VALUE());
        } else {
            this.funcionesGenerales.MostrarModalInfo("Ocurri\u00f3 un error obteniendo los men\u00fas para el usuario, intente m\u00e1s tarde.");
        }
    }

    private boolean getPermisoMenu(UsuarioMenuDto.MENU menu) {
        if (GlobalApp.usuarioAdmin.booleanValue()) {
            return true;
        }
        return GlobalApp.menusUsuarioGlobal.stream().filter(m -> m.getMenu().equals((Object)menu)).findFirst().orElse(null) != null;
    }

    private void cargarEmisores() {
        EmisorService emisorService = (EmisorService)AppContext.getInstance().get("EmisorService");
        Respuesta respuesta = emisorService.getEmisorIdEmpresa(GlobalApp.idEmpresa);
        if (respuesta.getEstado().booleanValue()) {
            this.emisoresLista = FXCollections.observableArrayList((Collection)((List)respuesta.getResultado("Emisores")));
        } else {
            this.funcionesGenerales.MostrarModalInfo("Error al cargar los emisores.");
        }
    }

    private void getParametrosEmpresa() {
        try {
            this.btnEmisor.setText(GlobalApp.empresa.getNombre());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getCicloFacturacionActual(int idEmisor) {
        CicloFacturacionService service = (CicloFacturacionService)AppContext.getInstance().get("CicloFacturacionService");
        Respuesta respuesta = service.getCicloFacturacionActivo(idEmisor);
        if (respuesta.getEstado().booleanValue()) {
            this.cicloFacturacionActualDto = (CicloFacturacionDto)respuesta.getResultado(ESTADO.OK.VALUE());
            this.lblTipoCuenta.setText(this.cicloFacturacionActualDto.getDescripcionPlan());
            this.lblComprobantes.setText(this.cicloFacturacionActualDto.getCompProcesados().toString());
            this.lblFechaIni.setText(this.cicloFacturacionActualDto.getFechaInicio().format(this.formatter));
            this.lblFechaFin.setText(this.cicloFacturacionActualDto.getFechaFin().format(this.formatter));
        } else {
            this.funcionesGenerales.MostrarModalInfo("El emisor seleccionado no tiene ning\u00fan ciclo de facturaci\u00f3n activo.");
        }
    }

    private void actualizarMenu() {
        if (!this.stackMenu.isVisible()) {
            this.stackMenu.setVisible(true);
        }
    }

    private void closeMenu() {
        this.stackMenu.setVisible(false);
    }

    private void procesarNotificaciones() {
        String fechaExpiracionCert = GlobalApp.fechaExpiracionCert;
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date certExpiryDate = null;
        if (fechaExpiracionCert != null) {
            try {
                if (fechaExpiracionCert != null) {
                    certExpiryDate = ft.parse(fechaExpiracionCert);
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            }
            Date today = new Date();
            long dateDiff = certExpiryDate.getTime() - today.getTime();
            long expiresIn = dateDiff / 86400000L;
            if (certExpiryDate != null) {
                if (expiresIn <= 15L && expiresIn >= 1L) {
                    NotificacionHelper.dispararNotificacion(NotificacionType.WARNING, "Tu certificado de seguridad vence en " + expiresIn + " d\u00edas.");
                }
                if (expiresIn <= 0L) {
                    NotificacionHelper.dispararNotificacion(NotificacionType.ERROR, "Tu certificado de seguridad de Hacienda se encuentra vencido. Favor actualizarlo.");
                }
            }
        }
    }

    @FXML
    private void onBtnCerrarSesion(ActionEvent event) throws IOException {
        this.funcionesGenerales.closeSession(this.panelPrincipal.getScene());
    }

    @FXML
    private void onBtnAcercaInventario() {
        this.funcionesGenerales.MostrarModalInfo("Si deseas adquir el mod\u00falo de inventario completo, cantactanos por Whatsapp al n\u00famero 8782-7962.");
    }

    @FXML
    private void onBtnAccFactPos() {
        GlobalApp.stackMenuGlobal.setVisible(false);
        this.mostrarFacturacionPos();
    }

    @FXML
    private void OnBtnVerReporteVentas() {
        GlobalApp.stackMenuGlobal.setVisible(false);
        this.mostrarReporteVentas();
    }

    @FXML
    private void onBtnAccVerFact() {
        GlobalApp.stackMenuGlobal.setVisible(false);
        try {
            this.lblRuta.setText("Inicio > Facturaci\u00f3n > Facturas");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturasView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FacturasViewController controller = (FacturasViewController)fxmlLoader.getController();
            controller.setTipoComprobante("01");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnAccInv() {
        GlobalApp.stackMenuGlobal.setVisible(false);
        try {
            this.lblRuta.setText("Inicio > Inventario > Productos");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ProductoServicioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ProductoServicioViewController controller = (ProductoServicioViewController)fxmlLoader.getController();
            controller.setTipo("P");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnMiFacturacion() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Ajustes > Mi facturaci\u00f3n");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MiFacturacionView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnCambiarContra() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Ajustes > Mi cuenta");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CuentaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnReporteSalarios() {
        this.closeMenu();
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReporteColaboradoresView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnCuenta() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Ajustes > Mi cuenta");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CuentaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnUsuarios() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Ajustes > Usuarios");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/UsuarioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnColaboradores() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Ajustes > Colaboradores");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ColaboradoresView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnDatosUsu() {
        this.openInfoEmpresa();
        GlobalApp.vBoxUsu.setVisible(false);
    }

    @FXML
    private void onBtnMnuTiqueteElec(ActionEvent event) {
        this.closeMenu();
        this.tipoCom = "04";
        MyAsyncTaskLoading asyncTaskLoading = new MyAsyncTaskLoading();
        asyncTaskLoading.setDaemon(false);
        asyncTaskLoading.execute(new String[0]);
    }

    @FXML
    private void onBtnFacturasElectronicas(ActionEvent event) {
        this.closeMenu();
        this.tipoCom = "01";
        MyAsyncTaskLoading asyncTaskLoading = new MyAsyncTaskLoading();
        asyncTaskLoading.setDaemon(false);
        asyncTaskLoading.execute(new String[0]);
    }

    @FXML
    private void onBtnMnuCreditoElec(ActionEvent event) {
        this.closeMenu();
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ComprobanteHaciendaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ComprobanteHaciendaViewController haciendaViewController = (ComprobanteHaciendaViewController)fxmlLoader.getController();
            haciendaViewController.setTipoComprobante("03");
            haciendaViewController.setInterno(true);
            haciendaViewController.cargarComprobantes();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnRecibidos(ActionEvent event) {
        this.closeMenu();
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ComprobanteHaciendaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ComprobanteHaciendaViewController haciendaViewController = (ComprobanteHaciendaViewController)fxmlLoader.getController();
            haciendaViewController.setInterno(false);
            haciendaViewController.cargarComprobantes();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnMnuDebitoElec(ActionEvent event) {
        this.closeMenu();
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ComprobanteHaciendaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ComprobanteHaciendaViewController haciendaViewController = (ComprobanteHaciendaViewController)fxmlLoader.getController();
            haciendaViewController.setTipoComprobante("02");
            haciendaViewController.setInterno(true);
            haciendaViewController.cargarComprobantes();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void OnBtnCrearFactura() {
        this.closeMenu();
        try {
            AnchorPane ancho;
            this.lblRuta.setText("Inicio > Facturaci\u00f3n > Facturar");
            if (GlobalApp.empresa.getUsaColaboradores().equalsIgnoreCase("N")) {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionView.fxml"));
                ancho = (AnchorPane)fxmlLoader.load();
                FacturacionViewController controller = (FacturacionViewController)fxmlLoader.getController();
                controller.setTipoComprobanteGlobal("01");
            } else {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionColView.fxml"));
                ancho = (AnchorPane)fxmlLoader.load();
                FacturacionColViewController controller = (FacturacionColViewController)fxmlLoader.getController();
                controller.setTipoComprobanteGlobal("01");
            }
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void OnBtnCrearRegistroInterno() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Registro > Interno");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/RegistroInternoView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            RegistroInternoViewController controller = (RegistroInternoViewController)fxmlLoader.getController();
            controller.setTipoComprobanteGlobal("04");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void OnBtnCrearFacturaCompra() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Facturaci\u00f3n > Factura de Compra");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionCompraView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FacturacionCompraViewController controller = (FacturacionCompraViewController)fxmlLoader.getController();
            controller.setTipoComprobanteGlobal("08");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void OnBtnCrearProforma() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Facturaci\u00f3n >  Crear proforma");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionProformaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FacturacionProformaViewController controller = (FacturacionProformaViewController)fxmlLoader.getController();
            controller.setTipoComprobanteGlobal("01");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void OnBtnVerProformas() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Facturaci\u00f3n >  Ver proformas");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ProformasView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ProformasViewController controller = (ProformasViewController)fxmlLoader.getController();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void OnBtnVerGastos() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Facturaci\u00f3n >  Ver gastos");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/GastosView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void OnBtnVerFacturas() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Facturaci\u00f3n > Facturas");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturasView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FacturasViewController controller = (FacturasViewController)fxmlLoader.getController();
            controller.setTipoComprobante("01");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnRecepcion() {
        this.closeMenu();
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/RecepcionComprobanteView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void OnBtnCrearTiquete(ActionEvent event) {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Facturaci\u00f3n > Tiquete electr\u00f3nico");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            FacturacionViewController controller = (FacturacionViewController)fxmlLoader.getController();
            controller.setTipoComprobanteGlobal("04");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void OnBtnCrearTiquetePos(ActionEvent event) {
        this.closeMenu();
        if (GlobalApp.empresa.getEsSimplificado().equalsIgnoreCase("N")) {
            this.mostrarFacturacionPos();
        } else {
            this.mostrarFacturacionPosSimplificado();
        }
    }

    private void mostrarReporteVentas() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Facturaci\u00f3n > Tiquete electr\u00f3nico");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReporteVentasView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ReporteVentasViewController controller = (ReporteVentasViewController)fxmlLoader.getController();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void mostrarFacturacionPos() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionPosView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        FacturacionPosViewController controller = (FacturacionPosViewController)fxmlLoader.getController();
        controller.setTipoComprobanteGlobal("04");
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.getIcons().add((Object)new Image("/electricpos/resources/space.jpg"));
        stage.setTitle("Facturaci\u00f3n electr\u00f3nica SPACE");
        stage.initModality(Modality.NONE);
        stage.show();
    }

    private void mostrarFacturacionPosSimplificado() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionPosSimpliView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ParametrosGeneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        FacturacionPosSimpliViewController controller = (FacturacionPosSimpliViewController)fxmlLoader.getController();
        controller.setTipoComprobanteGlobal("04");
        Stage stage = new Stage();
        stage.setScene(new Scene(root1));
        stage.getIcons().add((Object)new Image("/electricpos/resources/space.jpg"));
        stage.setTitle("Factux POS");
        stage.initModality(Modality.NONE);
        stage.show();
    }

    @FXML
    private void onBtnMnuVerAjustesInv() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Inventario > Ajustes");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/AjustesInventarioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            AjustesInventarioViewController controller = (AjustesInventarioViewController)fxmlLoader.getController();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnMnuVerProductos() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Inventario > Productos");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ProductoServicioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ProductoServicioViewController controller = (ProductoServicioViewController)fxmlLoader.getController();
            controller.setTipo("P");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnMnuVerServicios() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Inventario > Servicios");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ProductoServicioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ProductoServicioViewController controller = (ProductoServicioViewController)fxmlLoader.getController();
            controller.setTipo("S");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnInvEntradas() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Inventario > Entradas");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MovimientoInventarioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            MovimientoInventarioViewController controller = (MovimientoInventarioViewController)fxmlLoader.getController();
            controller.setTipoMovimiento("ENT");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnInvSalidas() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Inventario > Salidas");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MovimientoInventarioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            MovimientoInventarioViewController controller = (MovimientoInventarioViewController)fxmlLoader.getController();
            controller.setTipoMovimiento("SAL");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnReporteInventario() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Inventario > Reportes");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReportesInventarioView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnMnuInfoEmpresa() {
        this.openInfoEmpresa();
        this.closeMenu();
    }

    private void openInfoEmpresa() {
        try {
            this.lblRuta.setText("Inicio > Par\u00e1metros > Empresa");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ParametrosGeneView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnEmisores() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Par\u00e1metros > Emisores");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/EmisorView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnReceptores() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Par\u00e1metros > Clientes");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReceptorView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnCreditos() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Par\u00e1metros > Cr\u00e9ditos");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MovCreditoView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnClientes() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Par\u00e1metros > Clientes");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/ReceptorView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            ReceptorViewController d = (ReceptorViewController)fxmlLoader.getController();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnSucursales(ActionEvent event) {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Par\u00e1metros > Sucursales");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/SucursalView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnCierres() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Cajas > Cajas");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CajasView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnAbrirCaja() {
        this.closeMenu();
        if (!this.funcionesGenerales.isCajaAbierta()) {
            this.lblRuta.setText("Inicio > Cajas > Abrir caja");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CrearCajaView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            }
            CrearCajaViewController controller = (CrearCajaViewController)fxmlLoader.getController();
            controller.setUltimaCaja(this.funcionesGenerales.getUltimaCaja());
            FuncionesGenerales.showView(root1);
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "Ya existe una caja abierta, debe cerrar la caja actual para continuar.");
        }
    }

    @FXML
    private void onBtnCerrarCaja() {
        this.closeMenu();
        if (this.funcionesGenerales.isCajaAbierta()) {
            this.lblRuta.setText("Inicio > Cajas > Cierres de cajas");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CerrarCajaView.fxml"));
            Parent root1 = null;
            try {
                root1 = (Parent)fxmlLoader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            }
            CerrarCajaViewController controller = (CerrarCajaViewController)fxmlLoader.getController();
            controller.setCierreCajaDto(null, null);
            FuncionesGenerales.showView(root1);
        } else {
            NotificacionHelper.dispararNotificacion(NotificacionType.INFO, "Debe existir una caja abierta para continuar.");
        }
    }

    @FXML
    private void onBtnOtrosEgresos() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Caja > Egresos");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MovimientosCajaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            MovimientosCajaViewController controller = (MovimientosCajaViewController)fxmlLoader.getController();
            controller.setTipoMovimiento("E");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnRetirosEfectivo() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Caja > Retiros efectivo");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MovimientosCajaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            MovimientosCajaViewController controller = (MovimientosCajaViewController)fxmlLoader.getController();
            controller.setTipoMovimiento("R");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnOtrosIngresos() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Caja > Ingresos");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/MovimientosCajaView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            MovimientosCajaViewController controller = (MovimientosCajaViewController)fxmlLoader.getController();
            controller.setTipoMovimiento("I");
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnCierreMes() {
        this.closeMenu();
        try {
            this.lblRuta.setText("Inicio > Caja > Cierres de mes");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CierresMesView.fxml"));
            AnchorPane ancho = (AnchorPane)fxmlLoader.load();
            CierresMesViewController controller = (CierresMesViewController)fxmlLoader.getController();
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void onBtnCrearCierreMes() {
        this.closeMenu();
        this.lblRuta.setText("Inicio > Cajas > Cierres de mes");
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/CerrarCajaMesView.fxml"));
        Parent root1 = null;
        try {
            root1 = (Parent)fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
        FuncionesGenerales.showView(root1);
    }

    @FXML
    private void onBtnNueva() {
        this.stackMenu.setVisible(false);
        try {
            AnchorPane ancho;
            this.lblRuta.setText("Inicio > Facturaci\u00f3n > Facturar");
            if (GlobalApp.empresa.getUsaColaboradores().equalsIgnoreCase("N")) {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionView.fxml"));
                ancho = (AnchorPane)fxmlLoader.load();
                FacturacionViewController controller = (FacturacionViewController)fxmlLoader.getController();
                controller.setTipoComprobanteGlobal("01");
            } else {
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/electricpos/view/FacturacionColView.fxml"));
                ancho = (AnchorPane)fxmlLoader.load();
                FacturacionColViewController controller = (FacturacionColViewController)fxmlLoader.getController();
                controller.setTipoComprobanteGlobal("01");
            }
            this.panelPrincipal.getChildren().setAll((Object[])new Node[]{ancho});
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private class MyAsyncTaskLoading
    extends AsyncTask<String, Integer, Boolean> {
        AnchorPane ancho;

        private MyAsyncTaskLoading() {
        }

        public void onPreExecute() {
            PrincipalController.this.paneLoading.setVisible(true);
        }

        public Boolean doInBackground(String ... params) {
            try {
                PrincipalController.this.lblRuta.setText("Inicio > Comprobantes Ministerio Hacienda");
                FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/electricpos/view/ComprobanteHaciendaView.fxml"));
                this.ancho = (AnchorPane)fxmlLoader.load();
                ComprobanteHaciendaViewController haciendaViewController = (ComprobanteHaciendaViewController)fxmlLoader.getController();
                haciendaViewController.setInterno(true);
                haciendaViewController.setTipoComprobante(PrincipalController.this.tipoCom);
                haciendaViewController.cargarComprobantes();
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return true;
        }

        public void onPostExecute(Boolean success) {
            PrincipalController.this.panelPrincipal.getChildren().setAll((Object[])new Node[]{this.ancho});
            PrincipalController.this.paneLoading.setVisible(false);
        }

        public void progressCallback(Integer ... params) {
        }
    }
}

